/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.List;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.timetable.form.EditRoomFeatureForm;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.NonUniversityLocation;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.dao.DepartmentRoomFeatureDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.RoomFeatureDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@Service(value="/editRoomFeature")
public class EditRoomFeatureAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        EditRoomFeatureForm editRoomFeatureForm = (EditRoomFeatureForm)form;
        MessageResources rsc = this.getResources(request);
        String doit = editRoomFeatureForm.getDoit();
        if (doit != null && doit.equals(rsc.getMessage("button.returnToRoomDetail"))) {
            response.sendRedirect("roomDetail.do?id=" + editRoomFeatureForm.getId());
            return null;
        }
        if (doit != null && doit.equals(rsc.getMessage("button.update"))) {
            this.doUpdate(editRoomFeatureForm, request);
            return mapping.findForward("showRoomDetail");
        }
        LocationDAO ldao = new LocationDAO();
        Long id = Long.valueOf(request.getParameter("id"));
        Location location = (Location)ldao.get(id);
        if (location instanceof Room) {
            Room r = (Room)location;
            editRoomFeatureForm.setRoomLabel(r.getLabel());
        } else if (location instanceof NonUniversityLocation) {
            NonUniversityLocation nonUnivLocation = (NonUniversityLocation)location;
            editRoomFeatureForm.setRoomLabel(nonUnivLocation.getName());
        } else {
            ActionMessages errors = new ActionMessages();
            errors.add("editRoomGroup", new ActionMessage("errors.lookup.notFound", (Object)"Room Group"));
            this.saveErrors(request, errors);
        }
        this.sessionContext.checkPermission(location, Right.RoomEditFeatures);
        boolean editGlobalFeatures = this.sessionContext.hasPermission(location, Right.RoomEditGlobalFeatures);
        for (GlobalRoomFeature grf : RoomFeature.getAllGlobalRoomFeatures(location.getSession())) {
            if (editRoomFeatureForm.getGlobalRoomFeatureIds().contains(grf.getUniqueId().toString())) continue;
            editRoomFeatureForm.addToGlobalRoomFeatures(grf, editGlobalFeatures, location.hasFeature(grf));
        }
        TreeSet<Department> departments = Department.getUserDepartments(this.sessionContext.getUser());
        for (Department department : departments) {
            for (DepartmentRoomFeature drf : RoomFeature.getAllDepartmentRoomFeatures(department)) {
                editRoomFeatureForm.addToDepartmentRoomFeatures(drf, true, location.hasFeature(drf));
            }
        }
        for (Department department : Department.findAllExternal(location.getSession().getUniqueId())) {
            if (departments.contains(department)) continue;
            for (DepartmentRoomFeature drf : RoomFeature.getAllDepartmentRoomFeatures(department)) {
                editRoomFeatureForm.addToDepartmentRoomFeatures(drf, false, location.hasFeature(drf));
            }
        }
        return mapping.findForward("showEditRoomFeature");
    }

    private void doUpdate(EditRoomFeatureForm editRoomFeatureForm, HttpServletRequest request) throws Exception {
        Session hibSession = LocationDAO.getInstance().getSession();
        Transaction tx = null;
        try {
            TreeSet<Department> departments;
            tx = hibSession.beginTransaction();
            Location location = (Location)LocationDAO.getInstance().get(Long.valueOf(request.getParameter("id")), hibSession);
            this.sessionContext.checkPermission(location, Right.RoomEditFeatures);
            boolean editGlobalFeatures = this.sessionContext.hasPermission(location, Right.RoomEditGlobalFeatures);
            if (editGlobalFeatures && editRoomFeatureForm.getGlobalRoomFeaturesAssigned() != null) {
                List globalSelected = editRoomFeatureForm.getGlobalRoomFeaturesAssigned();
                List globalRf = editRoomFeatureForm.getGlobalRoomFeatureIds();
                if (globalSelected.size() == 0) {
                    for (String rfId : globalRf) {
                        RoomFeature rf = (RoomFeature)RoomFeatureDAO.getInstance().get(Long.valueOf(rfId), hibSession);
                        location.getFeatures().remove(rf);
                        rf.getRooms().remove(location);
                        hibSession.saveOrUpdate((Object)rf);
                    }
                } else {
                    int i = 0;
                    for (String rfId : globalRf) {
                        String selected = (String)globalSelected.get(i);
                        RoomFeature rf = (RoomFeature)RoomFeatureDAO.getInstance().get(Long.valueOf(rfId), hibSession);
                        if (selected == null) continue;
                        if (selected.equalsIgnoreCase("on") || selected.equalsIgnoreCase("true")) {
                            if (!rf.hasLocation(location)) {
                                location.getFeatures().add(rf);
                                rf.getRooms().add(location);
                            }
                        } else if (rf.hasLocation(location)) {
                            location.getFeatures().remove(rf);
                            rf.getRooms().remove(location);
                        }
                        hibSession.saveOrUpdate((Object)rf);
                        ++i;
                    }
                }
            }
            if (!(departments = Department.getUserDepartments(this.sessionContext.getUser())).isEmpty() && editRoomFeatureForm.getDepartmentRoomFeaturesAssigned() != null) {
                List managerSelected = editRoomFeatureForm.getDepartmentRoomFeaturesAssigned();
                List managerRf = editRoomFeatureForm.getDepartmentRoomFeatureIds();
                if (managerSelected.size() == 0) {
                    for (String rfId : managerRf) {
                        DepartmentRoomFeature rf = (DepartmentRoomFeature)DepartmentRoomFeatureDAO.getInstance().get(Long.valueOf(rfId), hibSession);
                        if (!departments.contains(rf.getDepartment())) continue;
                        location.getFeatures().remove(rf);
                        rf.getRooms().remove(location);
                        hibSession.saveOrUpdate((Object)rf);
                    }
                } else {
                    int i = 0;
                    for (String rfId : managerRf) {
                        DepartmentRoomFeature rf;
                        String selected = (String)managerSelected.get(i);
                        if (selected == null || !departments.contains((rf = (DepartmentRoomFeature)DepartmentRoomFeatureDAO.getInstance().get(Long.valueOf(rfId), hibSession)).getDepartment())) continue;
                        if (selected.equalsIgnoreCase("on") || selected.equalsIgnoreCase("true")) {
                            if (!rf.hasLocation(location)) {
                                rf.getRooms().add(location);
                                location.getFeatures().add(rf);
                            }
                        } else if (rf.hasLocation(location)) {
                            rf.getRooms().remove(location);
                            location.getFeatures().remove(rf);
                        }
                        hibSession.saveOrUpdate((Object)rf);
                        ++i;
                    }
                }
            }
            hibSession.saveOrUpdate((Object)location);
            ChangeLog.addChange(hibSession, this.sessionContext, location, ChangeLog.Source.ROOM_FEATURE_EDIT, ChangeLog.Operation.UPDATE, null, location.getControllingDepartment());
            tx.commit();
            hibSession.refresh((Object)location);
        }
        catch (Exception e) {
            Debug.error(e);
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }
}

