/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.ClassInfoForm;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.base.BasePreferenceGroup;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.course.ui.ClassInfoModel;
import org.unitime.timetable.util.DefaultRoomAvailabilityService;
import org.unitime.timetable.util.RoomAvailability;

@Service(value="/classInfo")
public class ClassInfoAction
extends Action {
    protected static CourseMessages MSG = Localization.create(CourseMessages.class);
    @Autowired
    SessionContext sessionContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Serializable session;
        Object type;
        ClassInfoModel model;
        String op;
        ClassInfoForm myForm = (ClassInfoForm)form;
        String string = op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
        if (request.getParameter("op2") != null && request.getParameter("op2").length() > 0) {
            op = request.getParameter("op2");
            myForm.setOp(op);
        }
        if ((model = (ClassInfoModel)this.sessionContext.getAttribute(SessionAttribute.ClassInfoModel)) == null) {
            model = new ClassInfoModel();
            this.sessionContext.setAttribute(SessionAttribute.ClassInfoModel, (Object)model);
            type = ApplicationProperty.ClassAssignmentStudentConflictsType.value();
            if ("none".equalsIgnoreCase((String)type)) {
                model.setShowStudentConflicts(false);
                model.setUseRealStudents(StudentClassEnrollment.sessionHasEnrollments(this.sessionContext.getUser().getCurrentAcademicSessionId()));
            } else if ("actual".equalsIgnoreCase((String)type)) {
                model.setShowStudentConflicts(true);
                model.setUseRealStudents(true);
            } else if ("solution".equalsIgnoreCase((String)type)) {
                model.setShowStudentConflicts(true);
                model.setUseRealStudents(false);
            } else {
                model.setUseRealStudents(StudentClassEnrollment.sessionHasEnrollments(this.sessionContext.getUser().getCurrentAcademicSessionId()));
            }
        }
        model.setSessionContext(this.sessionContext);
        if (op == null && model.getClass() != null && request.getParameter("classId") == null) {
            op = "Apply";
        }
        if (MSG.actionFilterApply().equals(op) || "Apply".equals(op)) {
            myForm.save(request.getSession());
        } else if ("Refresh".equals(op)) {
            myForm.reset(mapping, request);
        }
        myForm.load(request.getSession());
        myForm.setModel(model);
        model.apply(request, myForm);
        if (op == null) {
            model.clear(this.sessionContext.getUser().getExternalUserId());
        } else if ("Apply".equals(op)) {
            model.refreshRooms();
            if (model.isKeepConflictingAssignments() != myForm.getKeepConflictingAssignments()) {
                model.update();
            }
        }
        if (request.getParameter("classId") != null) {
            model.setClazz((Class_)new Class_DAO().get(Long.valueOf(request.getParameter("classId"))));
            if (model.getClassAssignment() != null && (model.getChange() == null || model.getChange().getCurrent(model.getClazz().getClassId()) == null)) {
                model.setTime(model.getClassAssignment().getTimeId());
            }
            myForm.save(request.getSession());
        }
        if (model.getClazz() == null) {
            throw new Exception(MSG.errorNoClassGiven());
        }
        this.sessionContext.checkPermission(model.getClazz().getClazz(), Right.ClassAssignment);
        if (RoomAvailability.getInstance() != null && op == null && !(RoomAvailability.getInstance() instanceof DefaultRoomAvailabilityService)) {
            session = (Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId());
            Date[] bounds = DatePattern.getBounds(((BasePreferenceGroup)session).getUniqueId());
            RoomAvailability.getInstance().activate((Session)session, bounds[0], bounds[1], RoomAvailabilityInterface.sClassType, false);
            RoomAvailability.setAvailabilityWarning(request, (Session)session, true, true);
        }
        if ("Select".equals(op)) {
            session = model;
            synchronized (session) {
                if (request.getParameter("time") != null) {
                    model.setTime(request.getParameter("time"));
                }
                if (request.getParameter("date") != null) {
                    model.setDate(request.getParameter("date"));
                }
                if (request.getParameter("room") != null) {
                    model.setRooms(request.getParameter("room"));
                }
                if (request.getParameter("delete") != null) {
                    model.delete(Long.valueOf(request.getParameter("delete")));
                }
            }
        }
        if ("Type".equals(op)) {
            type = request.getParameter("type");
            if ("actual".equalsIgnoreCase((String)type)) {
                model.setUseRealStudents(true);
            } else if ("solution".equalsIgnoreCase((String)type)) {
                model.setUseRealStudents(false);
            }
            model.setClazz(model.getClazz().getClazz());
            model.update();
        }
        if (MSG.actionClassAssign().equals(op) || "Assign".equals(op)) {
            type = model;
            synchronized (type) {
                String message = model.assign(this.sessionContext);
                if (message == null || message.trim().length() == 0) {
                    myForm.setOp("Close");
                } else {
                    myForm.setMessage(message);
                }
            }
        }
        if ("Lock".equals(op)) {
            InstructionalOffering offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(Long.valueOf(request.getParameter("offering")));
            this.sessionContext.checkPermission(offering, Right.OfferingCanLock);
            offering.getSession().lockOffering(offering.getUniqueId());
        }
        if ("Close".equals(op)) {
            myForm.setOp("Close");
        }
        if (myForm.getOp() == null || myForm.getOp().equals("Close")) {
            myForm.setKeepConflictingAssignments(false);
            request.getSession().removeAttribute("ClassInfo.KeepConflictingAssignments");
        }
        return mapping.findForward("show");
    }
}

