/*
 * Decompiled with CFR 0.152.
 */
package biweekly.util;

import biweekly.util.Duration;
import java.util.Date;

public final class Period {
    private final Date startDate;
    private final Date endDate;
    private final Duration duration;

    public Period(Date startDate, Date endDate) {
        this.startDate = this.copy(startDate);
        this.endDate = this.copy(endDate);
        this.duration = null;
    }

    public Period(Date startDate, Duration duration) {
        this.startDate = this.copy(startDate);
        this.duration = duration;
        this.endDate = null;
    }

    public Period(Period period) {
        this.startDate = period.startDate;
        this.endDate = period.endDate;
        this.duration = period.duration;
    }

    public Date getStartDate() {
        return this.copy(this.startDate);
    }

    public Date getEndDate() {
        return this.copy(this.endDate);
    }

    public Duration getDuration() {
        return this.duration;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.duration == null ? 0 : this.duration.hashCode());
        result = 31 * result + (this.endDate == null ? 0 : this.endDate.hashCode());
        result = 31 * result + (this.startDate == null ? 0 : this.startDate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Period other = (Period)obj;
        if (this.duration == null ? other.duration != null : !this.duration.equals(other.duration)) {
            return false;
        }
        if (this.endDate == null ? other.endDate != null : !this.endDate.equals(other.endDate)) {
            return false;
        }
        return !(this.startDate == null ? other.startDate != null : !this.startDate.equals(other.startDate));
    }

    private Date copy(Date date) {
        return date == null ? null : new Date(date.getTime());
    }
}

