/*
 * Decompiled with CFR 0.152.
 */
package biweekly.property;

import biweekly.ICalVersion;
import biweekly.Warning;
import biweekly.component.ICalComponent;
import biweekly.property.ValuedProperty;
import biweekly.util.Google2445Utils;
import biweekly.util.ICalDate;
import biweekly.util.Recurrence;
import com.google.ical.compat.javautil.DateIterator;
import com.google.ical.compat.javautil.DateIteratorFactory;
import com.google.ical.iter.RecurrenceIterator;
import com.google.ical.iter.RecurrenceIteratorFactory;
import com.google.ical.values.DateValue;
import com.google.ical.values.RRule;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecurrenceProperty
extends ValuedProperty<Recurrence> {
    public RecurrenceProperty(Recurrence recur) {
        super(recur);
    }

    public DateIterator getDateIterator(Date startDate) {
        return this.getDateIterator(new ICalDate(startDate));
    }

    public DateIterator getDateIterator(ICalDate startDate) {
        Recurrence recur = (Recurrence)this.getValue();
        if (recur == null) {
            return new EmptyDateIterator();
        }
        RRule rruleValue = Google2445Utils.convert(recur);
        ICalDate startDateCopy = startDate.getRawComponents() == null ? startDate : new ICalDate(startDate, null, startDate.hasTime());
        DateValue dtstartValue = Google2445Utils.convert(startDateCopy);
        RecurrenceIterator it = RecurrenceIteratorFactory.createRecurrenceIterator(rruleValue, dtstartValue, TimeZone.getDefault());
        return DateIteratorFactory.createDateIterator(it);
    }

    @Override
    protected void validate(List<ICalComponent> components, ICalVersion version, List<Warning> warnings) {
        super.validate(components, version, warnings);
        if (this.value == null) {
            return;
        }
        if (((Recurrence)this.value).getFrequency() == null) {
            warnings.add(Warning.validate(30, new Object[0]));
        }
        if (((Recurrence)this.value).getUntil() != null && ((Recurrence)this.value).getCount() != null) {
            warnings.add(Warning.validate(31, new Object[0]));
        }
        switch (version) {
            case V1_0: {
                if (!((Recurrence)this.value).getXRules().isEmpty()) {
                    warnings.add(new Warning("X-Rules are not supported by vCal."));
                }
                if (!((Recurrence)this.value).getBySetPos().isEmpty()) {
                    warnings.add(new Warning("BYSETPOS is not supported by vCal."));
                }
                if (((Recurrence)this.value).getFrequency() != Recurrence.Frequency.SECONDLY) break;
                warnings.add(new Warning(Recurrence.Frequency.SECONDLY.name() + " frequency is not supported by vCal."));
                break;
            }
            case V2_0_DEPRECATED: {
                break;
            }
            case V2_0: {
                if (((Recurrence)this.value).getXRules().isEmpty()) break;
                warnings.add(Warning.validate(32, new Object[0]));
            }
        }
    }

    private static class EmptyDateIterator
    implements DateIterator {
        private EmptyDateIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Date next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void advanceTo(Date newStartUtc) {
        }
    }
}

