/*
 * Decompiled with CFR 0.152.
 */
package biweekly.parameter;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.Warning;
import biweekly.parameter.CalendarUserType;
import biweekly.parameter.Encoding;
import biweekly.parameter.FreeBusyType;
import biweekly.parameter.ParticipationStatus;
import biweekly.parameter.Range;
import biweekly.parameter.Related;
import biweekly.parameter.RelationshipType;
import biweekly.parameter.Role;
import biweekly.util.ListMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICalParameters
extends ListMultimap<String, String> {
    public static final String CN = "CN";
    public static final String ALTREP = "ALTREP";
    public static final String CHARSET = "CHARSET";
    public static final String CUTYPE = "CUTYPE";
    public static final String DELEGATED_FROM = "DELEGATED-FROM";
    public static final String DELEGATED_TO = "DELEGATED-TO";
    public static final String DIR = "DIR";
    public static final String ENCODING = "ENCODING";
    public static final String FMTTYPE = "FMTTYPE";
    public static final String FBTYPE = "FBTYPE";
    public static final String LANGUAGE = "LANGUAGE";
    public static final String MEMBER = "MEMBER";
    public static final String PARTSTAT = "PARTSTAT";
    public static final String RANGE = "RANGE";
    public static final String RELATED = "RELATED";
    public static final String RELTYPE = "RELTYPE";
    public static final String ROLE = "ROLE";
    public static final String RSVP = "RSVP";
    public static final String SENT_BY = "SENT-BY";
    public static final String TYPE = "TYPE";
    public static final String TZID = "TZID";
    public static final String VALUE = "VALUE";

    public ICalParameters() {
        super(0);
    }

    public ICalParameters(ICalParameters parameters) {
        super(parameters);
    }

    public String getAltRepresentation() {
        return (String)this.first(ALTREP);
    }

    public void setAltRepresentation(String uri) {
        this.replace(ALTREP, uri);
    }

    public String getCharset() {
        return (String)this.first(CHARSET);
    }

    public void setCharset(String charset) {
        this.replace(CHARSET, charset);
    }

    public String getCommonName() {
        return (String)this.first(CN);
    }

    public void setCommonName(String cn) {
        this.replace(CN, cn);
    }

    public CalendarUserType getCalendarUserType() {
        String value = (String)this.first(CUTYPE);
        return value == null ? null : CalendarUserType.get(value);
    }

    public void setCalendarUserType(CalendarUserType cutype) {
        this.replace(CUTYPE, cutype == null ? null : cutype.getValue());
    }

    public List<String> getDelegatedFrom() {
        return this.get(DELEGATED_FROM);
    }

    public void addDelegatedFrom(String uri) {
        this.put(DELEGATED_FROM, uri);
    }

    public void removeDelegatedFrom(String uri) {
        this.remove(DELEGATED_FROM, uri);
    }

    public void removeDelegatedFrom() {
        this.removeAll(DELEGATED_FROM);
    }

    public List<String> getDelegatedTo() {
        return this.get(DELEGATED_TO);
    }

    public void addDelegatedTo(String uri) {
        this.put(DELEGATED_TO, uri);
    }

    public void removeDelegatedTo(String uri) {
        this.remove(DELEGATED_TO, uri);
    }

    public void removeDelegatedTo() {
        this.removeAll(DELEGATED_TO);
    }

    public String getDirectoryEntry() {
        return (String)this.first(DIR);
    }

    public void setDirectoryEntry(String uri) {
        this.replace(DIR, uri);
    }

    public Encoding getEncoding() {
        String value = (String)this.first(ENCODING);
        return value == null ? null : Encoding.get(value);
    }

    public void setEncoding(Encoding encoding) {
        this.replace(ENCODING, encoding == null ? null : encoding.getValue());
    }

    public String getFormatType() {
        return (String)this.first(FMTTYPE);
    }

    public void setFormatType(String formatType) {
        this.replace(FMTTYPE, formatType);
    }

    public FreeBusyType getFreeBusyType() {
        String value = (String)this.first(FBTYPE);
        return value == null ? null : FreeBusyType.get(value);
    }

    public void setFreeBusyType(FreeBusyType fbType) {
        this.replace(FBTYPE, fbType == null ? null : fbType.getValue());
    }

    public String getLanguage() {
        return (String)this.first(LANGUAGE);
    }

    public void setLanguage(String language) {
        this.replace(LANGUAGE, language);
    }

    public void addMember(String uri) {
        this.put(MEMBER, uri);
    }

    public List<String> getMembers() {
        return this.get(MEMBER);
    }

    public void removeMember(String uri) {
        this.remove(MEMBER, uri);
    }

    public void removeMembers() {
        this.removeAll(MEMBER);
    }

    public Range getRange() {
        String value = (String)this.first(RANGE);
        return value == null ? null : Range.get(value);
    }

    public void setRange(Range range) {
        this.replace(RANGE, range == null ? null : range.getValue());
    }

    public Related getRelated() {
        String value = (String)this.first(RELATED);
        return value == null ? null : Related.get(value);
    }

    public void setRelated(Related related) {
        this.replace(RELATED, related == null ? null : related.getValue());
    }

    public RelationshipType getRelationshipType() {
        String value = (String)this.first(RELTYPE);
        return value == null ? null : RelationshipType.get(value);
    }

    public void setRelationshipType(RelationshipType relationshipType) {
        this.replace(RELTYPE, relationshipType == null ? null : relationshipType.getValue());
    }

    public String getSentBy() {
        return (String)this.first(SENT_BY);
    }

    public void setSentBy(String uri) {
        this.replace(SENT_BY, uri);
    }

    public String getTimezoneId() {
        return (String)this.first(TZID);
    }

    public void setTimezoneId(String timezoneId) {
        this.replace(TZID, timezoneId);
    }

    public ICalDataType getValue() {
        String value = (String)this.first(VALUE);
        return value == null ? null : ICalDataType.get(value);
    }

    public void setValue(ICalDataType value) {
        this.replace(VALUE, value == null ? null : value.getName());
    }

    public List<Warning> validate(ICalVersion version) {
        ArrayList<Warning> warnings = new ArrayList<Warning>(0);
        boolean nonStandardCode = true;
        int deprecated = 47;
        String value = (String)this.first(RSVP);
        if (value != null) {
            value = value.toLowerCase();
            List<String> validValues = Arrays.asList("true", "false", "yes", "no");
            if (!validValues.contains(value)) {
                warnings.add(Warning.validate(1, RSVP, value, validValues));
            }
        }
        if ((value = (String)this.first(CUTYPE)) != null && CalendarUserType.find(value) == null) {
            warnings.add(Warning.validate(1, CUTYPE, value, CalendarUserType.all()));
        }
        if ((value = (String)this.first(ENCODING)) != null && Encoding.find(value) == null) {
            warnings.add(Warning.validate(1, ENCODING, value, Encoding.all()));
        }
        if ((value = (String)this.first(FBTYPE)) != null && FreeBusyType.find(value) == null) {
            warnings.add(Warning.validate(1, FBTYPE, value, FreeBusyType.all()));
        }
        if ((value = (String)this.first(PARTSTAT)) != null && ParticipationStatus.find(value) == null) {
            warnings.add(Warning.validate(1, PARTSTAT, value, ParticipationStatus.all()));
        }
        if ((value = (String)this.first(RANGE)) != null) {
            Range range = Range.find(value);
            if (range == null) {
                warnings.add(Warning.validate(1, RANGE, value, Range.all()));
            }
            if (range == Range.THIS_AND_PRIOR && version == ICalVersion.V2_0) {
                warnings.add(Warning.validate(47, RANGE, value));
            }
        }
        if ((value = (String)this.first(RELATED)) != null && Related.find(value) == null) {
            warnings.add(Warning.validate(1, RELATED, value, Related.all()));
        }
        if ((value = (String)this.first(RELTYPE)) != null && RelationshipType.find(value) == null) {
            warnings.add(Warning.validate(1, RELTYPE, value, RelationshipType.all()));
        }
        if ((value = (String)this.first(ROLE)) != null && Role.find(value) == null) {
            warnings.add(Warning.validate(1, ROLE, value, Role.all()));
        }
        if ((value = (String)this.first(VALUE)) != null && ICalDataType.find(value) == null) {
            warnings.add(Warning.validate(1, VALUE, value, ICalDataType.all()));
        }
        return warnings;
    }

    @Override
    protected String sanitizeKey(String key) {
        return key == null ? null : key.toUpperCase();
    }
}

