/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.text;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.ICalendar;
import biweekly.component.ICalComponent;
import biweekly.component.VAlarm;
import biweekly.component.VTimezone;
import biweekly.io.DataModelConverter;
import biweekly.io.SkipMeException;
import biweekly.io.StreamWriter;
import biweekly.io.scribe.component.ICalComponentScribe;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.text.ICalRawWriter;
import biweekly.parameter.ICalParameters;
import biweekly.property.Attendee;
import biweekly.property.Created;
import biweekly.property.DateTimeStamp;
import biweekly.property.Daylight;
import biweekly.property.ICalProperty;
import biweekly.property.Organizer;
import biweekly.property.Timezone;
import biweekly.property.VCalAlarmProperty;
import biweekly.property.Version;
import biweekly.util.IOUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ICalWriter
extends StreamWriter
implements Flushable {
    private final ICalRawWriter writer;

    public ICalWriter(OutputStream out, ICalVersion version) {
        this(version == ICalVersion.V1_0 ? new OutputStreamWriter(out) : IOUtils.utf8Writer(out), version);
    }

    public ICalWriter(File file, ICalVersion version) throws IOException {
        this(file, false, version);
    }

    public ICalWriter(File file, boolean append, ICalVersion version) throws IOException {
        this(version == ICalVersion.V1_0 ? new FileWriter(file, append) : IOUtils.utf8Writer(file, append), version);
    }

    public ICalWriter(Writer writer, ICalVersion version) {
        this.writer = new ICalRawWriter(writer, version);
    }

    public ICalRawWriter getRawWriter() {
        return this.writer;
    }

    public ICalVersion getTargetVersion() {
        return this.writer.getVersion();
    }

    public void setTargetVersion(ICalVersion targetVersion) {
        this.writer.setVersion(targetVersion);
    }

    public boolean isCaretEncodingEnabled() {
        return this.writer.isCaretEncodingEnabled();
    }

    public void setCaretEncodingEnabled(boolean enable) {
        this.writer.setCaretEncodingEnabled(enable);
    }

    protected void _write(ICalendar ical) throws IOException {
        this.writeComponent(ical, null);
    }

    private void writeComponent(ICalComponent component, ICalComponent parent) throws IOException {
        Collection<VTimezone> timezones;
        switch (this.writer.getVersion()) {
            case V1_0: {
                VAlarm valarm;
                VCalAlarmProperty vcalAlarm;
                if (!(component instanceof VAlarm) || (vcalAlarm = DataModelConverter.convert(valarm = (VAlarm)component, component)) == null) break;
                this.writeProperty(vcalAlarm);
                return;
            }
        }
        boolean inICalendar = component instanceof ICalendar;
        boolean inVCalRoot = inICalendar && this.getTargetVersion() == ICalVersion.V1_0;
        boolean inICalRoot = inICalendar && this.getTargetVersion() != ICalVersion.V1_0;
        ICalComponentScribe<? extends ICalComponent> componentScribe = this.index.getComponentScribe(component);
        this.writer.writeBeginComponent(componentScribe.getComponentName());
        List<ICalProperty> propertyObjs = componentScribe.getProperties(component);
        if (inICalendar && component.getProperty(Version.class) == null) {
            propertyObjs.add(0, new Version(this.getTargetVersion()));
        }
        for (ICalProperty propertyObj : propertyObjs) {
            this.context.setParent(component);
            ICalProperty property = propertyObj;
            this.writeProperty(property);
        }
        Collection<ICalComponent> subComponents = componentScribe.getComponents(component);
        if (inICalRoot) {
            timezones = this.tzinfo.getComponents();
            for (VTimezone timezone : timezones) {
                if (subComponents.contains(timezone)) continue;
                subComponents.add(timezone);
            }
        }
        Iterator<ICalComponent> i$ = subComponents.iterator();
        while (i$.hasNext()) {
            ICalComponent subComponentObj;
            ICalComponent subComponent = subComponentObj = i$.next();
            this.writeComponent(subComponent, component);
        }
        if (inVCalRoot && !(timezones = this.tzinfo.getComponents()).isEmpty()) {
            VTimezone timezone = timezones.iterator().next();
            DataModelConverter.VCalTimezoneProperties props = DataModelConverter.convert(timezone, this.context.getDates());
            Timezone tz = props.getTz();
            if (tz != null) {
                this.writeProperty(tz);
            }
            for (Daylight daylight : props.getDaylights()) {
                this.writeProperty(daylight);
            }
        }
        this.writer.writeEndComponent(componentScribe.getComponentName());
    }

    private void writeProperty(ICalProperty property) throws IOException {
        String value;
        switch (this.writer.getVersion()) {
            case V1_0: {
                if (property instanceof Organizer) {
                    Organizer organizer = (Organizer)property;
                    Attendee attendee = DataModelConverter.convert(organizer);
                    this.writeProperty(attendee);
                    return;
                }
                if (!(property instanceof DateTimeStamp)) break;
                return;
            }
        }
        ICalPropertyScribe<? extends ICalProperty> scribe = this.index.getPropertyScribe(property);
        try {
            value = scribe.writeText(property, this.context);
        }
        catch (SkipMeException e) {
            return;
        }
        ICalParameters parameters = scribe.prepareParameters(property, this.context);
        ICalDataType dataType = scribe.dataType(property, this.writer.getVersion());
        if (dataType != null && dataType != scribe.defaultDataType(this.writer.getVersion())) {
            parameters = new ICalParameters(parameters);
            parameters.setValue(dataType);
        }
        String propertyName = this.writer.getVersion() == ICalVersion.V1_0 && property instanceof Created ? "DCREATED" : scribe.getPropertyName();
        this.writer.writeProperty(propertyName, parameters, value);
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.close();
    }
}

