/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.Warning;
import biweekly.component.Observance;
import biweekly.io.CannotParseException;
import biweekly.io.ParseContext;
import biweekly.io.TimezoneInfo;
import biweekly.io.WriteContext;
import biweekly.io.json.JCalValue;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.ICalProperty;
import biweekly.util.DateTimeComponents;
import biweekly.util.ICalDate;
import biweekly.util.ICalDateFormat;
import biweekly.util.ListMultimap;
import biweekly.util.StringUtils;
import biweekly.util.XmlUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ICalPropertyScribe<T extends ICalProperty> {
    private static final Set<ICalVersion> allVersions = Collections.unmodifiableSet(EnumSet.allOf(ICalVersion.class));
    protected final Class<T> clazz;
    protected final String propertyName;
    private final ICalDataType defaultDataType;
    protected final QName qname;

    public ICalPropertyScribe(Class<T> clazz, String propertyName) {
        this(clazz, propertyName, null);
    }

    public ICalPropertyScribe(Class<T> clazz, String propertyName, ICalDataType defaultDataType) {
        this(clazz, propertyName, defaultDataType, new QName("urn:ietf:params:xml:ns:icalendar-2.0", propertyName.toLowerCase()));
    }

    public ICalPropertyScribe(Class<T> clazz, String propertyName, ICalDataType defaultDataType, QName qname) {
        this.clazz = clazz;
        this.propertyName = propertyName;
        this.defaultDataType = defaultDataType;
        this.qname = qname;
    }

    public Set<ICalVersion> getSupportedVersions() {
        return allVersions;
    }

    public Class<T> getPropertyClass() {
        return this.clazz;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public QName getQName() {
        return this.qname;
    }

    public final ICalParameters prepareParameters(T property, WriteContext context) {
        return this._prepareParameters(property, context);
    }

    public final ICalDataType defaultDataType(ICalVersion version) {
        return this._defaultDataType(version);
    }

    public final ICalDataType dataType(T property, ICalVersion version) {
        return this._dataType(property, version);
    }

    public final String writeText(T property, WriteContext context) {
        return this._writeText(property, context);
    }

    public final void writeXml(T property, Element element, WriteContext context) {
        XCalElement xcalElement = new XCalElement(element);
        this._writeXml(property, xcalElement, context);
    }

    public final JCalValue writeJson(T property, WriteContext context) {
        return this._writeJson(property, context);
    }

    public final T parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        T property = this._parseText(value, dataType, parameters, context);
        ((ICalProperty)property).setParameters(parameters);
        return property;
    }

    public final T parseXml(Element element, ICalParameters parameters, ParseContext context) {
        T property = this._parseXml(new XCalElement(element), parameters, context);
        ((ICalProperty)property).setParameters(parameters);
        return property;
    }

    public final T parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        T property = this._parseJson(value, dataType, parameters, context);
        ((ICalProperty)property).setParameters(parameters);
        return property;
    }

    protected ICalParameters _prepareParameters(T property, WriteContext context) {
        return ((ICalProperty)property).getParameters();
    }

    protected ICalDataType _defaultDataType(ICalVersion version) {
        return this.defaultDataType;
    }

    protected ICalDataType _dataType(T property, ICalVersion version) {
        return this.defaultDataType(version);
    }

    protected abstract String _writeText(T var1, WriteContext var2);

    protected void _writeXml(T property, XCalElement element, WriteContext context) {
        String value = this.writeText(property, context);
        ICalDataType dataType = this.dataType(property, ICalVersion.V2_0);
        element.append(dataType, value);
    }

    protected JCalValue _writeJson(T property, WriteContext context) {
        String value = this.writeText(property, context);
        return JCalValue.single(value);
    }

    protected abstract T _parseText(String var1, ICalDataType var2, ICalParameters var3, ParseContext var4);

    protected T _parseXml(XCalElement element, ICalParameters parameters, ParseContext context) {
        String value = null;
        ICalDataType dataType = null;
        Element rawElement = element.getElement();
        List<Element> children = XmlUtils.toElementList(rawElement.getChildNodes());
        for (Element child : children) {
            if (!"urn:ietf:params:xml:ns:icalendar-2.0".equals(child.getNamespaceURI())) continue;
            String dataTypeStr = child.getLocalName();
            dataType = "unknown".equals(dataTypeStr) ? null : ICalDataType.get(dataTypeStr);
            value = child.getTextContent();
            break;
        }
        if (dataType == null) {
            value = rawElement.getTextContent();
        }
        value = ICalPropertyScribe.escape(value);
        return this._parseText(value, dataType, parameters, context);
    }

    protected T _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        return this._parseText(this.jcalValueToString(value), dataType, parameters, context);
    }

    private String jcalValueToString(JCalValue value) {
        ListMultimap<String, String> object;
        List<List<String>> structured;
        List<String> multi;
        if (value.getValues().size() > 1 && !(multi = value.asMulti()).isEmpty()) {
            return ICalPropertyScribe.list(multi);
        }
        if (!value.getValues().isEmpty() && value.getValues().get(0).getArray() != null && !(structured = value.asStructured()).isEmpty()) {
            return ICalPropertyScribe.structured(structured.toArray());
        }
        if (value.getValues().get(0).getObject() != null && !(object = value.asObject()).isEmpty()) {
            return ICalPropertyScribe.object(object.getMap());
        }
        return ICalPropertyScribe.escape(value.asSingle());
    }

    protected static boolean isInObservance(WriteContext context) {
        return context.getParent() instanceof Observance;
    }

    protected static String unescape(String text) {
        if (text == null) {
            return text;
        }
        StringBuilder sb = null;
        boolean escaped = false;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (escaped) {
                if (sb == null) {
                    sb = new StringBuilder(text.length());
                    sb.append(text.substring(0, i - 1));
                }
                escaped = false;
                if (ch == 'n' || ch == 'N') {
                    sb.append(StringUtils.NEWLINE);
                    continue;
                }
                sb.append(ch);
                continue;
            }
            if (ch == '\\') {
                escaped = true;
                continue;
            }
            if (sb == null) continue;
            sb.append(ch);
        }
        return sb == null ? text : sb.toString();
    }

    protected static String escape(String text) {
        if (text == null) {
            return text;
        }
        String chars = "\\,;";
        StringBuilder sb = null;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (chars.indexOf(ch) >= 0) {
                if (sb == null) {
                    sb = new StringBuilder(text.length());
                    sb.append(text.substring(0, i));
                }
                sb.append('\\');
            }
            if (sb == null) continue;
            sb.append(ch);
        }
        return sb == null ? text : sb.toString();
    }

    protected static Splitter splitter(char delimiter) {
        return new Splitter(delimiter);
    }

    protected static List<String> list(String value) {
        if (value.length() == 0) {
            return new ArrayList<String>(0);
        }
        return ICalPropertyScribe.splitter(',').unescape(true).split(value);
    }

    protected static String list(Object ... values) {
        return ICalPropertyScribe.list(Arrays.asList(values));
    }

    protected static <T> String list(Collection<T> values) {
        return ICalPropertyScribe.list(values, new ListCallback<T>(){

            @Override
            public String asString(T value) {
                return value.toString();
            }
        });
    }

    protected static <T> String list(Collection<T> values, final ListCallback<T> callback) {
        return StringUtils.join(values, ",", new StringUtils.JoinCallback<T>(){

            @Override
            public void handle(StringBuilder sb, T value) {
                if (value == null) {
                    return;
                }
                String valueStr = callback.asString(value);
                sb.append(ICalPropertyScribe.escape(valueStr));
            }
        });
    }

    protected static SemiStructuredIterator semistructured(String value) {
        return ICalPropertyScribe.semistructured(value, false);
    }

    protected static SemiStructuredIterator semistructured(String value, boolean nullEmpties) {
        List<String> split = ICalPropertyScribe.splitter(';').unescape(true).nullEmpties(nullEmpties).split(value);
        return new SemiStructuredIterator(split.iterator());
    }

    protected static StructuredIterator structured(String value) {
        List<String> split = ICalPropertyScribe.splitter(';').split(value);
        ArrayList<List<String>> components = new ArrayList<List<String>>(split.size());
        for (String s : split) {
            components.add(ICalPropertyScribe.list(s));
        }
        return new StructuredIterator(components.iterator());
    }

    protected static StructuredIterator structured(JCalValue value) {
        return new StructuredIterator(value.asStructured().iterator());
    }

    protected static String structured(Object ... values) {
        return StringUtils.join(Arrays.asList(values), ";", new StringUtils.JoinCallback<Object>(){

            @Override
            public void handle(StringBuilder sb, Object value) {
                if (value == null) {
                    return;
                }
                if (value instanceof Collection) {
                    Collection list = (Collection)value;
                    sb.append(ICalPropertyScribe.list(list));
                    return;
                }
                sb.append(ICalPropertyScribe.escape(value.toString()));
            }
        });
    }

    protected static <T> String object(Map<String, List<T>> value) {
        return StringUtils.join(value, ";", new StringUtils.JoinMapCallback<String, List<T>>(){

            @Override
            public void handle(StringBuilder sb, String key, List<T> value) {
                sb.append(key.toUpperCase()).append('=').append(ICalPropertyScribe.list(value));
            }
        });
    }

    protected static ListMultimap<String, String> object(String value) {
        ListMultimap<String, String> map = new ListMultimap<String, String>();
        for (String component : ICalPropertyScribe.splitter(';').unescape(false).split(value)) {
            if (component.length() == 0) continue;
            String[] split = component.split("=", 2);
            String name = ICalPropertyScribe.unescape(split[0].toUpperCase());
            List<String> values = split.length > 1 ? ICalPropertyScribe.list(split[1]) : Arrays.asList("");
            map.putAll(name, values);
        }
        return map;
    }

    protected static DateParser date(String value) {
        return new DateParser(value);
    }

    protected static DateWriter date(Date date) {
        return ICalPropertyScribe.date(date == null ? null : new ICalDate(date));
    }

    protected static DateWriter date(ICalDate date) {
        return new DateWriter(date);
    }

    protected static DateWriter date(Date date, ICalProperty property, WriteContext context) {
        return ICalPropertyScribe.date(date == null ? null : new ICalDate(date), property, context);
    }

    protected static DateWriter date(ICalDate date, ICalProperty property, WriteContext context) {
        TimezoneInfo tzinfo = context.getTimezoneInfo();
        boolean floating = tzinfo.isFloating(property);
        TimeZone tz = tzinfo.getTimeZoneToWriteIn(property);
        context.addDate(date, floating, tz);
        return ICalPropertyScribe.date(date).tz(floating, tz);
    }

    protected static ICalParameters handleTzidParameter(ICalProperty property, boolean hasTime, WriteContext context) {
        ICalParameters parameters = property.getParameters();
        if (!hasTime) {
            return parameters;
        }
        if (context.getVersion() == ICalVersion.V1_0) {
            return parameters;
        }
        TimezoneInfo tzinfo = context.getTimezoneInfo();
        boolean floating = tzinfo.isFloating(property);
        if (floating) {
            return parameters;
        }
        TimeZone timezone = tzinfo.getTimeZoneToWriteIn(property);
        if (timezone == null) {
            return parameters;
        }
        String id = (tzinfo.hasSolidusTimezone(property) ? "/" : "") + timezone.getID();
        parameters = new ICalParameters(parameters);
        parameters.setTimezoneId(id);
        return parameters;
    }

    protected static CannotParseException missingXmlElements(ICalDataType ... dataTypes) {
        String[] elements = new String[dataTypes.length];
        for (int i = 0; i < dataTypes.length; ++i) {
            ICalDataType dataType = dataTypes[i];
            elements[i] = dataType == null ? "unknown" : dataType.getName().toLowerCase();
        }
        return ICalPropertyScribe.missingXmlElements(elements);
    }

    protected static CannotParseException missingXmlElements(String ... elements) {
        return new CannotParseException(23, Arrays.toString(elements));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Result<T> {
        private final T property;
        private final List<Warning> warnings;

        public Result(T property, List<Warning> warnings) {
            this.property = property;
            this.warnings = warnings;
        }

        public List<Warning> getWarnings() {
            return this.warnings;
        }

        public T getProperty() {
            return this.property;
        }
    }

    protected static class DateWriter {
        private ICalDate date;
        private TimeZone timezone;
        private boolean observance = false;
        private boolean extended = false;
        private boolean utc = false;

        public DateWriter(ICalDate date) {
            this.date = date;
        }

        public DateWriter observance(boolean observance) {
            this.observance = observance;
            return this;
        }

        public DateWriter utc(boolean utc) {
            this.utc = utc;
            return this;
        }

        public DateWriter tz(boolean floating, TimeZone timezone) {
            if (floating) {
                timezone = TimeZone.getDefault();
            }
            this.timezone = timezone;
            return this;
        }

        public DateWriter extended(boolean extended) {
            this.extended = extended;
            return this;
        }

        public String write() {
            ICalDateFormat format;
            if (this.date == null) {
                return "";
            }
            if (this.observance) {
                DateTimeComponents components = this.date.getRawComponents();
                if (components == null) {
                    ICalDateFormat format2 = this.extended ? ICalDateFormat.DATE_TIME_EXTENDED_WITHOUT_TZ : ICalDateFormat.DATE_TIME_BASIC_WITHOUT_TZ;
                    return format2.format(this.date);
                }
                return components.toString(true, this.extended);
            }
            if (this.utc) {
                ICalDateFormat format3 = this.extended ? ICalDateFormat.UTC_TIME_EXTENDED : ICalDateFormat.UTC_TIME_BASIC;
                return format3.format(this.date);
            }
            TimeZone timezone = this.timezone;
            if (this.date.hasTime()) {
                format = timezone == null ? (this.extended ? ICalDateFormat.UTC_TIME_EXTENDED : ICalDateFormat.UTC_TIME_BASIC) : (this.extended ? ICalDateFormat.DATE_TIME_EXTENDED_WITHOUT_TZ : ICalDateFormat.DATE_TIME_BASIC_WITHOUT_TZ);
            } else {
                format = this.extended ? ICalDateFormat.DATE_EXTENDED : ICalDateFormat.DATE_BASIC;
                timezone = null;
            }
            return format.format(this.date, timezone);
        }
    }

    protected static class DateParser {
        private String value;
        private Boolean hasTime;

        public DateParser(String value) {
            this.value = value;
        }

        public DateParser hasTime(Boolean hasTime) {
            this.hasTime = hasTime;
            return this;
        }

        public ICalDate parse() {
            DateTimeComponents components = DateTimeComponents.parse(this.value, this.hasTime);
            Date date = components.toDate();
            boolean hasTime = components.hasTime();
            return new ICalDate(date, components, hasTime);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SemiStructuredIterator {
        private final Iterator<String> it;

        public SemiStructuredIterator(Iterator<String> it) {
            this.it = it;
        }

        public String next() {
            return this.hasNext() ? this.it.next() : null;
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class StructuredIterator {
        private final Iterator<List<String>> it;

        public StructuredIterator(Iterator<List<String>> it) {
            this.it = it;
        }

        public String nextString() {
            if (!this.hasNext()) {
                return null;
            }
            List<String> list = this.it.next();
            if (list.isEmpty()) {
                return null;
            }
            String value = list.get(0);
            return value.length() == 0 ? null : value;
        }

        public List<String> nextComponent() {
            if (!this.hasNext()) {
                return new ArrayList<String>(0);
            }
            List<String> list = this.it.next();
            if (list.size() == 1 && list.get(0).length() == 0) {
                return new ArrayList<String>(0);
            }
            return list;
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface ListCallback<T> {
        public String asString(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Splitter {
        private char delimiter;
        private boolean unescape = false;
        private boolean nullEmpties = false;
        private int limit = -1;

        public Splitter(char delimiter) {
            this.delimiter = delimiter;
        }

        public Splitter unescape(boolean unescape) {
            this.unescape = unescape;
            return this;
        }

        public Splitter nullEmpties(boolean nullEmpties) {
            this.nullEmpties = nullEmpties;
            return this;
        }

        public Splitter limit(int limit) {
            this.limit = limit;
            return this;
        }

        public List<String> split(String string) {
            ArrayList<String> list = new ArrayList<String>();
            boolean escaped = false;
            int start = 0;
            for (int i = 0; i < string.length(); ++i) {
                char ch = string.charAt(i);
                if (escaped) {
                    escaped = false;
                    continue;
                }
                if (ch == this.delimiter) {
                    this.add(string.substring(start, i), list);
                    start = i + 1;
                    if (this.limit <= 0 || list.size() != this.limit - 1) continue;
                    break;
                }
                if (ch != '\\') continue;
                escaped = true;
            }
            this.add(string.substring(start), list);
            return list;
        }

        private void add(String str, List<String> list) {
            str = str.trim();
            if (this.nullEmpties && str.length() == 0) {
                str = null;
            } else if (this.unescape) {
                str = ICalPropertyScribe.unescape(str);
            }
            list.add(str);
        }
    }
}

