/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io;

import biweekly.component.VTimezone;
import biweekly.io.TzUrlDotOrgGenerator;
import biweekly.io.VTimezoneGenerator;
import biweekly.property.ICalProperty;
import biweekly.property.TimezoneId;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimezoneInfo {
    private final Map<VTimezone, TimeZone> assignments = new HashMap<VTimezone, TimeZone>();
    private final Map<TimeZone, VTimezone> assignmentsReverse = new HashMap<TimeZone, VTimezone>();
    private final Map<String, TimeZone> timezonesById = new HashMap<String, TimeZone>();
    private final Map<ICalProperty, TimeZone> propertyTimeZones = new HashMap<ICalProperty, TimeZone>();
    private final Set<ICalProperty> hasSolidusTimezone = new HashSet<ICalProperty>();
    private final Set<ICalProperty> floatingProperties = new HashSet<ICalProperty>();
    private VTimezoneGenerator generator = new TzUrlDotOrgGenerator(false);
    private TimeZone defaultTimezone;
    private boolean globalFloatingTime = false;

    public void assign(VTimezone component, TimeZone timezone) {
        this.checkForId(component);
        this.assignments.put(component, timezone);
        this.assignmentsReverse.put(timezone, component);
        this.timezonesById.put((String)component.getTimezoneId().getValue(), timezone);
    }

    public void setDefaultTimeZone(TimeZone timezone) {
        if (timezone == null) {
            this.defaultTimezone = null;
            return;
        }
        VTimezone component = this.assignmentsReverse.get(timezone);
        if (component == null) {
            component = this.generator.generate(timezone);
            this.assign(component, timezone);
        }
        this.defaultTimezone = timezone;
    }

    public void setGlobalFloatingTime(boolean enable) {
        this.globalFloatingTime = enable;
    }

    public void setTimeZone(ICalProperty property, TimeZone timezone) {
        this.setTimeZone(property, timezone, true);
    }

    public void setTimeZone(ICalProperty property, TimeZone timezone, boolean generateComponent) {
        if (timezone == null) {
            this.propertyTimeZones.remove(property);
            this.hasSolidusTimezone.remove(property);
            return;
        }
        if (generateComponent) {
            VTimezone component = this.assignmentsReverse.get(timezone);
            if (component == null) {
                component = this.generator.generate(timezone);
                this.assign(component, timezone);
            }
        } else {
            this.hasSolidusTimezone.add(property);
        }
        this.propertyTimeZones.put(property, timezone);
    }

    void setTimeZoneReader(ICalProperty property, TimeZone timezone, boolean solidus) {
        if (solidus) {
            this.hasSolidusTimezone.add(property);
        }
        this.propertyTimeZones.put(property, timezone);
    }

    public TimeZone getTimeZone(ICalProperty property) {
        return this.propertyTimeZones.get(property);
    }

    public boolean hasSolidusTimezone(ICalProperty property) {
        return this.hasSolidusTimezone.contains(property);
    }

    public TimeZone getTimeZoneToWriteIn(ICalProperty property) {
        TimeZone timezone = this.getTimeZone(property);
        return timezone == null ? this.defaultTimezone : timezone;
    }

    public TimeZone getTimeZoneById(String id) {
        return this.timezonesById.get(id);
    }

    public TimeZone getTimeZoneByComponent(VTimezone component) {
        return this.assignments.get(component);
    }

    public VTimezone getComponent(ICalProperty property) {
        if (this.hasSolidusTimezone.contains(property)) {
            return null;
        }
        TimeZone timezone = this.getTimeZone(property);
        return this.assignmentsReverse.get(timezone);
    }

    public void setFloating(ICalProperty property, boolean enable) {
        if (enable) {
            this.floatingProperties.add(property);
        } else {
            this.floatingProperties.remove(property);
        }
    }

    public boolean isFloating(ICalProperty property) {
        if (this.floatingProperties.contains(property)) {
            return true;
        }
        if (this.propertyTimeZones.containsKey(property)) {
            return false;
        }
        return this.globalFloatingTime;
    }

    public Collection<VTimezone> getComponents() {
        return this.assignments.keySet();
    }

    public VTimezoneGenerator getGenerator() {
        return this.generator;
    }

    public void setGenerator(VTimezoneGenerator generator) {
        this.generator = generator;
    }

    private void checkForId(VTimezone timezone) {
        TimezoneId id = timezone.getTimezoneId();
        if (id == null || id.getValue() == null || ((String)id.getValue()).trim().length() == 0) {
            throw new IllegalArgumentException("VTimezone component must have a non-empty TimezoneId property");
        }
    }
}

