/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util.queue;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.log4j.Logger;
import org.unitime.timetable.util.queue.QueueItem;
import org.unitime.timetable.util.queue.QueueProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalQueueProcessor
extends Thread
implements QueueProcessor {
    protected static Logger sLog = Logger.getLogger(QueueProcessor.class);
    protected static long sTimeToKeep = 36000000L;
    protected static long sTimeToSleep = 3600000L;
    private Queue<QueueItem> iQueue = new LinkedList<QueueItem>();
    private List<QueueItem> iFinished = new ArrayList<QueueItem>();
    private QueueItem iItem = null;
    private RunningItem iRunningItem = null;
    protected static LocalQueueProcessor sInstance = null;
    private boolean iCanContinue = true;

    protected LocalQueueProcessor() {
        super("QueueProcessor");
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        sLog.info((Object)"Queue processor is up and running.");
        while (this.iCanContinue) {
            Queue<QueueItem> queue = this.iQueue;
            synchronized (queue) {
                long now = new Date().getTime();
                Iterator<QueueItem> i = this.iFinished.iterator();
                while (i.hasNext()) {
                    QueueItem item = i.next();
                    if (item.finished() != null && now - item.finished().getTime() <= sTimeToKeep) continue;
                    i.remove();
                }
                if (this.iQueue.isEmpty()) {
                    sLog.info((Object)"Waiting for tasks to run...");
                    try {
                        this.iQueue.wait(sTimeToSleep);
                    }
                    catch (InterruptedException e) {
                        sLog.info((Object)"Interrupted.");
                    }
                }
                this.iItem = this.iQueue.poll();
                if (this.iItem == null) {
                    continue;
                }
            }
            sLog.info((Object)("Executing " + this.iItem.name()));
            this.iRunningItem = new RunningItem(this.iItem);
            this.iRunningItem.start();
            try {
                this.iRunningItem.join();
            }
            catch (InterruptedException e) {
                sLog.info((Object)("Task " + this.iItem.name() + " was interrupted."));
            }
            sLog.info((Object)("Task " + this.iItem.name() + (this.iItem.hasError() ? " failed (" + this.iItem.error().getMessage() + ")." : " is done.")));
            queue = this.iQueue;
            synchronized (queue) {
                this.iFinished.add(this.iItem);
                this.iItem = null;
            }
        }
        sLog.info((Object)"Queue processor is down.");
        sInstance = null;
    }

    public static synchronized QueueProcessor getInstance() {
        if (sInstance == null) {
            sInstance = new LocalQueueProcessor();
            sInstance.start();
        }
        return sInstance;
    }

    public String generateId() {
        String id;
        while (this.get(id = UUID.randomUUID().toString()) != null) {
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueueItem add(QueueItem item) {
        Queue<QueueItem> queue = this.iQueue;
        synchronized (queue) {
            if (item.getId() == null) {
                item.setId(this.generateId());
            }
            this.iQueue.add(item);
            this.iQueue.notify();
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<QueueItem> getItems(String ownerId, Long sessionId, String type) {
        Queue<QueueItem> queue = this.iQueue;
        synchronized (queue) {
            ArrayList<QueueItem> ret = new ArrayList<QueueItem>();
            for (QueueItem item : this.iFinished) {
                if (ownerId != null && !ownerId.equals(item.getOwnerId()) || sessionId != null && !sessionId.equals(item.getSessionId()) || type != null && !type.equals(item.type())) continue;
                ret.add(item);
            }
            if (this.iItem != null) {
                boolean add = true;
                if (ownerId != null && !ownerId.equals(this.iItem.getOwnerId())) {
                    add = false;
                }
                if (sessionId != null && !sessionId.equals(this.iItem.getSessionId())) {
                    add = false;
                }
                if (type != null && !type.equals(this.iItem.type())) {
                    add = false;
                }
                if (add) {
                    ret.add(this.iItem);
                }
            }
            for (QueueItem item : this.iQueue) {
                if (ownerId != null && !ownerId.equals(item.getOwnerId()) || sessionId != null && !sessionId.equals(item.getSessionId()) || type != null && !type.equals(item.type())) continue;
                ret.add(item);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueueItem get(String id) {
        Queue<QueueItem> queue = this.iQueue;
        synchronized (queue) {
            for (QueueItem item : this.iQueue) {
                if (!id.equals(item.getId())) continue;
                return item;
            }
            for (QueueItem item : this.iFinished) {
                if (!id.equals(item.getId())) continue;
                return item;
            }
        }
        if (this.iItem != null && id.equals(this.iItem.getId())) {
            return this.iItem;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueueItem getByExecutionId(Long id) {
        Queue<QueueItem> queue = this.iQueue;
        synchronized (queue) {
            for (QueueItem item : this.iQueue) {
                if (!id.equals(item.getTaskExecutionId())) continue;
                return item;
            }
            for (QueueItem item : this.iFinished) {
                if (!id.equals(item.getTaskExecutionId())) continue;
                return item;
            }
        }
        if (this.iItem != null && id.equals(this.iItem.getTaskExecutionId())) {
            return this.iItem;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(String id) {
        Queue<QueueItem> queue = this.iQueue;
        synchronized (queue) {
            QueueItem item;
            Iterator<Object> i = this.iQueue.iterator();
            while (i.hasNext()) {
                item = (QueueItem)i.next();
                if (!id.equals(item.getId())) continue;
                i.remove();
                return true;
            }
            i = this.iFinished.iterator();
            while (i.hasNext()) {
                item = (QueueItem)i.next();
                if (!id.equals(item.getId())) continue;
                i.remove();
                return true;
            }
        }
        if (this.iItem != null && id.equals(this.iItem.getId())) {
            this.iRunningItem.cancel();
        }
        return false;
    }

    public static void stopProcessor() {
        if (sInstance == null) {
            return;
        }
        sLog.info((Object)"Stopping queue processor...");
        try {
            LocalQueueProcessor.sInstance.iCanContinue = false;
            sInstance.interrupt();
            sInstance.join();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public DataSource getFile(String id) {
        QueueItem item = this.get(id);
        if (item != null && item.hasOutput()) {
            return new FileDataSource(item.output());
        }
        return null;
    }

    static class RunningItem
    extends Thread {
        boolean iInterrupted = false;
        QueueItem iRunningItem = null;

        private RunningItem(QueueItem item) {
            super("QueueRunner(" + item.name() + ")");
            this.iRunningItem = item;
            this.setDaemon(true);
        }

        public void run() {
            this.iRunningItem.executeItem();
        }

        public void cancel() {
            if (this.iInterrupted) {
                this.stop();
            } else {
                this.interrupt();
                this.iInterrupted = true;
            }
        }
    }
}

