/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.solver.jgroups.CourseSolverContainer;
import org.unitime.timetable.solver.jgroups.SolverServer;
import org.unitime.timetable.solver.jgroups.SolverServerImplementation;
import org.unitime.timetable.solver.ui.TimetableInfo;
import org.unitime.timetable.solver.ui.TimetableInfoFileProxy;

public class TimetableInfoUtil
implements TimetableInfoFileProxy {
    private static Log sLog = LogFactory.getLog(TimetableInfoUtil.class);
    private static TimetableInfoUtil sInstance = new TimetableInfoUtil();

    private TimetableInfoUtil() {
    }

    public static TimetableInfoUtil getLocalInstance() {
        return sInstance;
    }

    public static TimetableInfoFileProxy getInstance() {
        SolverServer server = SolverServerImplementation.getInstance();
        if (server != null && server.getCourseSolverContainer() != null) {
            return ((CourseSolverContainer)server.getCourseSolverContainer()).getFileProxy();
        }
        return TimetableInfoUtil.getLocalInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveToFile(String name, TimetableInfo info) {
        boolean bl;
        FileOutputStream out = null;
        try {
            try {
                File file = new File(ApplicationProperties.getBlobFolder(), name);
                file.getParentFile().mkdirs();
                out = new FileOutputStream(file);
                XMLWriter writer = new XMLWriter((OutputStream)new GZIPOutputStream(out), OutputFormat.createCompactFormat());
                Document document = DocumentHelper.createDocument();
                Element root = document.addElement(info.getClass().getName());
                info.save(root);
                writer.write(document);
                writer.flush();
                writer.close();
                out.flush();
                out.close();
                out = null;
                sLog.info((Object)("Saved info " + name + " as " + file + " (" + file.length() + " bytes)"));
                bl = true;
                Object var10_11 = null;
            }
            catch (Exception e) {
                sLog.warn((Object)("Failed to save info " + name + ": " + e.getMessage()), (Throwable)e);
                boolean bl2 = false;
                Object var10_12 = null;
                try {
                    if (out == null) return bl2;
                    out.close();
                    return bl2;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            if (out == null) throw throwable;
            out.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return bl;
        }
        if (out == null) return bl;
        out.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TimetableInfo loadFromFile(String name) {
        try {
            Document document;
            block6: {
                File file = new File(ApplicationProperties.getBlobFolder(), name);
                if (!file.exists()) {
                    return null;
                }
                sLog.info((Object)("Loading info " + name + " from " + file + " (" + file.length() + " bytes)"));
                document = null;
                GZIPInputStream gzipInput = null;
                try {
                    gzipInput = new GZIPInputStream(new FileInputStream(file));
                    document = new SAXReader().read((InputStream)gzipInput);
                    Object var6_6 = null;
                    if (gzipInput == null) break block6;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (gzipInput != null) {
                        gzipInput.close();
                    }
                    throw throwable;
                }
                gzipInput.close();
            }
            Element root = document.getRootElement();
            String infoClassName = root.getName();
            Class<?> infoClass = Class.forName(infoClassName);
            TimetableInfo info = (TimetableInfo)infoClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            info.load(root);
            return info;
        }
        catch (Exception e) {
            sLog.warn((Object)("Failed to load info " + name + ": " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public boolean deleteFile(String name) {
        try {
            File file = new File(ApplicationProperties.getBlobFolder(), name);
            if (file.exists()) {
                sLog.info((Object)("Deleting info " + name + " as " + file + " (" + file.length() + " bytes)"));
                file.delete();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            sLog.warn((Object)("Failed to delete info " + name + ": " + e.getMessage()), (Throwable)e);
            return false;
        }
    }
}

