/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.jgroups;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.DataProperties;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.SuspectedException;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.mux.MuxRpcDispatcher;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.solver.jgroups.RemoteSolver;
import org.unitime.timetable.solver.jgroups.RemoteSolverContainer;
import org.unitime.timetable.solver.jgroups.SolverServerImplementation;
import org.unitime.timetable.solver.jgroups.StudentSolverContainer;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudentSolverContainerRemote
extends StudentSolverContainer
implements RemoteSolverContainer<StudentSolverProxy> {
    private static Log sLog = LogFactory.getLog(StudentSolverContainerRemote.class);
    private RpcDispatcher iDispatcher;

    public StudentSolverContainerRemote(JChannel channel, short scope) {
        this.iDispatcher = new MuxRpcDispatcher(scope, (Channel)channel, null, null, (Object)this);
    }

    @Override
    public RpcDispatcher getDispatcher() {
        return this.iDispatcher;
    }

    @Override
    public boolean createRemoteSolver(String user, DataProperties config, Address caller) {
        super.createSolver(user, config);
        return true;
    }

    @Override
    public Object invoke(String method, String user, Class[] types, Object[] args) throws Exception {
        Object object;
        StudentSolverProxy solver;
        block7: {
            solver = (StudentSolverProxy)this.iStudentSolvers.get(user);
            if (!"exists".equals(method) || types.length != 0) break block7;
            Boolean bl = solver != null;
            Object var8_9 = null;
            _RootDAO.closeCurrentThreadSessions();
            return bl;
        }
        try {
            if (solver == null) {
                throw new Exception("Solver " + user + " does not exist.");
            }
            object = solver.getClass().getMethod(method, types).invoke((Object)solver, args);
            Object var8_10 = null;
        }
        catch (InvocationTargetException e) {
            try {
                if (e.getTargetException() != null && e.getTargetException() instanceof Exception) {
                    throw (Exception)e.getTargetException();
                }
                throw e;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                _RootDAO.closeCurrentThreadSessions();
                throw throwable;
            }
        }
        _RootDAO.closeCurrentThreadSessions();
        return object;
    }

    @Override
    public Object dispatch(Address address, String user, Method method, Object[] args) throws Exception {
        try {
            return this.iDispatcher.callRemoteMethod(address, "invoke", new Object[]{method.getName(), user, method.getParameterTypes(), args}, new Class[]{String.class, String.class, Class[].class, Object[].class}, SolverServerImplementation.sFirstResponse);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null && e.getTargetException() instanceof Exception) {
                throw (Exception)e.getTargetException();
            }
            throw e;
        }
        catch (Exception e) {
            if ("exists".equals(method.getName()) && e instanceof SuspectedException) {
                return false;
            }
            sLog.error((Object)("Excution of " + method.getName() + " on solver " + user + " failed: " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    @Override
    public StudentSolverProxy createProxy(Address address, String user) {
        SolverInvocationHandler handler = new SolverInvocationHandler(address, user);
        return (StudentSolverProxy)Proxy.newProxyInstance(StudentSolverProxy.class.getClassLoader(), new Class[]{StudentSolverProxy.class, RemoteSolver.class}, (InvocationHandler)handler);
    }

    public class SolverInvocationHandler
    implements InvocationHandler {
        private Address iAddress;
        private String iUser;

        private SolverInvocationHandler(Address address, String user) {
            this.iAddress = address;
            this.iUser = user;
        }

        public String getHost() {
            return this.iAddress.toString();
        }

        public String getUser() {
            return this.iUser;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return this.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke((Object)this, args);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return StudentSolverContainerRemote.this.dispatch(this.iAddress, this.iUser, method, args);
            }
        }
    }
}

