/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.interactive;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.interactive.Hint;
import org.unitime.timetable.solver.interactive.Suggestion;
import org.unitime.timetable.solver.interactive.Suggestions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuggestionsModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String[] sFilters = new String[]{"No Restrictions", "Same Time", "Same Room"};
    public static final int sFilterNoFilter = 0;
    public static final int sFilterSameTime = 1;
    public static final int sFilterSameRoom = 2;
    private boolean iCanAllowBreakHard = false;
    private boolean iAllowBreakHard = false;
    private boolean iDisplayCBS = true;
    private boolean iAllTheSame = true;
    private int iDepth = 2;
    private long iTimeOut = 5000L;
    private int iFilter = 0;
    private boolean iCompute = true;
    private boolean iDisplayFilter = false;
    private boolean iDisplayPlacements = false;
    private int iLimit = 20;
    private String iFilterText = null;
    private boolean iSimpleMode = true;
    private boolean iReversedMode = false;
    private int iMinRoomSize = -1;
    private int iMaxRoomSize = -1;
    private boolean iDisplaySuggestions = true;
    private boolean iDisplayConfTable = false;
    public Vector iHints = new Vector();
    public Long iClassId = null;
    private transient TreeSet iSuggestions = null;
    private transient Suggestion iCurrentSuggestion = null;
    private transient boolean iTimeoutReached = false;
    private transient long iNrCombinationsConsidered = 0L;
    private transient long iNrSolutions = 0L;
    private transient long iNrTries = 0L;
    private transient TreeSet iTryAssignments = null;
    private transient Suggestion iSelectedSuggestion = null;
    private transient Suggestion iEmptySuggestion = null;
    private transient Vector iConfTable = null;

    public void reset(SolverProxy solver) throws Exception {
        this.iCanAllowBreakHard = this.getCanAllowBreakHard(solver);
        if (!this.iCanAllowBreakHard) {
            this.iAllowBreakHard = false;
        }
        this.iSelectedSuggestion = null;
        this.iDepth = 2;
        this.iTimeOut = 5000L;
        this.iCompute = true;
        this.iHints.clear();
        this.iDisplayFilter = this.canDisplayFilter(solver);
        this.iFilter = 0;
        this.iFilterText = null;
        this.iMinRoomSize = -1;
        this.iMaxRoomSize = -1;
    }

    public boolean canDisplayFilter() {
        return this.iDisplayFilter;
    }

    public boolean isComputed() {
        return !this.iCompute;
    }

    public void recompute() {
        this.iCompute = true;
    }

    public void setFilter(int filter) {
        if (this.iFilter != filter) {
            this.iFilter = filter;
            this.iCompute = true;
        }
    }

    public int getFilter() {
        return this.iFilter;
    }

    public void setAllTheSame(boolean allTheSame) {
        if (this.iAllTheSame != allTheSame) {
            this.iAllTheSame = allTheSame;
            this.iCompute = true;
        }
    }

    public boolean isAllTheSame() {
        return this.iAllTheSame;
    }

    public void setDepth(int depth) {
        if (this.iDepth != depth) {
            this.iDepth = depth;
            this.iCompute = true;
        }
    }

    public int getDepth() {
        return this.iDepth;
    }

    public void incDepth() {
        ++this.iDepth;
        this.iCompute = true;
    }

    public long getTimeout() {
        return this.iTimeOut;
    }

    public void setTimeout(long timeout) {
        if (this.iTimeOut != timeout) {
            this.iTimeOut = timeout;
            this.iCompute = true;
        }
    }

    public void doubleTimeout() {
        this.iTimeOut *= 2L;
        this.iCompute = true;
    }

    public boolean getCanAllowBreakHard() {
        return this.iCanAllowBreakHard;
    }

    public void setAllowBreakHard(boolean allowBreakHard) {
        if (this.iAllowBreakHard != allowBreakHard) {
            this.iAllowBreakHard = allowBreakHard;
            this.iCompute = true;
        }
    }

    public boolean getAllowBreakHard() {
        return this.iAllowBreakHard;
    }

    public boolean getDisplayCBS() {
        return this.iDisplayCBS;
    }

    public void setDisplayCBS(boolean displayCBS) {
        this.iDisplayCBS = displayCBS;
    }

    public boolean getDisplayPlacements() {
        return this.iDisplayPlacements;
    }

    public void setDisplayPlacements(boolean displayPlacements) {
        this.iDisplayPlacements = displayPlacements;
        this.iCompute = true;
    }

    public int getLimit() {
        return this.iLimit;
    }

    public void setLimit(int limit) {
        this.iLimit = limit;
        this.iCompute = true;
    }

    public boolean getSimpleMode() {
        return this.iSimpleMode;
    }

    public void setSimpleMode(boolean simpleMode) {
        this.iSimpleMode = simpleMode;
    }

    public boolean getReversedMode() {
        return this.iReversedMode;
    }

    public void setReversedMode(boolean reversedMode) {
        this.iReversedMode = reversedMode;
    }

    public String getFilterText() {
        return this.iFilterText;
    }

    public void setFilterText(String text) {
        this.iFilterText = text;
        this.iCompute = true;
    }

    public int getMinRoomSize() {
        return this.iMinRoomSize;
    }

    public int getMaxRoomSize() {
        return this.iMaxRoomSize;
    }

    public void setMinRoomSize(int minRoomSize) {
        this.iMinRoomSize = minRoomSize;
    }

    public void setMaxRoomSize(int maxRoomSize) {
        this.iMaxRoomSize = maxRoomSize;
    }

    public boolean getDisplayConfTable() {
        return this.iDisplayConfTable;
    }

    public void setDisplayConfTable(boolean displayConfTable) {
        this.iDisplayConfTable = displayConfTable;
    }

    public boolean getDisplaySuggestions() {
        return this.iDisplaySuggestions;
    }

    public void setDisplaySuggestions(boolean displaySuggestions) {
        this.iDisplaySuggestions = displaySuggestions;
    }

    public void setClassId(Long classId) {
        if (!classId.equals(this.iClassId)) {
            this.iClassId = classId;
            this.iCompute = true;
        }
    }

    public Long getClassId() {
        return this.iClassId;
    }

    public Vector getHints() {
        return this.iHints;
    }

    public void addHint(Long classId, int days, int startSlots, List<Long> roomIds, Long patternId, Long datePatternId) {
        Hint hint = new Hint(classId, days, startSlots, roomIds, patternId, datePatternId);
        Hint prev = null;
        Enumeration e = this.iHints.elements();
        while (e.hasMoreElements()) {
            Hint h = (Hint)e.nextElement();
            if (!h.getClassId().equals(hint.getClassId())) continue;
            prev = h;
            break;
        }
        if (prev != null) {
            this.iHints.remove(prev);
        }
        this.iHints.add(hint);
        this.iSelectedSuggestion = null;
        this.iCompute = true;
    }

    public void remHint(Long classId) {
        Hint rem = null;
        Enumeration e = this.iHints.elements();
        while (e.hasMoreElements()) {
            Hint h = (Hint)e.nextElement();
            if (!h.getClassId().equals(classId)) continue;
            rem = h;
            break;
        }
        if (rem != null) {
            this.iHints.remove(rem);
            this.iSelectedSuggestion = null;
            this.iCompute = true;
        }
    }

    public boolean getCanAllowBreakHard(SolverProxy solver) throws Exception {
        return solver == null ? false : solver.getProperties().getPropertyBoolean("General.InteractiveMode", false);
    }

    public boolean canDisplayFilter(SolverProxy solver) {
        return solver != null;
    }

    public Suggestion getSelectedSuggestion() {
        return this.iSelectedSuggestion;
    }

    public void selectSuggestion(int ord) {
        this.iSelectedSuggestion = (Suggestion)this.iSuggestions.toArray()[ord];
    }

    public void selectPlacement(int ord) {
        Hint hint = ((Suggestion)this.iTryAssignments.toArray()[ord]).getHint();
        if (hint != null) {
            this.addHint(hint.getClassId(), hint.getDays(), hint.getStartSlot(), hint.getRoomIds(), hint.getPatternId(), hint.getDatePatternId());
        }
    }

    public Suggestion getEmptySuggestion() {
        return this.iEmptySuggestion;
    }

    public boolean compute(SolverProxy solver) throws Exception {
        if (!this.iCompute) {
            return true;
        }
        if (solver == null) {
            return false;
        }
        Suggestions suggestions = solver.getSuggestions(this);
        if (suggestions == null) {
            return false;
        }
        this.iSuggestions = suggestions.getSuggestions();
        this.iTimeoutReached = suggestions.getTimeoutReached();
        this.iNrCombinationsConsidered = suggestions.getNrCombinationsConsidered();
        this.iNrSolutions = suggestions.getNrSolutions();
        this.iCurrentSuggestion = suggestions.currentSuggestion();
        this.iTryAssignments = suggestions.tryAllAssignments();
        this.iNrTries = suggestions.getNrTries();
        this.iEmptySuggestion = suggestions.emptySuggestion();
        this.iHints = suggestions.getHints();
        this.iCompute = false;
        this.iConfTable = suggestions.getConfTable();
        return true;
    }

    public TreeSet getSuggestions() {
        return this.iSuggestions;
    }

    public Suggestion getCurrentSuggestion() {
        return this.iCurrentSuggestion;
    }

    public TreeSet getTryAssignments() {
        return this.iTryAssignments;
    }

    public boolean getTimeoutReached() {
        return this.iTimeoutReached;
    }

    public long getNrCombinationsConsidered() {
        return this.iNrCombinationsConsidered;
    }

    public long getNrSolutions() {
        return this.iNrSolutions;
    }

    public long getNrTries() {
        return this.iNrTries;
    }

    public Vector getConfTable() {
        return this.iConfTable;
    }

    public void save(UserContext user) {
        user.setProperty("SuggestionsModel.allowBreakHard", this.getAllowBreakHard() ? "1" : "0");
        user.setProperty("SuggestionsModel.displayCBS", this.getDisplayCBS() ? "1" : "0");
        user.setProperty("SuggestionsModel.displayPlacements", this.getDisplayPlacements() ? "1" : "0");
        user.setProperty("SuggestionsModel.simpleMode", this.getSimpleMode() ? "1" : "0");
        user.setProperty("SuggestionsModel.limit", String.valueOf(this.getLimit()));
        user.setProperty("SuggestionsModel.displayConfTable", this.getDisplayConfTable() ? "1" : "0");
        user.setProperty("SuggestionsModel.displaySuggestions", this.getDisplaySuggestions() ? "1" : "0");
        user.setProperty("SuggestionsModel.reversedMode", this.getReversedMode() ? "1" : "0");
    }

    public void load(UserContext context) {
        this.setAllowBreakHard(this.getCanAllowBreakHard() && "1".equals(context.getProperty("SuggestionsModel.allowBreakHard", this.getAllowBreakHard() ? "1" : "0")));
        this.setDisplayCBS("1".equals(context.getProperty("SuggestionsModel.displayCBS", this.getDisplayCBS() ? "1" : "0")));
        this.setDisplayPlacements("1".equals(context.getProperty("SuggestionsModel.displayPlacements", this.getDisplayPlacements() ? "1" : "0")));
        this.setSimpleMode("1".equals(context.getProperty("SuggestionsModel.simpleMode", this.getSimpleMode() ? "1" : "0")));
        this.setLimit(Integer.parseInt(context.getProperty("SuggestionsModel.limit", String.valueOf(this.getLimit()))));
        this.setDisplayConfTable("1".equals(context.getProperty("SuggestionsModel.displayConfTable", this.getDisplayConfTable() ? "1" : "0")));
        this.setDisplaySuggestions("1".equals(context.getProperty("SuggestionsModel.displaySuggestions", this.getDisplaySuggestions() ? "1" : "0")));
        this.setReversedMode("1".equals(context.getProperty("SuggestionsModel.reversedMode", this.getReversedMode() ? "1" : "0")));
    }

    public String toString() {
        return "SuggestionModel{\n  canAllowBreakHard = " + this.iCanAllowBreakHard + "\n  allowBreakHard = " + this.iAllowBreakHard + "\n  displayCBS = " + this.iDisplayCBS + "\n  allTheSame = " + this.iAllTheSame + "\n  depth = " + this.iDepth + "\n  timeOut = " + this.iTimeOut + "\n  filter = " + this.iFilter + "\n  compute = " + this.iCompute + "\n  displayFilter = " + this.iDisplayFilter + "\n  displayPlacements = " + this.iDisplayPlacements + "\n  limit = " + this.iLimit + "\n  filterText = " + this.iFilterText + "\n  simpleMode = " + this.iSimpleMode + "\n  reversedMode = " + this.iReversedMode + "\n  minRoomSize = " + this.iMinRoomSize + "\n  maxRoomSize = " + this.iMaxRoomSize + "\n  displaySuggestions = " + this.iDisplaySuggestions + "\n  displayConfTable = " + this.iDisplayConfTable + "\n  hints = " + this.iHints + "\n  classId = " + this.iClassId + "\n  suggestions = " + this.iSuggestions + "\n  currentSuggestion = " + this.iCurrentSuggestion + "\n  timeoutReached = " + this.iTimeoutReached + "\n  nrCombinationsConsidered = " + this.iNrCombinationsConsidered + "\n  nrSolutions = " + this.iNrSolutions + "\n  nrTries = " + this.iNrTries + "\n  tryAssignments = " + this.iTryAssignments + "\n  selectedSuggestion = " + this.iSelectedSuggestion + "\n  emptySuggestion = " + this.iEmptySuggestion + "\n  confTable = " + this.iConfTable + "\n}";
    }
}

