/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.interactive;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.cpsolver.coursett.constraint.FlexibleConstraint;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.cpsolver.coursett.constraint.InstructorConstraint;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.criteria.BackToBackInstructorPreferences;
import org.cpsolver.coursett.criteria.BrokenTimePatterns;
import org.cpsolver.coursett.criteria.DepartmentBalancingPenalty;
import org.cpsolver.coursett.criteria.DistributionPreferences;
import org.cpsolver.coursett.criteria.FlexibleConstraintCriterion;
import org.cpsolver.coursett.criteria.Perturbations;
import org.cpsolver.coursett.criteria.RoomPreferences;
import org.cpsolver.coursett.criteria.SameSubpartBalancingPenalty;
import org.cpsolver.coursett.criteria.StudentCommittedConflict;
import org.cpsolver.coursett.criteria.StudentConflict;
import org.cpsolver.coursett.criteria.StudentDistanceConflict;
import org.cpsolver.coursett.criteria.StudentHardConflict;
import org.cpsolver.coursett.criteria.TimePreferences;
import org.cpsolver.coursett.criteria.TooBigRooms;
import org.cpsolver.coursett.criteria.UselessHalfHours;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.dom4j.Element;
import org.unitime.commons.Debug;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.interactive.ClassAssignmentDetails;
import org.unitime.timetable.solver.interactive.Hint;
import org.unitime.timetable.solver.ui.GroupConstraintInfo;
import org.unitime.timetable.solver.ui.JenrlInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Suggestion
implements Serializable,
Comparable {
    private static final long serialVersionUID = 1L;
    private static DecimalFormat sDF = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.US));
    private double iValue = 0.0;
    private Vector iDifferentAssignments = null;
    private int iTooBigRooms = 0;
    private long iUselessSlots = 0L;
    private double iGlobalTimePreference = 0.0;
    private long iGlobalRoomPreference = 0L;
    private long iGlobalGroupConstraintPreference = 0L;
    private long iViolatedStudentConflicts = 0L;
    private long iHardStudentConflicts = 0L;
    private long iDistanceStudentConflicts = 0L;
    private long iCommitedStudentConflicts = 0L;
    private long iInstructorDistancePreference = 0L;
    private int iDepartmentSpreadPenalty = 0;
    private int iUnassignedVariables = 0;
    private double iPerturbationPenalty = 0.0;
    private int iSpreadPenalty = 0;
    private HashSet iUnresolvedConflicts = null;
    private Hint iHint = null;
    private Vector iStudentConflictInfos = null;
    private Vector iGroupConstraintInfos = null;
    private Vector iBtbInstructorInfos = null;
    private boolean iCanAssign = true;

    public Suggestion(Solver solver) {
        this((Solver<Lecture, Placement>)solver, null, null, null);
    }

    public Suggestion() {
    }

    public Suggestion(Solver<Lecture, Placement> solver, Hashtable<Lecture, Placement> initialAssignments, Vector order, Collection unresolvedConflicts) {
        Assignment assignment = solver.currentSolution().getAssignment();
        if (unresolvedConflicts != null) {
            this.iUnresolvedConflicts = new HashSet();
            Iterator i = unresolvedConflicts.iterator();
            while (i.hasNext()) {
                this.iUnresolvedConflicts.add(new Hint(solver, (Placement)i.next()));
            }
        }
        if (initialAssignments != null) {
            DistributionInfo dist;
            this.iDifferentAssignments = new Vector();
            this.iBtbInstructorInfos = new Vector();
            HashSet jenrls = new HashSet();
            HashSet gcs = new HashSet();
            HashSet fcs = new HashSet();
            Hashtable committed = new Hashtable();
            for (Lecture lecture : assignment.assignedVariables()) {
                Placement p = (Placement)assignment.getValue((Variable)lecture);
                Placement ini = initialAssignments.get(p.variable());
                if (ini != null && ini.equals((Object)p)) continue;
                this.iDifferentAssignments.add(new Hint(solver, p));
                jenrls.addAll(lecture.activeJenrls(assignment));
                if (p.getCommitedConflicts() > 0) {
                    Hashtable x = new Hashtable();
                    for (Object s : lecture.students()) {
                        Set confs = s.conflictPlacements(p);
                        if (confs == null) continue;
                        Iterator j = confs.iterator();
                        while (j.hasNext()) {
                            Placement commitedPlacement;
                            Integer current = (Integer)x.get(commitedPlacement = (Placement)j.next());
                            x.put(commitedPlacement, new Integer(1 + (current == null ? 0 : current)));
                        }
                    }
                    committed.put(p, x);
                }
                gcs.addAll(lecture.groupConstraints());
                fcs.addAll(lecture.getFlexibleGroupConstraints());
                for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
                    Object s;
                    s = ic.variables().iterator();
                    while (s.hasNext()) {
                        int pref;
                        Lecture other = (Lecture)s.next();
                        Placement otherPlacement = (Placement)assignment.getValue((Variable)other);
                        if (other.equals((Object)lecture) || otherPlacement == null || (pref = ic.getDistancePreference(p, otherPlacement)) == PreferenceLevel.sIntLevelNeutral) continue;
                        Hint h1 = new Hint(solver, p);
                        Hint h2 = new Hint(solver, otherPlacement);
                        this.iBtbInstructorInfos.add(new BtbInstructorInfo(h1, h2, lecture.getInstructorName(), pref));
                    }
                }
            }
            if (order != null) {
                Collections.sort(this.iDifferentAssignments, new Hint.HintComparator(order));
            }
            this.iStudentConflictInfos = new Vector(jenrls.size());
            for (JenrlConstraint jenrlConstraint : jenrls) {
                if (jenrlConstraint.jenrl() <= 0.0) continue;
                Hint h1 = new Hint(solver, (Placement)assignment.getValue(jenrlConstraint.first()));
                Hint h2 = new Hint(solver, (Placement)assignment.getValue(jenrlConstraint.second()));
                int i1 = this.iDifferentAssignments.indexOf(h1);
                int i2 = this.iDifferentAssignments.indexOf(h2);
                if (i2 < 0 || i1 >= 0 && i1 < i2) {
                    this.iStudentConflictInfos.add(new StudentConflictInfo(h1, h2, new JenrlInfo(solver, jenrlConstraint)));
                    continue;
                }
                this.iStudentConflictInfos.add(new StudentConflictInfo(h2, h1, new JenrlInfo(solver, jenrlConstraint)));
            }
            for (Map.Entry entry : committed.entrySet()) {
                Placement p1 = (Placement)entry.getKey();
                Lecture l1 = (Lecture)p1.variable();
                for (Map.Entry y : ((Hashtable)entry.getValue()).entrySet()) {
                    Placement p2 = (Placement)y.getKey();
                    Integer cnt = (Integer)y.getValue();
                    Hint h1 = new Hint(solver, p1);
                    Hint h2 = new Hint(solver, p2);
                    JenrlInfo jenrl = new JenrlInfo();
                    jenrl.setIsCommited(true);
                    jenrl.setJenrl(cnt.intValue());
                    jenrl.setIsFixed(l1.nrTimeLocations() == 1);
                    jenrl.setIsHard(l1.isSingleSection());
                    jenrl.setIsDistance(!p1.getTimeLocation().hasIntersection(p2.getTimeLocation()));
                    this.iStudentConflictInfos.add(new StudentConflictInfo(h1, h2, jenrl));
                }
            }
            this.iGroupConstraintInfos = new Vector();
            for (GroupConstraint groupConstraint : gcs) {
                if (groupConstraint.isSatisfied(assignment)) continue;
                dist = new DistributionInfo(new GroupConstraintInfo((Assignment<Lecture, Placement>)assignment, groupConstraint));
                for (Lecture another : groupConstraint.variables()) {
                    Placement anotherPlacement = (Placement)assignment.getValue((Variable)another);
                    if (anotherPlacement == null) continue;
                    dist.addHint(new Hint(solver, anotherPlacement));
                }
                this.iGroupConstraintInfos.addElement(dist);
            }
            for (FlexibleConstraint flexibleConstraint : fcs) {
                if (flexibleConstraint.isHard() || flexibleConstraint.getNrViolations(assignment, new HashSet(), new HashMap()) == 0.0) continue;
                dist = new DistributionInfo(new GroupConstraintInfo((Assignment<Lecture, Placement>)assignment, flexibleConstraint));
                for (Lecture another : flexibleConstraint.variables()) {
                    Placement anotherPlacement = (Placement)assignment.getValue((Variable)another);
                    if (anotherPlacement == null) continue;
                    dist.addHint(new Hint(solver, anotherPlacement));
                }
                this.iGroupConstraintInfos.addElement(dist);
            }
        }
        this.iValue = solver.currentSolution().getModel().getTotalValue(assignment);
        TimetableModel m = (TimetableModel)solver.currentSolution().getModel();
        this.iTooBigRooms = (int)Math.round(m.getCriterion(TooBigRooms.class).getValue(assignment));
        this.iUselessSlots = Math.round(m.getCriterion(UselessHalfHours.class).getValue(assignment) + m.getCriterion(BrokenTimePatterns.class).getValue(assignment));
        this.iGlobalTimePreference = m.getCriterion(TimePreferences.class).getValue(assignment);
        this.iGlobalRoomPreference = Math.round(m.getCriterion(RoomPreferences.class).getValue(assignment));
        this.iGlobalGroupConstraintPreference = Math.round(m.getCriterion(DistributionPreferences.class).getValue(assignment)) + Math.round(m.getCriterion(FlexibleConstraintCriterion.class).getValue(assignment));
        this.iViolatedStudentConflicts = Math.round(m.getCriterion(StudentConflict.class).getValue(assignment) + m.getCriterion(StudentCommittedConflict.class).getValue(assignment));
        this.iHardStudentConflicts = Math.round(m.getCriterion(StudentHardConflict.class).getValue(assignment));
        this.iDistanceStudentConflicts = Math.round(m.getCriterion(StudentDistanceConflict.class).getValue(assignment));
        this.iCommitedStudentConflicts = Math.round(m.getCriterion(StudentCommittedConflict.class).getValue(assignment));
        this.iInstructorDistancePreference = Math.round(m.getCriterion(BackToBackInstructorPreferences.class).getValue(assignment));
        this.iDepartmentSpreadPenalty = (int)Math.round(m.getCriterion(DepartmentBalancingPenalty.class).getValue(assignment));
        this.iSpreadPenalty = (int)Math.round(m.getCriterion(SameSubpartBalancingPenalty.class).getValue(assignment));
        this.iUnassignedVariables = m.nrUnassignedVariables(assignment);
        this.iPerturbationPenalty = m.getCriterion(Perturbations.class).getValue(assignment);
    }

    public Suggestion(Solver solver, Lecture lecture, TimeLocation time) {
        Assignment assignment = solver.currentSolution().getAssignment();
        this.iStudentConflictInfos = new Vector();
        Placement currentPlacement = (Placement)assignment.getValue((Variable)lecture);
        if (currentPlacement == null) {
            List values = lecture.values(assignment);
            currentPlacement = values.isEmpty() ? null : (Placement)values.get(0);
        }
        Hashtable<Placement, Integer> committed = new Hashtable<Placement, Integer>();
        if (currentPlacement != null) {
            Placement dummyPlacement = null;
            dummyPlacement = currentPlacement.isMultiRoom() ? new Placement(lecture, time, currentPlacement.getRoomLocations()) : new Placement(lecture, time, currentPlacement.getRoomLocation());
            this.iDifferentAssignments = new Vector();
            this.iDifferentAssignments.addElement(new Hint(solver, dummyPlacement));
            if (dummyPlacement.getCommitedConflicts() > 0) {
                for (Student student : lecture.students()) {
                    Set confs = student.conflictPlacements(dummyPlacement);
                    if (confs == null) continue;
                    Iterator j = confs.iterator();
                    while (j.hasNext()) {
                        Placement commitedPlacement;
                        Integer current = (Integer)committed.get(commitedPlacement = (Placement)j.next());
                        committed.put(commitedPlacement, new Integer(1 + (current == null ? 0 : current)));
                    }
                }
            }
            for (JenrlConstraint jenrlConstraint : lecture.jenrlConstraints()) {
                Hint h;
                long j = jenrlConstraint.jenrl(assignment, lecture, dummyPlacement);
                if (j <= 0L || jenrlConstraint.isToBeIgnored() || jenrlConstraint.areStudentConflictsDistance(assignment, dummyPlacement)) continue;
                JenrlInfo jInfo = new JenrlInfo();
                jInfo.setJenrl(j);
                this.iViolatedStudentConflicts += j;
                if (jenrlConstraint.areStudentConflictsHard()) {
                    this.iHardStudentConflicts += j;
                    jInfo.setIsHard(true);
                }
                if (jenrlConstraint.areStudentConflictsDistance(assignment, dummyPlacement)) {
                    this.iDistanceStudentConflicts += j;
                    jInfo.setIsDistance(true);
                }
                if (((Lecture)jenrlConstraint.first()).equals((Object)lecture)) {
                    h = new Hint(solver, (Placement)assignment.getValue(jenrlConstraint.second()));
                    this.iStudentConflictInfos.add(new StudentConflictInfo(h, null, jInfo));
                    continue;
                }
                h = new Hint(solver, (Placement)assignment.getValue(jenrlConstraint.first()));
                this.iStudentConflictInfos.add(new StudentConflictInfo(h, null, jInfo));
            }
            for (Map.Entry entry : committed.entrySet()) {
                Placement p = (Placement)entry.getKey();
                Integer cnt = (Integer)entry.getValue();
                Hint h = new Hint(solver, p);
                JenrlInfo jenrl = new JenrlInfo();
                jenrl.setIsCommited(true);
                jenrl.setJenrl(cnt.intValue());
                this.iViolatedStudentConflicts += (long)cnt.intValue();
                jenrl.setIsFixed(lecture.nrTimeLocations() == 1);
                jenrl.setIsHard(lecture.isSingleSection());
                jenrl.setIsDistance(!dummyPlacement.getTimeLocation().hasIntersection(p.getTimeLocation()));
                this.iStudentConflictInfos.add(new StudentConflictInfo(h, null, jenrl));
            }
            this.iGroupConstraintInfos = new Vector();
            for (GroupConstraint groupConstraint : lecture.groupConstraints()) {
                boolean sat;
                if (groupConstraint.getType() == GroupConstraint.ConstraintType.SAME_ROOM) continue;
                int curPref = groupConstraint.getCurrentPreference(assignment, dummyPlacement);
                if (groupConstraint.getType() == GroupConstraint.ConstraintType.BTB) {
                    groupConstraint.setType(GroupConstraint.ConstraintType.BTB_TIME);
                    curPref = groupConstraint.getCurrentPreference(assignment, dummyPlacement);
                    groupConstraint.setType(GroupConstraint.ConstraintType.BTB);
                }
                if (groupConstraint.getType() == GroupConstraint.ConstraintType.SAME_STUDENTS) {
                    groupConstraint.setType(GroupConstraint.ConstraintType.DIFF_TIME);
                    curPref = groupConstraint.getCurrentPreference(assignment, dummyPlacement);
                    groupConstraint.setType(GroupConstraint.ConstraintType.SAME_STUDENTS);
                }
                boolean bl = sat = curPref <= 0;
                if (sat) continue;
                this.iGlobalGroupConstraintPreference += (long)curPref;
                DistributionInfo dist = new DistributionInfo(new GroupConstraintInfo((Assignment<Lecture, Placement>)assignment, groupConstraint));
                for (Lecture another : groupConstraint.variables()) {
                    if (another.equals((Object)lecture) || assignment.getValue((Variable)another) == null) continue;
                    dist.addHint(new Hint(solver, (Placement)assignment.getValue((Variable)another)));
                }
                this.iGroupConstraintInfos.addElement(dist);
            }
            HashMap<Lecture, Placement> dummies = new HashMap<Lecture, Placement>();
            if (dummyPlacement != null) {
                dummies.put(lecture, dummyPlacement);
            }
            for (FlexibleConstraint fc : lecture.getFlexibleGroupConstraints()) {
                if (fc.isHard() || fc.getNrViolations(assignment, null, dummies) == 0.0) continue;
                this.iGlobalGroupConstraintPreference = (long)((double)this.iGlobalGroupConstraintPreference + Math.abs(fc.getCurrentPreference(assignment, null, dummies)));
                DistributionInfo dist = new DistributionInfo(new GroupConstraintInfo((Assignment<Lecture, Placement>)assignment, fc));
                for (Lecture another : fc.variables()) {
                    if (another.equals((Object)lecture) || assignment.getValue((Variable)another) == null) continue;
                    dist.addHint(new Hint(solver, (Placement)assignment.getValue((Variable)another)));
                }
                this.iGroupConstraintInfos.addElement(dist);
            }
            this.iCommitedStudentConflicts = dummyPlacement.getCommitedConflicts();
        }
    }

    public void setHint(Hint hint) {
        this.iHint = hint;
    }

    public Hint getHint() {
        return this.iHint;
    }

    public Vector getDifferentAssignments() {
        return this.iDifferentAssignments;
    }

    public void assign(SolverProxy solver) {
        if (solver != null) {
            solver.assign(this.iDifferentAssignments);
        }
    }

    public Map<Long, String> conflictInfo(SolverProxy solver) {
        return solver.conflictInfo(this.iDifferentAssignments);
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof Suggestion)) {
            return -1;
        }
        int cmp = Double.compare(this.iValue, ((Suggestion)o).iValue);
        if (cmp != 0) {
            return cmp;
        }
        return this.iDifferentAssignments.toString().compareTo(((Suggestion)o).iDifferentAssignments.toString());
    }

    public boolean isBetter(Solver solver) {
        return this.iValue < solver.currentSolution().getModel().getTotalValue(solver.currentSolution().getAssignment());
    }

    public double getValue() {
        return this.iValue;
    }

    public int getTooBigRooms() {
        return this.iTooBigRooms;
    }

    public long getUselessSlots() {
        return this.iUselessSlots;
    }

    public double getGlobalTimePreference() {
        return this.iGlobalTimePreference;
    }

    public long getGlobalRoomPreference() {
        return this.iGlobalRoomPreference;
    }

    public long getGlobalGroupConstraintPreference() {
        return this.iGlobalGroupConstraintPreference;
    }

    public long getViolatedStudentConflicts() {
        return this.iViolatedStudentConflicts;
    }

    public long getHardStudentConflicts() {
        return this.iHardStudentConflicts;
    }

    public long getCommitedStudentConflicts() {
        return this.iCommitedStudentConflicts;
    }

    public long getDistanceStudentConflicts() {
        return this.iDistanceStudentConflicts;
    }

    public long getInstructorDistancePreference() {
        return this.iInstructorDistancePreference;
    }

    public double getDepartmentSpreadPenalty() {
        return (double)this.iDepartmentSpreadPenalty / 12.0;
    }

    public double getSpreadPenalty() {
        return (double)this.iSpreadPenalty / 12.0;
    }

    public int getUnassignedVariables() {
        return this.iUnassignedVariables;
    }

    public double getPerturbationPenalty() {
        return this.iPerturbationPenalty;
    }

    public Set getUnresolvedConflicts() {
        return this.iUnresolvedConflicts;
    }

    public boolean hasStudentConflictInfo() {
        return this.iStudentConflictInfos != null && !this.iStudentConflictInfos.isEmpty();
    }

    public String getStudentConflictInfosAsHtml(SessionContext context, SolverProxy solver, boolean link, int id, int spanLimit) {
        Collections.sort(this.iStudentConflictInfos, new StudentConflictInfoComparator(context, solver));
        StringBuffer sb = new StringBuffer();
        int idx = 0;
        boolean span = false;
        Enumeration e = this.iStudentConflictInfos.elements();
        while (e.hasMoreElements()) {
            StudentConflictInfo info = (StudentConflictInfo)e.nextElement();
            if (idx == spanLimit) {
                sb.append("<span id='hint_conf_dots" + id + "' onMouseOver=\"this.style.cursor='hand';this.style.cursor='pointer';\" style='display:inline'><a onClick=\"document.getElementById('hint_conf_dots" + id + "').style.display='none';document.getElementById('hint_conf_rest" + id + "').style.display='inline';\">...</a></span><span id='hint_conf_rest" + id + "' style='display:none'>");
                span = true;
            }
            sb.append(info.toHtml(context, solver, link));
            ++idx;
        }
        if (span) {
            sb.append("</span>");
        }
        return sb.toString();
    }

    public boolean hasBtbInstructorInfo() {
        return this.iBtbInstructorInfos != null && !this.iBtbInstructorInfos.isEmpty();
    }

    public String getBtbInstructorInfosAsHtml(SessionContext context, SolverProxy solver, boolean link) {
        Collections.sort(this.iBtbInstructorInfos, new BtbInstructorInfoComparator(context, solver));
        StringBuffer sb = new StringBuffer();
        Enumeration e = this.iBtbInstructorInfos.elements();
        while (e.hasMoreElements()) {
            BtbInstructorInfo info = (BtbInstructorInfo)e.nextElement();
            if (sb.length() > 0) {
                sb.append("<br>");
            }
            sb.append(info.toHtml(context, solver, link));
        }
        return sb.toString();
    }

    public boolean hasDistributionConstraintInfo() {
        return this.iGroupConstraintInfos != null && !this.iGroupConstraintInfos.isEmpty();
    }

    public String getDistributionConstraintInfoAsHtml(SessionContext context, SolverProxy solver, boolean link, int id, int spanLimit) {
        StringBuffer sb = new StringBuffer();
        int idx = 0;
        boolean span = false;
        Enumeration e = this.iGroupConstraintInfos.elements();
        while (e.hasMoreElements()) {
            DistributionInfo info = (DistributionInfo)e.nextElement();
            if (idx == spanLimit) {
                sb.append("<span id='hint_dist_dots" + id + "' onMouseOver=\"this.style.cursor='hand';this.style.cursor='pointer';\" style='display:inline'><a onClick=\"document.getElementById('hint_dist_dots" + id + "').style.display='none';document.getElementById('hint_dist_rest" + id + "').style.display='inline';\">...</a></span><span id='hint_dist_rest" + id + "' style='display:none'>");
                span = true;
            }
            sb.append(info.toHtml(context, solver, link));
            ++idx;
        }
        if (span) {
            sb.append("</span>");
        }
        return sb.toString();
    }

    public void toXml(Element element) {
        Enumeration e;
        element.addAttribute("value", String.valueOf(this.iValue));
        element.addAttribute("tooBigRooms", String.valueOf(this.iTooBigRooms));
        element.addAttribute("uselessSlots", String.valueOf(this.iUselessSlots));
        element.addAttribute("timePreference", String.valueOf(this.iGlobalTimePreference));
        element.addAttribute("roomPreference", String.valueOf(this.iGlobalRoomPreference));
        element.addAttribute("groupConstraintPreference", String.valueOf(this.iGlobalGroupConstraintPreference));
        element.addAttribute("studentConflicts", String.valueOf(this.iViolatedStudentConflicts));
        element.addAttribute("hardStudentConflicts", String.valueOf(this.iHardStudentConflicts));
        element.addAttribute("distanceStudentConflicts", String.valueOf(this.iDistanceStudentConflicts));
        element.addAttribute("commitedStudentConflicts", String.valueOf(this.iCommitedStudentConflicts));
        element.addAttribute("instructorDistancePreference", String.valueOf(this.iInstructorDistancePreference));
        element.addAttribute("departmentSpreadPenalty", String.valueOf(this.iDepartmentSpreadPenalty));
        element.addAttribute("unassignedVariables", String.valueOf(this.iUnassignedVariables));
        element.addAttribute("perturbationPenalty", String.valueOf(this.iPerturbationPenalty));
        element.addAttribute("spreadPenalty", String.valueOf(this.iSpreadPenalty));
        if (this.iHint != null) {
            this.iHint.toXml(element.addElement("hint"));
        }
        if (this.iDifferentAssignments != null) {
            e = this.iDifferentAssignments.elements();
            while (e.hasMoreElements()) {
                Hint h = (Hint)e.nextElement();
                h.toXml(element.addElement("differentAssignment"));
            }
        }
        if (this.iUnresolvedConflicts != null) {
            for (Hint h : this.iUnresolvedConflicts) {
                h.toXml(element.addElement("unresolvedConflict"));
            }
        }
        if (this.iStudentConflictInfos != null) {
            e = this.iStudentConflictInfos.elements();
            while (e.hasMoreElements()) {
                StudentConflictInfo sci = (StudentConflictInfo)e.nextElement();
                sci.toXml(element.addElement("studentConflictInfo"));
            }
        }
        if (this.iGroupConstraintInfos != null) {
            e = this.iGroupConstraintInfos.elements();
            while (e.hasMoreElements()) {
                DistributionInfo di = (DistributionInfo)e.nextElement();
                di.toXml(element.addElement("groupConstraintInfo"));
            }
        }
        if (this.iBtbInstructorInfos != null) {
            e = this.iBtbInstructorInfos.elements();
            while (e.hasMoreElements()) {
                BtbInstructorInfo bii = (BtbInstructorInfo)e.nextElement();
                bii.toXml(element.addElement("btbInstructorInfo"));
            }
        }
    }

    public static Suggestion fromXml(Element element) {
        Suggestion s = new Suggestion();
        s.iValue = Double.parseDouble(element.attributeValue("value"));
        s.iTooBigRooms = Integer.parseInt(element.attributeValue("tooBigRooms"));
        s.iUselessSlots = Long.parseLong(element.attributeValue("uselessSlots"));
        s.iGlobalTimePreference = Double.parseDouble(element.attributeValue("timePreference"));
        s.iGlobalRoomPreference = Long.parseLong(element.attributeValue("roomPreference"));
        s.iGlobalGroupConstraintPreference = Long.parseLong(element.attributeValue("groupConstraintPreference"));
        s.iViolatedStudentConflicts = Long.parseLong(element.attributeValue("studentConflicts"));
        s.iHardStudentConflicts = Long.parseLong(element.attributeValue("hardStudentConflicts"));
        s.iDistanceStudentConflicts = Long.parseLong(element.attributeValue("distanceStudentConflicts"));
        s.iCommitedStudentConflicts = Long.parseLong(element.attributeValue("commitedStudentConflicts"));
        s.iInstructorDistancePreference = Long.parseLong(element.attributeValue("instructorDistancePreference"));
        s.iDepartmentSpreadPenalty = Integer.parseInt(element.attributeValue("departmentSpreadPenalty"));
        s.iUnassignedVariables = Integer.parseInt(element.attributeValue("unassignedVariables"));
        s.iPerturbationPenalty = Double.parseDouble(element.attributeValue("perturbationPenalty"));
        s.iSpreadPenalty = Integer.parseInt(element.attributeValue("spreadPenalty"));
        if (element.element("hint") != null) {
            s.iHint = Hint.fromXml(element.element("hint"));
        }
        Iterator i = element.elementIterator("differentAssignment");
        while (i.hasNext()) {
            if (s.iDifferentAssignments == null) {
                s.iDifferentAssignments = new Vector();
            }
            s.iDifferentAssignments.add(Hint.fromXml((Element)i.next()));
        }
        i = element.elementIterator("unresolvedConflict");
        while (i.hasNext()) {
            if (s.iUnresolvedConflicts == null) {
                s.iUnresolvedConflicts = new HashSet();
            }
            s.iUnresolvedConflicts.add(Hint.fromXml((Element)i.next()));
        }
        i = element.elementIterator("studentConflictInfo");
        while (i.hasNext()) {
            if (s.iStudentConflictInfos == null) {
                s.iStudentConflictInfos = new Vector();
            }
            s.iStudentConflictInfos.add(StudentConflictInfo.fromXml((Element)i.next()));
        }
        i = element.elementIterator("groupConstraintInfo");
        while (i.hasNext()) {
            if (s.iGroupConstraintInfos == null) {
                s.iGroupConstraintInfos = new Vector();
            }
            s.iGroupConstraintInfos.add(DistributionInfo.fromXml((Element)i.next()));
        }
        i = element.elementIterator("btbInstructorInfo");
        while (i.hasNext()) {
            if (s.iBtbInstructorInfos == null) {
                s.iBtbInstructorInfos = new Vector();
            }
            s.iBtbInstructorInfos.add(BtbInstructorInfo.fromXml((Element)i.next()));
        }
        return s;
    }

    public boolean isCanAssign() {
        return this.iCanAssign;
    }

    public void setCanAssign(boolean canAssign) {
        this.iCanAssign = canAssign;
    }

    public String toString() {
        return "Suggestion{value = " + sDF.format(this.iValue) + "\n" + (this.iDifferentAssignments == null || this.iDifferentAssignments.isEmpty() ? "" : "  differentAssignments = " + this.iDifferentAssignments + "\n") + (this.iUnresolvedConflicts == null || this.iUnresolvedConflicts.isEmpty() ? "" : "  unresolvedConflicts = " + this.iUnresolvedConflicts + "\n") + (this.iHint == null ? "" : "  hint = " + this.iHint + "\n") + "}";
    }

    public static class DistributionInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private GroupConstraintInfo iInfo;
        private Vector iClassIds = new Vector();

        public DistributionInfo() {
        }

        public DistributionInfo(GroupConstraintInfo info) {
            this.iInfo = info;
        }

        public void addHint(Hint hint) {
            this.iClassIds.add(hint);
        }

        public Vector getClassIds() {
            return this.iClassIds;
        }

        public GroupConstraintInfo getInfo() {
            return this.iInfo;
        }

        public String toHtml(SessionContext context, SolverProxy solver, boolean link) {
            StringBuffer sb = new StringBuffer("<table border='0'>");
            sb.append("<tr><td nowrap align='center'>");
            sb.append("<font color='" + PreferenceLevel.prolog2color(this.iInfo.getPreference()) + "'>");
            sb.append(PreferenceLevel.getPreferenceLevel(this.iInfo.getPreference()).getPrefName());
            sb.append("</font><br>");
            sb.append(this.iInfo.getName());
            sb.append("</font>");
            sb.append("</td><td nowrap>");
            try {
                Enumeration e = this.iClassIds.elements();
                while (e.hasMoreElements()) {
                    int i;
                    Hint hint = (Hint)e.nextElement();
                    ClassAssignmentDetails other = hint.getDetails(context, solver, false);
                    if (other == null) continue;
                    sb.append(other.getClazz().toHtml(link) + " ");
                    if (other.getAssignedTime() != null) {
                        sb.append(other.getAssignedTime().toHtml(false, false, true, false) + " ");
                    } else if (other.getTime() != null) {
                        sb.append(other.getTime().toHtml(false, false, true, false) + " ");
                    }
                    if (other.getAssignedRoom() != null) {
                        for (i = 0; i < other.getAssignedRoom().length; ++i) {
                            if (i > 0) {
                                sb.append(", ");
                            }
                            sb.append(other.getAssignedRoom()[i].toHtml(false, false, false));
                        }
                    } else if (other.getRoom() != null) {
                        for (i = 0; i < other.getRoom().length; ++i) {
                            if (i > 0) {
                                sb.append(", ");
                            }
                            sb.append(other.getRoom()[i].toHtml(false, false, false));
                        }
                    }
                    if (!e.hasMoreElements()) continue;
                    sb.append("<BR>");
                }
            }
            catch (Exception e) {
                Debug.error(e);
                sb.append("<font color='red'>ERROR:" + e.getMessage() + "</font>");
            }
            sb.append("</td></tr></table>");
            return sb.toString();
        }

        public void toXml(Element element) {
            if (this.iInfo != null) {
                this.iInfo.save(element.addElement("groupConstraintInfo"));
            }
            if (this.iClassIds != null) {
                Enumeration e = this.iClassIds.elements();
                while (e.hasMoreElements()) {
                    Hint h = (Hint)e.nextElement();
                    h.toXml(element.addElement("class"));
                }
            }
        }

        public static DistributionInfo fromXml(Element element) {
            DistributionInfo s = new DistributionInfo();
            s.iClassIds = new Vector();
            Iterator i = element.elementIterator("class");
            while (i.hasNext()) {
                s.iClassIds.add(Hint.fromXml((Element)i.next()));
            }
            if (element.element("groupConstraintInfo") != null) {
                s.iInfo = new GroupConstraintInfo();
                s.iInfo.load(element.element("groupConstraintInfo"));
            }
            return s;
        }
    }

    public class StudentConflictInfoComparator
    implements Comparator {
        SessionContext iContext;
        SolverProxy iSolver;

        public StudentConflictInfoComparator(SessionContext context, SolverProxy solver) {
            this.iContext = context;
            this.iSolver = solver;
        }

        public int compare(Object o1, Object o2) {
            try {
                StudentConflictInfo i1 = (StudentConflictInfo)o1;
                StudentConflictInfo i2 = (StudentConflictInfo)o2;
                int cmp = Double.compare(i1.getInfo().getJenrl(), i2.getInfo().getJenrl());
                if (cmp != 0) {
                    return -cmp;
                }
                if (!i1.hasInfo()) {
                    i1.createInfo(this.iContext, this.iSolver);
                }
                if (!i2.hasInfo()) {
                    i2.createInfo(this.iContext, this.iSolver);
                }
                if ((cmp = i1.iFirstInfo.getClassName().compareTo(i2.iFirstInfo.getClassName())) != 0 || i1.iSecondInfo == null) {
                    return cmp;
                }
                return i1.iSecondInfo.getClassName().compareTo(i2.iSecondInfo.getClassName());
            }
            catch (Exception e) {
                return 0;
            }
        }
    }

    public static class StudentConflictInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private JenrlInfo iInfo;
        private Hint iFirst;
        private Hint iSecond;
        private transient ClassAssignmentDetails iFirstInfo = null;
        private transient ClassAssignmentDetails iSecondInfo = null;

        public StudentConflictInfo() {
        }

        public StudentConflictInfo(Hint first, Hint second, JenrlInfo info) {
            this.iInfo = info;
            this.iFirst = first;
            this.iSecond = second;
        }

        public JenrlInfo getInfo() {
            return this.iInfo;
        }

        public void createInfo(SessionContext context, SolverProxy solver) {
            if (this.iFirstInfo == null) {
                this.iFirstInfo = this.iFirst.getDetails(context, solver, false);
            }
            if (this.iSecondInfo == null && this.iSecond != null) {
                this.iSecondInfo = this.iSecond.getDetails(context, solver, false);
            }
        }

        public boolean hasInfo() {
            return this.iFirstInfo != null;
        }

        public String toHtml(SessionContext context, SolverProxy solver, boolean link) {
            try {
                int i;
                this.createInfo(context, solver);
                Vector<String> props = new Vector<String>();
                if (this.iInfo.isCommited()) {
                    props.add("committed");
                }
                if (this.iInfo.isFixed()) {
                    props.add("fixed");
                } else if (this.iInfo.isHard()) {
                    props.add("hard");
                }
                if (this.iInfo.isDistance()) {
                    props.add("distance");
                }
                if (this.iInfo.isImportant()) {
                    props.add("important");
                }
                if (this.iInfo.isInstructor()) {
                    props.add("instructor");
                }
                StringBuffer sb = new StringBuffer("<table border='0'>");
                sb.append("<tr>");
                sb.append("<td " + (this.iSecondInfo == null ? "" : "rowspan='2'") + " nowrap>");
                sb.append(ClassAssignmentDetails.sJenrDF.format(this.iInfo.getJenrl()));
                sb.append("&times; ");
                sb.append("</td><td nowrap>");
                sb.append(this.iFirstInfo.getClazz().toHtml(link && !this.iInfo.isCommited()) + " ");
                if (this.iFirstInfo.getAssignedTime() != null) {
                    sb.append(this.iFirstInfo.getAssignedTime().toHtml(false, false, true, false) + " ");
                    for (i = 0; i < this.iFirstInfo.getAssignedRoom().length; ++i) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        sb.append(this.iFirstInfo.getAssignedRoom()[i].toHtml(false, false, false));
                    }
                } else {
                    sb.append(this.iFirstInfo.getTime().toHtml(false, false, true, false) + " ");
                    for (i = 0; i < this.iFirstInfo.getRoom().length; ++i) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        sb.append(this.iFirstInfo.getRoom()[i].toHtml(false, false, false));
                    }
                }
                sb.append("</td><td " + (this.iSecondInfo == null ? "" : "rowspan='2'") + " nowrap>");
                sb.append(props.isEmpty() ? "" : " <i>" + props + "</i>");
                sb.append(" <i>" + this.iInfo.getCurriculumText() + "</i>");
                if (this.iSecondInfo != null) {
                    sb.append("</td></tr><tr><td nowrap>");
                    sb.append(this.iSecondInfo.getClazz().toHtml(link && !this.iInfo.isCommited()) + " ");
                    if (this.iSecondInfo.getAssignedTime() != null) {
                        sb.append(this.iSecondInfo.getAssignedTime().toHtml(false, false, true, false) + " ");
                        for (i = 0; i < this.iSecondInfo.getAssignedRoom().length; ++i) {
                            if (i > 0) {
                                sb.append(", ");
                            }
                            sb.append(this.iSecondInfo.getAssignedRoom()[i].toHtml(false, false, false));
                        }
                    } else {
                        sb.append(this.iSecondInfo.getTime().toHtml(false, false, true, false) + " ");
                        for (i = 0; i < this.iSecondInfo.getRoom().length; ++i) {
                            if (i > 0) {
                                sb.append(", ");
                            }
                            sb.append(this.iSecondInfo.getRoom()[i].toHtml(false, false, false));
                        }
                    }
                }
                sb.append("</td></tr></table>");
                return sb.toString();
            }
            catch (Exception e) {
                Debug.error(e);
                return "<font color='red'>ERROR:" + e.getMessage() + "</font>";
            }
        }

        public void toXml(Element element) {
            if (this.iInfo != null) {
                this.iInfo.save(element.addElement("jenrl"));
            }
            if (this.iFirst != null) {
                this.iFirst.toXml(element.addElement("first"));
            }
            if (this.iSecond != null) {
                this.iSecond.toXml(element.addElement("second"));
            }
        }

        public static StudentConflictInfo fromXml(Element element) {
            StudentConflictInfo s = new StudentConflictInfo();
            if (element.element("first") != null) {
                s.iFirst = Hint.fromXml(element.element("first"));
            }
            if (element.element("second") != null) {
                s.iSecond = Hint.fromXml(element.element("second"));
            }
            if (element.element("jenrl") != null) {
                s.iInfo = new JenrlInfo();
                s.iInfo.load(element.element("jenrl"));
            }
            return s;
        }
    }

    public class BtbInstructorInfoComparator
    implements Comparator {
        SessionContext iContext;
        SolverProxy iSolver;

        public BtbInstructorInfoComparator(SessionContext context, SolverProxy solver) {
            this.iContext = context;
            this.iSolver = solver;
        }

        public int compare(Object o1, Object o2) {
            try {
                BtbInstructorInfo i1 = (BtbInstructorInfo)o1;
                BtbInstructorInfo i2 = (BtbInstructorInfo)o2;
                int cmp = i1.getInstructor().compareTo(i2.getInstructor());
                if (cmp != 0) {
                    return cmp;
                }
                if (!i1.hasInfo()) {
                    i1.createInfo(this.iContext, this.iSolver);
                }
                if (!i2.hasInfo()) {
                    i2.createInfo(this.iContext, this.iSolver);
                }
                if ((cmp = i1.iFirstInfo.compareTo(i2.iFirstInfo)) != 0) {
                    return cmp;
                }
                return i1.iSecondInfo.compareTo(i2.iSecondInfo);
            }
            catch (Exception e) {
                return 0;
            }
        }
    }

    public static class BtbInstructorInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Hint iFirst;
        private Hint iSecond;
        private transient ClassAssignmentDetails iFirstInfo = null;
        private transient ClassAssignmentDetails iSecondInfo = null;
        private int iPref;
        private String iInsturctor;

        public BtbInstructorInfo() {
        }

        public BtbInstructorInfo(Hint first, Hint second, String instructor, int pref) {
            this.iFirst = first;
            this.iSecond = second;
            this.iPref = pref;
            this.iInsturctor = instructor;
        }

        public void createInfo(SessionContext context, SolverProxy solver) {
            if (this.iFirstInfo == null) {
                this.iFirstInfo = this.iFirst.getDetails(context, solver, false);
            }
            if (this.iSecondInfo == null) {
                this.iSecondInfo = this.iSecond.getDetails(context, solver, false);
            }
        }

        public boolean hasInfo() {
            return this.iFirstInfo != null && this.iSecondInfo != null;
        }

        public int getPreference() {
            return this.iPref;
        }

        public String getInstructor() {
            return this.iInsturctor;
        }

        public String toHtml(SessionContext context, SolverProxy solver, boolean link) {
            try {
                int i;
                this.createInfo(context, solver);
                StringBuffer sb = new StringBuffer("<table border='0'>");
                sb.append("<tr><td nowrap align='center'>");
                sb.append("<font color='" + PreferenceLevel.int2color(this.getPreference()) + "'>");
                sb.append(PreferenceLevel.getPreferenceLevel(PreferenceLevel.int2prolog(this.getPreference())).getPrefName());
                sb.append("</font><br>");
                sb.append(this.iInsturctor);
                sb.append("</font>");
                sb.append("</td><td nowrap>");
                sb.append(this.iFirstInfo.getClazz().toHtml(link) + " ");
                if (this.iFirstInfo.getAssignedTime() != null) {
                    sb.append(this.iFirstInfo.getAssignedTime().toHtml(false, false, true, false) + " ");
                    sb.append(this.iFirstInfo.getAssignedTime().toDatesHtml(false, false, true) + " ");
                    for (i = 0; i < this.iFirstInfo.getAssignedRoom().length; ++i) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        sb.append(this.iFirstInfo.getAssignedRoom()[i].toHtml(false, false, false));
                    }
                } else {
                    sb.append(this.iFirstInfo.getTime().toHtml(false, false, true, false) + " ");
                    sb.append(this.iFirstInfo.getTime().toDatesHtml(false, false, true) + " ");
                    for (i = 0; i < this.iFirstInfo.getRoom().length; ++i) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        sb.append(this.iFirstInfo.getRoom()[i].toHtml(false, false, false));
                    }
                }
                sb.append("<br>");
                sb.append(this.iSecondInfo.getClazz().toHtml(link) + " ");
                if (this.iSecondInfo.getAssignedTime() != null) {
                    sb.append(this.iSecondInfo.getAssignedTime().toHtml(false, false, true, false) + " ");
                    sb.append(this.iSecondInfo.getAssignedTime().toDatesHtml(false, false, true) + " ");
                    for (i = 0; i < this.iSecondInfo.getAssignedRoom().length; ++i) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        sb.append(this.iSecondInfo.getAssignedRoom()[i].toHtml(false, false, false));
                    }
                } else {
                    sb.append(this.iSecondInfo.getTime().toHtml(false, false, true, false) + " ");
                    sb.append(this.iSecondInfo.getTime().toDatesHtml(false, false, true) + " ");
                    for (i = 0; i < this.iSecondInfo.getRoom().length; ++i) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        sb.append(this.iSecondInfo.getRoom()[i].toHtml(false, false, false));
                    }
                }
                sb.append("</td></tr></table>");
                return sb.toString();
            }
            catch (Exception e) {
                Debug.error(e);
                return "<font color='red'>ERROR:" + e.getMessage() + "</font>";
            }
        }

        public void toXml(Element element) {
            if (this.iFirst != null) {
                this.iFirst.toXml(element.addElement("first"));
            }
            if (this.iSecond != null) {
                this.iSecond.toXml(element.addElement("second"));
            }
            element.addAttribute("pref", String.valueOf(this.iPref));
            if (this.iInsturctor != null) {
                element.addAttribute("instructor", this.iInsturctor);
            }
        }

        public static BtbInstructorInfo fromXml(Element element) {
            BtbInstructorInfo s = new BtbInstructorInfo();
            if (element.element("first") != null) {
                s.iFirst = Hint.fromXml(element.element("first"));
            }
            if (element.element("second") != null) {
                s.iSecond = Hint.fromXml(element.element("second"));
            }
            s.iPref = Integer.parseInt(element.attributeValue("pref"));
            s.iInsturctor = element.attributeValue("instructor");
            return s;
        }
    }
}

