/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import org.cpsolver.coursett.TimetableXMLLoader;
import org.cpsolver.coursett.TimetableXMLSaver;
import org.cpsolver.coursett.constraint.ClassLimitConstraint;
import org.cpsolver.coursett.constraint.DepartmentSpreadConstraint;
import org.cpsolver.coursett.constraint.FlexibleConstraint;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.cpsolver.coursett.constraint.InstructorConstraint;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.constraint.RoomConstraint;
import org.cpsolver.coursett.constraint.SpreadConstraint;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.StudentGroup;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.extension.ConflictStatistics;
import org.cpsolver.ifs.extension.Extension;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.termination.TerminationCondition;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.Callback;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ProblemLoader;
import org.cpsolver.ifs.util.ProblemSaver;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ToolBox;
import org.dom4j.Document;
import org.dom4j.Element;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.SuggestionsInterface;
import org.unitime.timetable.gwt.shared.TimetableGridInterface;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.dao.DatePatternDAO;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.RoomTypeDAO;
import org.unitime.timetable.model.dao.SolutionDAO;
import org.unitime.timetable.model.dao.SolverGroupDAO;
import org.unitime.timetable.model.dao.TimePatternDAO;
import org.unitime.timetable.server.solver.ClassAssignmentDetailsBackend;
import org.unitime.timetable.server.solver.ComputeConflictTableBackend;
import org.unitime.timetable.server.solver.ComputeSuggestionsBackend;
import org.unitime.timetable.server.solver.SelectedAssignmentBackend;
import org.unitime.timetable.server.solver.SuggestionsContext;
import org.unitime.timetable.server.solver.SuggestionsFilterBackend;
import org.unitime.timetable.server.solver.TimetableGridHelper;
import org.unitime.timetable.server.solver.TimetableGridSolverHelper;
import org.unitime.timetable.solver.AbstractSolver;
import org.unitime.timetable.solver.CommitedClassAssignmentProxy;
import org.unitime.timetable.solver.SolverDisposeListener;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.TimetableDatabaseLoader;
import org.unitime.timetable.solver.TimetableDatabaseSaver;
import org.unitime.timetable.solver.interactive.ClassAssignmentDetails;
import org.unitime.timetable.solver.interactive.Hint;
import org.unitime.timetable.solver.interactive.Suggestion;
import org.unitime.timetable.solver.interactive.Suggestions;
import org.unitime.timetable.solver.interactive.SuggestionsModel;
import org.unitime.timetable.solver.ui.AssignmentPreferenceInfo;
import org.unitime.timetable.solver.ui.ConflictStatisticsInfo;
import org.unitime.timetable.solver.ui.DeptBalancingReport;
import org.unitime.timetable.solver.ui.DiscouragedInstructorBtbReport;
import org.unitime.timetable.solver.ui.PerturbationReport;
import org.unitime.timetable.solver.ui.RoomReport;
import org.unitime.timetable.solver.ui.SameSubpartBalancingReport;
import org.unitime.timetable.solver.ui.SolverUnassignedClassesModel;
import org.unitime.timetable.solver.ui.StudentConflictsReport;
import org.unitime.timetable.solver.ui.ViolatedDistrPreferencesReport;
import org.unitime.timetable.webutil.timegrid.SolverGridModel;
import org.unitime.timetable.webutil.timegrid.TimetableGridContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimetableSolver
extends AbstractSolver<Lecture, Placement, TimetableModel>
implements SolverProxy {
    private Vector<AssignmentRecord> iAssignmentRecords = new Vector();
    private Vector<AssignmentRecord> iBestAssignmentRecords = new Vector();
    private ConflictStatisticsInfo iCbsInfo = null;
    private CommitedClassAssignmentProxy iCommitedClassAssignmentProxy = new CommitedClassAssignmentProxy();
    private HashSet iDepartmentIds = null;

    public TimetableSolver(DataProperties properties, SolverDisposeListener solverDisposeListener) {
        super(properties, solverDisposeListener);
    }

    @Override
    protected ProblemSaver<Lecture, Placement, TimetableModel> getDatabaseSaver(Solver<Lecture, Placement> solver) {
        return new TimetableDatabaseSaver(solver);
    }

    @Override
    protected ProblemLoader<Lecture, Placement, TimetableModel> getDatabaseLoader(TimetableModel model, Assignment<Lecture, Placement> assignment) {
        return new TimetableDatabaseLoader(model, assignment);
    }

    @Override
    protected TimetableModel createModel(DataProperties properties) {
        return new TimetableModel(properties);
    }

    @Override
    protected Document createCurrentSolutionBackup(boolean anonymize, boolean idconv) {
        if (anonymize) {
            this.getProperties().setProperty("Xml.ConvertIds", idconv ? "true" : "false");
            this.getProperties().setProperty("Xml.ShowNames", "false");
        }
        TimetableXMLSaver saver = new TimetableXMLSaver((Solver)this);
        Document document = saver.saveDocument();
        if (!anonymize) {
            ConflictStatisticsInfo cbsInfo;
            AssignmentRecord r;
            Enumeration<AssignmentRecord> e;
            Progress.getInstance((Object)saver.getModel()).save(document.getRootElement());
            if (!this.iAssignmentRecords.isEmpty()) {
                Element assignmentRecords = document.getRootElement().addElement("assignmentRecords");
                e = this.iAssignmentRecords.elements();
                while (e.hasMoreElements()) {
                    r = e.nextElement();
                    r.toXml(assignmentRecords.addElement("record"));
                }
            }
            if (!this.iBestAssignmentRecords.isEmpty()) {
                Element bestAssignmentRecords = document.getRootElement().addElement("bestAssignmentRecords");
                e = this.iBestAssignmentRecords.elements();
                while (e.hasMoreElements()) {
                    r = e.nextElement();
                    r.toXml(bestAssignmentRecords.addElement("record"));
                }
            }
            if ((cbsInfo = this.getCbsInfo()) != null) {
                cbsInfo.save(document.getRootElement().addElement("cbsInfo"));
            }
        }
        if (anonymize) {
            this.getProperties().setProperty("Xml.ConvertIds", "false");
            this.getProperties().setProperty("Xml.ShowNames", "true");
        }
        return document;
    }

    @Override
    protected void restureCurrentSolutionFromBackup(Document document) {
        Element bestAssignmentRecords;
        TimetableXMLLoader loader = new TimetableXMLLoader((TimetableModel)this.currentSolution().getModel(), this.currentSolution().getAssignment());
        loader.load(this.currentSolution(), document);
        this.iAssignmentRecords.clear();
        this.iBestAssignmentRecords.clear();
        Element assignmentRecords = document.getRootElement().element("assignmentRecords");
        if (assignmentRecords != null) {
            Iterator i = assignmentRecords.elementIterator("record");
            while (i.hasNext()) {
                this.iAssignmentRecords.add(AssignmentRecord.fromXml((Element)i.next()));
            }
        }
        if ((bestAssignmentRecords = document.getRootElement().element("bestAssignmentRecords")) != null) {
            Iterator i = bestAssignmentRecords.elementIterator("record");
            while (i.hasNext()) {
                this.iBestAssignmentRecords.add(AssignmentRecord.fromXml((Element)i.next()));
            }
        }
        if (document.getRootElement().element("cbsInfo") != null) {
            this.iCbsInfo = new ConflictStatisticsInfo();
            this.iCbsInfo.load(document.getRootElement().element("cbsInfo"));
        }
    }

    @Override
    protected void beforeStart() {
        this.iCbsInfo = null;
    }

    @Override
    public String getNote() {
        return this.getProperties().getProperty("General.Note");
    }

    @Override
    public void setNote(String note) {
        this.getProperties().setProperty("General.Note", note);
    }

    @Override
    public void restoreBest() {
        this.iAssignmentRecords = new Vector<AssignmentRecord>(this.iBestAssignmentRecords);
        this.currentSolution().restoreBest();
    }

    @Override
    public void saveBest() {
        this.iBestAssignmentRecords = new Vector<AssignmentRecord>(this.iAssignmentRecords);
        this.currentSolution().saveBest();
    }

    @Override
    public void finalSectioning() {
        this.iWorkThread = new FinalSectioning();
        this.iWorkThread.start();
    }

    protected void afterFinalSectioning() {
    }

    @Override
    protected void disposeNoInherit(boolean unregister) {
        this.iAssignmentRecords.clear();
        this.iBestAssignmentRecords.clear();
        this.iCbsInfo = null;
        super.disposeNoInherit(unregister);
    }

    @Override
    protected void finishBeforeSave() {
        if (this.getProperties().getPropertyBoolean("General.SwitchStudents", true)) {
            ((TimetableModel)this.currentSolution().getModel()).switchStudents(this.currentSolution().getAssignment(), null);
            this.currentSolution().saveBest();
        }
    }

    @Override
    public void save(boolean createNewSolution, boolean commitSolution) {
        this.getProperties().setProperty("General.CreateNewSolution", createNewSolution ? "true" : "false");
        if (createNewSolution) {
            this.getProperties().remove((Object)"General.SolutionId");
        }
        this.getProperties().setProperty("General.CommitSolution", commitSolution ? "true" : "false");
        super.save();
    }

    @Override
    public void load(DataProperties properties) {
        this.iAssignmentRecords.clear();
        this.iBestAssignmentRecords.clear();
        this.iCbsInfo = null;
        super.load(properties);
    }

    @Override
    public Callback getReloadingDoneCallback() {
        return new ReloadingDoneCallback();
    }

    protected boolean useAmPm() {
        return this.getProperties().getPropertyBoolean("General.UseAmPm", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConflictStatisticsInfo getCbsInfo() {
        ConflictStatistics cbs = null;
        for (Extension ext : this.getExtensions()) {
            if (!(ext instanceof ConflictStatistics)) continue;
            cbs = (ConflictStatistics)ext;
            break;
        }
        if (cbs == null || cbs.getNoGoods().isEmpty()) {
            if (this.iCbsInfo != null) {
                return this.iCbsInfo;
            }
            return null;
        }
        ConflictStatisticsInfo info = new ConflictStatisticsInfo();
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            info.load((Solver<Lecture, Placement>)this, cbs);
        }
        finally {
            lock.unlock();
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConflictStatisticsInfo getCbsInfo(Long classId) {
        ConflictStatistics cbs = null;
        for (Extension ext : this.getExtensions()) {
            if (!(ext instanceof ConflictStatistics)) continue;
            cbs = (ConflictStatistics)ext;
            break;
        }
        if (cbs == null || cbs.getNoGoods().isEmpty()) {
            if (this.iCbsInfo != null) {
                return this.iCbsInfo;
            }
            return null;
        }
        ConflictStatisticsInfo info = new ConflictStatisticsInfo();
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            info.load((Solver<Lecture, Placement>)this, cbs, classId);
        }
        finally {
            lock.unlock();
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SolverUnassignedClassesModel getUnassignedClassesModel(String ... prefix) {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            SolverUnassignedClassesModel solverUnassignedClassesModel = new SolverUnassignedClassesModel(this, prefix);
            return solverUnassignedClassesModel;
        }
        finally {
            lock.unlock();
        }
    }

    private boolean match(Query q, final String name) {
        return q == null || q.match(new Query.TermMatcher(){

            public boolean match(String attr, String term) {
                if (term.isEmpty()) {
                    return true;
                }
                if (attr == null) {
                    StringTokenizer s = new StringTokenizer(term, " ,");
                    block0: while (s.hasMoreTokens()) {
                        String termToken = s.nextToken();
                        StringTokenizer t = new StringTokenizer(name, " ,");
                        while (t.hasMoreTokens()) {
                            String token = t.nextToken();
                            if (!token.toLowerCase().startsWith(termToken.toLowerCase())) continue;
                            continue block0;
                        }
                        return false;
                    }
                    return true;
                }
                if ("regex".equals(attr) || "regexp".equals(attr) || "re".equals(attr)) {
                    return name.matches(term);
                }
                if ("find".equals(attr)) {
                    return name.toLowerCase().indexOf(term.toLowerCase()) >= 0;
                }
                return false;
            }
        });
    }

    private boolean match(Query q, final RoomConstraint rc) {
        return q == null || q.match(new Query.TermMatcher(){

            public boolean match(String attr, String term) {
                if (term.isEmpty()) {
                    return true;
                }
                if (attr == null) {
                    StringTokenizer s = new StringTokenizer(rc.getName(), " ,");
                    while (s.hasMoreTokens()) {
                        String token = s.nextToken();
                        if (!term.equalsIgnoreCase(token)) continue;
                        return true;
                    }
                } else {
                    if ("regex".equals(attr) || "regexp".equals(attr) || "re".equals(attr)) {
                        return rc.getName().matches(term);
                    }
                    if ("find".equals(attr)) {
                        return rc.getName().toLowerCase().indexOf(term.toLowerCase()) >= 0;
                    }
                    if ("type".equals(attr) && rc.getType() != null) {
                        RoomType type = (RoomType)RoomTypeDAO.getInstance().get(rc.getType());
                        return type != null && (term.equalsIgnoreCase(type.getReference()) || term.equalsIgnoreCase(type.getLabel()));
                    }
                    if ("size".equals(attr)) {
                        int min = 0;
                        int max = Integer.MAX_VALUE;
                        Size prefix = Size.eq;
                        String number = term;
                        if (number.startsWith("<=")) {
                            prefix = Size.le;
                            number = number.substring(2);
                        } else if (number.startsWith(">=")) {
                            prefix = Size.ge;
                            number = number.substring(2);
                        } else if (number.startsWith("<")) {
                            prefix = Size.lt;
                            number = number.substring(1);
                        } else if (number.startsWith(">")) {
                            prefix = Size.gt;
                            number = number.substring(1);
                        } else if (number.startsWith("=")) {
                            prefix = Size.eq;
                            number = number.substring(1);
                        }
                        try {
                            int a = Integer.parseInt(number);
                            switch (prefix) {
                                case eq: {
                                    min = max = a;
                                    break;
                                }
                                case le: {
                                    max = a;
                                    break;
                                }
                                case ge: {
                                    min = a;
                                    break;
                                }
                                case lt: {
                                    max = a - 1;
                                    break;
                                }
                                case gt: {
                                    min = a + 1;
                                }
                            }
                        }
                        catch (NumberFormatException a) {
                            // empty catch block
                        }
                        if (term.contains("..")) {
                            try {
                                String a = term.substring(0, term.indexOf(46));
                                String b = term.substring(term.indexOf("..") + 2);
                                min = Integer.parseInt(a);
                                max = Integer.parseInt(b);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        return min <= rc.getCapacity() && rc.getCapacity() <= max;
                    }
                }
                return false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public Vector getTimetableGridTables(TimetableGridContext context) {
        models = new Vector<SolverGridModel>();
        q = context.getFilter() == null ? null : new Query(context.getFilter());
        lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            model = (TimetableModel)this.currentSolution().getModel();
            switch (context.getResourceType()) {
                case 0: {
                    for (RoomConstraint rc : model.getRoomConstraints()) {
                        if (!this.match(q, rc)) continue;
                        models.add(new SolverGridModel((Solver)this, rc, context));
                    }
                    break;
                }
                case 1: {
                    for (InstructorConstraint ic : model.getInstructorConstraints()) {
                        if (!this.match(q, ic.getName())) continue;
                        models.add(new SolverGridModel((Solver)this, ic, context));
                    }
                    break;
                }
                case 2: {
                    for (DepartmentSpreadConstraint dc : model.getDepartmentSpreadConstraints()) {
                        if (!this.match(q, dc.getName())) continue;
                        models.add(new SolverGridModel((Solver)this, dc, context));
                    }
                    if (!model.getDepartmentSpreadConstraints().isEmpty()) ** break;
                    assignment = this.currentSolution().getAssignment();
                    dept2class = new HashMap<Department, HashSet<Long>>();
                    for (Object[] pair : DepartmentDAO.getInstance().getSession().createQuery("select c.controllingDept, c.uniqueId from Class_ c where c.managingDept.solverGroup.uniqueId in :solverGroupIds").setParameterList("solverGroupIds", (Object[])this.getOwnerId(), (Type)new LongType()).list()) {
                        dept = (Department)pair[0];
                        classId = (Long)pair[1];
                        classIds = (HashSet<Long>)dept2class.get(dept);
                        if (classIds == null) {
                            classIds = new HashSet<Long>();
                            dept2class.put(dept, classIds);
                        }
                        classIds.add(classId);
                    }
                    for (Department d : new TreeSet<K>(dept2class.keySet())) {
                        if (!this.match(q, d.getShortLabel())) continue;
                        classIds = (Set)dept2class.get(d);
                        size = 0;
                        placements = new ArrayList<Placement>();
                        for (Lecture lecture : ((TimetableModel)this.getModel()).variables()) {
                            if (!classIds.contains(lecture.getClassId())) continue;
                            ++size;
                            placement = (Placement)assignment.getValue((Variable)lecture);
                            if (placement == null) continue;
                            placements.add(placement);
                        }
                        if (size <= 0) continue;
                        models.add(new SolverGridModel((Solver)this, 2, d.getUniqueId(), d.getShortLabel(), size, placements, context));
                    }
                    break;
                }
                case 3: {
                    curricula = new Hashtable<String, ArrayList<Student>>();
                    hasCurricula = false;
                    ignore = new HashSet<String>();
                    tested = new HashSet<String>();
                    for (Student student : model.getAllStudents()) {
                        if (student.getCurriculum() != null && !student.getCurriculum().isEmpty()) {
                            if (!hasCurricula) {
                                curricula.clear();
                                hasCurricula = true;
                            }
                            for (String c : student.getCurriculum().split("\\|")) {
                                if (tested.add(c) && !this.match(q, c)) {
                                    ignore.add(c);
                                }
                                if (ignore.contains(c)) continue;
                                students = (ArrayList<Student>)curricula.get(c);
                                if (students == null) {
                                    students = new ArrayList<Student>();
                                    curricula.put(c, students);
                                }
                                students.add(student);
                            }
                            continue;
                        }
                        if (hasCurricula || student.getAcademicArea() == null || student.getAcademicClassification() == null) continue;
                        c = student.getAcademicArea() + (student.getMajor() == null ? "" : " " + student.getMajor()) + " " + student.getAcademicClassification();
                        if (tested.add(c) && !this.match(q, c)) {
                            ignore.add(c);
                        }
                        if (ignore.contains(c)) continue;
                        students = (ArrayList<Student>)curricula.get(c);
                        if (students == null) {
                            students = new ArrayList<Student>();
                            curricula.put(c, students);
                        }
                        students.add(student);
                    }
                    for (Map.Entry curriculum : curricula.entrySet()) {
                        models.add(new SolverGridModel((Solver)this, (String)curriculum.getKey(), (List)curriculum.getValue(), context));
                    }
                    break;
                }
                case 4: {
                    assignment = this.currentSolution().getAssignment();
                    sa2class = new HashMap<SubjectArea, HashSet<Long>>();
                    for (Object[] pair : DepartmentDAO.getInstance().getSession().createQuery("select co.subjectArea, c.uniqueId from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where co.isControl = true and c.managingDept.solverGroup.uniqueId in :solverGroupIds").setParameterList("solverGroupIds", (Object[])this.getOwnerId(), (Type)new LongType()).list()) {
                        sa = (SubjectArea)pair[0];
                        classId = (Long)pair[1];
                        classIds = (HashSet<Long>)sa2class.get(sa);
                        if (classIds == null) {
                            classIds = new HashSet<Long>();
                            sa2class.put(sa, classIds);
                        }
                        classIds.add(classId);
                    }
                    for (SubjectArea sa : new TreeSet<K>(sa2class.keySet())) {
                        if (!this.match(q, sa.getSubjectAreaAbbreviation())) continue;
                        classIds = (Set)sa2class.get(sa);
                        size = 0;
                        placements = new ArrayList<Placement>();
                        for (Lecture lecture : ((TimetableModel)this.getModel()).variables()) {
                            if (!classIds.contains(lecture.getClassId())) continue;
                            ++size;
                            placement = (Placement)assignment.getValue((Variable)lecture);
                            if (placement == null) continue;
                            placements.add(placement);
                        }
                        if (size <= 0) continue;
                        models.add(new SolverGridModel((Solver)this, 4, sa.getUniqueId(), sa.getSubjectAreaAbbreviation(), size, placements, context));
                    }
                    break;
                }
                case 5: {
                    for (StudentGroup group : model.getStudentGroups()) {
                        if (!this.match(q, group.getName())) continue;
                        models.add(new SolverGridModel((Solver)this, group, context));
                    }
                    break;
                }
                ** default:
lbl143:
                // 1 sources

                break;
            }
        }
        finally {
            lock.unlock();
        }
        return models;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassAssignmentDetails getClassAssignmentDetails(Long classId, boolean includeConstraints) {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            TimetableModel model = (TimetableModel)this.currentSolution().getModel();
            for (Lecture lecture : model.variables()) {
                if (!lecture.getClassId().equals(classId)) continue;
                ClassAssignmentDetails classAssignmentDetails = new ClassAssignmentDetails((Solver)this, lecture, includeConstraints);
                return classAssignmentDetails;
            }
            Iterator iterator = null;
            return iterator;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Suggestions getSuggestions(SuggestionsModel model) {
        if (this.iWorking) {
            return null;
        }
        Lock lock = this.currentSolution().getLock().writeLock();
        lock.lock();
        try {
            Suggestions suggestions = new Suggestions((Solver)this, model);
            return suggestions;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssignmentPreferenceInfo getInfo(Hint hint) {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            AssignmentPreferenceInfo assignmentPreferenceInfo = hint.getInfo((Solver)this);
            return assignmentPreferenceInfo;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNotValidReason(Hint hint) {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            String string = hint.getNotValidReason((Solver)this);
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assign(Collection hints) {
        Lock lock = this.currentSolution().getLock().writeLock();
        lock.lock();
        try {
            Placement p;
            Hashtable<Variable, Placement> initialAssignments = new Hashtable<Variable, Placement>();
            for (Placement placement : this.currentSolution().getAssignment().assignedValues()) {
                initialAssignments.put(placement.variable(), placement);
            }
            AssignmentRecord record = new AssignmentRecord((Solver)this);
            for (Hint hint : hints) {
                p = hint.getPlacement((TimetableModel)this.currentSolution().getModel());
                if (p != null) {
                    Placement ini = (Placement)initialAssignments.get(p.variable());
                    record.add(ini, p);
                    Progress.getInstance((Object)this.currentSolution().getModel()).info(((Lecture)p.variable()).getName() + ": " + (ini == null ? "not assigned" : ini.getLongName(this.useAmPm())) + " &rarr; " + p.getLongName(this.useAmPm()));
                    if (ini == null) continue;
                    this.currentSolution().getAssignment().unassign(0L, p.variable());
                    continue;
                }
                if (hint.getDays() != 0) continue;
                Lecture lecture = null;
                for (Lecture l : this.currentSolution().getModel().variables()) {
                    if (!l.getClassId().equals(hint.getClassId())) continue;
                    lecture = l;
                }
                if (lecture == null || lecture.isCommitted()) continue;
                this.currentSolution().getAssignment().unassign(0L, lecture);
            }
            for (Hint hint : hints) {
                p = hint.getPlacement((TimetableModel)this.currentSolution().getModel());
                if (p == null) continue;
                this.currentSolution().getAssignment().assign(0L, (Value)p);
            }
            for (Lecture lec : this.currentSolution().getModel().unassignedVariables(this.currentSolution().getAssignment())) {
                p = (Placement)initialAssignments.get(lec);
                if (p == null) continue;
                record.add(p, null);
                Progress.getInstance((Object)this.currentSolution().getModel()).info(((Lecture)p.variable()).getName() + ": " + p.getLongName(this.useAmPm()) + " &rarr; not assigned");
            }
            record.done();
            this.iAssignmentRecords.addElement(record);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable conflictInfo(Collection hints) {
        Hashtable<Hint, String> conflictTable = new Hashtable<Hint, String>();
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            HashSet<Hint> done = new HashSet<Hint>();
            for (Hint hint : hints) {
                Placement p = hint.getPlacement((TimetableModel)this.currentSolution().getModel());
                if (p == null) continue;
                for (Constraint constraint : ((Lecture)p.variable()).hardConstraints()) {
                    HashSet conflicts = new HashSet();
                    constraint.computeConflicts(this.currentSolution().getAssignment(), (Value)p, conflicts);
                    if (conflicts == null || conflicts.isEmpty()) continue;
                    for (Placement conflict : conflicts) {
                        Hint confHint = new Hint((Solver)this, conflict);
                        if (done.contains(confHint) || conflictTable.containsKey(confHint)) continue;
                        String name = TimetableSolver.getConstraintName((Constraint<Lecture, Placement>)constraint);
                        conflictTable.put(confHint, name);
                    }
                }
                done.add(hint);
            }
        }
        finally {
            lock.unlock();
        }
        return conflictTable;
    }

    public Long[] getOwnerId() {
        return this.getProperties().getPropertyLongArry("General.SolverGroupId", null);
    }

    @Override
    public Set getDepartmentIds() {
        if (this.iDepartmentIds != null) {
            return this.iDepartmentIds;
        }
        this.iDepartmentIds = new HashSet();
        Long[] ownerId = this.getOwnerId();
        for (int i = 0; i < ownerId.length; ++i) {
            SolverGroup sg = (SolverGroup)new SolverGroupDAO().get(ownerId[i]);
            Iterator<Department> j = sg.getDepartments().iterator();
            while (j.hasNext()) {
                this.iDepartmentIds.add(j.next().getUniqueId());
            }
        }
        return this.iDepartmentIds;
    }

    @Override
    public org.unitime.timetable.model.Assignment getAssignment(Class_ clazz) {
        Department dept = clazz.getManagingDept();
        if (dept != null && this.getDepartmentIds().contains(dept.getUniqueId())) {
            return this.getAssignment(clazz.getUniqueId());
        }
        return this.iCommitedClassAssignmentProxy.getAssignment(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public org.unitime.timetable.model.Assignment getAssignment(Long classId) {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            Lecture lecture = null;
            for (Lecture l : this.currentSolution().getModel().variables()) {
                if (!l.getClassId().equals(classId)) continue;
                lecture = l;
                break;
            }
            if (lecture == null) {
                Iterator iterator = null;
                return iterator;
            }
            Placement placement = (Placement)this.currentSolution().getAssignment().getValue(lecture);
            if (placement == null) {
                Lecture l;
                l = null;
                return l;
            }
            org.unitime.timetable.model.Assignment assignment = new org.unitime.timetable.model.Assignment();
            assignment.setClassName(lecture.getName());
            assignment.setDays(new Integer(placement.getTimeLocation().getDayCode()));
            assignment.setStartSlot(new Integer(placement.getTimeLocation().getStartSlot()));
            if (placement.getTimeLocation().getDatePatternId() != null) {
                assignment.setDatePattern((DatePattern)DatePatternDAO.getInstance().get(placement.getTimeLocation().getDatePatternId()));
            }
            assignment.setSlotsPerMtg(placement.getTimeLocation().getLength());
            assignment.setBreakTime(placement.getTimeLocation().getBreakTime());
            HashSet<Location> rooms = new HashSet<Location>();
            if (placement.isMultiRoom()) {
                for (RoomLocation r : placement.getRoomLocations()) {
                    Location room = (Location)new LocationDAO().get(r.getId());
                    if (room == null) continue;
                    rooms.add(room);
                }
            } else {
                Location room = (Location)new LocationDAO().get(placement.getRoomLocation().getId());
                if (room != null) {
                    rooms.add(room);
                }
            }
            assignment.setRooms(rooms);
            TimePattern pattern = (TimePattern)new TimePatternDAO().get(placement.getTimeLocation().getTimePatternId());
            assignment.setTimePattern(pattern);
            HashSet<DepartmentalInstructor> instructors = new HashSet<DepartmentalInstructor>();
            for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
                DepartmentalInstructor instructor = null;
                if (ic.getResourceId() != null) {
                    instructor = (DepartmentalInstructor)new DepartmentalInstructorDAO().get(ic.getResourceId());
                }
                if (instructor == null) continue;
                instructors.add(instructor);
            }
            assignment.setInstructors(instructors);
            org.unitime.timetable.model.Assignment assignment2 = assignment;
            return assignment2;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public AssignmentPreferenceInfo getAssignmentInfo(Class_ clazz) {
        Department dept = clazz.getManagingDept();
        if (dept != null && this.getDepartmentIds().contains(dept.getUniqueId())) {
            return this.getAssignmentInfo(clazz.getUniqueId());
        }
        return this.iCommitedClassAssignmentProxy.getAssignmentInfo(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssignmentPreferenceInfo getAssignmentInfo(Long classId) {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            AssignmentPreferenceInfo assignmentPreferenceInfo;
            Lecture lecture = null;
            for (Lecture l : this.currentSolution().getModel().variables()) {
                if (!l.getClassId().equals(classId)) continue;
                lecture = l;
                break;
            }
            if (lecture == null) {
                Iterator iterator = null;
                return iterator;
            }
            Placement placement = (Placement)this.currentSolution().getAssignment().getValue(lecture);
            if (placement == null) {
                assignmentPreferenceInfo = null;
                return assignmentPreferenceInfo;
            }
            assignmentPreferenceInfo = new AssignmentPreferenceInfo((Solver)this, placement);
            return assignmentPreferenceInfo;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Hashtable getAssignmentTable(Collection classesOrClassIds) {
        Hashtable<Long, org.unitime.timetable.model.Assignment> assignments = new Hashtable<Long, org.unitime.timetable.model.Assignment>();
        for (Object classOrClassId : classesOrClassIds) {
            org.unitime.timetable.model.Assignment assignment;
            if (classOrClassId instanceof Object[]) {
                classOrClassId = ((Object[])classOrClassId)[0];
            }
            if ((assignment = classOrClassId instanceof Class_ ? this.getAssignment((Class_)classOrClassId) : this.getAssignment((Long)classOrClassId)) == null) continue;
            assignments.put(classOrClassId instanceof Class_ ? ((Class_)classOrClassId).getUniqueId() : (Long)classOrClassId, assignment);
        }
        return assignments;
    }

    @Override
    public Hashtable getAssignmentTable2(Collection classesOrClassIds) {
        return this.getAssignmentTable(classesOrClassIds);
    }

    @Override
    public Hashtable getAssignmentInfoTable(Collection classesOrClassIds) {
        Hashtable<Long, AssignmentPreferenceInfo> infos = new Hashtable<Long, AssignmentPreferenceInfo>();
        for (Object classOrClassId : classesOrClassIds) {
            AssignmentPreferenceInfo info;
            if (classOrClassId instanceof Object[]) {
                classOrClassId = ((Object[])classOrClassId)[0];
            }
            if ((info = classOrClassId instanceof Class_ ? this.getAssignmentInfo((Class_)classOrClassId) : this.getAssignmentInfo((Long)classOrClassId)) == null) continue;
            infos.put(classOrClassId instanceof Class_ ? ((Class_)classOrClassId).getUniqueId() : (Long)classOrClassId, info);
        }
        return infos;
    }

    @Override
    public Hashtable getAssignmentInfoTable2(Collection classesOrClassIds) {
        return this.getAssignmentInfoTable(classesOrClassIds);
    }

    @Override
    public List<AssignmentRecord> getAssignmentRecords() {
        return this.iAssignmentRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RecordedAssignment> getChangesToInitial() {
        ArrayList<RecordedAssignment> ret = new ArrayList<RecordedAssignment>();
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            for (Lecture lecture : this.currentSolution().getModel().variables()) {
                if (ToolBox.equals((Object)lecture.getInitialAssignment(), (Object)this.currentSolution().getAssignment().getValue((Variable)lecture))) continue;
                RecordedAssignment a = new RecordedAssignment((Solver)this, (Placement)lecture.getInitialAssignment(), (Placement)this.currentSolution().getAssignment().getValue((Variable)lecture));
                if (lecture.getInitialAssignment() != null) {
                    a.getBefore().setDetails(new ClassAssignmentDetails((Solver)this, lecture, (Placement)lecture.getInitialAssignment(), false));
                }
                if (this.currentSolution().getAssignment().getValue((Variable)lecture) != null) {
                    a.getAfter().setDetails(new ClassAssignmentDetails((Solver)this, lecture, false));
                }
                ret.add(a);
            }
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ClassAssignmentDetails> getAssignedClasses(String ... prefix) {
        ArrayList<ClassAssignmentDetails> ret = new ArrayList<ClassAssignmentDetails>();
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            for (Lecture lecture : this.currentSolution().getAssignment().assignedVariables()) {
                if (prefix != null && prefix.length > 0) {
                    boolean hasPrefix = false;
                    for (String p : prefix) {
                        if (p != null && !lecture.getName().startsWith(p)) continue;
                        hasPrefix = true;
                        break;
                    }
                    if (!hasPrefix) continue;
                }
                ret.add(new ClassAssignmentDetails((Solver)this, lecture, false));
            }
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RecordedAssignment> getChangesToBest() {
        ArrayList<RecordedAssignment> ret = new ArrayList<RecordedAssignment>();
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            for (Lecture lecture : this.currentSolution().getModel().variables()) {
                Placement placement = (Placement)this.currentSolution().getAssignment().getValue((Variable)lecture);
                if (ToolBox.equals((Object)lecture.getBestAssignment(), (Object)placement)) continue;
                RecordedAssignment a = new RecordedAssignment((Solver)this, (Placement)lecture.getBestAssignment(), placement);
                if (lecture.getBestAssignment() != null) {
                    a.getBefore().setDetails(new ClassAssignmentDetails((Solver)this, lecture, (Placement)lecture.getBestAssignment(), false));
                }
                if (placement != null) {
                    a.getAfter().setDetails(new ClassAssignmentDetails((Solver)this, lecture, false));
                }
                ret.add(a);
            }
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    @Override
    public List<RecordedAssignment> getChangesToSolution(Long solutionId) {
        return this.getChangesToSolution(solutionId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<RecordedAssignment> getChangesToSolution(Long solutionId, boolean closeSession) {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            Session hibSession = new SolutionDAO().getSession();
            Transaction tx = null;
            ArrayList<RecordedAssignment> ret = new ArrayList<RecordedAssignment>();
            try {
                tx = hibSession.beginTransaction();
                Solution solution = (Solution)new SolutionDAO().get(solutionId, hibSession);
                if (solution == null) {
                    List<RecordedAssignment> list = null;
                    return list;
                }
                Long ownerId = solution.getOwner().getUniqueId();
                Long[] ownerIds = this.getOwnerId();
                boolean sameOwner = false;
                for (int i = 0; i < ownerIds.length; ++i) {
                    if (!ownerId.equals(ownerIds[i])) continue;
                    sameOwner = true;
                    break;
                }
                if (!sameOwner) {
                    List<RecordedAssignment> i = null;
                    return i;
                }
                HashSet<Long> ids = new HashSet<Long>();
                for (org.unitime.timetable.model.Assignment assignment : solution.getAssignments()) {
                    RecordedAssignment a;
                    Placement placement;
                    Lecture lecture = null;
                    for (Lecture l : this.currentSolution().getModel().variables()) {
                        if (!l.getClassId().equals(assignment.getClassId())) continue;
                        lecture = l;
                        break;
                    }
                    ids.add(assignment.getClassId());
                    Placement placement2 = placement = lecture == null ? null : (Placement)this.currentSolution().getAssignment().getValue((Variable)lecture);
                    if (lecture == null || placement == null) {
                        a = new RecordedAssignment((Solver)this, assignment.getPlacement(), null);
                        a.getBefore().setDetails(new ClassAssignmentDetails(solution, assignment, false, hibSession, null));
                        ret.add(a);
                        continue;
                    }
                    if (placement.equals((Object)assignment.getPlacement())) continue;
                    a = new RecordedAssignment((Solver)this, assignment.getPlacement(), placement);
                    a.getBefore().setDetails(new ClassAssignmentDetails(solution, assignment, false, hibSession, null));
                    a.getAfter().setDetails(new ClassAssignmentDetails((Solver)this, lecture, false));
                    ret.add(a);
                }
                for (Lecture lecture : this.currentSolution().getModel().variables()) {
                    Placement placement = (Placement)this.currentSolution().getAssignment().getValue((Variable)lecture);
                    if (ids.contains(lecture.getClassId()) || placement == null || !ownerId.equals(lecture.getSolverGroupId())) continue;
                    RecordedAssignment a = new RecordedAssignment((Solver)this, null, placement);
                    a.getAfter().setDetails(new ClassAssignmentDetails((Solver)this, lecture, false));
                    ret.add(a);
                }
                if (tx != null) {
                    tx.commit();
                }
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
            }
            finally {
                if (closeSession && hibSession != null && hibSession.isOpen()) {
                    hibSession.close();
                }
            }
            ArrayList<RecordedAssignment> arrayList = ret;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RoomReport getRoomReport(BitSet sessionDays, int startDayDayOfWeek, Long roomType, Float nrWeeks) {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            RoomReport roomReport = new RoomReport((Solver<Lecture, Placement>)this, sessionDays, startDayDayOfWeek, roomType, nrWeeks);
            return roomReport;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public DeptBalancingReport getDeptBalancingReport() {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            DeptBalancingReport deptBalancingReport = new DeptBalancingReport((Solver)this);
            return deptBalancingReport;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public ViolatedDistrPreferencesReport getViolatedDistrPreferencesReport() {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            ViolatedDistrPreferencesReport violatedDistrPreferencesReport = new ViolatedDistrPreferencesReport((Solver)this);
            return violatedDistrPreferencesReport;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public DiscouragedInstructorBtbReport getDiscouragedInstructorBtbReport() {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            DiscouragedInstructorBtbReport discouragedInstructorBtbReport = new DiscouragedInstructorBtbReport((Solver)this);
            return discouragedInstructorBtbReport;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public StudentConflictsReport getStudentConflictsReport() {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            StudentConflictsReport studentConflictsReport = new StudentConflictsReport((Solver)this);
            return studentConflictsReport;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public SameSubpartBalancingReport getSameSubpartBalancingReport() {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            SameSubpartBalancingReport sameSubpartBalancingReport = new SameSubpartBalancingReport((Solver)this);
            return sameSubpartBalancingReport;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public PerturbationReport getPerturbationReport() {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            PerturbationReport perturbationReport = new PerturbationReport((Solver)this);
            return perturbationReport;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CSVFile export(boolean useAmPm) {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            CSVFile file = new CSVFile();
            file.setSeparator(",");
            file.setQuotationMark("\"");
            file.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"COURSE"), new CSVFile.CSVField((Object)"ITYPE"), new CSVFile.CSVField((Object)"SECTION"), new CSVFile.CSVField((Object)"SUFFIX"), new CSVFile.CSVField((Object)"DATE_PATTERN"), new CSVFile.CSVField((Object)"DAY"), new CSVFile.CSVField((Object)"START_TIME"), new CSVFile.CSVField((Object)"END_TIME"), new CSVFile.CSVField((Object)"ROOM"), new CSVFile.CSVField((Object)"INSTRUCTOR")});
            Vector lectures = new Vector(this.currentSolution().getModel().variables());
            Collections.sort(lectures);
            for (Lecture lecture : lectures) {
                Placement placement = (Placement)this.currentSolution().getAssignment().getValue((Variable)lecture);
                String name = lecture.getName();
                String itype = "";
                String section = "";
                if (name.indexOf(32) >= 0) {
                    section = name.substring(name.lastIndexOf(32) + 1);
                    name = name.substring(0, name.lastIndexOf(32)).trim();
                }
                String suffix = "";
                while (section.charAt(section.length() - 1) >= 'a' && section.charAt(section.length() - 1) <= 'z') {
                    suffix = section.charAt(section.length() - 1) + suffix;
                    section = section.substring(0, section.length() - 1);
                }
                if (name.indexOf(32) >= 0) {
                    itype = name.substring(name.lastIndexOf(32) + 1);
                    name = name.substring(0, name.lastIndexOf(32)).trim();
                }
                try {
                    Integer.parseInt(itype);
                    itype = name.substring(name.lastIndexOf(32) + 1) + " " + itype;
                    name = name.substring(0, name.lastIndexOf(32)).trim();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                file.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)name), new CSVFile.CSVField((Object)itype), new CSVFile.CSVField((Object)section), new CSVFile.CSVField((Object)suffix), new CSVFile.CSVField((Object)(placement == null ? "" : placement.getTimeLocation().getDatePatternName())), new CSVFile.CSVField((Object)(placement == null ? "" : placement.getTimeLocation().getDayHeader())), new CSVFile.CSVField((Object)(placement == null ? "" : placement.getTimeLocation().getStartTimeHeader(useAmPm))), new CSVFile.CSVField((Object)(placement == null ? "" : placement.getTimeLocation().getEndTimeHeader(useAmPm))), new CSVFile.CSVField((Object)(placement == null ? "" : placement.getRoomName(","))), new CSVFile.CSVField((Object)(lecture.getInstructorName() == null ? "" : lecture.getInstructorName()))});
            }
            CSVFile cSVFile = file;
            return cSVFile;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean hasFinalSectioning() {
        return ((TimetableModel)this.currentSolution().getModel()).getStudentSectioning().hasFinalSectioning();
    }

    @Override
    public boolean hasConflicts(Long offeringId) {
        return false;
    }

    @Override
    public Set<org.unitime.timetable.model.Assignment> getConflicts(Long classId) {
        return null;
    }

    @Override
    public Set<RoomAvailabilityInterface.TimeBlock> getConflictingTimeBlocks(Long classId) {
        return null;
    }

    @Override
    public void save() {
        this.save(false, false);
    }

    @Override
    public SolverParameterGroup.SolverType getType() {
        return SolverParameterGroup.SolverType.COURSE;
    }

    @Override
    public boolean isRunning() {
        if (super.isRunning()) {
            return true;
        }
        return this.iWorking && this.iWorkThread != null && this.iWorkThread instanceof AbstractSolver.InterruptibleThread && this.iWorkThread.isAlive() && !this.iWorkThread.isInterrupted();
    }

    @Override
    public void stopSolver() {
        if (super.isRunning()) {
            super.stopSolver();
        }
        if (this.iWorking && this.iWorkThread != null && this.iWorkThread instanceof AbstractSolver.InterruptibleThread && this.iWorkThread.isAlive() && !this.iWorkThread.isInterrupted()) {
            try {
                this.iWorkThread.interrupt();
                this.iWorkThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public List<TimetableGridInterface.TimetableGridModel> getTimetableGridTables(org.unitime.timetable.server.solver.TimetableGridContext context) {
        context.ensureLocalizationIsSet();
        models = new ArrayList<TimetableGridInterface.TimetableGridModel>();
        q = context.getFilter() == null ? null : new Query(context.getFilter());
        lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            model = (TimetableModel)this.currentSolution().getModel();
            switch (3.$SwitchMap$org$unitime$timetable$server$solver$TimetableGridHelper$ResourceType[TimetableGridHelper.ResourceType.values()[context.getResourceType()].ordinal()]) {
                case 1: {
                    for (RoomConstraint rc : model.getRoomConstraints()) {
                        if (!this.match(q, rc)) continue;
                        models.add(TimetableGridSolverHelper.createModel(this, rc, context));
                    }
                    break;
                }
                case 2: {
                    for (InstructorConstraint ic : model.getInstructorConstraints()) {
                        if (!this.match(q, ic.getName())) continue;
                        models.add(TimetableGridSolverHelper.createModel(this, ic, context));
                    }
                    break;
                }
                case 3: {
                    for (DepartmentSpreadConstraint dc : model.getDepartmentSpreadConstraints()) {
                        if (!this.match(q, dc.getName())) continue;
                        models.add(TimetableGridSolverHelper.createModel(this, dc, context));
                    }
                    if (!model.getDepartmentSpreadConstraints().isEmpty()) ** break;
                    assignment = this.currentSolution().getAssignment();
                    dept2class = new HashMap<Department, HashSet<Long>>();
                    for (Object[] pair : DepartmentDAO.getInstance().getSession().createQuery("select c.controllingDept, c.uniqueId from Class_ c where c.managingDept.solverGroup.uniqueId in :solverGroupIds").setParameterList("solverGroupIds", (Object[])this.getOwnerId(), (Type)new LongType()).list()) {
                        dept = (Department)pair[0];
                        classId = (Long)pair[1];
                        classIds = (HashSet<Long>)dept2class.get(dept);
                        if (classIds == null) {
                            classIds = new HashSet<Long>();
                            dept2class.put(dept, classIds);
                        }
                        classIds.add(classId);
                    }
                    for (Department d : new TreeSet<K>(dept2class.keySet())) {
                        if (!this.match(q, d.getShortLabel())) continue;
                        classIds = (Set)dept2class.get(d);
                        size = 0;
                        placements = new ArrayList<Placement>();
                        for (Lecture lecture : ((TimetableModel)this.getModel()).variables()) {
                            if (!classIds.contains(lecture.getClassId())) continue;
                            ++size;
                            placement = (Placement)assignment.getValue((Variable)lecture);
                            if (placement == null) continue;
                            placements.add(placement);
                        }
                        if (size <= 0) continue;
                        models.add(TimetableGridSolverHelper.createModel(this, TimetableGridHelper.ResourceType.DEPARTMENT.ordinal(), d.getUniqueId(), d.getShortLabel(), size, placements, context));
                    }
                    break;
                }
                case 4: {
                    curricula = new Hashtable<String, ArrayList<Student>>();
                    hasCurricula = false;
                    ignore = new HashSet<String>();
                    tested = new HashSet<String>();
                    for (Student student : model.getAllStudents()) {
                        if (student.getCurriculum() != null && !student.getCurriculum().isEmpty()) {
                            if (!hasCurricula) {
                                curricula.clear();
                                hasCurricula = true;
                            }
                            for (String c : student.getCurriculum().split("\\|")) {
                                if (tested.add(c) && !this.match(q, c)) {
                                    ignore.add(c);
                                }
                                if (ignore.contains(c)) continue;
                                students = (ArrayList<Student>)curricula.get(c);
                                if (students == null) {
                                    students = new ArrayList<Student>();
                                    curricula.put(c, students);
                                }
                                students.add(student);
                            }
                            continue;
                        }
                        if (hasCurricula || student.getAcademicArea() == null || student.getAcademicClassification() == null) continue;
                        c = student.getAcademicArea() + (student.getMajor() == null ? "" : "/" + student.getMajor()) + " " + student.getAcademicClassification();
                        if (tested.add(c) && !this.match(q, c)) {
                            ignore.add(c);
                        }
                        if (ignore.contains(c)) continue;
                        students = (ArrayList<Student>)curricula.get(c);
                        if (students == null) {
                            students = new ArrayList<Student>();
                            curricula.put(c, students);
                        }
                        students.add(student);
                    }
                    for (Map.Entry curriculum : curricula.entrySet()) {
                        models.add(TimetableGridSolverHelper.createModel(this, (String)curriculum.getKey(), (List)curriculum.getValue(), context));
                    }
                    break;
                }
                case 5: {
                    assignment = this.currentSolution().getAssignment();
                    sa2class = new HashMap<SubjectArea, HashSet<Long>>();
                    for (Object[] pair : DepartmentDAO.getInstance().getSession().createQuery("select co.subjectArea, c.uniqueId from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where co.isControl = true and c.managingDept.solverGroup.uniqueId in :solverGroupIds").setParameterList("solverGroupIds", (Object[])this.getOwnerId(), (Type)new LongType()).list()) {
                        sa = (SubjectArea)pair[0];
                        classId = (Long)pair[1];
                        classIds = (HashSet<Long>)sa2class.get(sa);
                        if (classIds == null) {
                            classIds = new HashSet<Long>();
                            sa2class.put(sa, classIds);
                        }
                        classIds.add(classId);
                    }
                    for (SubjectArea sa : new TreeSet<K>(sa2class.keySet())) {
                        if (!this.match(q, sa.getSubjectAreaAbbreviation())) continue;
                        classIds = (Set)sa2class.get(sa);
                        size = 0;
                        placements = new ArrayList<Placement>();
                        for (Lecture lecture : ((TimetableModel)this.getModel()).variables()) {
                            if (!classIds.contains(lecture.getClassId())) continue;
                            ++size;
                            placement = (Placement)assignment.getValue((Variable)lecture);
                            if (placement == null) continue;
                            placements.add(placement);
                        }
                        if (size <= 0) continue;
                        models.add(TimetableGridSolverHelper.createModel(this, TimetableGridHelper.ResourceType.SUBJECT_AREA.ordinal(), sa.getUniqueId(), sa.getSubjectAreaAbbreviation(), size, placements, context));
                    }
                    break;
                }
                case 6: {
                    for (StudentGroup group : model.getStudentGroups()) {
                        if (!this.match(q, group.getName())) continue;
                        models.add(TimetableGridSolverHelper.createModel(this, group, context));
                    }
                    break;
                }
                ** default:
lbl144:
                // 1 sources

                break;
            }
        }
        finally {
            lock.unlock();
        }
        return models;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SuggestionsInterface.ClassAssignmentDetails getClassAssignmentDetails(SuggestionsContext context, Long classId, boolean includeDomain, boolean includeConstraints) {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            TimetableModel model = (TimetableModel)this.currentSolution().getModel();
            for (Lecture lecture : model.variables()) {
                if (!lecture.getClassId().equals(classId)) continue;
                SuggestionsInterface.ClassAssignmentDetails classAssignmentDetails = ClassAssignmentDetailsBackend.createClassAssignmentDetails(context, (Solver)this, lecture, includeDomain, includeConstraints);
                return classAssignmentDetails;
            }
            if (model.hasConstantVariables()) {
                for (Lecture lecture : model.constantVariables()) {
                    if (!lecture.getClassId().equals(classId)) continue;
                    SuggestionsInterface.ClassAssignmentDetails classAssignmentDetails = ClassAssignmentDetailsBackend.createClassAssignmentDetails(context, (Solver)this, lecture, includeDomain, includeConstraints);
                    return classAssignmentDetails;
                }
            }
            Iterator iterator = null;
            return iterator;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SuggestionsInterface.Suggestion getSelectedSuggestion(SuggestionsContext context, SuggestionsInterface.SelectedAssignmentsRequest request) {
        if (this.iWorking) {
            return null;
        }
        Lock lock = this.currentSolution().getLock().writeLock();
        lock.lock();
        try {
            SuggestionsInterface.Suggestion suggestion = SelectedAssignmentBackend.computeSuggestion(context, this, request.getAssignments(), null);
            return suggestion;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assignSelectedAssignments(List<SuggestionsInterface.SelectedAssignment> assignments) {
        Lock lock = this.currentSolution().getLock().writeLock();
        lock.lock();
        try {
            Placement p;
            TimetableModel model = (TimetableModel)this.currentSolution().getModel();
            Assignment assignment = this.currentSolution().getAssignment();
            HashMap<Variable, Placement> initialAssignments = new HashMap<Variable, Placement>();
            for (Placement placement : assignment.assignedValues()) {
                initialAssignments.put(placement.variable(), placement);
            }
            AssignmentRecord record = new AssignmentRecord((Solver)this);
            ArrayList<Placement> placements = new ArrayList<Placement>();
            for (SuggestionsInterface.SelectedAssignment selected : assignments) {
                if (selected.getDays() == 0) {
                    Lecture lecture = null;
                    for (Lecture l : model.variables()) {
                        if (!l.getClassId().equals(selected.getClassId())) continue;
                        lecture = l;
                        break;
                    }
                    if (lecture == null || lecture.isCommitted()) continue;
                    assignment.unassign(0L, lecture);
                    continue;
                }
                p = SelectedAssignmentBackend.getPlacement(model, selected, true);
                if (p == null) continue;
                Placement ini = (Placement)initialAssignments.get(p.variable());
                record.add(ini, p);
                Progress.getInstance((Object)model).info(((Lecture)p.variable()).getName() + ": " + (ini == null ? "not assigned" : ini.getLongName(this.useAmPm())) + " &rarr; " + p.getLongName(this.useAmPm()));
                if (ini != null) {
                    assignment.unassign(0L, p.variable());
                }
                placements.add(p);
            }
            for (Placement p2 : placements) {
                assignment.assign(0L, (Value)p2);
            }
            for (Lecture lec : model.unassignedVariables(assignment)) {
                p = (Placement)initialAssignments.get(lec);
                if (p == null) continue;
                record.add(p, null);
                Progress.getInstance((Object)model).info(((Lecture)p.variable()).getName() + ": " + p.getLongName(this.useAmPm()) + " &rarr; not assigned");
            }
            record.done();
            this.iAssignmentRecords.addElement(record);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SuggestionsInterface.Suggestions computeSuggestions(SuggestionsContext context, SuggestionsInterface.ComputeSuggestionsRequest request) {
        if (this.iWorking) {
            return null;
        }
        Lock lock = this.currentSolution().getLock().writeLock();
        lock.lock();
        try {
            SuggestionsInterface.Suggestions suggestions = ComputeSuggestionsBackend.computeSuggestions(context, this, request);
            return suggestions;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Collection<EventInterface.FilterRpcResponse.Entity>> loadSuggestionFilter(Long classId) {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            TimetableModel model = (TimetableModel)this.currentSolution().getModel();
            for (Lecture lecture : model.variables()) {
                if (!lecture.getClassId().equals(classId)) continue;
                Map<String, Collection<EventInterface.FilterRpcResponse.Entity>> map = SuggestionsFilterBackend.load(lecture);
                return map;
            }
            Iterator iterator = null;
            return iterator;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SuggestionsInterface.ClassAssignmentDetails> computeConfTable(SuggestionsContext context, SuggestionsInterface.ComputeConflictTableRequest request) {
        if (this.iWorking) {
            return null;
        }
        Lock lock = this.currentSolution().getLock().writeLock();
        lock.lock();
        try {
            List<SuggestionsInterface.ClassAssignmentDetails> list = ComputeConflictTableBackend.computeConfTable(context, this, request);
            return list;
        }
        finally {
            lock.unlock();
        }
    }

    public static String getConstraintName(Constraint<Lecture, Placement> constraint) {
        if (constraint instanceof RoomConstraint) {
            return MSG.constraintRoom(constraint.getName());
        }
        if (constraint instanceof InstructorConstraint) {
            return MSG.constraintInstructor(constraint.getName());
        }
        if (constraint instanceof GroupConstraint) {
            return MSG.constraintDistribution(constraint.getName());
        }
        if (constraint instanceof FlexibleConstraint) {
            return MSG.constraintFlexible(constraint.getName());
        }
        if (constraint instanceof DepartmentSpreadConstraint) {
            return MSG.constraintDeptBalancing(constraint.getName());
        }
        if (constraint instanceof SpreadConstraint) {
            return MSG.constraintSubpartBalancing(constraint.getName());
        }
        if (constraint instanceof ClassLimitConstraint) {
            return MSG.constraintClassLimit(constraint.getName());
        }
        if (constraint instanceof JenrlConstraint) {
            return MSG.constraintJointEnrollment(constraint.getName());
        }
        return constraint.getName() == null ? MSG.constraintWithNoName() : constraint.getName();
    }

    public String getNotValidReason(Lecture lecture, Assignment<Lecture, Placement> assignment, Placement placement, boolean useAmPm) {
        TimetableModel model = (TimetableModel)lecture.getModel();
        if (model == null) {
            return null;
        }
        Map conflictConstraints = model.conflictConstraints(assignment, (Value)placement);
        for (Map.Entry entry : conflictConstraints.entrySet()) {
            Constraint constraint = (Constraint)entry.getKey();
            Set conflicts = (Set)entry.getValue();
            String cname = TimetableSolver.getConstraintName((Constraint<Lecture, Placement>)constraint);
            for (Placement confPlacement : conflicts) {
                Lecture other = (Lecture)confPlacement.variable();
                if (other.isCommitted()) {
                    return MSG.reasonConflictsWithCommittedClass(placement.getLongName(useAmPm), other.getName(), confPlacement.getLongName(useAmPm), cname);
                }
                if (!confPlacement.equals((Object)placement)) continue;
                return MSG.reasonConflictConstraint(placement.getLongName(useAmPm), cname);
            }
        }
        return null;
    }

    public static String getNotValidReason(Placement placement, Assignment<Lecture, Placement> assignment, boolean useAmPm) {
        Lecture lecture = (Lecture)placement.variable();
        String reason = lecture.getNotValidReason(assignment, placement, useAmPm);
        if (reason != null) {
            return reason;
        }
        for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
            if (ic.isAvailable(lecture, placement)) continue;
            if (!ic.isAvailable(lecture, placement.getTimeLocation())) {
                for (Placement c : ic.getUnavailabilities()) {
                    if (!c.getTimeLocation().hasIntersection(placement.getTimeLocation()) || lecture.canShareRoom((Lecture)c.variable())) continue;
                    return MSG.reasonInstructorNotAvailableEvent(ic.getName(), placement.getTimeLocation().getLongName(useAmPm), ((Lecture)c.variable()).getName());
                }
                return MSG.reasonInstructorNotAvailable(ic.getName(), placement.getTimeLocation().getLongName(useAmPm));
            }
            return MSG.reasonInstructorTooFar(placement.getTimeLocation().getLongName(useAmPm), placement.getRoomName(", "), ic.getName());
        }
        if (lecture.getNrRooms() > 0) {
            if (placement.isMultiRoom()) {
                for (RoomLocation roomLocation : placement.getRoomLocations()) {
                    if (roomLocation.getRoomConstraint() == null || roomLocation.getRoomConstraint().isAvailable(lecture, placement.getTimeLocation(), lecture.getScheduler())) continue;
                    if (roomLocation.getRoomConstraint().getAvailableArray() != null) {
                        TimeLocation.IntEnumeration e = placement.getTimeLocation().getSlots();
                        while (e.hasMoreElements()) {
                            int slot = (Integer)e.nextElement();
                            if (roomLocation.getRoomConstraint().getAvailableArray()[slot] == null) continue;
                            for (Placement c : roomLocation.getRoomConstraint().getAvailableArray()[slot]) {
                                if (!c.getTimeLocation().hasIntersection(placement.getTimeLocation()) || lecture.canShareRoom((Lecture)c.variable())) continue;
                                return MSG.reasonRoomNotAvailableEvent(roomLocation.getName(), placement.getTimeLocation().getLongName(useAmPm), ((Lecture)c.variable()).getName());
                            }
                        }
                    }
                    return MSG.reasonRoomNotAvailable(roomLocation.getName(), placement.getTimeLocation().getLongName(useAmPm));
                }
            } else if (placement.getRoomLocation().getRoomConstraint() != null && !placement.getRoomLocation().getRoomConstraint().isAvailable(lecture, placement.getTimeLocation(), lecture.getScheduler())) {
                if (placement.getRoomLocation().getRoomConstraint().getAvailableArray() != null) {
                    TimeLocation.IntEnumeration e = placement.getTimeLocation().getSlots();
                    while (e.hasMoreElements()) {
                        int slot = (Integer)e.nextElement();
                        if (placement.getRoomLocation().getRoomConstraint().getAvailableArray()[slot] == null) continue;
                        for (Placement c : placement.getRoomLocation().getRoomConstraint().getAvailableArray()[slot]) {
                            if (!c.getTimeLocation().hasIntersection(placement.getTimeLocation()) || lecture.canShareRoom((Lecture)c.variable())) continue;
                            return MSG.reasonRoomNotAvailableEvent(placement.getRoomLocation().getName(), placement.getTimeLocation().getLongName(useAmPm), ((Lecture)c.variable()).getName());
                        }
                    }
                }
                return MSG.reasonRoomNotAvailable(placement.getRoomLocation().getName(), placement.getTimeLocation().getLongName(useAmPm));
            }
        }
        return reason == null ? MSG.reasonNotKnown() : reason;
    }

    public static class RecordedAssignment
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Hint iBefore = null;
        private Hint iAfter = null;

        public RecordedAssignment(Solver solver, Placement before, Placement after) {
            if (before != null) {
                this.iBefore = new Hint(solver, before, false);
            }
            if (after != null) {
                this.iAfter = new Hint(solver, after, false);
            }
        }

        public RecordedAssignment(Hint before, Hint after) {
            this.iBefore = before;
            this.iAfter = after;
        }

        public Hint getBefore() {
            return this.iBefore;
        }

        public Hint getAfter() {
            return this.iAfter;
        }

        public void toXml(Element element) {
            if (this.iBefore != null) {
                this.iBefore.toXml(element.addElement("before"));
            }
            if (this.iAfter != null) {
                this.iAfter.toXml(element.addElement("after"));
            }
        }

        public static RecordedAssignment fromXml(Element element) {
            Hint before = null;
            Hint after = null;
            if (element.element("before") != null) {
                before = Hint.fromXml(element.element("before"));
            }
            if (element.element("after") != null) {
                after = Hint.fromXml(element.element("after"));
            }
            return new RecordedAssignment(before, after);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AssignmentRecord
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient Solver iSolver;
        private Date iTimeStamp = new Date();
        private Suggestion iBefore = null;
        private Suggestion iAfter = null;
        private List<RecordedAssignment> iAssignments = new ArrayList<RecordedAssignment>();

        public AssignmentRecord() {
        }

        public AssignmentRecord(Solver solver) {
            this.iSolver = solver;
            this.iBefore = new Suggestion(this.iSolver);
        }

        public void done() {
            this.iAfter = new Suggestion(this.iSolver);
        }

        public void add(Placement before, Placement after) {
            this.iAssignments.add(new RecordedAssignment(this.iSolver, before, after));
        }

        public Date getTimeStamp() {
            return this.iTimeStamp;
        }

        public Suggestion getBefore() {
            return this.iBefore;
        }

        public Suggestion getAfter() {
            return this.iAfter;
        }

        public List<RecordedAssignment> getAssignments() {
            return this.iAssignments;
        }

        public String toString() {
            return "Record{TS=" + this.iTimeStamp + ", before=" + this.iBefore + ", after=" + this.iAfter + ", assignments=" + this.iAssignments.size() + "}";
        }

        public void toXml(Element element) {
            if (this.iTimeStamp != null) {
                element.addAttribute("timeStamp", String.valueOf(this.iTimeStamp.getTime()));
            }
            if (this.iBefore != null) {
                this.iBefore.toXml(element.addElement("before"));
            }
            if (this.iAfter != null) {
                this.iAfter.toXml(element.addElement("after"));
            }
            if (this.iAssignments != null) {
                for (RecordedAssignment ra : this.iAssignments) {
                    ra.toXml(element.addElement("assignment"));
                }
            }
        }

        public static AssignmentRecord fromXml(Element element) {
            AssignmentRecord r = new AssignmentRecord();
            if (element.attributeValue("timeStamp") != null) {
                r.iTimeStamp = new Date(Long.parseLong(element.attributeValue("timeStamp")));
            }
            if (element.element("before") != null) {
                r.iBefore = Suggestion.fromXml(element.element("before"));
            }
            if (element.element("after") != null) {
                r.iAfter = Suggestion.fromXml(element.element("after"));
            }
            Iterator i = element.elementIterator("assignment");
            while (i.hasNext()) {
                r.iAssignments.add(RecordedAssignment.fromXml((Element)i.next()));
            }
            return r;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Size {
        eq,
        lt,
        gt,
        le,
        ge;

    }

    public class ReloadingDoneCallback
    implements Callback {
        Hashtable iCurrentAssignmentTable = new Hashtable();
        Hashtable iBestAssignmentTable = new Hashtable();
        Hashtable iInitialAssignmentTable = new Hashtable();
        String iSolutionId = null;
        Progress iProgress = null;

        public ReloadingDoneCallback() {
            this.iSolutionId = TimetableSolver.this.getProperties().getProperty("General.SolutionId");
            for (Lecture lecture : TimetableSolver.this.currentSolution().getModel().variables()) {
                Placement current = (Placement)TimetableSolver.this.currentSolution().getAssignment().getValue((Variable)lecture);
                if (current != null) {
                    this.iCurrentAssignmentTable.put(lecture.getClassId(), current);
                }
                if (lecture.getBestAssignment() != null) {
                    this.iBestAssignmentTable.put(lecture.getClassId(), lecture.getBestAssignment());
                }
                if (lecture.getInitialAssignment() == null) continue;
                this.iInitialAssignmentTable.put(lecture.getClassId(), lecture.getInitialAssignment());
            }
        }

        private Lecture getLecture(Long classId) {
            for (Lecture lecture : TimetableSolver.this.currentSolution().getModel().variables()) {
                if (!lecture.getClassId().equals(classId)) continue;
                return lecture;
            }
            return null;
        }

        private Placement getPlacement(Lecture lecture, Placement placement) {
            TimeLocation time = null;
            for (TimeLocation t : lecture.timeLocations()) {
                if (!placement.getTimeLocation().equals((Object)t)) continue;
                time = t;
                break;
            }
            if (time == null) {
                this.iProgress.warn(AbstractSolver.MSG.warnTimeNoLongerValid(placement.getTimeLocation().getLongName(TimetableSolver.this.useAmPm()), lecture.getName()));
                return null;
            }
            Vector<RoomLocation> rooms = new Vector<RoomLocation>();
            for (RoomLocation r : lecture.roomLocations()) {
                if (placement.isMultiRoom() && placement.getRoomLocations().contains(r)) {
                    rooms.add(r);
                }
                if (placement.isMultiRoom() || !placement.getRoomLocation().equals((Object)r)) continue;
                rooms.add(r);
                break;
            }
            if (rooms.size() != lecture.getNrRooms()) {
                this.iProgress.warn(AbstractSolver.MSG.warnRoomNoLongerValid(placement.isMultiRoom() ? placement.getRoomLocations().toString() : placement.getRoomLocation().getName(), lecture.getName()));
                return null;
            }
            return new Placement(lecture, time, rooms);
        }

        private void assign(Placement placement) {
            ((TimetableModel)TimetableSolver.this.currentSolution().getModel()).weaken(TimetableSolver.this.currentSolution().getAssignment(), (Value)placement);
            if (placement.isValid()) {
                Map conflictConstraints = TimetableSolver.this.currentSolution().getModel().conflictConstraints(TimetableSolver.this.currentSolution().getAssignment(), (Value)placement);
                if (conflictConstraints.isEmpty()) {
                    TimetableSolver.this.currentSolution().getAssignment().assign(0L, (Value)placement);
                } else {
                    this.iProgress.warn(AbstractSolver.MSG.warnCannotAssignClass(((Lecture)placement.variable()).getName(), placement.getLongName(TimetableSolver.this.useAmPm())));
                    this.iProgress.warn(AbstractSolver.MSG.warnReasonFirstLine());
                    for (Constraint c : conflictConstraints.keySet()) {
                        Collection vals = (Collection)conflictConstraints.get(c);
                        for (Placement v : vals) {
                            this.iProgress.warn(AbstractSolver.MSG.warnReasonConflict(((Lecture)v.variable()).getName(), v.getLongName(TimetableSolver.this.useAmPm())));
                        }
                        this.iProgress.debug(AbstractSolver.MSG.warnReasonConstraint(TimetableSolver.getConstraintName((Constraint<Lecture, Placement>)c)));
                    }
                }
            } else {
                Map conflictConstraints;
                Lecture lecture = (Lecture)placement.variable();
                String reason = "";
                for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
                    if (ic.isAvailable(lecture, placement)) continue;
                    reason = reason + AbstractSolver.MSG.warnReasonInstructorNotAvailable(ic.getName());
                }
                if (lecture.getNrRooms() > 0) {
                    if (placement.isMultiRoom()) {
                        for (RoomLocation roomLocation : placement.getRoomLocations()) {
                            if (roomLocation.getRoomConstraint().isAvailable(lecture, placement.getTimeLocation(), lecture.getScheduler())) continue;
                            reason = reason + AbstractSolver.MSG.warnReasonRoomNotAvailable(roomLocation.getName());
                        }
                    } else if (!placement.getRoomLocation().getRoomConstraint().isAvailable(lecture, placement.getTimeLocation(), lecture.getScheduler())) {
                        reason = reason + AbstractSolver.MSG.warnReasonRoomNotAvailable(placement.getRoomLocation().getName());
                    }
                }
                if (!(conflictConstraints = TimetableSolver.this.currentSolution().getModel().conflictConstraints(TimetableSolver.this.currentSolution().getAssignment(), (Value)placement)).isEmpty()) {
                    for (Constraint c : conflictConstraints.keySet()) {
                        Set vals = (Set)conflictConstraints.get(c);
                        for (Placement p : vals) {
                            Lecture l = (Lecture)p.variable();
                            if (l.isCommitted()) {
                                reason = reason + AbstractSolver.MSG.warnReasonConstraintCommitedAssignment(l.getName(), p.getLongName(TimetableSolver.this.useAmPm()), TimetableSolver.getConstraintName((Constraint<Lecture, Placement>)c));
                            }
                            if (!p.equals((Object)placement)) continue;
                            reason = reason + AbstractSolver.MSG.warnReasonConstraint(TimetableSolver.getConstraintName((Constraint<Lecture, Placement>)c));
                        }
                    }
                }
                if (reason.isEmpty()) {
                    this.iProgress.warn(AbstractSolver.MSG.warnCannotAssignClass(lecture.getName(), placement.getLongName(TimetableSolver.this.useAmPm())));
                } else {
                    this.iProgress.warn(AbstractSolver.MSG.warnCannotAssignClassWithReason(lecture.getName(), placement.getLongName(TimetableSolver.this.useAmPm()), reason));
                }
            }
        }

        private void unassignAll() {
            for (Lecture lecture : TimetableSolver.this.currentSolution().getModel().variables()) {
                TimetableSolver.this.currentSolution().getAssignment().unassign(0L, (Variable)lecture);
            }
        }

        public void execute() {
            Placement placement;
            Lecture lecture;
            this.iProgress = Progress.getInstance((Object)TimetableSolver.this.currentSolution().getModel());
            if (!this.iBestAssignmentTable.isEmpty()) {
                this.iProgress.setPhase(AbstractSolver.MSG.phaseCreatingBestAssignment(), (long)this.iBestAssignmentTable.size());
                this.unassignAll();
                for (Map.Entry entry : this.iBestAssignmentTable.entrySet()) {
                    this.iProgress.incProgress();
                    lecture = this.getLecture((Long)entry.getKey());
                    if (lecture == null || (placement = this.getPlacement(lecture, (Placement)entry.getValue())) == null) continue;
                    this.assign(placement);
                }
                TimetableSolver.this.currentSolution().saveBest();
            }
            if (!this.iInitialAssignmentTable.isEmpty()) {
                this.iProgress.setPhase(AbstractSolver.MSG.phaseCreatingInitialAssignment(), (long)this.iInitialAssignmentTable.size());
                for (Map.Entry entry : this.iInitialAssignmentTable.entrySet()) {
                    this.iProgress.incProgress();
                    lecture = this.getLecture((Long)entry.getKey());
                    if (lecture == null || (placement = this.getPlacement(lecture, (Placement)entry.getValue())) == null) continue;
                    lecture.setInitialAssignment((Value)placement);
                }
            }
            if (!this.iCurrentAssignmentTable.isEmpty()) {
                this.iProgress.setPhase(AbstractSolver.MSG.phaseCreatingCurrentAssignment(), (long)this.iCurrentAssignmentTable.size());
                this.unassignAll();
                for (Map.Entry entry : this.iCurrentAssignmentTable.entrySet()) {
                    this.iProgress.incProgress();
                    lecture = this.getLecture((Long)entry.getKey());
                    if (lecture == null || (placement = this.getPlacement(lecture, (Placement)entry.getValue())) == null) continue;
                    this.assign(placement);
                }
            }
            this.iCurrentAssignmentTable.clear();
            TimetableSolver.this.iBestAssignmentRecords.clear();
            this.iInitialAssignmentTable.clear();
            this.iProgress = null;
            if (this.iSolutionId != null) {
                TimetableSolver.this.getProperties().setProperty("General.SolutionId", this.iSolutionId);
            }
            TimetableSolver.this.iLoadedDate = new Date();
            TimetableSolver.this.iWorking = false;
            TimetableSolver.this.afterLoad();
            Progress.getInstance((Object)TimetableSolver.this.currentSolution().getModel()).setStatus(AbstractSolver.MSG.statusReady());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FinalSectioning
    extends AbstractSolver.InterruptibleThread<Lecture, Placement> {
        @Override
        public void run() {
            this.setName("FinalSectioning");
            TimetableSolver.this.iWorking = true;
            try {
                ((TimetableModel)TimetableSolver.this.currentSolution().getModel()).switchStudents(TimetableSolver.this.currentSolution().getAssignment(), (TerminationCondition)this);
            }
            finally {
                TimetableSolver.this.iWorking = false;
                Progress.getInstance((Object)TimetableSolver.this.currentSolution().getModel()).setStatus(AbstractSolver.MSG.statusReady());
            }
            TimetableSolver.this.afterFinalSectioning();
        }
    }
}

