/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.solver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cpsolver.coursett.constraint.FlexibleConstraint;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.criteria.StudentConflict;
import org.cpsolver.coursett.criteria.additional.ImportantStudentConflict;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DistanceMetric;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SuggestionsInterface;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.solver.ClassAssignmentDetailsBackend;
import org.unitime.timetable.server.solver.SuggestionsContext;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.TimetableSolver;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.ui.GroupConstraintInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=SuggestionsInterface.ComputeConflictTableRequest.class)
public class ComputeConflictTableBackend
implements GwtRpcImplementation<SuggestionsInterface.ComputeConflictTableRequest, GwtRpcResponseList<SuggestionsInterface.ClassAssignmentDetails>> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;

    @Override
    public GwtRpcResponseList<SuggestionsInterface.ClassAssignmentDetails> execute(SuggestionsInterface.ComputeConflictTableRequest request, SessionContext context) {
        SolverProxy solver;
        context.checkPermission(Right.Suggestions);
        SuggestionsContext cx = new SuggestionsContext();
        String instructorFormat = context.getUser().getProperty(UserProperty.NameFormat);
        if (instructorFormat != null) {
            cx.setInstructorNameFormat(instructorFormat);
        }
        if ((solver = this.courseTimetablingSolverService.getSolver()) == null) {
            throw new GwtRpcException(MESSAGES.warnSolverNotLoaded());
        }
        if (solver.isWorking()) {
            throw new GwtRpcException(MESSAGES.warnSolverIsWorking());
        }
        List<SuggestionsInterface.ClassAssignmentDetails> response = solver.computeConfTable(cx, request);
        return response == null ? null : new GwtRpcResponseList<SuggestionsInterface.ClassAssignmentDetails>((Collection<SuggestionsInterface.ClassAssignmentDetails>)response);
    }

    public static List<SuggestionsInterface.ClassAssignmentDetails> computeConfTable(SuggestionsContext context, TimetableSolver solver, SuggestionsInterface.ComputeConflictTableRequest request) {
        ArrayList<SuggestionsInterface.ClassAssignmentDetails> conflicts = new ArrayList<SuggestionsInterface.ClassAssignmentDetails>();
        Lecture lecture = null;
        for (Lecture l : solver.currentSolution().getModel().variables()) {
            if (!l.getClassId().equals(request.getClassId())) continue;
            lecture = l;
        }
        if (lecture == null) {
            for (Lecture l : ((TimetableModel)solver.currentSolution().getModel()).constantVariables()) {
                if (!l.getClassId().equals(request.getClassId())) continue;
                lecture = l;
            }
        }
        for (TimeLocation t : lecture.timeLocations()) {
            SuggestionsInterface.ClassAssignmentDetails conflict;
            if (PreferenceLevel.sProhibited.equals(PreferenceLevel.int2prolog(t.getPreference())) || t.getPreference() > 500 || (conflict = ComputeConflictTableBackend.createConflict(context, (Solver)solver, lecture, t)) == null) continue;
            conflicts.add(conflict);
        }
        return conflicts;
    }

    protected static SuggestionsInterface.ClassAssignmentDetails createConflict(SuggestionsContext context, Solver solver, Lecture lecture, TimeLocation time) {
        Assignment assignment = solver.currentSolution().getAssignment();
        Placement currentPlacement = (Placement)assignment.getValue((Variable)lecture);
        if (currentPlacement == null) {
            List values = lecture.values(assignment);
            Placement placement = currentPlacement = values.isEmpty() ? null : (Placement)values.get(0);
        }
        if (currentPlacement == null) {
            return null;
        }
        Placement dummyPlacement = null;
        dummyPlacement = currentPlacement.isMultiRoom() ? new Placement(lecture, time, currentPlacement.getRoomLocations()) : new Placement(lecture, time, currentPlacement.getRoomLocation());
        SuggestionsInterface.ClassAssignmentDetails suggestion = ClassAssignmentDetailsBackend.createClassAssignmentDetails(context, solver, lecture, dummyPlacement, false, false);
        TimetableModel m = (TimetableModel)solver.currentSolution().getModel();
        StudentConflict imp = (StudentConflict)m.getCriterion(ImportantStudentConflict.class);
        HashMap<Placement, Integer> committed = new HashMap<Placement, Integer>();
        if (dummyPlacement.getCommitedConflicts() > 0) {
            for (Student student : lecture.students()) {
                Set confs = student.conflictPlacements(dummyPlacement);
                if (confs == null) continue;
                Iterator iterator = confs.iterator();
                while (iterator.hasNext()) {
                    Placement commitedPlacement;
                    Integer current = (Integer)committed.get(commitedPlacement = (Placement)iterator.next());
                    committed.put(commitedPlacement, new Integer(1 + (current == null ? 0 : current)));
                }
            }
        }
        for (JenrlConstraint jenrlConstraint : lecture.jenrlConstraints()) {
            long j = jenrlConstraint.jenrl(assignment, lecture, dummyPlacement);
            if (j <= 0L || jenrlConstraint.isToBeIgnored() || jenrlConstraint.areStudentConflictsDistance(assignment, dummyPlacement)) continue;
            SuggestionsInterface.JenrlInfo jInfo = new SuggestionsInterface.JenrlInfo();
            jInfo.setJenrl((int)j);
            jInfo.setIsHard(jenrlConstraint.areStudentConflictsHard());
            jInfo.setIsDistance(jenrlConstraint.areStudentConflictsDistance(assignment, dummyPlacement));
            jInfo.setIsImportant(imp != null && jenrlConstraint.priority() > 0.0);
            jInfo.setIsWorkDay(jenrlConstraint.areStudentConflictsWorkday(assignment, dummyPlacement));
            jInfo.setIsFixed(((Lecture)jenrlConstraint.first()).nrTimeLocations() == 1 && ((Lecture)jenrlConstraint.second()).nrTimeLocations() == 1);
            jInfo.setIsInstructor(jenrlConstraint.getNrInstructors() > 0);
            if (((Lecture)jenrlConstraint.first()).equals((Object)lecture)) {
                if (((Lecture)jenrlConstraint.second()).isCommitted()) {
                    jInfo.setIsCommited(true);
                }
                suggestion.addStudentConflict(new SuggestionsInterface.StudentConflictInfo(jInfo, ClassAssignmentDetailsBackend.createClassAssignmentDetails(context, solver, (Lecture)jenrlConstraint.second(), false, false)));
                continue;
            }
            if (((Lecture)jenrlConstraint.first()).isCommitted()) {
                jInfo.setIsCommited(true);
            }
            suggestion.addStudentConflict(new SuggestionsInterface.StudentConflictInfo(jInfo, ClassAssignmentDetailsBackend.createClassAssignmentDetails(context, solver, (Lecture)jenrlConstraint.first(), false, false)));
        }
        for (Map.Entry entry : committed.entrySet()) {
            Placement p = (Placement)entry.getKey();
            Integer cnt = (Integer)entry.getValue();
            SuggestionsInterface.JenrlInfo jenrl = new SuggestionsInterface.JenrlInfo();
            jenrl.setIsCommited(true);
            jenrl.setJenrl(cnt);
            jenrl.setIsFixed(lecture.nrTimeLocations() == 1);
            jenrl.setIsHard(lecture.isSingleSection());
            jenrl.setIsDistance(StudentConflict.distance((DistanceMetric)m.getDistanceMetric(), (Placement)dummyPlacement, (Placement)p));
            jenrl.setIsWorkDay(StudentConflict.workday((int)m.getStudentWorkDayLimit(), (Placement)dummyPlacement, (Placement)p));
            suggestion.addStudentConflict(new SuggestionsInterface.StudentConflictInfo(jenrl, ClassAssignmentDetailsBackend.createClassAssignmentDetails(context, solver, (Lecture)p.variable(), p, false, false)));
        }
        for (GroupConstraint groupConstraint : lecture.groupConstraints()) {
            boolean sat;
            if (groupConstraint.getType() == GroupConstraint.ConstraintType.SAME_ROOM) continue;
            int curPref = groupConstraint.getCurrentPreference(assignment, dummyPlacement);
            if (groupConstraint.getType() == GroupConstraint.ConstraintType.BTB) {
                groupConstraint.setType(GroupConstraint.ConstraintType.BTB_TIME);
                curPref = groupConstraint.getCurrentPreference(assignment, dummyPlacement);
                groupConstraint.setType(GroupConstraint.ConstraintType.BTB);
            }
            if (groupConstraint.getType() == GroupConstraint.ConstraintType.SAME_STUDENTS) {
                groupConstraint.setType(GroupConstraint.ConstraintType.DIFF_TIME);
                curPref = groupConstraint.getCurrentPreference(assignment, dummyPlacement);
                groupConstraint.setType(GroupConstraint.ConstraintType.SAME_STUDENTS);
            }
            boolean bl = sat = curPref <= 0;
            if (sat) continue;
            SuggestionsInterface.DistributionInfo dist = new SuggestionsInterface.DistributionInfo(ClassAssignmentDetailsBackend.toGroupConstraintInfo(new GroupConstraintInfo((Assignment<Lecture, Placement>)assignment, groupConstraint)));
            dist.getInfo().setValue(Double.valueOf(curPref));
            dist.getInfo().setIsSatisfied(false);
            for (Lecture another : groupConstraint.variables()) {
                if (another.equals((Object)lecture) || assignment.getValue((Variable)another) == null) continue;
                dist.addClass(ClassAssignmentDetailsBackend.createClassAssignmentDetails(context, solver, another, false, false));
            }
            suggestion.addDistributionConflict(dist);
        }
        HashMap<Lecture, Placement> dummies = new HashMap<Lecture, Placement>();
        if (dummyPlacement != null) {
            dummies.put(lecture, dummyPlacement);
        }
        for (FlexibleConstraint fc : lecture.getFlexibleGroupConstraints()) {
            if (fc.isHard() || fc.getNrViolations(assignment, null, dummies) == 0.0) continue;
            SuggestionsInterface.DistributionInfo dist = new SuggestionsInterface.DistributionInfo(ClassAssignmentDetailsBackend.toGroupConstraintInfo(new GroupConstraintInfo((Assignment<Lecture, Placement>)assignment, fc)));
            dist.getInfo().setValue(Math.abs(fc.getCurrentPreference(assignment, null, dummies)));
            dist.getInfo().setIsSatisfied(false);
            for (Lecture another : fc.variables()) {
                if (another.equals((Object)lecture) || assignment.getValue((Variable)another) == null) continue;
                dist.addClass(ClassAssignmentDetailsBackend.createClassAssignmentDetails(context, solver, another, false, false));
            }
            suggestion.addDistributionConflict(dist);
        }
        return suggestion;
    }
}

