/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.instructor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.util.HtmlUtils;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.InstructorInterface;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.InstructorAttributeType;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.InstructorAttributeTypeDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.FilterBoxBackend;
import org.unitime.timetable.solver.instructor.InstructorSchedulingProxy;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.util.NameFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=InstructorInterface.TeachingRequestsFilterRpcRequest.class)
public class TeachingRequestsFilterBackend
extends FilterBoxBackend<InstructorInterface.TeachingRequestsFilterRpcRequest> {
    protected static GwtMessages MSG = Localization.create(GwtMessages.class);
    @Autowired
    SolverService<InstructorSchedulingProxy> instructorSchedulingSolverService;

    @Override
    public EventInterface.FilterRpcResponse execute(InstructorInterface.TeachingRequestsFilterRpcRequest request, SessionContext context) {
        context.checkPermission(Right.InstructorScheduling);
        return super.execute(request, context);
    }

    @Override
    public void load(InstructorInterface.TeachingRequestsFilterRpcRequest request, EventInterface.FilterRpcResponse response, SessionContext context) {
        SubjectArea subject;
        boolean hasTeachingPreference;
        InstructorSchedulingProxy solver = this.instructorSchedulingSolverService.getSolver();
        Long ownerId = null;
        if (solver != null && (ownerId = solver.getProperties().getPropertyLong("General.SolverGroupId", null)) != null) {
            request.setOption("owner", ownerId.toString());
        }
        for (SubjectArea sa : SubjectArea.getUserSubjectAreas(context.getUser(), true)) {
            if (ownerId != null && (sa.getDepartment().getSolverGroup() == null || !ownerId.equals(sa.getDepartment().getSolverGroup().getUniqueId()))) continue;
            hasTeachingPreference = false;
            for (DepartmentalInstructor di : sa.getDepartment().getInstructors()) {
                if (di.getTeachingPreference() == null || PreferenceLevel.sProhibited.equals(di.getTeachingPreference().getPrefProlog())) continue;
                hasTeachingPreference = true;
                break;
            }
            if (!hasTeachingPreference) continue;
            response.add("subject", new EventInterface.FilterRpcResponse.Entity(sa.getUniqueId(), sa.getSubjectAreaAbbreviation(), sa.getSubjectAreaAbbreviation() + " - " + HtmlUtils.htmlUnescape((String)sa.getTitle()), "hint", sa.getSubjectAreaAbbreviation() + " - " + HtmlUtils.htmlUnescape((String)sa.getTitle())));
        }
        for (Department d : Department.getUserDepartments(context.getUser())) {
            if (ownerId != null && (d.getSolverGroup() == null || !ownerId.equals(d.getSolverGroup().getUniqueId()))) continue;
            hasTeachingPreference = false;
            for (DepartmentalInstructor di : d.getInstructors()) {
                if (di.getTeachingPreference() == null || PreferenceLevel.sProhibited.equals(di.getTeachingPreference().getPrefProlog())) continue;
                hasTeachingPreference = true;
                break;
            }
            if (!hasTeachingPreference) continue;
            response.add("department", new EventInterface.FilterRpcResponse.Entity(d.getUniqueId(), d.getDeptCode(), d.getDeptCode() + " - " + HtmlUtils.htmlUnescape((String)d.getLabel()), new String[0]));
        }
        Department department = null;
        if (request.hasOption("department")) {
            department = Department.findByDeptCode(request.getOption("department"), request.getSessionId(), DepartmentDAO.getInstance().getSession());
        } else if (request.hasOption("subject") && (subject = SubjectArea.findByAbbv(request.getSessionId(), request.getOption("subject"))) != null) {
            department = subject.getDepartment();
        }
        for (InstructorAttribute a : InstructorAttribute.getAllGlobalAttributes(request.getSessionId())) {
            response.add(a.getType().getReference().replace(' ', '_'), new EventInterface.FilterRpcResponse.Entity(a.getUniqueId(), a.getCode(), a.getName(), "hint", a.getNameWithType()));
        }
        if (department != null) {
            for (InstructorAttribute a : InstructorAttribute.getAllDepartmentalAttributes(department.getUniqueId())) {
                response.add(a.getType().getReference().replace(' ', '_'), new EventInterface.FilterRpcResponse.Entity(a.getUniqueId(), a.getCode(), a.getName(), "hint", a.getNameWithType()));
            }
        }
    }

    protected void fixAttributeTypes(InstructorInterface.TeachingRequestsFilterRpcRequest request) {
        Long ownerId;
        InstructorSchedulingProxy solver = this.instructorSchedulingSolverService.getSolver();
        if (solver != null && (ownerId = solver.getProperties().getPropertyLong("General.SolverGroupId", null)) != null) {
            request.setOption("owner", ownerId.toString());
        }
        for (InstructorAttributeType type : InstructorAttributeTypeDAO.getInstance().findAll()) {
            if (!request.hasOptions(type.getReference().replace(' ', '_'))) continue;
            for (String option : request.getOptions(type.getReference().replace(' ', '_'))) {
                request.addOption("attribute", option);
            }
        }
    }

    @Override
    public void suggestions(InstructorInterface.TeachingRequestsFilterRpcRequest request, EventInterface.FilterRpcResponse response, SessionContext context) {
        this.fixAttributeTypes(request);
        if (!request.getText().isEmpty()) {
            NameFormat nf = NameFormat.fromReference(UserProperty.NameFormat.get(context.getUser()));
            InstructorQuery.QueryInstance instance = TeachingRequestsFilterBackend.getQuery(request, context.getUser()).select("distinct i").exclude("instructor").order("i.lastName, i.firstName, i.middleName");
            int id = 0;
            String where = "";
            StringTokenizer s = new StringTokenizer(request.getText().trim(), ", ");
            while (s.hasMoreTokens()) {
                String token = s.nextToken().toUpperCase();
                if (!where.isEmpty()) {
                    where = where + " and ";
                }
                where = where + "(upper(i.firstName) like :cn" + id + " || '%' or upper(i.middleName) like :cn" + id + " || '%' or upper(i.lastName) like :cn" + id + " || '%' or upper(i.email) like :cn" + id + ")";
                instance.set("cn" + id, token);
                ++id;
            }
            if (id > 0) {
                instance.where("(" + where + ") or upper(trim(trailing ' ' from i.lastName || ', ' || i.firstName || ' ' || i.middleName)) = :name or i.externalUniqueId = :id");
                instance.set("name", request.getText().trim().toUpperCase());
                instance.set("id", request.getText().trim());
                for (DepartmentalInstructor instructor : instance.limit(20).query(DepartmentalInstructorDAO.getInstance().getSession()).list()) {
                    response.addSuggestion(nf.format(instructor), instructor.getExternalUniqueId() == null ? nf.format(instructor) : instructor.getExternalUniqueId(), MSG.fieldInstructor(), "instructor");
                }
            }
        }
        if (!request.getText().isEmpty()) {
            RequestQuery.QueryInstance instance = TeachingRequestsFilterBackend.getRequestQuery(request, context.getUser()).select("distinct c").exclude("course").order("c.subjectAreaAbbv, c.courseNbr");
            if (request.hasOption("subject")) {
                instance.set("name", request.getText().toUpperCase() + "%").where("upper(c.subjectAreaAbbv || ' ' || c.courseNbr) like :name or c.courseNbr like :name");
            } else {
                instance.set("name", request.getText().toUpperCase() + "%").where("upper(c.subjectAreaAbbv || ' ' || c.courseNbr) like :name");
            }
            for (CourseOffering co : instance.limit(20).query(DepartmentalInstructorDAO.getInstance().getSession()).list()) {
                response.addSuggestion(co.getCourseName(), co.getCourseName(), co.getTitle() == null || co.getTitle().isEmpty() ? MSG.fieldCourse() : co.getTitle(), "course");
            }
        }
    }

    @Override
    public void enumarate(InstructorInterface.TeachingRequestsFilterRpcRequest request, EventInterface.FilterRpcResponse response, SessionContext context) {
    }

    public static InstructorQuery getQuery(EventInterface.FilterRpcRequest request, UserContext user) {
        int id;
        InstructorQuery query = new InstructorQuery(request.getSessionId() == null ? user.getCurrentAcademicSessionId() : request.getSessionId());
        if (request.hasOption("instructorId")) {
            query.addParameter("instructor", "Xiid", Long.valueOf(request.getOption("instructorId")));
            query.addWhere("instructor", "i.uniqueId = :Xiid");
        } else if (request.hasOptions("instructor")) {
            String instructor = "";
            id = 0;
            StringTokenizer s = new StringTokenizer(request.getOption("instructor").trim(), ", ");
            while (s.hasMoreTokens()) {
                String token = s.nextToken().toUpperCase();
                instructor = instructor + (instructor.isEmpty() ? "" : " and ") + "(upper(i.firstName) like :Xins" + id + " || '%' or upper(i.middleName) like :Xins" + id + " || '%' or upper(i.lastName) like :Xins" + id + " || '%' or upper(i.email) like :Xins" + id + " || '%')";
                query.addParameter("instructor", "Xins" + id, token);
                ++id;
            }
            if (id > 0) {
                instructor = "(" + instructor + ") or (upper(trim(trailing ' ' from i.lastName || ', ' || i.firstName || ' ' || i.middleName)) = :Xins) or (i.externalUniqueId = :Xiid)";
                query.addParameter("instructor", "Xins", request.getOption("instructor").trim().toUpperCase());
                query.addParameter("instructor", "Xiid", request.getOption("instructor").trim());
                query.addWhere("instructor", instructor);
            }
        }
        query.addWhere("load", "i.maxLoad > 0");
        query.addWhere("preference", "i.teachingPreference.prefProlog != :Xpref");
        query.addParameter("preference", "Xpref", PreferenceLevel.sProhibited);
        if (request.hasOption("department")) {
            query.addParameter("department", "Xdpt", request.getOption("department"));
            query.addWhere("department", "i.department.deptCode = :Xdpt");
        } else if (request.hasOption("subject")) {
            query.addFrom("subject", "SubjectArea s");
            query.addParameter("subject", "Xsa", request.getOption("subject"));
            query.addWhere("subject", "s in elements(i.department.subjectAreas) and s.subjectAreaAbbreviation = :Xsa");
        } else if (request.hasOption("owner")) {
            query.addParameter("owner", "Xsg", Long.valueOf(request.getOption("owner")));
            query.addWhere("owner", "i.department.solverGroup.uniqueId = :Xsg");
        } else {
            String department = "";
            id = 0;
            for (Department d : Department.getUserDepartments(user)) {
                boolean hasTeachingPreference = false;
                for (DepartmentalInstructor di : d.getInstructors()) {
                    if (di.getTeachingPreference() == null || PreferenceLevel.sProhibited.equals(di.getTeachingPreference().getPrefProlog())) continue;
                    hasTeachingPreference = true;
                    break;
                }
                if (!hasTeachingPreference) continue;
                query.addParameter("department", "Xdpt" + id, d.getUniqueId());
                department = department + (department.isEmpty() ? "" : ",") + ":Xdpt" + id;
                ++id;
            }
            if (id > 0) {
                query.addWhere("department", "i.department.uniqueId in (" + department + ")");
            }
        }
        if (request.hasOptions("attribute")) {
            query.addFrom("attribute", "InstructorAttribute a");
            String attribute = "";
            id = 0;
            for (String g : request.getOptions("attribute")) {
                attribute = attribute + (attribute.isEmpty() ? "" : ",") + ":Xatt" + id;
                query.addParameter("attribute", "Xatt" + id, g);
                ++id;
            }
            query.addWhere("attribute", "a in elements(i.attributes) and a.code in (" + attribute + ")");
        }
        return query;
    }

    public static RequestQuery getRequestQuery(EventInterface.FilterRpcRequest request, UserContext user) {
        RequestQuery query = new RequestQuery(request.getSessionId() == null ? user.getCurrentAcademicSessionId() : request.getSessionId());
        if (request.hasOption("subject")) {
            query.addParameter("owner", "Xsa", request.getOption("subject"));
            query.addWhere("owner", "c.subjectArea.subjectAreaAbbreviation = :Xsa");
        } else if (request.hasOption("subjectId")) {
            query.addParameter("owner", "Xsa", request.getOption("subjectId"));
            query.addWhere("owner", "c.subjectArea.uniqueId = :Xsa");
        } else if (request.hasOption("department")) {
            query.addParameter("owner", "Xdpt", request.getOption("department"));
            query.addWhere("owner", "c.subjectArea.department.deptCode = :Xdpt");
        } else if (request.hasOption("departmentId")) {
            query.addParameter("owner", "Xdpt", request.getOption("department"));
            query.addWhere("owner", "c.subjectArea.department.uniqueId = :Xdpt");
        } else if (request.hasOption("owner")) {
            query.addParameter("owner", "Xsg", Long.valueOf(request.getOption("owner")));
            query.addWhere("owner", "c.subjectArea.department.solverGroup.uniqueId = :Xsg");
        } else if (request.hasOption("offeringId")) {
            query.addParameter("owner", "Xoff", request.getOption("offeringId"));
            query.addWhere("owner", "o.uniqueId = :Xoff");
        } else {
            String department = "";
            int id = 0;
            for (Department d : Department.getUserDepartments(user)) {
                boolean hasTeachingPreference = false;
                for (DepartmentalInstructor di : d.getInstructors()) {
                    if (di.getTeachingPreference() == null || PreferenceLevel.sProhibited.equals(di.getTeachingPreference().getPrefProlog())) continue;
                    hasTeachingPreference = true;
                    break;
                }
                if (!hasTeachingPreference) continue;
                query.addParameter("owner", "Xdpt" + id, d.getUniqueId());
                department = department + (department.isEmpty() ? "" : ",") + ":Xdpt" + id;
                ++id;
            }
            if (id > 0) {
                query.addWhere("owner", "c.subjectArea.department.uniqueId in (" + department + ")");
            }
        }
        if (request.hasOption("course")) {
            query.addWhere("course", "c.subjectAreaAbbv || ' ' || c.courseNbr = :Xcrs");
            query.addParameter("course", "Xcrs", request.getOption("course"));
        }
        return query;
    }

    public static Query toQuery(EventInterface.FilterRpcRequest request) {
        ArrayList<Query.Term> ands = new ArrayList<Query.Term>();
        if (request.hasOptions()) {
            for (Map.Entry<String, Set<String>> option : request.getOptions().entrySet()) {
                ArrayList<Query.Term> ors = new ArrayList<Query.Term>();
                for (String value : option.getValue()) {
                    ors.add(new Query.AtomTerm(option.getKey(), value));
                }
                if (ors.size() > 1) {
                    ands.add(new Query.OrTerm(ors));
                    continue;
                }
                if (ors.size() != 1) continue;
                ands.add((Query.Term)ors.get(0));
            }
        }
        if (request.hasText()) {
            ands.add(new Query(request.getText()).getQuery());
        }
        if (ands.size() == 1) {
            return new Query((Query.Term)ands.get(0));
        }
        return new Query(new Query.AndTerm(ands));
    }

    public static class TeachingRequestMatcher
    implements Query.TermMatcher {
        private InstructorInterface.TeachingRequestInfo iRequest;
        private InstructorInterface.InstructorInfo iInstructor;
        private EventInterface.FilterRpcRequest iFilter;

        public TeachingRequestMatcher(InstructorInterface.TeachingRequestInfo request, InstructorInterface.InstructorInfo instructor, EventInterface.FilterRpcRequest filter) {
            this.iRequest = request;
            this.iInstructor = instructor;
            this.iFilter = filter;
        }

        public TeachingRequestMatcher(InstructorInterface.TeachingRequestInfo request, EventInterface.FilterRpcRequest filter) {
            this(request, null, filter);
        }

        public TeachingRequestMatcher(InstructorInterface.InstructorInfo instructor, EventInterface.FilterRpcRequest filter) {
            this(null, instructor, filter);
        }

        public boolean match(String attr, String term) {
            if ("department".equals(attr) || "departmentId".equals(attr)) {
                return true;
            }
            if ("subject".equals(attr) || "subjectId".equals(attr)) {
                return true;
            }
            if ("owner".equals(attr) || "offeringId".equals(attr)) {
                return true;
            }
            if (attr == null || "course".equals(attr)) {
                if (this.iRequest != null) {
                    return this.iRequest.getCourse().getCourseName().equalsIgnoreCase(term);
                }
                for (InstructorInterface.TeachingRequestInfo r : this.iInstructor.getAssignedRequests()) {
                    if (!r.getCourse().getCourseName().equalsIgnoreCase(term)) continue;
                    return true;
                }
                return false;
            }
            if ("attribute".equals(attr)) {
                if (this.iInstructor != null) {
                    for (InstructorInterface.AttributeInterface a : this.iInstructor.getAttributes()) {
                        if (!a.getCode().equalsIgnoreCase(term) && !a.getName().equalsIgnoreCase(term)) continue;
                        return true;
                    }
                    return false;
                }
                if (this.iRequest.hasInstructors()) {
                    for (InstructorInterface.InstructorInfo i : this.iRequest.getInstructors()) {
                        for (InstructorInterface.AttributeInterface a : i.getAttributes()) {
                            if (!a.getCode().equalsIgnoreCase(term) && !a.getName().equalsIgnoreCase(term)) continue;
                            return true;
                        }
                    }
                    return false;
                }
                return true;
            }
            if ("instructor".equals(attr)) {
                if (this.iInstructor != null) {
                    return this.iInstructor.hasExternalId() && this.iInstructor.getExternalId().equals(term) || this.iInstructor.getInstructorName().equalsIgnoreCase(term);
                }
                if (this.iRequest.hasInstructors()) {
                    for (InstructorInterface.InstructorInfo i : this.iRequest.getInstructors()) {
                        if ((!i.hasExternalId() || !i.getExternalId().equals(term)) && !i.getInstructorName().equalsIgnoreCase(term)) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }
            if ("instructorId".equals(attr)) {
                if (this.iInstructor != null) {
                    return this.iInstructor.getInstructorId().toString().equals(term);
                }
                if (this.iRequest.hasInstructors()) {
                    for (InstructorInterface.InstructorInfo i : this.iRequest.getInstructors()) {
                        if (!i.getInstructorId().toString().equals(term)) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }
            if ("assigned".equals(attr)) {
                if (this.iRequest != null && this.iInstructor == null) {
                    if ("true".equalsIgnoreCase(term) && this.iRequest.getNrAssignedInstructors() > 0) {
                        return true;
                    }
                    if (!"true".equalsIgnoreCase(term) && this.iRequest.getNrAssignedInstructors() < this.iRequest.getNrInstructors()) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            if (this.iInstructor != null) {
                for (InstructorInterface.AttributeInterface a : this.iInstructor.getAttributes()) {
                    if (!a.getType().getLabel().equalsIgnoreCase(attr) || !a.getName().equalsIgnoreCase(term)) continue;
                    return true;
                }
                return false;
            }
            if (this.iRequest.hasInstructors()) {
                for (InstructorInterface.InstructorInfo i : this.iRequest.getInstructors()) {
                    for (InstructorInterface.AttributeInterface a : i.getAttributes()) {
                        if (!a.getType().getLabel().equalsIgnoreCase(attr) || !a.getName().equalsIgnoreCase(term)) continue;
                        return true;
                    }
                }
                return false;
            }
            if (this.iFilter.hasOption("assigned") && !"true".equals(this.iFilter.getOption("assigned"))) {
                for (InstructorInterface.PreferenceInfo p : this.iRequest.getAttributePreferences()) {
                    if (!p.getOwnerName().equalsIgnoreCase(term)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RequestQuery {
        protected Long iSessionId;
        protected Map<String, String> iFrom = new HashMap<String, String>();
        protected Map<String, String> iWhere = new HashMap<String, String>();
        protected Map<String, Map<String, Object>> iParams = new HashMap<String, Map<String, Object>>();

        public RequestQuery(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public RequestQuery(RequestQuery q) {
            this.iSessionId = q.iSessionId;
            this.iFrom.putAll(q.iFrom);
            this.iWhere.putAll(q.iWhere);
            this.iParams.putAll(q.iParams);
        }

        public void addFrom(String option, String from) {
            if (from == null) {
                this.iFrom.remove(option);
            } else {
                this.iFrom.put(option, from);
            }
        }

        public void addWhere(String option, String where) {
            if (where == null) {
                this.iWhere.remove(option);
            } else {
                this.iWhere.put(option, where);
            }
        }

        protected void addParameter(String option, String name, Object value) {
            Map<String, Object> params = this.iParams.get(option);
            if (params == null) {
                params = new HashMap<String, Object>();
                this.iParams.put(option, params);
            }
            if (value == null) {
                params.remove(name);
            } else {
                params.put(name, value);
            }
        }

        public String getFrom(Collection<String> excludeOption) {
            String from = "";
            for (Map.Entry<String, String> entry : this.iFrom.entrySet()) {
                if (excludeOption != null && excludeOption.contains(entry.getKey())) continue;
                from = from + (entry.getValue().startsWith("inner join") ? " " : ", ") + entry.getValue();
            }
            return from;
        }

        public String getWhere(Collection<String> excludeOption) {
            String where = "";
            for (Map.Entry<String, String> entry : this.iWhere.entrySet()) {
                if (excludeOption != null && excludeOption.contains(entry.getKey())) continue;
                where = where + " and (" + entry.getValue() + ")";
            }
            return where;
        }

        public org.hibernate.Query setParams(org.hibernate.Query query, Collection<String> excludeOption) {
            for (Map.Entry<String, Map<String, Object>> entry : this.iParams.entrySet()) {
                if (excludeOption != null && excludeOption.contains(entry.getKey())) continue;
                for (Map.Entry<String, Object> param : entry.getValue().entrySet()) {
                    if (param.getValue() instanceof Integer) {
                        query.setInteger(param.getKey(), ((Integer)param.getValue()).intValue());
                        continue;
                    }
                    if (param.getValue() instanceof Long) {
                        query.setLong(param.getKey(), ((Long)param.getValue()).longValue());
                        continue;
                    }
                    if (param.getValue() instanceof String) {
                        query.setString(param.getKey(), (String)param.getValue());
                        continue;
                    }
                    if (param.getValue() instanceof Boolean) {
                        query.setBoolean(param.getKey(), ((Boolean)param.getValue()).booleanValue());
                        continue;
                    }
                    if (param.getValue() instanceof Date) {
                        query.setDate(param.getKey(), (Date)param.getValue());
                        continue;
                    }
                    query.setString(param.getKey(), param.getValue().toString());
                }
            }
            return query;
        }

        public QueryInstance select(String select) {
            return new QueryInstance(select);
        }

        public class QueryInstance {
            protected String iSelect = null;
            protected String iFrom = null;
            protected String iWhere = null;
            protected String iOrderBy = null;
            protected String iGroupBy = null;
            protected String iType = "TeachingRequest";
            protected Integer iLimit = null;
            protected Set<String> iExclude = new HashSet<String>();
            protected Map<String, Object> iParams = new HashMap<String, Object>();

            private QueryInstance(String select) {
                this.iSelect = select;
            }

            public QueryInstance from(String from) {
                this.iFrom = from;
                return this;
            }

            public QueryInstance where(String where) {
                this.iWhere = this.iWhere == null ? "(" + where + ")" : this.iWhere + " and (" + where + ")";
                return this;
            }

            public QueryInstance type(String type) {
                this.iType = type;
                return this;
            }

            public QueryInstance order(String orderBy) {
                this.iOrderBy = orderBy;
                return this;
            }

            public QueryInstance group(String groupBy) {
                this.iGroupBy = groupBy;
                return this;
            }

            public QueryInstance exclude(String excludeOption) {
                this.iExclude.add(excludeOption);
                return this;
            }

            public QueryInstance set(String param, Object value) {
                this.iParams.put(param, value);
                return this;
            }

            public QueryInstance limit(Integer limit) {
                this.iLimit = limit == null || limit <= 0 ? null : limit;
                return this;
            }

            public String query() {
                return "select " + (this.iSelect == null ? "distinct r" : this.iSelect) + " from " + this.iType + " r inner join r.offering o inner join o.courseOfferings c " + (this.iFrom == null ? "" : (this.iFrom.trim().toLowerCase().startsWith("inner join") ? " " + this.iFrom : ", " + this.iFrom)) + RequestQuery.this.getFrom(this.iExclude) + " where c.isControl = true and o.session.uniqueId = :sessionId" + RequestQuery.this.getWhere(this.iExclude) + (this.iWhere == null ? "" : " and (" + this.iWhere + ")") + (this.iGroupBy == null ? "" : " group by " + this.iGroupBy) + (this.iOrderBy == null ? "" : " order by " + this.iOrderBy);
            }

            public org.hibernate.Query query(Session hibSession) {
                org.hibernate.Query query = RequestQuery.this.setParams(hibSession.createQuery(this.query()), this.iExclude).setLong("sessionId", RequestQuery.this.iSessionId.longValue()).setCacheable(true);
                for (Map.Entry<String, Object> param : this.iParams.entrySet()) {
                    if (param.getValue() instanceof Integer) {
                        query.setInteger(param.getKey(), ((Integer)param.getValue()).intValue());
                        continue;
                    }
                    if (param.getValue() instanceof Long) {
                        query.setLong(param.getKey(), ((Long)param.getValue()).longValue());
                        continue;
                    }
                    if (param.getValue() instanceof String) {
                        query.setString(param.getKey(), (String)param.getValue());
                        continue;
                    }
                    if (param.getValue() instanceof Boolean) {
                        query.setBoolean(param.getKey(), ((Boolean)param.getValue()).booleanValue());
                        continue;
                    }
                    if (param.getValue() instanceof Date) {
                        query.setDate(param.getKey(), (Date)param.getValue());
                        continue;
                    }
                    query.setString(param.getKey(), param.getValue().toString());
                }
                if (this.iLimit != null) {
                    query.setMaxResults(this.iLimit.intValue());
                }
                return query;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InstructorQuery {
        protected Long iSessionId;
        protected Map<String, String> iFrom = new HashMap<String, String>();
        protected Map<String, String> iWhere = new HashMap<String, String>();
        protected Map<String, Map<String, Object>> iParams = new HashMap<String, Map<String, Object>>();

        public InstructorQuery(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public InstructorQuery(InstructorQuery q) {
            this.iSessionId = q.iSessionId;
            this.iFrom.putAll(q.iFrom);
            this.iWhere.putAll(q.iWhere);
            this.iParams.putAll(q.iParams);
        }

        public void addFrom(String option, String from) {
            if (from == null) {
                this.iFrom.remove(option);
            } else {
                this.iFrom.put(option, from);
            }
        }

        public void addWhere(String option, String where) {
            if (where == null) {
                this.iWhere.remove(option);
            } else {
                this.iWhere.put(option, where);
            }
        }

        protected void addParameter(String option, String name, Object value) {
            Map<String, Object> params = this.iParams.get(option);
            if (params == null) {
                params = new HashMap<String, Object>();
                this.iParams.put(option, params);
            }
            if (value == null) {
                params.remove(name);
            } else {
                params.put(name, value);
            }
        }

        public String getFrom(Collection<String> excludeOption) {
            String from = "";
            for (Map.Entry<String, String> entry : this.iFrom.entrySet()) {
                if (excludeOption != null && excludeOption.contains(entry.getKey())) continue;
                from = from + (entry.getValue().startsWith("inner join") ? " " : ", ") + entry.getValue();
            }
            return from;
        }

        public String getWhere(Collection<String> excludeOption) {
            String where = "";
            for (Map.Entry<String, String> entry : this.iWhere.entrySet()) {
                if (excludeOption != null && excludeOption.contains(entry.getKey())) continue;
                where = where + " and (" + entry.getValue() + ")";
            }
            return where;
        }

        public org.hibernate.Query setParams(org.hibernate.Query query, Collection<String> excludeOption) {
            for (Map.Entry<String, Map<String, Object>> entry : this.iParams.entrySet()) {
                if (excludeOption != null && excludeOption.contains(entry.getKey())) continue;
                for (Map.Entry<String, Object> param : entry.getValue().entrySet()) {
                    if (param.getValue() instanceof Integer) {
                        query.setInteger(param.getKey(), ((Integer)param.getValue()).intValue());
                        continue;
                    }
                    if (param.getValue() instanceof Long) {
                        query.setLong(param.getKey(), ((Long)param.getValue()).longValue());
                        continue;
                    }
                    if (param.getValue() instanceof String) {
                        query.setString(param.getKey(), (String)param.getValue());
                        continue;
                    }
                    if (param.getValue() instanceof Boolean) {
                        query.setBoolean(param.getKey(), ((Boolean)param.getValue()).booleanValue());
                        continue;
                    }
                    if (param.getValue() instanceof Date) {
                        query.setDate(param.getKey(), (Date)param.getValue());
                        continue;
                    }
                    query.setString(param.getKey(), param.getValue().toString());
                }
            }
            return query;
        }

        public QueryInstance select(String select) {
            return new QueryInstance(select);
        }

        public class QueryInstance {
            protected String iSelect = null;
            protected String iFrom = null;
            protected String iWhere = null;
            protected String iOrderBy = null;
            protected String iGroupBy = null;
            protected String iType = "DepartmentalInstructor";
            protected Integer iLimit = null;
            protected Set<String> iExclude = new HashSet<String>();
            protected Map<String, Object> iParams = new HashMap<String, Object>();

            private QueryInstance(String select) {
                this.iSelect = select;
            }

            public QueryInstance from(String from) {
                this.iFrom = from;
                return this;
            }

            public QueryInstance where(String where) {
                this.iWhere = this.iWhere == null ? "(" + where + ")" : this.iWhere + " and (" + where + ")";
                return this;
            }

            public QueryInstance type(String type) {
                this.iType = type;
                return this;
            }

            public QueryInstance order(String orderBy) {
                this.iOrderBy = orderBy;
                return this;
            }

            public QueryInstance group(String groupBy) {
                this.iGroupBy = groupBy;
                return this;
            }

            public QueryInstance exclude(String excludeOption) {
                this.iExclude.add(excludeOption);
                return this;
            }

            public QueryInstance set(String param, Object value) {
                this.iParams.put(param, value);
                return this;
            }

            public QueryInstance limit(Integer limit) {
                this.iLimit = limit == null || limit <= 0 ? null : limit;
                return this;
            }

            public String query() {
                return "select " + (this.iSelect == null ? "distinct i" : this.iSelect) + " from " + this.iType + " i " + (this.iFrom == null ? "" : (this.iFrom.trim().toLowerCase().startsWith("inner join") ? " " + this.iFrom : ", " + this.iFrom)) + InstructorQuery.this.getFrom(this.iExclude) + " where i.department.session.uniqueId = :sessionId" + InstructorQuery.this.getWhere(this.iExclude) + (this.iWhere == null ? "" : " and (" + this.iWhere + ")") + (this.iGroupBy == null ? "" : " group by " + this.iGroupBy) + (this.iOrderBy == null ? "" : " order by " + this.iOrderBy);
            }

            public org.hibernate.Query query(Session hibSession) {
                org.hibernate.Query query = InstructorQuery.this.setParams(hibSession.createQuery(this.query()), this.iExclude).setLong("sessionId", InstructorQuery.this.iSessionId.longValue()).setCacheable(true);
                for (Map.Entry<String, Object> param : this.iParams.entrySet()) {
                    if (param.getValue() instanceof Integer) {
                        query.setInteger(param.getKey(), ((Integer)param.getValue()).intValue());
                        continue;
                    }
                    if (param.getValue() instanceof Long) {
                        query.setLong(param.getKey(), ((Long)param.getValue()).longValue());
                        continue;
                    }
                    if (param.getValue() instanceof String) {
                        query.setString(param.getKey(), (String)param.getValue());
                        continue;
                    }
                    if (param.getValue() instanceof Boolean) {
                        query.setBoolean(param.getKey(), ((Boolean)param.getValue()).booleanValue());
                        continue;
                    }
                    if (param.getValue() instanceof Date) {
                        query.setDate(param.getKey(), (Date)param.getValue());
                        continue;
                    }
                    query.setString(param.getKey(), param.getValue().toString());
                }
                if (this.iLimit != null) {
                    query.setMaxResults(this.iLimit.intValue());
                }
                return query;
            }
        }
    }
}

