/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.ifs.util.ToolBox;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.Advisor;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Roles;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.dao.AdvisorDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="gwtAdminTable[type=advisor]")
public class Advisors
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageStudentAdvisor(), MESSAGES.pageStudentAdvisors());
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentAdvisors')")
    public SimpleEditInterface load(SessionContext context, org.hibernate.Session hibSession) {
        ArrayList<SimpleEditInterface.ListItem> roles = new ArrayList<SimpleEditInterface.ListItem>();
        for (Roles r : Roles.findAll(true)) {
            if (!r.hasRight(Right.StudentSchedulingAdvisor)) continue;
            roles.add(new SimpleEditInterface.ListItem(r.getReference(), r.getAbbv()));
        }
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldExternalId(), SimpleEditInterface.FieldType.text, 120, 40, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldFirstName(), SimpleEditInterface.FieldType.text, 200, 100, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldMiddleName(), SimpleEditInterface.FieldType.text, 200, 100, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldLastName(), SimpleEditInterface.FieldType.text, 200, 100, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldAcademicTitle(), SimpleEditInterface.FieldType.text, 100, 50, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldEmailAddress(), SimpleEditInterface.FieldType.text, 200, 200, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldRole(), SimpleEditInterface.FieldType.list, 100, roles, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldStudents(), SimpleEditInterface.FieldType.students, 200, new SimpleEditInterface.Flag[0]));
        data.setSortBy(4, 2, 3);
        for (Advisor advisor : AdvisorDAO.getInstance().findBySession(hibSession, context.getUser().getCurrentAcademicSessionId())) {
            SimpleEditInterface.Record r = data.addRecord(advisor.getUniqueId());
            r.setField(0, advisor.getExternalUniqueId());
            r.setField(1, advisor.getFirstName());
            r.setField(2, advisor.getMiddleName());
            r.setField(3, advisor.getLastName());
            r.setField(4, advisor.getAcademicTitle());
            r.setField(5, advisor.getEmail());
            r.setField(6, advisor.getRole().getReference());
            String students = "";
            for (Student student : new TreeSet<Student>(advisor.getStudents())) {
                if (!students.isEmpty()) {
                    students = students + "\n";
                }
                students = students + student.getExternalUniqueId() + " " + student.getName(DepartmentalInstructor.sNameFormatLastFirstMiddle);
            }
            r.setField(7, students);
        }
        data.setEditable(context.hasPermission(Right.StudentAdvisorEdit));
        return data;
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentAdvisorEdit')")
    public void save(SimpleEditInterface data, SessionContext context, org.hibernate.Session hibSession) {
        HashSet<Long> studentIds = new HashSet<Long>();
        for (Advisor advisor : AdvisorDAO.getInstance().findBySession(hibSession, context.getUser().getCurrentAcademicSessionId())) {
            SimpleEditInterface.Record r = data.getRecord(advisor.getUniqueId());
            if (r == null) {
                this.delete(advisor, context, hibSession, studentIds);
                continue;
            }
            this.update(advisor, r, context, hibSession, studentIds);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession, studentIds);
        }
        if (!studentIds.isEmpty()) {
            StudentSectioningQueue.studentChanged(hibSession, context.getUser(), context.getUser().getCurrentAcademicSessionId(), studentIds);
        }
    }

    protected void save(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession, Set<Long> studentIds) {
        Advisor advisor = new Advisor();
        advisor.setExternalUniqueId(record.getField(0));
        advisor.setFirstName(record.getField(1));
        advisor.setMiddleName(record.getField(2));
        advisor.setLastName(record.getField(3));
        advisor.setAcademicTitle(record.getField(4));
        advisor.setEmail(record.getField(5));
        advisor.setRole(Roles.getRole(record.getField(6), hibSession));
        advisor.setSession((Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId(), hibSession));
        advisor.setStudents(new HashSet<Student>());
        if (record.getField(7) != null) {
            String students = "";
            for (String s : record.getField(7).split("\\n")) {
                Student student;
                if (s.indexOf(32) >= 0) {
                    s = s.substring(0, s.indexOf(32));
                }
                if (s.trim().isEmpty() || (student = Student.findByExternalId(context.getUser().getCurrentAcademicSessionId(), s.trim())) == null) continue;
                advisor.getStudents().add(student);
                student.getAdvisors().add(advisor);
                if (!students.isEmpty()) {
                    students = students + "\n";
                }
                students = students + student.getExternalUniqueId() + " " + student.getName(DepartmentalInstructor.sNameFormatLastFirstMiddle);
                studentIds.add(student.getUniqueId());
            }
            record.setField(7, students);
        }
        record.setUniqueId((Long)hibSession.save((Object)advisor));
        ChangeLog.addChange(hibSession, context, advisor, advisor.getName(DepartmentalInstructor.sNameFormatLastFirstMiddle), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentAdvisorEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        HashSet<Long> studentIds = new HashSet<Long>();
        this.save(record, context, hibSession, studentIds);
        if (!studentIds.isEmpty()) {
            StudentSectioningQueue.studentChanged(hibSession, context.getUser(), context.getUser().getCurrentAcademicSessionId(), studentIds);
        }
    }

    protected void update(Advisor advisor, SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession, Set<Long> studentIds) {
        if (advisor == null) {
            return;
        }
        boolean changed = !ToolBox.equals((Object)advisor.getExternalUniqueId(), (Object)record.getField(0)) || !ToolBox.equals((Object)advisor.getFirstName(), (Object)record.getField(1)) || !ToolBox.equals((Object)advisor.getMiddleName(), (Object)record.getField(2)) || !ToolBox.equals((Object)advisor.getLastName(), (Object)record.getField(3)) || !ToolBox.equals((Object)advisor.getAcademicTitle(), (Object)record.getField(4)) || !ToolBox.equals((Object)advisor.getEmail(), (Object)record.getField(5)) || !ToolBox.equals((Object)advisor.getRole().getReference(), (Object)record.getField(6));
        advisor.setExternalUniqueId(record.getField(0));
        advisor.setFirstName(record.getField(1));
        advisor.setMiddleName(record.getField(2));
        advisor.setLastName(record.getField(3));
        advisor.setAcademicTitle(record.getField(4));
        advisor.setEmail(record.getField(5));
        advisor.setRole(Roles.getRole(record.getField(6), hibSession));
        Hashtable<String, Student> students = new Hashtable<String, Student>();
        for (Student s : advisor.getStudents()) {
            students.put(s.getExternalUniqueId(), s);
        }
        for (String line : record.getField(7).split("\\n")) {
            Student student;
            String extId = (line.indexOf(32) >= 0 ? line.substring(0, line.indexOf(32)) : line).trim();
            if (extId.isEmpty() || students.remove(extId) != null || (student = Student.findByExternalId(context.getUser().getCurrentAcademicSessionId(), extId)) == null) continue;
            advisor.getStudents().add(student);
            student.getAdvisors().add(advisor);
            changed = true;
            studentIds.add(student.getUniqueId());
        }
        if (!students.isEmpty()) {
            for (Student student : students.values()) {
                student.getAdvisors().remove(advisor);
                studentIds.add(student.getUniqueId());
            }
            advisor.getStudents().removeAll(students.values());
            changed = true;
        }
        String newStudents = "";
        for (Student student : new TreeSet<Student>(advisor.getStudents())) {
            if (!newStudents.isEmpty()) {
                newStudents = newStudents + "\n";
            }
            newStudents = newStudents + student.getExternalUniqueId() + " " + student.getName(DepartmentalInstructor.sNameFormatLastFirstMiddle);
        }
        record.setField(7, newStudents);
        hibSession.saveOrUpdate((Object)advisor);
        if (changed) {
            ChangeLog.addChange(hibSession, context, advisor, advisor.getName(DepartmentalInstructor.sNameFormatLastFirstMiddle), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentAdvisorEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        HashSet<Long> studentIds = new HashSet<Long>();
        this.update((Advisor)AdvisorDAO.getInstance().get(record.getUniqueId()), record, context, hibSession, studentIds);
        if (!studentIds.isEmpty()) {
            StudentSectioningQueue.studentChanged(hibSession, context.getUser(), context.getUser().getCurrentAcademicSessionId(), studentIds);
        }
    }

    protected void delete(Advisor advisor, SessionContext context, org.hibernate.Session hibSession, Set<Long> studentIds) {
        if (advisor == null) {
            return;
        }
        if (advisor.getStudents() != null) {
            for (Student student : advisor.getStudents()) {
                studentIds.add(student.getUniqueId());
                student.getAdvisors().remove(advisor);
            }
        }
        ChangeLog.addChange(hibSession, context, advisor, advisor.getName(DepartmentalInstructor.sNameFormatLastFirstMiddle), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.delete((Object)advisor);
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentAdvisorEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        HashSet<Long> studentIds = new HashSet<Long>();
        this.delete((Advisor)AdvisorDAO.getInstance().get(record.getUniqueId()), context, hibSession, studentIds);
        if (!studentIds.isEmpty()) {
            StudentSectioningQueue.studentChanged(hibSession, context.getUser(), context.getUser().getCurrentAcademicSessionId(), studentIds);
        }
    }
}

