/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.studentsct;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.report.StudentSectioningReport;
import org.unitime.timetable.model.dao.StudentDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerturbationsReport
implements StudentSectioningReport {
    private static DecimalFormat sDF = new DecimalFormat("0.000");
    private StudentSectioningModel iModel;
    protected double iSameChoiceWeight = 0.9;
    protected double iSameTimeWeight = 0.7;
    protected double iSameConfigWeight = 0.5;

    public PerturbationsReport(StudentSectioningModel model) {
        this.iModel = model;
        this.iSameChoiceWeight = model.getProperties().getPropertyDouble("StudentWeights.SameChoice", this.iSameChoiceWeight);
        this.iSameTimeWeight = model.getProperties().getPropertyDouble("StudentWeights.SameTime", this.iSameTimeWeight);
        this.iSameConfigWeight = model.getProperties().getPropertyDouble("StudentWeights.SameConfig", this.iSameConfigWeight);
    }

    protected double getDifference(Section section, Enrollment other) {
        if (section == null) {
            return 0.0;
        }
        if (section.getSubpart().getConfig().equals((Object)other.getConfig())) {
            for (Section initial : other.getSections()) {
                if (!section.getSubpart().equals((Object)initial.getSubpart())) continue;
                if (section.equals((Object)initial)) {
                    return 1.0;
                }
                if (section.sameChoice(initial)) {
                    return this.iSameChoiceWeight;
                }
                if (!section.sameTime(initial)) continue;
                return this.iSameTimeWeight;
            }
        } else {
            for (Section initial : other.getSections()) {
                if (section.sameChoice(initial)) {
                    return this.iSameChoiceWeight;
                }
                if (!section.sameInstructionalType(initial) || !section.sameTime(initial)) continue;
                return this.iSameTimeWeight;
            }
        }
        return 0.0;
    }

    public CSVFile create(Assignment<Request, Enrollment> assignment, DataProperties properties) {
        boolean useAmPm = properties.getPropertyBoolean("useAmPm", true);
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"__Student"), new CSVFile.CSVField((Object)"Student\nId"), new CSVFile.CSVField((Object)"Student\nName"), new CSVFile.CSVField((Object)"Student\nEmail"), new CSVFile.CSVField((Object)"Course"), new CSVFile.CSVField((Object)"Original\nClass"), new CSVFile.CSVField((Object)"Original\nTime"), new CSVFile.CSVField((Object)"Original\nDate"), new CSVFile.CSVField((Object)"Original\nRoom"), new CSVFile.CSVField((Object)"Assigned\nClass"), new CSVFile.CSVField((Object)"Assigned\nTime"), new CSVFile.CSVField((Object)"Assigned\nDate"), new CSVFile.CSVField((Object)"Assigned\nRoom"), new CSVFile.CSVField((Object)"Penalization")});
        TreeSet<Student> students = new TreeSet<Student>(new Comparator<Student>(){

            @Override
            public int compare(Student s1, Student s2) {
                return s1.getExternalId().compareTo(s2.getExternalId());
            }
        });
        students.addAll(this.iModel.getStudents());
        boolean includeLastLikeStudents = properties.getPropertyBoolean("lastlike", false);
        boolean includeRealStudents = properties.getPropertyBoolean("real", true);
        for (Student student : students) {
            if (student.isDummy() || student.isDummy() && !includeLastLikeStudents || !student.isDummy() && !includeRealStudents) continue;
            for (Request r : student.getRequests()) {
                Section sct;
                Enrollment e = (Enrollment)assignment.getValue((Variable)r);
                Enrollment i = (Enrollment)r.getInitialAssignment();
                if (i == null || r instanceof FreeTimeRequest || i.equals((Object)e)) continue;
                org.unitime.timetable.model.Student s = (org.unitime.timetable.model.Student)StudentDAO.getInstance().get(student.getId());
                if (e == null) {
                    for (Section sct2 : i.getSections()) {
                        ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
                        line.add(new CSVFile.CSVField(student.getId()));
                        line.add(new CSVFile.CSVField((Object)student.getExternalId()));
                        line.add(new CSVFile.CSVField((Object)student.getName()));
                        line.add(new CSVFile.CSVField((Object)(s == null ? null : s.getEmail())));
                        line.add(new CSVFile.CSVField((Object)i.getCourse().getName()));
                        line.add(new CSVFile.CSVField((Object)(sct2.getSubpart().getName() + " " + sct2.getName(i.getCourse().getId()))));
                        line.add(new CSVFile.CSVField((Object)(sct2.getTime() == null ? "" : sct2.getTime().getDayHeader() + " " + sct2.getTime().getStartTimeHeader(useAmPm) + " - " + sct2.getTime().getEndTimeHeader(useAmPm))));
                        line.add(new CSVFile.CSVField((Object)(sct2.getTime() == null ? "" : sct2.getTime().getDatePatternName())));
                        line.add(new CSVFile.CSVField((Object)(sct2.getNrRooms() == 0 ? "" : sct2.getPlacement().getRoomName(", "))));
                        line.add(new CSVFile.CSVField((Object)"Not Assigned"));
                        line.add(new CSVFile.CSVField((Object)""));
                        line.add(new CSVFile.CSVField((Object)""));
                        line.add(new CSVFile.CSVField((Object)""));
                        line.add(new CSVFile.CSVField((Object)sDF.format(1.0 - this.getDifference(null, i))));
                        csv.addLine(line);
                    }
                    continue;
                }
                if (i.getConfig().equals((Object)e.getConfig())) {
                    for (Section org : i.getSections()) {
                        sct = null;
                        for (Section x : e.getSections()) {
                            if (!org.getSubpart().equals((Object)x.getSubpart())) continue;
                            sct = x;
                            break;
                        }
                        if (sct == null || org.equals((Object)sct)) continue;
                        ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
                        line.add(new CSVFile.CSVField(student.getId()));
                        line.add(new CSVFile.CSVField((Object)student.getExternalId()));
                        line.add(new CSVFile.CSVField((Object)student.getName()));
                        line.add(new CSVFile.CSVField((Object)(s == null ? null : s.getEmail())));
                        line.add(new CSVFile.CSVField((Object)i.getCourse().getName()));
                        line.add(new CSVFile.CSVField((Object)(org.getSubpart().getName() + " " + org.getName(i.getCourse().getId()))));
                        line.add(new CSVFile.CSVField((Object)(org.getTime() == null ? "" : org.getTime().getDayHeader() + " " + org.getTime().getStartTimeHeader(useAmPm) + " - " + org.getTime().getEndTimeHeader(useAmPm))));
                        line.add(new CSVFile.CSVField((Object)(org.getTime() == null ? "" : org.getTime().getDatePatternName())));
                        line.add(new CSVFile.CSVField((Object)(org.getNrRooms() == 0 ? "" : org.getPlacement().getRoomName(", "))));
                        line.add(new CSVFile.CSVField((Object)(sct.getSubpart().getName() + " " + sct.getName(i.getCourse().getId()))));
                        line.add(new CSVFile.CSVField((Object)(sct.getTime() == null ? "" : sct.getTime().getDayHeader() + " " + sct.getTime().getStartTimeHeader(useAmPm) + " - " + sct.getTime().getEndTimeHeader(useAmPm))));
                        line.add(new CSVFile.CSVField((Object)(sct.getTime() == null ? "" : sct.getTime().getDatePatternName())));
                        line.add(new CSVFile.CSVField((Object)(sct.getNrRooms() == 0 ? "" : sct.getPlacement().getRoomName(", "))));
                        line.add(new CSVFile.CSVField((Object)sDF.format(1.0 - this.getDifference(sct, i))));
                        csv.addLine(line);
                    }
                    continue;
                }
                Iterator orgIt = i.getSections().iterator();
                Iterator sctIt = e.getSections().iterator();
                while (orgIt.hasNext() || sctIt.hasNext()) {
                    sct = sctIt.hasNext() ? (Section)sctIt.next() : null;
                    Section org = orgIt.hasNext() ? (Section)orgIt.next() : null;
                    ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
                    line.add(new CSVFile.CSVField(student.getId()));
                    line.add(new CSVFile.CSVField((Object)student.getExternalId()));
                    line.add(new CSVFile.CSVField((Object)student.getName()));
                    line.add(new CSVFile.CSVField((Object)(s == null ? null : s.getEmail())));
                    line.add(new CSVFile.CSVField((Object)i.getCourse().getName()));
                    if (org != null) {
                        line.add(new CSVFile.CSVField((Object)(org.getSubpart().getName() + " " + org.getName(i.getCourse().getId()))));
                        line.add(new CSVFile.CSVField((Object)(org.getTime() == null ? "" : org.getTime().getDayHeader() + " " + org.getTime().getStartTimeHeader(useAmPm) + " - " + org.getTime().getEndTimeHeader(useAmPm))));
                        line.add(new CSVFile.CSVField((Object)(org.getTime() == null ? "" : org.getTime().getDatePatternName())));
                        line.add(new CSVFile.CSVField((Object)(org.getNrRooms() == 0 ? "" : org.getPlacement().getRoomName(", "))));
                    } else {
                        line.add(new CSVFile.CSVField((Object)""));
                        line.add(new CSVFile.CSVField((Object)""));
                        line.add(new CSVFile.CSVField((Object)""));
                        line.add(new CSVFile.CSVField((Object)""));
                    }
                    if (sct != null) {
                        line.add(new CSVFile.CSVField((Object)(sct.getSubpart().getName() + " " + sct.getName(i.getCourse().getId()))));
                        line.add(new CSVFile.CSVField((Object)(sct.getTime() == null ? "" : sct.getTime().getDayHeader() + " " + sct.getTime().getStartTimeHeader(useAmPm) + " - " + sct.getTime().getEndTimeHeader(useAmPm))));
                        line.add(new CSVFile.CSVField((Object)(sct.getTime() == null ? "" : sct.getTime().getDatePatternName())));
                        line.add(new CSVFile.CSVField((Object)(sct.getNrRooms() == 0 ? "" : sct.getPlacement().getRoomName(", "))));
                        line.add(new CSVFile.CSVField((Object)sDF.format(1.0 - this.getDifference(sct, i))));
                    } else {
                        line.add(new CSVFile.CSVField((Object)""));
                        line.add(new CSVFile.CSVField((Object)""));
                        line.add(new CSVFile.CSVField((Object)""));
                        line.add(new CSVFile.CSVField((Object)""));
                        line.add(new CSVFile.CSVField((Object)""));
                    }
                    csv.addLine(line);
                }
            }
        }
        return csv;
    }
}

