/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.pointintimedata;

import java.util.ArrayList;
import java.util.HashSet;
import org.hibernate.Session;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.PitClass;
import org.unitime.timetable.model.PointInTimeData;
import org.unitime.timetable.reports.pointintimedata.BasePointInTimeDataReports;

public abstract class WSCHByDepartment
extends BasePointInTimeDataReports {
    protected void intializeHeader() {
        ArrayList<String> hdr = new ArrayList<String>();
        hdr.add(MSG.columnDepartmentCode());
        hdr.add(MSG.columnDepartmentAbbreviation());
        hdr.add(MSG.columnDepartmentName());
        hdr.add(MSG.columnWeeklyClassHours());
        hdr.add(MSG.columnWeeklyStudentClassHours());
        this.setHeader(hdr);
    }

    protected abstract float weeklyClassHours(PitClass var1);

    protected abstract float weeklyStudentClassHours(PitClass var1);

    public void createWeeklyStudentContactHoursByDepartmentReportFor(PointInTimeData pointInTimeData, Session hibSession) {
        HashSet<Long> processedClasses = new HashSet<Long>();
        for (Department d : pointInTimeData.getSession().getDepartments()) {
            if (d.getSubjectAreas().isEmpty()) continue;
            float deptTotalWsch = 0.0f;
            float deptTotalWch = 0.0f;
            for (Long pioUid : this.findAllPitInstructionalOfferingUniqueIdsForDepartment(pointInTimeData, d.getUniqueId(), hibSession)) {
                for (PitClass pc : this.findAllPitClassesForPitInstructionalOfferingId(pointInTimeData, pioUid, hibSession)) {
                    if (processedClasses.contains(pc.getUniqueId())) continue;
                    processedClasses.add(pc.getUniqueId());
                    deptTotalWch += this.weeklyClassHours(pc);
                    deptTotalWsch += this.weeklyStudentClassHours(pc);
                }
            }
            ArrayList<String> row = new ArrayList<String>();
            row.add(d.getDeptCode());
            row.add(d.getAbbreviation());
            row.add(d.getName());
            row.add(Float.toString(deptTotalWch));
            row.add(Float.toString(deptTotalWsch));
            this.addDataRow(row);
        }
    }

    protected void runReport(Session hibSession) {
        PointInTimeData pitd = (PointInTimeData)hibSession.createQuery("from PointInTimeData pitd where pitd.uniqueId = :uid").setLong("uid", this.getPointInTimeDataUniqueId().longValue()).uniqueResult();
        this.createWeeklyStudentContactHoursByDepartmentReportFor(pitd, hibSession);
    }
}

