/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.status.db;

import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.util.DistanceMetric;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.CourseRequestOption;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentAreaClassificationMajor;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentNote;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.base.BaseCourseRequest;
import org.unitime.timetable.model.base.BaseStudentNote;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.status.FindStudentInfoAction;
import org.unitime.timetable.onlinesectioning.status.SectioningStatusFilterAction;
import org.unitime.timetable.onlinesectioning.status.db.DbFindEnrollmentInfoAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbFindStudentInfoAction
extends FindStudentInfoAction {
    private static final long serialVersionUID = 1L;

    public boolean isMyStudent(Student student) {
        return this.iMyStudents != null && this.iMyStudents.contains(student.getUniqueId());
    }

    public boolean isCanSelect(Student student) {
        if (this.iIsAdmin) {
            return true;
        }
        return this.iIsAdvisor && (this.iCanEditOtherStudents || this.iCanEditMyStudents && this.isMyStudent(student));
    }

    @Override
    public List<ClassAssignmentInterface.StudentInfo> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (this.iFilter == null) {
            return super.execute(server, helper);
        }
        HashMap<Long, ClassAssignmentInterface.StudentInfo> students = new HashMap<Long, ClassAssignmentInterface.StudentInfo>();
        int gEnrl = 0;
        int gWait = 0;
        int gRes = 0;
        int gUnasg = 0;
        int gtEnrl = 0;
        int gtWait = 0;
        int gtRes = 0;
        int gtUnasg = 0;
        int gConNeed = 0;
        int gtConNeed = 0;
        int gOvrNeed = 0;
        int gtOvrNeed = 0;
        int gDist = 0;
        int gtDist = 0;
        int gNrDC = 0;
        int gtNrDC = 0;
        int gShr = 0;
        int gtShr = 0;
        int gFre = 0;
        int gtFre = 0;
        int gPIM = 0;
        int gtPIM = 0;
        int gPSec = 0;
        int gtPSec = 0;
        HashSet<Long> unassigned = new HashSet<Long>();
        HashSet<Long> assignedRequests = new HashSet<Long>();
        AcademicSessionInfo session = server.getAcademicSession();
        DistanceMetric dm = server.getDistanceMetric();
        DbFindEnrollmentInfoAction.DbFindStudentInfoMatcher sm = new DbFindEnrollmentInfoAction.DbFindStudentInfoMatcher(session, this.iQuery, helper.getStudentNameFormat(), this.iMyStudents);
        sm.setServer(server);
        HashMap<CourseOffering, ArrayList<CourseRequest>> requests = new HashMap<CourseOffering, ArrayList<CourseRequest>>();
        for (CourseRequest courseRequest : SectioningStatusFilterAction.getCourseQuery(this.iFilter, server).select("distinct cr").query(helper.getHibSession()).list()) {
            if (!this.hasMatchingSubjectArea(courseRequest.getCourseOffering().getSubjectAreaAbbv()) || !this.isCourseVisible(courseRequest.getCourseOffering().getUniqueId()) || !this.query().match(new DbFindEnrollmentInfoAction.DbCourseRequestMatcher(session, courseRequest, this.isConsentToDoCourse(courseRequest.getCourseOffering()), this.isMyStudent(courseRequest.getCourseDemand().getStudent()), helper.getStudentNameFormat()))) continue;
            ArrayList<CourseRequest> list = (ArrayList<CourseRequest>)requests.get(courseRequest.getCourseOffering());
            if (list == null) {
                list = new ArrayList<CourseRequest>();
                requests.put(courseRequest.getCourseOffering(), list);
            }
            list.add(courseRequest);
        }
        for (Map.Entry entry : requests.entrySet()) {
            CourseOffering course = (CourseOffering)entry.getKey();
            boolean bl = this.isConsentToDoCourse(course);
            for (CourseRequest request : (List)entry.getValue()) {
                DbFindEnrollmentInfoAction.DbCourseRequestMatcher crm;
                Iterator<StudentClassEnrollment> status;
                Student student = request.getCourseDemand().getStudent();
                ClassAssignmentInterface.StudentInfo s = (ClassAssignmentInterface.StudentInfo)students.get(student.getUniqueId());
                if (s == null) {
                    s = new ClassAssignmentInterface.StudentInfo();
                    students.put(student.getUniqueId(), s);
                    ClassAssignmentInterface.Student st = new ClassAssignmentInterface.Student();
                    s.setStudent(st);
                    st.setId(student.getUniqueId());
                    st.setSessionId(session.getUniqueId());
                    st.setExternalId(student.getExternalUniqueId());
                    st.setCanShowExternalId(this.iCanShowExtIds);
                    status = student.getEffectiveStatus();
                    st.setCanRegister(this.iCanRegister && (status == null || ((StudentSectioningStatus)((Object)status)).hasOption(StudentSectioningStatus.Option.regenabled)));
                    st.setCanUseAssistant(this.iCanUseAssistant && (status == null || ((StudentSectioningStatus)((Object)status)).hasOption(StudentSectioningStatus.Option.enabled)));
                    st.setCanSelect(this.isCanSelect(student));
                    st.setName(helper.getStudentNameFormat().format(student));
                    for (StudentAreaClassificationMajor acm : new TreeSet<StudentAreaClassificationMajor>(student.getAreaClasfMajors())) {
                        st.addArea(acm.getAcademicArea().getAcademicAreaAbbreviation());
                        st.addClassification(acm.getAcademicClassification().getCode());
                        st.addMajor(acm.getMajor().getCode());
                    }
                    for (StudentAccomodation acc : student.getAccomodations()) {
                        st.addAccommodation(acc.getAbbreviation());
                    }
                    for (StudentGroup gr : student.getGroups()) {
                        st.addGroup(gr.getGroupAbbreviation());
                    }
                    int tEnrl = 0;
                    int tWait = 0;
                    int tRes = 0;
                    int tConNeed = 0;
                    int tReq = 0;
                    int tUnasg = 0;
                    int tOvrNeed = 0;
                    int ovrNeed = 0;
                    float tCred = 0.0f;
                    int nrDisCnf = 0;
                    int maxDist = 0;
                    int share = 0;
                    int ftShare = 0;
                    ArrayList<Float> minsTot = new ArrayList<Float>();
                    ArrayList<Float> maxsTot = new ArrayList<Float>();
                    ArrayList<Float> mins = new ArrayList<Float>();
                    ArrayList<Float> maxs = new ArrayList<Float>();
                    int nrCoursesTot = 0;
                    int nrCourses = 0;
                    for (CourseDemand demand : student.getCourseDemands()) {
                        InstructionalMethod im;
                        if (demand.getCourseRequests().isEmpty()) continue;
                        Float minTot = null;
                        Float maxTot = null;
                        Float min = null;
                        Float max = null;
                        for (CourseRequest r : demand.getCourseRequests()) {
                            CourseCreditUnitConfig c = r.getCourseOffering().getCredit();
                            if (c != null) {
                                if (minTot == null || minTot.floatValue() > c.getMinCredit()) {
                                    minTot = Float.valueOf(c.getMinCredit());
                                }
                                if (maxTot == null || maxTot.floatValue() < c.getMaxCredit()) {
                                    maxTot = Float.valueOf(c.getMaxCredit());
                                }
                            }
                            if (r.isRequestPending()) {
                                ++tOvrNeed;
                                ++gtOvrNeed;
                            }
                            if (!this.query().match(new DbFindEnrollmentInfoAction.DbCourseRequestMatcher(session, r, this.isConsentToDoCourse(r.getCourseOffering()), this.isMyStudent(student), helper.getStudentNameFormat()))) continue;
                            if (c != null) {
                                if (min == null || min.floatValue() > c.getMinCredit()) {
                                    min = Float.valueOf(c.getMinCredit());
                                }
                                if (max == null || max.floatValue() < c.getMaxCredit()) {
                                    max = Float.valueOf(c.getMaxCredit());
                                }
                            }
                            if (!r.isRequestPending()) continue;
                            ++ovrNeed;
                            ++gOvrNeed;
                        }
                        if (minTot != null) {
                            minsTot.add(minTot);
                            maxsTot.add(maxTot);
                            if (!demand.isAlternative().booleanValue()) {
                                ++nrCoursesTot;
                            }
                        }
                        if (min != null) {
                            mins.add(min);
                            maxs.add(max);
                            if (!demand.isAlternative().booleanValue()) {
                                ++nrCourses;
                            }
                        }
                        if (!demand.isAlternative().booleanValue()) {
                            ++tReq;
                        }
                        List<StudentClassEnrollment> enrollment = null;
                        CourseRequest assigned = null;
                        for (CourseRequest courseRequest : demand.getCourseRequests()) {
                            enrollment = courseRequest.getClassEnrollments();
                            if (enrollment.isEmpty()) continue;
                            assigned = courseRequest;
                            break;
                        }
                        if (enrollment.isEmpty()) {
                            BaseCourseRequest first = null;
                            for (CourseRequest r2 : demand.getCourseRequests()) {
                                if (first != null && r2.getOrder() >= first.getOrder()) continue;
                                first = r2;
                            }
                            DbFindEnrollmentInfoAction.DbCourseRequestMatcher dbCourseRequestMatcher = new DbFindEnrollmentInfoAction.DbCourseRequestMatcher(session, (CourseRequest)first, this.isConsentToDoCourse(first.getCourseOffering()), this.isMyStudent(student), helper.getStudentNameFormat());
                            if (!dbCourseRequestMatcher.canAssign()) continue;
                            ++tUnasg;
                            ++gtUnasg;
                            if (!demand.isWaitlist().booleanValue()) continue;
                            ++tWait;
                            ++gtWait;
                            continue;
                        }
                        ++tEnrl;
                        ++gtEnrl;
                        DbFindEnrollmentInfoAction.DbCourseRequestMatcher crm3 = new DbFindEnrollmentInfoAction.DbCourseRequestMatcher(session, assigned, this.isConsentToDoCourse(assigned.getCourseOffering()), this.isMyStudent(student), helper.getStudentNameFormat());
                        if (crm3.reservation() != null) {
                            ++tRes;
                            ++gtRes;
                        }
                        if (assigned.getCourseOffering().getConsentType() != null && crm3.approval() == null) {
                            ++tConNeed;
                            ++gtConNeed;
                        }
                        if (assigned.getCourseOffering().getCredit() != null) {
                            StudentClassEnrollment e;
                            tCred += assigned.getCourseOffering().getCredit().getMinCredit();
                            Iterator<StudentClassEnrollment> iterator = enrollment.iterator();
                            if (iterator.hasNext() && (im = (e = iterator.next()).getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod()) != null) {
                                s.addIMTotalCredit(im.getReference(), assigned.getCourseOffering().getCredit().getMinCredit());
                            }
                        } else {
                            for (StudentClassEnrollment e : enrollment) {
                                if (e.getClazz().getSchedulingSubpart().getCredit() == null) continue;
                                tCred += e.getClazz().getSchedulingSubpart().getCredit().getMinCredit();
                                im = e.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod();
                                if (im == null) continue;
                                s.addIMTotalCredit(im.getReference(), e.getClazz().getSchedulingSubpart().getCredit().getMinCredit());
                            }
                        }
                        for (StudentClassEnrollment section : enrollment) {
                            int sh;
                            Assignment assignment = section.getClazz().getCommittedAssignment();
                            if (assignment == null) continue;
                            for (StudentClassEnrollment otherSection : student.getClassEnrollments()) {
                                Assignment otherAssignment;
                                if (section.equals(otherSection) || (otherAssignment = otherSection.getClazz().getCommittedAssignment()) == null) continue;
                                if (this.isDistanceConflict(student, assignment, otherAssignment, dm)) {
                                    ++nrDisCnf;
                                    ++gtNrDC;
                                    int d = this.getDistanceInMinutes(assignment, otherAssignment, dm);
                                    if (d > maxDist) {
                                        maxDist = d;
                                    }
                                    if (d > gtDist) {
                                        gtDist = d;
                                    }
                                }
                                if (!assignment.getTimeLocation().hasIntersection(otherAssignment.getTimeLocation()) || section.getClazz().isToIgnoreStudentConflictsWith(otherSection.getClazz()) || section.getClazz().getUniqueId() >= otherSection.getClazz().getUniqueId()) continue;
                                sh = assignment.getTimeLocation().nrSharedDays(otherAssignment.getTimeLocation()) * assignment.getTimeLocation().nrSharedHours(otherAssignment.getTimeLocation()) * Constants.SLOT_LENGTH_MIN;
                                share += sh;
                                gtShr += sh;
                            }
                            for (CourseDemand cd : student.getCourseDemands()) {
                                TimeLocation ft;
                                if (cd.getFreeTime() == null || !(ft = new TimeLocation(cd.getFreeTime().getDayCode().intValue(), cd.getFreeTime().getStartSlot().intValue(), cd.getFreeTime().getLength().intValue(), 0, 0.0, 0, null, null, session.getFreeTimePattern(), 0)).hasIntersection(assignment.getTimeLocation())) continue;
                                sh = assignment.getTimeLocation().nrSharedDays(ft) * assignment.getTimeLocation().nrSharedHours(ft) * Constants.SLOT_LENGTH_MIN;
                                ftShare += sh;
                                gtFre += sh;
                            }
                        }
                    }
                    Collections.sort(mins);
                    Collections.sort(maxs);
                    float min = 0.0f;
                    float max = 0.0f;
                    for (int i = 0; i < nrCourses; ++i) {
                        min += ((Float)mins.get(i)).floatValue();
                        max += ((Float)maxs.get(maxs.size() - i - 1)).floatValue();
                    }
                    Collections.sort(minsTot);
                    Collections.sort(maxsTot);
                    float minTot = 0.0f;
                    float maxTot = 0.0f;
                    for (int i = 0; i < nrCoursesTot; ++i) {
                        minTot += ((Float)minsTot.get(i)).floatValue();
                        maxTot += ((Float)maxsTot.get(maxsTot.size() - i - 1)).floatValue();
                    }
                    if (student.isRequestPending()) {
                        if (nrCourses == nrCoursesTot) {
                            ++gOvrNeed;
                            ++ovrNeed;
                        }
                        ++gtOvrNeed;
                        ++tOvrNeed;
                    }
                    s.setRequestCredit(min, max);
                    s.setTotalRequestCredit(minTot, maxTot);
                    s.setTotalEnrollment(tEnrl);
                    s.setTotalReservation(tRes);
                    s.setTotalWaitlist(tWait);
                    s.setTotalUnassigned(tUnasg);
                    s.setTotalConsentNeeded(tConNeed);
                    s.setTotalOverrideNeeded(tOvrNeed);
                    s.setEnrollment(0);
                    s.setReservation(0);
                    s.setWaitlist(0);
                    s.setUnassigned(0);
                    s.setConsentNeeded(0);
                    s.setOverrideNeeded(ovrNeed);
                    s.setRequested(tReq);
                    s.setStatus(student.getSectioningStatus() == null ? session.getDefaultSectioningStatus() : student.getSectioningStatus().getReference());
                    s.setEmailDate(student.getScheduleEmailedDate() == null ? null : student.getScheduleEmailedDate());
                    s.setCredit(Float.valueOf(0.0f));
                    s.setTotalCredit(Float.valueOf(tCred));
                    s.setNrDistanceConflicts(0);
                    s.setLongestDistanceMinutes(0);
                    s.setOverlappingMinutes(0);
                    s.setTotalNrDistanceConflicts(nrDisCnf);
                    s.setTotalLongestDistanceMinutes(maxDist);
                    s.setTotalOverlappingMinutes(share);
                    s.setFreeTimeOverlappingMins(0);
                    s.setTotalFreeTimeOverlappingMins(ftShare);
                    s.setPrefInstrMethConflict(0);
                    s.setTotalPrefInstrMethConflict(0);
                    s.setPrefSectionConflict(0);
                    s.setTotalPrefSectionConflict(0);
                    BaseStudentNote note = null;
                    for (StudentNote n : student.getNotes()) {
                        if (note != null && ((StudentNote)note).compareTo(n) <= 0) continue;
                        note = n;
                    }
                    if (note != null) {
                        s.setNote(note.getTextNote());
                    }
                }
                if (!(crm = new DbFindEnrollmentInfoAction.DbCourseRequestMatcher(session, request, bl, this.isMyStudent(student), helper.getStudentNameFormat())).enrollment().isEmpty()) {
                    if (assignedRequests.add(crm.request().getCourseDemand().getUniqueId())) {
                        s.setEnrollment(s.getEnrollment() + 1);
                        ++gEnrl;
                        if (crm.reservation() != null) {
                            s.setReservation(s.getReservation() + 1);
                            ++gRes;
                        }
                        if (course.getConsentType() != null && crm.approval() == null) {
                            s.setConsentNeeded(s.getConsentNeeded() + 1);
                            ++gConNeed;
                        }
                        for (StudentClassEnrollment e : crm.enrollment()) {
                            if (e.getTimestamp() == null) continue;
                            if (s.getEnrolledDate() == null) {
                                s.setEnrolledDate(e.getTimestamp());
                                continue;
                            }
                            if (!e.getTimestamp().after(s.getEnrolledDate())) continue;
                            s.setEnrolledDate(e.getTimestamp());
                        }
                        if (crm.approval() != null) {
                            for (StudentClassEnrollment e : crm.enrollment()) {
                                if (e.getApprovedDate() == null) continue;
                                if (s.getApprovedDate() == null) {
                                    s.setApprovedDate(e.getApprovedDate());
                                    continue;
                                }
                                if (!e.getApprovedDate().after(s.getApprovedDate())) continue;
                                s.setApprovedDate(e.getApprovedDate());
                            }
                        }
                        if (course.getCredit() != null) {
                            StudentClassEnrollment e;
                            InstructionalMethod im;
                            s.setCredit(Float.valueOf(s.getCredit().floatValue() + course.getCredit().getMinCredit()));
                            status = crm.enrollment().iterator();
                            if (status.hasNext() && (im = (e = status.next()).getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod()) != null) {
                                s.addIMCredit(im.getReference(), course.getCredit().getMinCredit());
                            }
                        } else {
                            for (StudentClassEnrollment e : crm.enrollment()) {
                                if (e.getClazz().getSchedulingSubpart().getCredit() == null) continue;
                                s.setCredit(Float.valueOf(s.getCredit().floatValue() + e.getClazz().getSchedulingSubpart().getCredit().getMinCredit()));
                                InstructionalMethod im = e.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod();
                                if (im == null) continue;
                                s.addIMCredit(im.getReference(), e.getClazz().getSchedulingSubpart().getCredit().getMinCredit());
                            }
                        }
                        CourseRequestOption option = request.getCourseRequestOption(OnlineSectioningLog.CourseRequestOption.OptionType.REQUEST_PREFERENCE);
                        if (option != null && option.getValue() != null) {
                            try {
                                OnlineSectioningLog.CourseRequestOption pref = OnlineSectioningLog.CourseRequestOption.parseFrom(option.getValue());
                                if (pref.getInstructionalMethodCount() > 0) {
                                    boolean im = false;
                                    InstructionalMethod method = crm.enrollment().get(0).getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod();
                                    if (method != null) {
                                        for (OnlineSectioningLog.Entity e : pref.getInstructionalMethodList()) {
                                            if (!method.getReference().equals(e.getExternalId()) && !method.getUniqueId().equals(e.getUniqueId())) continue;
                                            im = true;
                                            break;
                                        }
                                    }
                                    s.setTotalPrefInstrMethConflict(s.getTotalPrefInstrMethConflict() + 1);
                                    ++gtPIM;
                                    if (im) {
                                        s.setPrefInstrMethConflict(s.getPrefInstrMethConflict() + 1);
                                        ++gPIM;
                                    }
                                }
                                if (pref.getSectionCount() > 0) {
                                    HashSet<String> allSubpartIds = new HashSet<String>();
                                    HashSet<String> selectedSubpartIds = new HashSet<String>();
                                    for (OnlineSectioningLog.Section sc : pref.getSectionList()) {
                                        allSubpartIds.add(sc.getSubpart().getName());
                                        for (StudentClassEnrollment section : crm.enrollment()) {
                                            String externalId = section.getClazz().getExternalId(section.getCourseOffering());
                                            if (!section.getClazz().getUniqueId().equals(sc.getClazz().getUniqueId()) && (externalId == null || !externalId.equals(sc.getClazz().getExternalId()))) continue;
                                            selectedSubpartIds.add(sc.getSubpart().getName());
                                        }
                                    }
                                    s.setTotalPrefSectionConflict(s.getTotalPrefSectionConflict() + allSubpartIds.size());
                                    gtPSec += allSubpartIds.size();
                                    if (!allSubpartIds.isEmpty()) {
                                        s.setPrefSectionConflict(s.getPrefSectionConflict() + selectedSubpartIds.size());
                                        gPSec += selectedSubpartIds.size();
                                    }
                                }
                            }
                            catch (InvalidProtocolBufferException pref) {
                                // empty catch block
                            }
                        }
                    }
                    for (StudentClassEnrollment section : crm.enrollment()) {
                        int sh;
                        Assignment assignment = section.getClazz().getCommittedAssignment();
                        if (assignment == null) continue;
                        for (StudentClassEnrollment otherSection : student.getClassEnrollments()) {
                            Assignment otherAssignment;
                            if (section.equals(otherSection) || (otherAssignment = otherSection.getClazz().getCommittedAssignment()) == null) continue;
                            if (this.isDistanceConflict(student, assignment, otherAssignment, dm)) {
                                s.setNrDistanceConflicts(s.getNrDistanceConflicts() + 1);
                                ++gNrDC;
                                int d = this.getDistanceInMinutes(assignment, otherAssignment, dm);
                                if (d > s.getLongestDistanceMinutes()) {
                                    s.setLongestDistanceMinutes(d);
                                }
                                if (d > gDist) {
                                    gDist = d;
                                }
                            }
                            if (!assignment.getTimeLocation().hasIntersection(otherAssignment.getTimeLocation()) || section.getClazz().isToIgnoreStudentConflictsWith(otherSection.getClazz()) || section.getClazz().getUniqueId() >= otherSection.getClazz().getUniqueId() && this.query().match(new DbFindEnrollmentInfoAction.DbCourseRequestMatcher(session, otherSection.getCourseRequest(), this.isConsentToDoCourse(otherSection.getCourseOffering()), this.isMyStudent(student), helper.getStudentNameFormat()))) continue;
                            sh = assignment.getTimeLocation().nrSharedDays(otherAssignment.getTimeLocation()) * assignment.getTimeLocation().nrSharedHours(otherAssignment.getTimeLocation()) * Constants.SLOT_LENGTH_MIN;
                            s.setOverlappingMinutes(s.getOverlappingMinutes() + sh);
                            gShr += sh;
                        }
                        for (CourseDemand cd : student.getCourseDemands()) {
                            TimeLocation ft;
                            if (cd.getFreeTime() == null || !(ft = new TimeLocation(cd.getFreeTime().getDayCode().intValue(), cd.getFreeTime().getStartSlot().intValue(), cd.getFreeTime().getLength().intValue(), 0, 0.0, 0, null, null, session.getFreeTimePattern(), 0)).hasIntersection(assignment.getTimeLocation())) continue;
                            sh = assignment.getTimeLocation().nrSharedDays(ft) * assignment.getTimeLocation().nrSharedHours(ft) * Constants.SLOT_LENGTH_MIN;
                            s.setFreeTimeOverlappingMins(s.getFreeTimeOverlappingMins() + sh);
                            gFre += sh;
                        }
                    }
                } else if (crm.canAssign() && unassigned.add(crm.request().getCourseDemand().getUniqueId())) {
                    if (crm.request().getCourseDemand().isWaitlist().booleanValue()) {
                        s.setWaitlist(s.getWaitlist() + 1);
                        ++gWait;
                        if (s.getTopWaitingPriority() == null) {
                            s.setTopWaitingPriority(1 + crm.request().getCourseDemand().getPriority());
                        } else {
                            s.setTopWaitingPriority(Math.min(1 + crm.request().getCourseDemand().getPriority(), s.getTopWaitingPriority()));
                        }
                    }
                    s.setUnassigned(s.getUnassigned() + 1);
                    ++gUnasg;
                }
                if (crm.request().getCourseDemand().getTimestamp() == null) continue;
                if (s.getRequestedDate() == null) {
                    s.setRequestedDate(crm.request().getCourseDemand().getTimestamp());
                    continue;
                }
                if (!crm.request().getCourseDemand().getTimestamp().after(s.getRequestedDate())) continue;
                s.setRequestedDate(crm.request().getCourseDemand().getTimestamp());
            }
        }
        ArrayList<Object> ret = new ArrayList(students.values());
        if (this.iSubjectAreas == null && this.iCoursesIcoordinate == null) {
            for (Student student : SectioningStatusFilterAction.getQuery(this.iFilter, server).select("distinct s").query(helper.getHibSession()).list()) {
                if (students.containsKey(student.getUniqueId()) || !sm.match(student)) continue;
                ClassAssignmentInterface.StudentInfo studentInfo = new ClassAssignmentInterface.StudentInfo();
                ClassAssignmentInterface.Student st = new ClassAssignmentInterface.Student();
                studentInfo.setStudent(st);
                st.setId(student.getUniqueId());
                st.setSessionId(session.getUniqueId());
                st.setExternalId(student.getExternalUniqueId());
                st.setCanShowExternalId(this.iCanShowExtIds);
                StudentSectioningStatus status = student.getEffectiveStatus();
                st.setCanRegister(this.iCanRegister && (status == null || status.hasOption(StudentSectioningStatus.Option.regenabled)));
                st.setCanUseAssistant(this.iCanUseAssistant && (status == null || status.hasOption(StudentSectioningStatus.Option.enabled)));
                st.setCanSelect(this.isCanSelect(student));
                st.setName(helper.getStudentNameFormat().format(student));
                for (StudentAreaClassificationMajor acm : new TreeSet<StudentAreaClassificationMajor>(student.getAreaClasfMajors())) {
                    st.addArea(acm.getAcademicArea().getAcademicAreaAbbreviation());
                    st.addClassification(acm.getAcademicClassification().getCode());
                    st.addMajor(acm.getMajor().getCode());
                }
                for (StudentAccomodation acc : student.getAccomodations()) {
                    st.addAccommodation(acc.getAbbreviation());
                }
                for (StudentGroup gr : student.getGroups()) {
                    st.addGroup(gr.getGroupAbbreviation());
                }
                studentInfo.setStatus(student.getSectioningStatus() == null ? session.getDefaultSectioningStatus() : student.getSectioningStatus().getReference());
                studentInfo.setEmailDate(student.getScheduleEmailedDate() == null ? null : student.getScheduleEmailedDate());
                BaseStudentNote note = null;
                for (StudentNote n : student.getNotes()) {
                    if (note != null && ((StudentNote)note).compareTo(n) <= 0) continue;
                    note = n;
                }
                if (note != null) {
                    studentInfo.setNote(note.getTextNote());
                }
                ret.add(studentInfo);
            }
        }
        Collections.sort(ret, new Comparator<ClassAssignmentInterface.StudentInfo>(){

            @Override
            public int compare(ClassAssignmentInterface.StudentInfo s1, ClassAssignmentInterface.StudentInfo s2) {
                int cmp = s1.getStudent().getName().compareTo(s2.getStudent().getName());
                if (cmp != 0) {
                    return cmp;
                }
                return new Long(s1.getStudent().getId()).compareTo(s2.getStudent().getId());
            }
        });
        if (this.limit() != null && ret.size() >= this.limit()) {
            ArrayList<ClassAssignmentInterface.StudentInfo> arrayList = new ArrayList<ClassAssignmentInterface.StudentInfo>(this.limit());
            for (ClassAssignmentInterface.StudentInfo studentInfo : ret) {
                arrayList.add(studentInfo);
                if (arrayList.size() != this.limit().intValue()) continue;
                break;
            }
            ret = arrayList;
        }
        ClassAssignmentInterface.StudentInfo studentInfo = new ClassAssignmentInterface.StudentInfo();
        studentInfo.setEnrollment(gEnrl);
        studentInfo.setReservation(gRes);
        studentInfo.setWaitlist(gWait);
        studentInfo.setUnassigned(gUnasg);
        studentInfo.setTotalEnrollment(gtEnrl);
        studentInfo.setTotalReservation(gtRes);
        studentInfo.setTotalWaitlist(gtWait);
        studentInfo.setTotalUnassigned(gtUnasg);
        studentInfo.setConsentNeeded(gConNeed);
        studentInfo.setTotalConsentNeeded(gtConNeed);
        studentInfo.setOverrideNeeded(gOvrNeed);
        studentInfo.setTotalOverrideNeeded(gtOvrNeed);
        studentInfo.setNrDistanceConflicts(gNrDC);
        studentInfo.setTotalNrDistanceConflicts(gtNrDC);
        studentInfo.setLongestDistanceMinutes(gDist);
        studentInfo.setTotalLongestDistanceMinutes(gtDist);
        studentInfo.setOverlappingMinutes(gShr);
        studentInfo.setTotalOverlappingMinutes(gtShr);
        studentInfo.setFreeTimeOverlappingMins(gFre);
        studentInfo.setTotalFreeTimeOverlappingMins(gtFre);
        studentInfo.setPrefInstrMethConflict(gPIM);
        studentInfo.setTotalPrefInstrMethConflict(gtPIM);
        studentInfo.setPrefSectionConflict(gPSec);
        studentInfo.setTotalPrefSectionConflict(gtPSec);
        ret.add(studentInfo);
        return ret;
    }

    public int getDistanceInMinutes(Assignment as1, Assignment as2, DistanceMetric m) {
        Placement p1 = as1.getPlacement();
        Placement p2 = as2.getPlacement();
        if (p1.getNrRooms() == 0 || p2.getNrRooms() == 0) {
            return 0;
        }
        TimeLocation t1 = p1.getTimeLocation();
        TimeLocation t2 = p2.getTimeLocation();
        if (t1 == null || t2 == null || !t1.shareDays(t2) || !t1.shareWeeks(t2)) {
            return 0;
        }
        int a1 = t1.getStartSlot();
        int a2 = t2.getStartSlot();
        if (m.doComputeDistanceConflictsBetweenNonBTBClasses()) {
            int dist;
            if (a1 + t1.getLength() <= a2 && (dist = Placement.getDistanceInMinutes((DistanceMetric)m, (Placement)p1, (Placement)p2)) > t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength())) {
                return dist;
            }
        } else if (a1 + t1.getLength() == a2) {
            return Placement.getDistanceInMinutes((DistanceMetric)m, (Placement)p1, (Placement)p2);
        }
        return 0;
    }

    public boolean isDistanceConflict(Student student, Assignment as1, Assignment as2, DistanceMetric m) {
        Placement p1 = as1.getPlacement();
        Placement p2 = as2.getPlacement();
        if (p1.getNrRooms() == 0 || p2.getNrRooms() == 0) {
            return false;
        }
        TimeLocation t1 = p1.getTimeLocation();
        TimeLocation t2 = p2.getTimeLocation();
        if (t1 == null || t2 == null || !t1.shareDays(t2) || !t1.shareWeeks(t2)) {
            return false;
        }
        int a1 = t1.getStartSlot();
        int a2 = t2.getStartSlot();
        boolean sd = false;
        for (StudentAccomodation a : student.getAccomodations()) {
            if (!m.getShortDistanceAccommodationReference().equals(a.getAbbreviation())) continue;
            sd = true;
            break;
        }
        if (sd) {
            if (m.doComputeDistanceConflictsBetweenNonBTBClasses()) {
                if (a1 + t1.getLength() <= a2) {
                    int dist = Placement.getDistanceInMinutes((DistanceMetric)m, (Placement)p1, (Placement)p2);
                    return dist > Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength());
                }
            } else if (a1 + t1.getLength() == a2) {
                return Placement.getDistanceInMinutes((DistanceMetric)m, (Placement)p1, (Placement)p2) > 0;
            }
        } else if (m.doComputeDistanceConflictsBetweenNonBTBClasses()) {
            if (a1 + t1.getLength() <= a2) {
                int dist = Placement.getDistanceInMinutes((DistanceMetric)m, (Placement)p1, (Placement)p2);
                return dist > t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength());
            }
        } else if (a1 + t1.getLength() == a2) {
            return Placement.getDistanceInMinutes((DistanceMetric)m, (Placement)p1, (Placement)p2) > t1.getBreakTime();
        }
        return false;
    }

    public boolean isConsentToDoCourse(CourseOffering course) {
        return this.iCoursesIcanApprove != null && course.getConsentType() != null && this.iCoursesIcanApprove.contains(course.getUniqueId());
    }
}

