/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.specreg;

import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.gwt.shared.SpecialRegistrationInterface;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CustomSpecialRegistrationHolder;
import org.unitime.timetable.onlinesectioning.model.XStudent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecialRegistrationRetrieve
implements OnlineSectioningAction<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private SpecialRegistrationInterface.RetrieveSpecialRegistrationRequest iRequest;

    public SpecialRegistrationRetrieve withRequest(SpecialRegistrationInterface.RetrieveSpecialRegistrationRequest request) {
        this.iRequest = request;
        return this;
    }

    public SpecialRegistrationInterface.RetrieveSpecialRegistrationRequest getRequest() {
        return this.iRequest;
    }

    public Long getStudentId() {
        return this.iRequest.getStudentId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (!server.getAcademicSession().isSectioningEnabled() || !CustomSpecialRegistrationHolder.hasProvider()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        OnlineSectioningServer.Lock lock = server.lockStudent(this.getStudentId(), null, this.name());
        try {
            SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse response;
            OnlineSectioningLog.Action.Builder action = helper.getAction();
            XStudent student = server.getStudent(this.getStudentId());
            action.getStudentBuilder().setUniqueId(student.getStudentId()).setExternalId(student.getExternalId()).setName(student.getName());
            SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse retrieveSpecialRegistrationResponse = response = CustomSpecialRegistrationHolder.getProvider().retrieveRegistration(server, helper, student, this.getRequest());
            Object var9_8 = null;
            lock.release();
            return retrieveSpecialRegistrationResponse;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            lock.release();
            throw throwable;
        }
    }

    @Override
    public String name() {
        return "specreg-retrieve";
    }
}

