/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.solver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentComparator;
import org.cpsolver.ifs.assignment.AssignmentMap;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.extension.DistanceConflict;
import org.cpsolver.studentsct.extension.TimeOverlapsCounter;
import org.cpsolver.studentsct.heuristics.selection.BranchBoundSelection;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.online.OnlineReservation;
import org.cpsolver.studentsct.online.OnlineSectioningModel;
import org.cpsolver.studentsct.online.selection.BestPenaltyCriterion;
import org.cpsolver.studentsct.online.selection.MultiCriteriaBranchAndBoundSelection;
import org.cpsolver.studentsct.online.selection.MultiCriteriaBranchAndBoundSuggestions;
import org.cpsolver.studentsct.online.selection.SuggestionsBranchAndBound;
import org.cpsolver.studentsct.reservation.Reservation;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.basic.GetAssignment;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XDistribution;
import org.unitime.timetable.onlinesectioning.model.XDistributionType;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XReservationType;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.solver.FindAssignmentAction;
import org.unitime.timetable.onlinesectioning.solver.SuggestionsFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComputeSuggestionsAction
extends FindAssignmentAction {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private ClassAssignmentInterface.ClassAssignment iSelection;
    private double iValue = 0.0;
    private String iFilter = null;

    @Override
    public ComputeSuggestionsAction forRequest(CourseRequestInterface request) {
        super.forRequest(request);
        return this;
    }

    @Override
    public ComputeSuggestionsAction withAssignment(Collection<ClassAssignmentInterface.ClassAssignment> assignment) {
        super.withAssignment(assignment);
        return this;
    }

    public ComputeSuggestionsAction withSelection(ClassAssignmentInterface.ClassAssignment selectedAssignment) {
        this.iSelection = selectedAssignment;
        return this;
    }

    public ComputeSuggestionsAction withFilter(String filter) {
        this.iFilter = filter;
        return this;
    }

    public ClassAssignmentInterface.ClassAssignment getSelection() {
        return this.iSelection;
    }

    public String getFilter() {
        return this.iFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ClassAssignmentInterface> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        String override;
        long t0 = System.currentTimeMillis();
        OnlineSectioningModel model = new OnlineSectioningModel(server.getConfig(), server.getOverExpectedCriterion());
        AssignmentMap assignment = new AssignmentMap();
        boolean linkedClassesMustBeUsed = server.getConfig().getPropertyBoolean("LinkedClasses.mustBeUsed", false);
        OnlineSectioningLog.Action.Builder action = helper.getAction();
        if (this.getRequest().getStudentId() != null) {
            action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.getRequest().getStudentId()));
        }
        Student student = new Student(this.getRequest().getStudentId() == null ? -1L : this.getRequest().getStudentId());
        HashSet<FindAssignmentAction.IdPair> enrolled = null;
        OnlineSectioningServer.Lock readLock = server.readLock();
        ClassAssignmentInterface unavailabilities = null;
        try {
            Collection<Long> collection;
            XStudent original;
            XStudent xStudent = original = this.getRequest().getStudentId() == null ? null : server.getStudent(this.getRequest().getStudentId());
            if (original != null) {
                unavailabilities = new ClassAssignmentInterface();
                GetAssignment.fillUnavailabilitiesIn(unavailabilities, original, server, helper, null);
                Collections.reverse(unavailabilities.getCourseAssignments());
                student.setExternalId(original.getExternalId());
                student.setName(original.getName());
                student.setNeedShortDistances(original.hasAccomodation(server.getDistanceMetric().getShortDistanceAccommodationReference()));
                student.setAllowDisabled(original.isAllowDisabled());
                action.getStudentBuilder().setUniqueId(original.getStudentId()).setExternalId(original.getExternalId()).setName(original.getName());
                enrolled = new HashSet<FindAssignmentAction.IdPair>();
                for (XRequest xRequest : original.getRequests()) {
                    if (!(xRequest instanceof XCourseRequest) || ((XCourseRequest)xRequest).getEnrollment() == null) continue;
                    XEnrollment xEnrollment = ((XCourseRequest)xRequest).getEnrollment();
                    for (Long s : xEnrollment.getSectionIds()) {
                        enrolled.add(new FindAssignmentAction.IdPair(xEnrollment.getCourseId(), s));
                    }
                }
                OnlineSectioningLog.Enrollment.Builder enrollment = OnlineSectioningLog.Enrollment.newBuilder();
                enrollment.setType(OnlineSectioningLog.Enrollment.EnrollmentType.STORED);
                for (XRequest xRequest : original.getRequests()) {
                    if (!(xRequest instanceof XCourseRequest) || ((XCourseRequest)xRequest).getEnrollment() == null) continue;
                    XCourseRequest cr = (XCourseRequest)xRequest;
                    XOffering offering = server.getOffering(cr.getEnrollment().getOfferingId());
                    for (XSection section : offering.getSections(cr.getEnrollment())) {
                        enrollment.addSection(OnlineSectioningHelper.toProto(section, cr.getEnrollment()));
                    }
                }
                action.addEnrollment(enrollment);
            }
            HashMap<Long, Section> classTable = new HashMap<Long, Section>();
            HashSet<XDistribution> hashSet = new HashSet<XDistribution>();
            for (CourseRequestInterface.Request c : this.getRequest().getCourses()) {
                ComputeSuggestionsAction.addRequest(server, (StudentSectioningModel)model, (Assignment<Request, Enrollment>)assignment, student, original, c, false, true, classTable, hashSet, this.getAssignment() != null);
            }
            if (student.getRequests().isEmpty()) {
                throw new SectioningException(MSG.exceptionNoCourse());
            }
            for (CourseRequestInterface.Request c : this.getRequest().getAlternatives()) {
                ComputeSuggestionsAction.addRequest(server, (StudentSectioningModel)model, (Assignment<Request, Enrollment>)assignment, student, original, c, true, true, classTable, hashSet, this.getAssignment() != null);
            }
            if (helper.isAlternativeCourseEnabled()) {
                for (Object r : student.getRequests()) {
                    XOffering x;
                    XCourse ci;
                    XCourse course;
                    Long altCourseId;
                    CourseRequest cr;
                    if (r.isAlternative() || !(r instanceof CourseRequest) || (cr = (CourseRequest)r).getCourses().size() != 1 || (altCourseId = (course = server.getCourse(((Course)cr.getCourses().get(0)).getId())) == null ? null : course.getAlternativeCourseId()) == null) continue;
                    boolean hasCourse = false;
                    block9: for (Request x2 : student.getRequests()) {
                        if (!(x2 instanceof CourseRequest)) continue;
                        for (Course c : ((CourseRequest)x2).getCourses()) {
                            if (c.getId() != altCourseId.longValue()) continue;
                            hasCourse = true;
                            continue block9;
                        }
                    }
                    if (hasCourse || (ci = server.getCourse(altCourseId)) == null || (x = server.getOffering(ci.getOfferingId())) == null) continue;
                    cr.getCourses().add(ComputeSuggestionsAction.clone(x, server.getEnrollments(x.getOfferingId()), ci.getCourseId(), student.getId(), original, classTable, server, (StudentSectioningModel)model, this.getAssignment() != null));
                    hashSet.addAll(x.getDistributions());
                }
            }
            if (student.getExternalId() != null && !student.getExternalId().isEmpty() && (collection = server.getInstructedOfferings(student.getExternalId())) != null) {
                for (Long offeringId : collection) {
                    XOffering offering = server.getOffering(offeringId);
                    if (offering == null) continue;
                    offering.fillInUnavailabilities(student);
                }
            }
            model.addStudent(student);
            model.setDistanceConflict(new DistanceConflict(server.getDistanceMetric(), model.getProperties()));
            model.setTimeOverlaps(new TimeOverlapsCounter(null, model.getProperties()));
            for (XDistribution link : hashSet) {
                if (link.getDistributionType() != XDistributionType.LinkedSections) continue;
                ArrayList<Section> sections = new ArrayList<Section>();
                for (Long sectionId : link.getSectionIds()) {
                    Section x = (Section)classTable.get(sectionId);
                    if (x == null) continue;
                    sections.add(x);
                }
                if (sections.size() < 2) continue;
                model.addLinkedSections(linkedClassesMustBeUsed, sections);
            }
            Object var27_44 = null;
            readLock.release();
        }
        catch (Throwable throwable) {
            Object var27_45 = null;
            readLock.release();
            throw throwable;
        }
        long t1 = System.currentTimeMillis();
        Hashtable<CourseRequest, Iterator<OnlineSectioningLog.Time.Builder>> hashtable = new Hashtable<CourseRequest, Iterator<OnlineSectioningLog.Time.Builder>>();
        Hashtable<CourseRequest, Set<Section>> hashtable2 = new Hashtable<CourseRequest, Set<Section>>();
        HashSet<FreeTimeRequest> requiredFreeTimes = new HashSet<FreeTimeRequest>();
        ArrayList<ClassAssignmentInterface> ret = new ArrayList<ClassAssignmentInterface>();
        ClassAssignmentInterface messages = new ClassAssignmentInterface();
        ret.add(messages);
        OnlineSectioningLog.Enrollment.Builder requested = OnlineSectioningLog.Enrollment.newBuilder();
        requested.setType(OnlineSectioningLog.Enrollment.EnrollmentType.PREVIOUS);
        for (ClassAssignmentInterface.ClassAssignment a : this.getAssignment()) {
            if (a == null || !a.isAssigned()) continue;
            requested.addSection(OnlineSectioningHelper.toProto(a));
        }
        action.addEnrollment(requested);
        Request selectedRequest = null;
        Section selectedSection = null;
        int notAssigned = 0;
        double selectedPenalty = 0.0;
        for (Request r : student.getRequests()) {
            OnlineSectioningLog.Request.Builder rq = OnlineSectioningHelper.toProto(r);
            if (r instanceof CourseRequest) {
                CourseRequest cr = (CourseRequest)r;
                if (this.getRequest().areTimeConflictsAllowed() || this.getRequest().areSpaceConflictsAllowed()) {
                    for (Course course : cr.getCourses()) {
                        new OnlineReservation(XReservationType.Dummy.ordinal(), -3L, course.getOffering(), -100, this.getRequest().areSpaceConflictsAllowed(), 1, true, true, this.getRequest().areTimeConflictsAllowed(), true){

                            public boolean mustBeUsed() {
                                return true;
                            }
                        };
                    }
                }
                if (!this.getSelection().isFreeTime() && cr.getCourse(this.getSelection().getCourseId().longValue()) != null) {
                    Section section;
                    selectedRequest = r;
                    if (this.getSelection().getClassId() != null && (section = cr.getSection(this.getSelection().getClassId().longValue())) != null) {
                        selectedSection = section;
                    }
                }
                Iterator<OnlineSectioningLog.Time.Builder> preferredSections = new HashSet();
                HashSet<Section> requiredSections = new HashSet<Section>();
                for (ClassAssignmentInterface.ClassAssignment a : this.getAssignment()) {
                    if (a == null || a.isFreeTime() || cr.getCourse(a.getCourseId().longValue()) == null || a.getClassId() == null) continue;
                    Section section = cr.getSection(a.getClassId().longValue());
                    boolean hasIndividualReservation = false;
                    if (section != null && section.getLimit() == 0) {
                        for (Reservation res : cr.getReservations(cr.getCourse(a.getCourseId().longValue()))) {
                            Set sect;
                            if (!res.canAssignOverLimit() || (sect = res.getSections(section.getSubpart())) != null && !sect.contains(section)) continue;
                            hasIndividualReservation = true;
                        }
                    }
                    if (section == null || section.getLimit() == 0 && !hasIndividualReservation) {
                        messages.addMessage((a.isSaved() ? "Enrolled class" : (a.isPinned() ? "Required class " : "Previously selected class ")) + a.getSubject() + " " + a.getCourseNbr() + " " + a.getSubpart() + " " + a.getSection() + " is no longer available.");
                        continue;
                    }
                    selectedPenalty += model.getOverExpected((Assignment)assignment, section, (Request)cr);
                    if (a.isPinned() && !this.getSelection().equals(a)) {
                        requiredSections.add(section);
                    }
                    ((HashSet)((Object)preferredSections)).add((OnlineSectioningLog.Time.Builder)section);
                    rq.addSection(OnlineSectioningHelper.toProto((SctAssignment)section, cr.getCourse(a.getCourseId().longValue())).setPreference(this.getSelection().equals(a) ? OnlineSectioningLog.Section.Preference.SELECTED : (a.isPinned() ? OnlineSectioningLog.Section.Preference.REQUIRED : OnlineSectioningLog.Section.Preference.PREFERRED)));
                }
                if (((HashSet)((Object)preferredSections)).isEmpty()) {
                    ++notAssigned;
                }
                hashtable.put(cr, preferredSections);
                hashtable2.put(cr, requiredSections);
            } else {
                FreeTimeRequest ft = (FreeTimeRequest)r;
                if (this.getSelection().isFreeTime() && ft.getTime() != null && ft.getTime().getStartSlot() == this.getSelection().getStart() && ft.getTime().getLength() == this.getSelection().getLength() && ft.getTime().getDayCode() == DayCode.toInt(DayCode.toDayCodes(this.getSelection().getDays()))) {
                    selectedRequest = r;
                    for (OnlineSectioningLog.Time.Builder ftb : rq.getFreeTimeBuilderList()) {
                        ftb.setPreference(OnlineSectioningLog.Section.Preference.SELECTED);
                    }
                } else {
                    for (ClassAssignmentInterface.ClassAssignment a : this.getAssignment()) {
                        if (a == null || !a.isFreeTime() || !a.isPinned() || ft.getTime() == null || ft.getTime().getStartSlot() != a.getStart() || ft.getTime().getLength() != a.getLength() || ft.getTime().getDayCode() != DayCode.toInt(DayCode.toDayCodes(a.getDays()))) continue;
                        requiredFreeTimes.add(ft);
                        for (OnlineSectioningLog.Time.Builder ftb : rq.getFreeTimeBuilderList()) {
                            ftb.setPreference(OnlineSectioningLog.Section.Preference.REQUIRED);
                        }
                    }
                }
            }
            action.addRequest(rq);
        }
        long t2 = System.currentTimeMillis();
        if (selectedRequest == null) {
            return new ArrayList<ClassAssignmentInterface>();
        }
        Object suggestionBaB = null;
        boolean avoidOverExpected = server.getAcademicSession().isSectioningEnabled();
        if (avoidOverExpected && helper.getUser() != null && helper.getUser().hasType() && helper.getUser().getType() != OnlineSectioningLog.Entity.EntityType.STUDENT) {
            avoidOverExpected = false;
        }
        if ((override = ApplicationProperty.OnlineSchedulingAllowOverExpected.value()) != null) {
            avoidOverExpected = "false".equalsIgnoreCase(override);
        }
        double maxOverExpected = -1.0;
        if (avoidOverExpected) {
            if (notAssigned == 0) {
                maxOverExpected = selectedPenalty;
            } else {
                long x0 = System.currentTimeMillis();
                MultiCriteriaBranchAndBoundSelection selection = new MultiCriteriaBranchAndBoundSelection(model.getProperties());
                selection.setModel(model);
                selection.setPreferredSections(hashtable);
                selection.setRequiredSections(hashtable2);
                selection.setRequiredFreeTimes(requiredFreeTimes);
                selection.setTimeout(100);
                BranchBoundSelection.BranchBoundNeighbour neighbour = selection.select((Assignment)assignment, student, (MultiCriteriaBranchAndBoundSelection.SelectionCriterion)new BestPenaltyCriterion(student, model));
                long x1 = System.currentTimeMillis();
                if (neighbour != null) {
                    maxOverExpected = 0.0;
                    for (Enrollment enrollment : neighbour.getAssignment()) {
                        if (enrollment == null || !enrollment.isCourseRequest()) continue;
                        for (Section section : enrollment.getSections()) {
                            maxOverExpected += model.getOverExpected((Assignment)assignment, section, enrollment.getRequest());
                        }
                    }
                    if (maxOverExpected < selectedPenalty) {
                        maxOverExpected = selectedPenalty;
                    }
                    helper.debug("Maximum number of over-expected sections limited to " + maxOverExpected + " (computed in " + (x1 - x0) + " ms).");
                }
            }
        }
        SuggestionsFilter filter = null;
        if (this.getFilter() != null && !this.getFilter().isEmpty()) {
            filter = new SuggestionsFilter(this.getFilter(), server.getAcademicSession().getDatePatternFirstDate());
        }
        suggestionBaB = server.getConfig().getPropertyBoolean("StudentWeights.MultiCriteria", true) ? new MultiCriteriaBranchAndBoundSuggestions(model.getProperties(), student, (Assignment)assignment, hashtable2, requiredFreeTimes, hashtable, selectedRequest, selectedSection, (SuggestionsBranchAndBound.SuggestionFilter)filter, maxOverExpected, server.getConfig().getPropertyBoolean("StudentWeights.PriorityWeighting", true)) : new SuggestionsBranchAndBound(model.getProperties(), student, (Assignment)assignment, hashtable2, requiredFreeTimes, hashtable, selectedRequest, selectedSection, (SuggestionsBranchAndBound.SuggestionFilter)filter, maxOverExpected);
        helper.debug("Using " + (server.getConfig().getPropertyBoolean("StudentWeights.MultiCriteria", true) ? "multi-criteria " : "") + (server.getConfig().getPropertyBoolean("StudentWeights.PriorityWeighting", true) ? "priority" : "equal") + " weighting model with " + server.getConfig().getPropertyInt("Suggestions.Timeout", 5000) + " ms time limit" + (maxOverExpected < 0.0 ? "" : ", maximal over-expected of " + maxOverExpected) + " and maximal depth of " + server.getConfig().getPropertyInt("Suggestions.MaxDepth", 4) + ".");
        TreeSet suggestions = suggestionBaB.computeSuggestions();
        this.iValue = suggestions.isEmpty() ? 0.0 : -((SuggestionsBranchAndBound.Suggestion)suggestions.first()).getValue();
        long t3 = System.currentTimeMillis();
        helper.debug("  -- suggestion B&B took " + suggestionBaB.getTime() + "ms" + (suggestionBaB.isTimeoutReached() ? ", timeout reached" : ""));
        for (SuggestionsBranchAndBound.Suggestion suggestion : suggestions) {
            ClassAssignmentInterface ca = this.convert(server, (Assignment<Request, Enrollment>)assignment, suggestion.getEnrollments(), hashtable2, requiredFreeTimes, true, model.getDistanceConflict(), enrolled);
            if (unavailabilities != null) {
                for (ClassAssignmentInterface.CourseAssignment u : unavailabilities.getCourseAssignments()) {
                    ca.getCourseAssignments().add(0, u);
                }
            }
            ret.add(ca);
            OnlineSectioningLog.Enrollment.Builder solution = OnlineSectioningLog.Enrollment.newBuilder();
            solution.setType(OnlineSectioningLog.Enrollment.EnrollmentType.COMPUTED);
            solution.setValue(-suggestion.getValue());
            for (Enrollment e : suggestion.getEnrollments()) {
                if (e == null || e.getAssignments() == null) continue;
                for (SctAssignment section : e.getAssignments()) {
                    solution.addSection(OnlineSectioningHelper.toProto(section, e));
                }
            }
            action.addEnrollment(solution);
        }
        if (suggestions.isEmpty() && selectedRequest != null && selectedRequest instanceof CourseRequest) {
            String ov;
            TreeSet<Enrollment> overlap = new TreeSet<Enrollment>(new Comparator<Enrollment>(){

                @Override
                public int compare(Enrollment o1, Enrollment o2) {
                    return o1.getRequest().compareTo(o2.getRequest());
                }
            });
            Hashtable<CourseRequest, TreeSet<Section>> overlapingSections = new Hashtable<CourseRequest, TreeSet<Section>>();
            CourseRequest request = (CourseRequest)selectedRequest;
            Course course = (Course)request.getCourses().get(0);
            List avEnrls = request.getAvaiableEnrollmentsSkipSameTime((Assignment)assignment);
            for (Enrollment enrl : avEnrls) {
                for (Request q : enrl.getStudent().getRequests()) {
                    Enrollment x;
                    if (q.equals((Object)request) || (x = (Enrollment)assignment.getValue((Variable)q)) == null || x.getAssignments() == null || x.getAssignments().isEmpty()) continue;
                    for (SctAssignment a : x.getAssignments()) {
                        if (!a.isOverlapping(enrl.getAssignments())) continue;
                        overlap.add(x);
                        if (!(x.getRequest() instanceof CourseRequest)) continue;
                        CourseRequest cr = (CourseRequest)x.getRequest();
                        TreeSet<Section> ss = (TreeSet<Section>)overlapingSections.get(cr);
                        if (ss == null) {
                            ss = new TreeSet<Section>((Comparator<Section>)new AssignmentComparator((Assignment)assignment));
                            overlapingSections.put(cr, ss);
                        }
                        ss.add((Section)a);
                    }
                }
            }
            TreeSet<String> overlapMessages = new TreeSet<String>();
            for (Enrollment q : overlap) {
                ov = null;
                if (q.getRequest() instanceof FreeTimeRequest) {
                    ov = OnlineSectioningHelper.toString((FreeTimeRequest)q.getRequest());
                } else {
                    CourseRequest cr = (CourseRequest)q.getRequest();
                    Course o = q.getCourse();
                    ov = MSG.course(o.getSubjectArea(), o.getCourseNumber());
                    if (((TreeSet)overlapingSections.get(cr)).size() == 1) {
                        for (Section s : (TreeSet)overlapingSections.get(cr)) {
                            ov = ov + " " + s.getSubpart().getName();
                        }
                    }
                }
                overlapMessages.add(ov);
            }
            if (!overlapMessages.isEmpty()) {
                String overlapMessage = null;
                Iterator i = overlapMessages.iterator();
                while (i.hasNext()) {
                    ov = (String)i.next();
                    if (overlapMessage == null) {
                        overlapMessage = ov;
                        continue;
                    }
                    if (i.hasNext()) {
                        overlapMessage = overlapMessage + MSG.conflictWithMiddle(ov);
                        continue;
                    }
                    overlapMessage = overlapMessage + MSG.conflictWithLast(ov);
                }
                messages.addMessage(MSG.suggestionsNoChoicesCourseIsConflicting(MSG.course(course.getSubjectArea(), course.getCourseNumber()), overlapMessage));
            } else if (course.getLimit() == 0) {
                messages.addMessage(MSG.suggestionsNoChoicesCourseIsFull(MSG.course(course.getSubjectArea(), course.getCourseNumber())));
            }
        }
        long t4 = System.currentTimeMillis();
        helper.debug("Sectioning took " + (t4 - t0) + "ms (model " + (t1 - t0) + "ms, solver init " + (t2 - t1) + "ms, sectioning " + (t3 - t2) + "ms, conversion " + (t4 - t3) + "ms)");
        return ret;
    }

    @Override
    public String name() {
        return "suggestions";
    }

    public double value() {
        return this.iValue;
    }
}

