/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.unitime.timetable.model.StudentGroupReservation;
import org.unitime.timetable.model.StudentGroupType;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XReservation;
import org.unitime.timetable.onlinesectioning.model.XReservationType;
import org.unitime.timetable.onlinesectioning.model.XStudent;

@SerializeWith(value=XCourseReservationSerializer.class)
public class XGroupReservation
extends XReservation {
    private static final long serialVersionUID = 1L;
    private int iLimit;
    private String iGroup;

    public XGroupReservation() {
    }

    public XGroupReservation(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XGroupReservation(XOffering offering, StudentGroupReservation reservation) {
        super(XReservationType.Group, offering, reservation);
        this.iLimit = reservation.getLimit() == null ? -1 : reservation.getLimit();
        this.iGroup = reservation.getGroup().getGroupAbbreviation();
        if (reservation.getGroup().getType() != null && reservation.getGroup().getType().getAllowDisabledSection() == StudentGroupType.AllowDisabledSection.WithGroupReservation) {
            this.setAllowDisabled(true);
        }
    }

    public String getGroup() {
        return this.iGroup;
    }

    public int getReservationLimit() {
        return this.iLimit;
    }

    public boolean isApplicable(XStudent student, XCourseId course) {
        return student.getGroups().contains(this.iGroup);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.iGroup = (String)in.readObject();
        this.iLimit = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.iGroup);
        out.writeInt(this.iLimit);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XCourseReservationSerializer
    implements Externalizer<XGroupReservation> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XGroupReservation object) throws IOException {
            object.writeExternal(output);
        }

        public XGroupReservation readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XGroupReservation(input);
        }
    }
}

