/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.cpsolver.studentsct.model.Choice;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.unitime.timetable.model.ClassWaitList;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.CourseRequestOption;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentEnrollmentMessage;
import org.unitime.timetable.model.base.BaseStudentEnrollmentMessage;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XInstructor;
import org.unitime.timetable.onlinesectioning.model.XOverride;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XWaitListedSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SerializeWith(value=XCourseRequestSerializer.class)
public class XCourseRequest
extends XRequest {
    private static final long serialVersionUID = 1L;
    private List<XCourseId> iCourseIds = new ArrayList<XCourseId>();
    private boolean iWaitlist = false;
    private Date iTimeStamp = null;
    private XEnrollment iEnrollment = null;
    private Map<XCourseId, List<XWaitListedSection>> iSectionWaitlist = null;
    private Map<XCourseId, byte[]> iOptions = null;
    private Map<XCourseId, byte[]> iPreferences = null;
    private String iMessage = null;
    private Map<XCourseId, XOverride> iOverrides = null;

    public XCourseRequest() {
    }

    public XCourseRequest(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XCourseRequest(CourseDemand demand, OnlineSectioningHelper helper) {
        super(demand);
        List<StudentClassEnrollment> enrl;
        TreeSet<org.unitime.timetable.model.CourseRequest> crs = new TreeSet<org.unitime.timetable.model.CourseRequest>(new Comparator<org.unitime.timetable.model.CourseRequest>(){

            @Override
            public int compare(org.unitime.timetable.model.CourseRequest r1, org.unitime.timetable.model.CourseRequest r2) {
                return r1.getOrder().compareTo(r2.getOrder());
            }
        });
        crs.addAll(demand.getCourseRequests());
        for (org.unitime.timetable.model.CourseRequest cr : crs) {
            XCourseId courseId = new XCourseId(cr.getCourseOffering());
            this.iCourseIds.add(courseId);
            if (cr.getClassWaitLists() != null) {
                for (ClassWaitList cwl : cr.getClassWaitLists()) {
                    List<XWaitListedSection> sections;
                    if (this.iSectionWaitlist == null) {
                        this.iSectionWaitlist = new HashMap<XCourseId, List<XWaitListedSection>>();
                    }
                    if ((sections = this.iSectionWaitlist.get(courseId)) == null) {
                        sections = new ArrayList<XWaitListedSection>();
                        this.iSectionWaitlist.put(courseId, sections);
                    }
                    sections.add(new XWaitListedSection(cwl, helper));
                }
            }
            for (CourseRequestOption option : cr.getCourseRequestOptions()) {
                if (OnlineSectioningLog.CourseRequestOption.OptionType.ORIGINAL_ENROLLMENT.getNumber() == option.getOptionType().intValue()) {
                    if (this.iOptions == null) {
                        this.iOptions = new HashMap<XCourseId, byte[]>();
                    }
                    this.iOptions.put(courseId, option.getValue());
                    continue;
                }
                if (OnlineSectioningLog.CourseRequestOption.OptionType.REQUEST_PREFERENCE.getNumber() != option.getOptionType().intValue()) continue;
                if (this.iPreferences == null) {
                    this.iPreferences = new HashMap<XCourseId, byte[]>();
                }
                this.iPreferences.put(courseId, option.getValue());
            }
            if (cr.getOverrideExternalId() == null) continue;
            if (this.iOverrides == null) {
                this.iOverrides = new HashMap<XCourseId, XOverride>();
            }
            this.iOverrides.put(courseId, new XOverride(cr.getOverrideExternalId(), cr.getOverrideTimeStamp(), cr.getOverrideStatus()));
        }
        if (helper.isAlternativeCourseEnabled() && crs.size() == 1 && !demand.isAlternative().booleanValue()) {
            CourseOffering co = crs.first().getCourseOffering();
            CourseOffering alternative = co.getAlternativeOffering();
            if (alternative != null) {
                for (CourseDemand d : demand.getStudent().getCourseDemands()) {
                    if (d.getFreeTime() != null) continue;
                    for (org.unitime.timetable.model.CourseRequest r : d.getCourseRequests()) {
                        if (alternative.equals(r.getCourseOffering())) {
                            alternative = null;
                            break;
                        }
                        if (d.isAlternative().booleanValue() || d.getPriority() >= demand.getPriority() || d.getCourseRequests().size() != 1 || !alternative.equals(r.getCourseOffering().getAlternativeOffering())) continue;
                        alternative = null;
                        break;
                    }
                    if (alternative != null) continue;
                    break;
                }
            }
            if (alternative != null) {
                this.iCourseIds.add(new XCourseId(alternative));
                enrl = alternative.getClassEnrollments(demand.getStudent());
                if (!enrl.isEmpty()) {
                    this.iEnrollment = new XEnrollment(demand.getStudent(), alternative, helper, enrl);
                }
            }
        }
        this.iWaitlist = demand.isWaitlist() != null && demand.isWaitlist() != false;
        this.iTimeStamp = demand.getTimestamp() == null ? new Date() : demand.getTimestamp();
        for (org.unitime.timetable.model.CourseRequest cr : crs) {
            enrl = cr.getClassEnrollments();
            if (enrl.isEmpty()) continue;
            this.iEnrollment = new XEnrollment(demand.getStudent(), cr.getCourseOffering(), helper, enrl);
            break;
        }
        if (demand.getEnrollmentMessages() != null) {
            BaseStudentEnrollmentMessage message = null;
            for (StudentEnrollmentMessage m : demand.getEnrollmentMessages()) {
                if (message != null && message.getOrder() >= m.getOrder() && (message.getOrder() != m.getOrder() || !message.getTimestamp().before(m.getTimestamp()))) continue;
                message = m;
            }
            if (message != null) {
                this.iMessage = message.getMessage();
            }
        }
    }

    public XCourseRequest(Student student, CourseOffering course, int priority, OnlineSectioningHelper helper, Collection<StudentClassEnrollment> classes) {
        this.iStudentId = student.getUniqueId();
        this.iRequestId = -course.getUniqueId().longValue();
        this.iAlternative = false;
        this.iPriority = priority;
        this.iCourseIds.add(new XCourseId(course));
        this.iWaitlist = false;
        if (classes != null && !classes.isEmpty()) {
            this.iEnrollment = new XEnrollment(student, course, helper, classes);
        }
        this.iTimeStamp = this.iEnrollment != null ? this.iEnrollment.getTimeStamp() : new Date();
    }

    public XCourseRequest(Student student, XCourseId course, int priority, XEnrollment enrollment) {
        this.iStudentId = student.getUniqueId();
        this.iRequestId = -course.getCourseId().longValue();
        this.iAlternative = false;
        this.iPriority = priority;
        this.iCourseIds.add(course);
        this.iWaitlist = false;
        this.iEnrollment = enrollment;
        this.iTimeStamp = this.iEnrollment != null ? this.iEnrollment.getTimeStamp() : new Date();
    }

    public XCourseRequest(XCourseRequest request, XEnrollment enrollment) {
        super(request);
        this.iCourseIds.addAll(request.getCourseIds());
        this.iWaitlist = request.isWaitlist();
        this.iTimeStamp = request.getTimeStamp();
        this.iEnrollment = enrollment;
        if (request.iSectionWaitlist != null) {
            this.iSectionWaitlist = new HashMap<XCourseId, List<XWaitListedSection>>(request.iSectionWaitlist);
        }
        if (request.iOptions != null) {
            this.iOptions = new HashMap<XCourseId, byte[]>(request.iOptions);
        }
        if (request.iPreferences != null) {
            this.iPreferences = new HashMap<XCourseId, byte[]>(request.iPreferences);
        }
        if (request.iOverrides != null) {
            this.iOverrides = new HashMap<XCourseId, XOverride>(request.iOverrides);
        }
        this.iMessage = request.getEnrollmentMessage();
    }

    public XCourseRequest(CourseRequest request, Enrollment enrollment) {
        super((Request)request);
        for (Course course : request.getCourses()) {
            this.iCourseIds.add(new XCourseId(course));
        }
        this.iWaitlist = request.isWaitlist();
        this.iTimeStamp = request.getTimeStamp() == null ? null : new Date(request.getTimeStamp());
        XEnrollment xEnrollment = this.iEnrollment = enrollment == null ? null : new XEnrollment(enrollment);
        if (!request.getSelectedChoices().isEmpty()) {
            for (Course course : request.getCourses()) {
                HashSet<Long> im = new HashSet<Long>();
                OnlineSectioningLog.CourseRequestOption.Builder preference = OnlineSectioningLog.CourseRequestOption.newBuilder();
                preference.setType(OnlineSectioningLog.CourseRequestOption.OptionType.REQUEST_PREFERENCE);
                for (Choice choice : request.getSelectedChoices()) {
                    if (!course.getOffering().equals((Object)choice.getOffering())) continue;
                    if (choice.getSectionId() != null) {
                        Section section = choice.getOffering().getSection(choice.getSectionId().longValue());
                        if (section == null) continue;
                        preference.addSection(OnlineSectioningHelper.toProto((SctAssignment)section, course));
                        continue;
                    }
                    if (choice.getConfigId() == null) continue;
                    for (Config config : choice.getOffering().getConfigs()) {
                        if (!choice.getConfigId().equals(config.getId()) || config.getInstructionalMethodId() == null || !im.add(config.getInstructionalMethodId())) continue;
                        preference.addInstructionalMethod(OnlineSectioningLog.Entity.newBuilder().setUniqueId(config.getInstructionalMethodId()).setName(config.getInstructionalMethodName()));
                    }
                }
                if (preference.getInstructionalMethodCount() <= 0 && preference.getSectionCount() <= 0) continue;
                if (this.iPreferences == null) {
                    this.iPreferences = new HashMap<XCourseId, byte[]>();
                }
                this.iPreferences.put(new XCourseId(course), preference.build().toByteArray());
            }
        }
    }

    public List<XCourseId> getCourseIds() {
        return this.iCourseIds;
    }

    public boolean hasCourse(Long courseId) {
        for (XCourseId id : this.iCourseIds) {
            if (!id.getCourseId().equals(courseId)) continue;
            return true;
        }
        return false;
    }

    public boolean isPrimary(Long courseId) {
        return !this.iCourseIds.isEmpty() && this.iCourseIds.get(0).getCourseId().equals(courseId);
    }

    public boolean isPrimary(XCourseId courseId) {
        return !this.iCourseIds.isEmpty() && this.iCourseIds.get(0).equals(courseId);
    }

    public Integer getEnrolledCourseIndex() {
        if (this.iEnrollment == null) {
            return null;
        }
        for (int i = 0; i < this.iCourseIds.size(); ++i) {
            if (!this.iCourseIds.get(i).getCourseId().equals(this.iEnrollment.getCourseId())) continue;
            return i;
        }
        return -1;
    }

    public XCourseId getCourseIdByOfferingId(Long offeringId) {
        for (XCourseId id : this.iCourseIds) {
            if (!id.getOfferingId().equals(offeringId)) continue;
            return id;
        }
        return null;
    }

    public boolean isWaitlist() {
        return this.iWaitlist;
    }

    public Date getTimeStamp() {
        return this.iTimeStamp;
    }

    public XEnrollment getEnrollment() {
        return this.iEnrollment;
    }

    public void setEnrollment(XEnrollment enrollment) {
        this.iEnrollment = enrollment;
    }

    public void setWaitlist(boolean waitlist) {
        this.iWaitlist = waitlist;
    }

    public boolean hasSectionWaitlist(XCourseId courseId) {
        List<XWaitListedSection> sections = this.getSectionWaitlist(courseId);
        return sections != null && !sections.isEmpty();
    }

    public List<XWaitListedSection> getSectionWaitlist(XCourseId courseId) {
        return this.iSectionWaitlist == null ? null : this.iSectionWaitlist.get(courseId);
    }

    public XOverride getOverride(XCourseId courseId) {
        return this.iOverrides == null ? null : this.iOverrides.get(courseId);
    }

    public Integer getOverrideStatus(XCourseId courseId) {
        XOverride override = this.iOverrides == null ? null : this.iOverrides.get(courseId);
        return override == null ? null : override.getStatus();
    }

    public Date getOverrideTimeStamp(XCourseId courseId) {
        XOverride override = this.iOverrides == null ? null : this.iOverrides.get(courseId);
        return override == null ? null : override.getTimeStamp();
    }

    public String getOverrideExternalId(XCourseId courseId) {
        XOverride override = this.iOverrides == null ? null : this.iOverrides.get(courseId);
        return override == null ? null : override.getExternalId();
    }

    public boolean isOverridePending(XCourseId courseId) {
        XOverride override;
        XOverride xOverride = override = this.iOverrides == null ? null : this.iOverrides.get(courseId);
        return override == null || override.getStatus() == null ? false : override.getStatus().intValue() == CourseRequest.CourseRequestOverrideStatus.PENDING.ordinal();
    }

    public OnlineSectioningLog.CourseRequestOption getOptions(Long offeringId) {
        if (this.iOptions == null) {
            return null;
        }
        XCourseId courseId = this.getCourseIdByOfferingId(offeringId);
        if (courseId == null) {
            return null;
        }
        byte[] option = this.iOptions.get(courseId);
        if (option != null) {
            try {
                return OnlineSectioningLog.CourseRequestOption.parseFrom(option);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                // empty catch block
            }
        }
        return null;
    }

    public OnlineSectioningLog.CourseRequestOption getPreferences(XCourseId courseId) {
        if (this.iPreferences == null) {
            return null;
        }
        byte[] option = this.iPreferences.get(courseId);
        if (option != null) {
            try {
                return OnlineSectioningLog.CourseRequestOption.parseFrom(option);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                // empty catch block
            }
        }
        return null;
    }

    public void fillChoicesIn(CourseRequest request) {
        Course course;
        if (this.iSectionWaitlist != null) {
            for (Map.Entry<XCourseId, List<XWaitListedSection>> entry : this.iSectionWaitlist.entrySet()) {
                course = request.getCourse(entry.getKey().getCourseId().longValue());
                if (course == null) continue;
                for (XSection xSection : entry.getValue()) {
                    ArrayList<Instructor> instructors = null;
                    if (!xSection.getInstructors().isEmpty()) {
                        instructors = new ArrayList<Instructor>();
                        for (XInstructor i : xSection.getInstructors()) {
                            instructors.add(new Instructor(i.getIntructorId().longValue(), i.getExternalId(), i.getName(), i.getEmail()));
                        }
                    }
                    request.getSelectedChoices().add(new Choice(course.getOffering(), xSection.getInstructionalType(), xSection.getTime() == null || xSection.getTime().getDays() == 0 ? null : xSection.getTime().toTimeLocation(), instructors));
                }
            }
        }
        if (this.iPreferences != null) {
            for (Map.Entry<XCourseId, List<XWaitListedSection>> entry : this.iPreferences.entrySet()) {
                course = request.getCourse(entry.getKey().getCourseId().longValue());
                if (course == null) continue;
                try {
                    OnlineSectioningLog.CourseRequestOption option = OnlineSectioningLog.CourseRequestOption.parseFrom((byte[])entry.getValue());
                    if (option.getInstructionalMethodCount() > 0) {
                        for (OnlineSectioningLog.Entity e : option.getInstructionalMethodList()) {
                            for (Config config : course.getOffering().getConfigs()) {
                                if (config.getInstructionalMethodId() == null || !config.getInstructionalMethodId().equals(e.getUniqueId())) continue;
                                request.getSelectedChoices().add(new Choice(config));
                            }
                        }
                    }
                    if (option.getSectionCount() <= 0) continue;
                    for (OnlineSectioningLog.Section s : option.getSectionList()) {
                        Section section = course.getOffering().getSection(s.getClazz().getUniqueId());
                        if (section == null) continue;
                        request.getSelectedChoices().add(new Choice(section));
                    }
                }
                catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                }
            }
        }
    }

    public String getEnrollmentMessage() {
        return this.iMessage;
    }

    public void setEnrollmentMessage(String message) {
        this.iMessage = message;
    }

    @Override
    public String toString() {
        String ret = super.toString();
        Iterator<XCourseId> i = this.iCourseIds.iterator();
        while (i.hasNext()) {
            XCourseId c = i.next();
            ret = ret + " " + c.getCourseName();
            if (!i.hasNext()) continue;
            ret = ret + ",";
        }
        if (this.isWaitlist()) {
            ret = ret + " (w)";
        }
        ret = ret + " (" + this.getRequestId() + ")";
        return ret;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int nrCourses = in.readInt();
        this.iCourseIds.clear();
        for (int i = 0; i < nrCourses; ++i) {
            this.iCourseIds.add(new XCourseId(in));
        }
        this.iWaitlist = in.readBoolean();
        this.iTimeStamp = in.readBoolean() ? new Date(in.readLong()) : null;
        this.iEnrollment = in.readBoolean() ? new XEnrollment(in) : null;
        int nrWaitlists = in.readInt();
        if (nrWaitlists == 0) {
            this.iSectionWaitlist = null;
        } else {
            this.iSectionWaitlist = new HashMap<XCourseId, List<XWaitListedSection>>();
            block1: for (int i = 0; i < nrWaitlists; ++i) {
                Long courseId = in.readLong();
                int nrSections = in.readInt();
                ArrayList<XWaitListedSection> sections = new ArrayList<XWaitListedSection>(nrSections);
                for (int j = 0; j < nrSections; ++j) {
                    sections.add(new XWaitListedSection(in));
                }
                for (XCourseId xCourseId : this.iCourseIds) {
                    if (!xCourseId.getCourseId().equals(courseId)) continue;
                    this.iSectionWaitlist.put(xCourseId, sections);
                    continue block1;
                }
            }
        }
        int nrOptions = in.readInt();
        if (nrOptions == 0) {
            this.iOptions = null;
        } else {
            this.iOptions = new HashMap<XCourseId, byte[]>();
            block4: for (int i = 0; i < nrOptions; ++i) {
                Long courseId = in.readLong();
                byte[] data = new byte[in.readInt()];
                in.read(data);
                for (XCourseId xCourseId : this.iCourseIds) {
                    if (!xCourseId.getCourseId().equals(courseId)) continue;
                    this.iOptions.put(xCourseId, data);
                    continue block4;
                }
            }
        }
        int nrPrefs = in.readInt();
        if (nrPrefs == 0) {
            this.iPreferences = null;
        } else {
            this.iPreferences = new HashMap<XCourseId, byte[]>();
            block6: for (int i = 0; i < nrPrefs; ++i) {
                Long courseId = in.readLong();
                byte[] data = new byte[in.readInt()];
                in.read(data);
                for (XCourseId course : this.iCourseIds) {
                    if (!course.getCourseId().equals(courseId)) continue;
                    this.iPreferences.put(course, data);
                    continue block6;
                }
            }
        }
        this.iMessage = (String)in.readObject();
        int nrOverrides = in.readInt();
        if (nrOverrides == 0) {
            this.iOverrides = null;
        } else {
            this.iOverrides = new HashMap<XCourseId, XOverride>();
            block8: for (int i = 0; i < nrOverrides; ++i) {
                Long courseId = in.readLong();
                XOverride xOverride = new XOverride(in);
                for (XCourseId course : this.iCourseIds) {
                    if (!course.getCourseId().equals(courseId)) continue;
                    this.iOverrides.put(course, xOverride);
                    continue block8;
                }
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] value;
        super.writeExternal(out);
        out.writeInt(this.iCourseIds.size());
        for (XCourseId xCourseId : this.iCourseIds) {
            xCourseId.writeExternal(out);
        }
        out.writeBoolean(this.iWaitlist);
        out.writeBoolean(this.iTimeStamp != null);
        if (this.iTimeStamp != null) {
            out.writeLong(this.iTimeStamp.getTime());
        }
        out.writeBoolean(this.iEnrollment != null);
        if (this.iEnrollment != null) {
            this.iEnrollment.writeExternal(out);
        }
        out.writeInt(this.iSectionWaitlist == null ? 0 : this.iSectionWaitlist.size());
        if (this.iSectionWaitlist != null) {
            for (Map.Entry entry : this.iSectionWaitlist.entrySet()) {
                out.writeLong(((XCourseId)entry.getKey()).getCourseId());
                out.writeInt(((List)entry.getValue()).size());
                for (XWaitListedSection section : (List)entry.getValue()) {
                    section.writeExternal(out);
                }
            }
        }
        out.writeInt(this.iOptions == null ? 0 : this.iOptions.size());
        if (this.iOptions != null) {
            for (Map.Entry entry : this.iOptions.entrySet()) {
                out.writeLong(((XCourseId)entry.getKey()).getCourseId());
                value = (byte[])entry.getValue();
                out.writeInt(value.length);
                out.write(value);
            }
        }
        out.writeInt(this.iPreferences == null ? 0 : this.iPreferences.size());
        if (this.iPreferences != null) {
            for (Map.Entry entry : this.iPreferences.entrySet()) {
                out.writeLong(((XCourseId)entry.getKey()).getCourseId());
                value = (byte[])entry.getValue();
                out.writeInt(value.length);
                out.write(value);
            }
        }
        out.writeObject(this.iMessage);
        out.writeInt(this.iOverrides == null ? 0 : this.iOverrides.size());
        if (this.iOverrides != null) {
            for (Map.Entry entry : this.iOverrides.entrySet()) {
                out.writeLong(((XCourseId)entry.getKey()).getCourseId());
                ((XOverride)entry.getValue()).writeExternal(out);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XCourseRequestSerializer
    implements Externalizer<XCourseRequest> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XCourseRequest object) throws IOException {
            object.writeExternal(output);
        }

        public XCourseRequest readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XCourseRequest(input);
        }
    }
}

