/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.StudentSectioningSaver;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.Transaction;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.restlet.Client;
import org.restlet.Uniform;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.OfferingConsentType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLogger;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CustomStudentEnrollmentHolder;
import org.unitime.timetable.onlinesectioning.custom.ExternalTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.BannerTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.GsonRepresentation;
import org.unitime.timetable.onlinesectioning.custom.purdue.XEInterface;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.solver.studentsct.InMemoryReport;
import org.unitime.timetable.solver.studentsct.StudentSolver;
import org.unitime.timetable.util.Formats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XEBatchSolverSaver
extends StudentSectioningSaver {
    private static Log sLog = LogFactory.getLog(XEBatchSolverSaver.class);
    private String iInitiative = null;
    private String iTerm = null;
    private String iYear = null;
    private String iOwnerId = null;
    private Progress iProgress = null;
    private Client iClient;
    private ExternalTermProvider iExternalTermProvider;
    private AcademicSessionInfo iSession;
    private String iHoldPassword = null;
    private String iRegistrationDate = null;
    private String iActionAdd = null;
    private String iActionDrop = null;
    private boolean iConditionalAddDrop = true;
    private InMemoryReport iCSV;
    private boolean iAutoOverrides = false;
    private Set<String> iAllowedOverrides = new HashSet<String>();
    private int iNrThreads = 1;
    private boolean iCanContinue = true;
    private Hashtable<Long, CourseOffering> iCourses = null;
    private Hashtable<Long, Class_> iClasses = null;
    private List<XStudent> iUpdatedStudents = new ArrayList<XStudent>();
    protected static String[] defaultOverrides = new String[]{"CAMP", "CAMPUS", "CLAS", "CLASS", "CLOS", "CLOSED", "COLL", "COLLEGE", "CORQ", "CO-REQ", "DEGR", "DEGREE", "DEPT", "DPT-PERMIT", "DUPL", "DUP-CRSE", "LEVL", "LEVEL", "MAJR", "MAJOR", "PREQ", "PRE-REQ", "PROG", "PROGRAM", "TIME", "TIME-CNFLT", "CHRT", "COHORT"};

    public XEBatchSolverSaver(Solver solver) {
        super(solver);
        this.iInitiative = solver.getProperties().getProperty("Data.Initiative");
        this.iYear = solver.getProperties().getProperty("Data.Year");
        this.iTerm = solver.getProperties().getProperty("Data.Term");
        this.iOwnerId = solver.getProperties().getProperty("General.OwnerPuid");
        this.iProgress = Progress.getInstance((Object)this.getModel());
        try {
            String clazz = ApplicationProperty.CustomizationExternalTerm.value();
            this.iExternalTermProvider = clazz == null || clazz.isEmpty() ? new BannerTermProvider() : (ExternalTermProvider)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            sLog.error((Object)"Failed to create external term provider, using the default one instead.", (Throwable)e);
            this.iExternalTermProvider = new BannerTermProvider();
        }
        this.iHoldPassword = solver.getProperties().getProperty("Save.XE.HoldPassword");
        this.iRegistrationDate = solver.getProperties().getProperty("Save.XE.RegistrationDate");
        this.iActionAdd = solver.getProperties().getProperty("Save.XE.ActionAdd", "RE");
        this.iActionDrop = solver.getProperties().getProperty("Save.XE.ActionDrop", "DDD");
        this.iConditionalAddDrop = solver.getProperties().getPropertyBoolean("Save.XE.ConditionalAddDrop", true);
        this.iAutoOverrides = solver.getProperties().getPropertyBoolean("Save.XE.AutoOverrides", false);
        String allowedOverrides = solver.getProperties().getProperty("Save.XE.AllowedOverrides", null);
        if (allowedOverrides != null && !allowedOverrides.isEmpty()) {
            this.iAllowedOverrides = new HashSet<String>(Arrays.asList(allowedOverrides.split(",")));
        }
        this.iNrThreads = solver.getProperties().getPropertyInt("Save.XE.NrSaveThreads", 10);
        this.iCSV = new InMemoryReport("XE", "Last XE Enrollment Results (" + Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP_SHORT).format(new Date()) + ")");
        ((StudentSolver)solver).setReport(this.iCSV);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void save() throws Exception {
        block14: {
            this.iProgress.setStatus("Saving solution ...");
            ArrayList<Protocol> protocols = new ArrayList<Protocol>();
            protocols.add(Protocol.HTTP);
            protocols.add(Protocol.HTTPS);
            this.iClient = new Client(protocols);
            this.iCSV.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"PUID"), new CSVFile.CSVField((Object)"Name"), new CSVFile.CSVField((Object)"Course"), new CSVFile.CSVField((Object)"CRN"), new CSVFile.CSVField((Object)"Request"), new CSVFile.CSVField((Object)"Status"), new CSVFile.CSVField((Object)"Message"), new CSVFile.CSVField((Object)"Used Override")});
            org.hibernate.Session hibSession = null;
            Transaction tx = null;
            hibSession = SessionDAO.getInstance().getSession();
            hibSession.setCacheMode(CacheMode.IGNORE);
            hibSession.setFlushMode(FlushMode.MANUAL);
            tx = hibSession.beginTransaction();
            Session session = Session.getSessionUsingInitiativeYearTerm(this.iInitiative, this.iYear, this.iTerm);
            if (session == null) {
                throw new Exception("Session " + this.iInitiative + " " + this.iTerm + this.iYear + " not found!");
            }
            ApplicationProperties.setSessionId(session.getUniqueId());
            this.iSession = new AcademicSessionInfo(session);
            this.save(session, hibSession);
            if (!this.iUpdatedStudents.isEmpty() && CustomStudentEnrollmentHolder.isCanRequestUpdates()) {
                CustomStudentEnrollmentHolder.getProvider().requestUpdate((OnlineSectioningServer)this.getSolver(), new OnlineSectioningHelper(hibSession, this.getUser()), this.iUpdatedStudents);
            }
            hibSession.flush();
            tx.commit();
            tx = null;
            Object var6_6 = null;
            if (hibSession != null && hibSession.isOpen()) {
                hibSession.close();
            }
            try {
                this.iClient.stop();
            }
            catch (Exception e2) {
                sLog.error((Object)e2.getMessage(), (Throwable)e2);
            }
            break block14;
            {
                catch (Exception e) {
                    this.iProgress.fatal("Unable to save , reason: " + e.getMessage(), (Throwable)e);
                    sLog.error((Object)e.getMessage(), (Throwable)e);
                    if (tx != null) {
                        tx.rollback();
                    }
                    Object var6_7 = null;
                    if (hibSession != null && hibSession.isOpen()) {
                        hibSession.close();
                    }
                    try {
                        this.iClient.stop();
                    }
                    catch (Exception e2) {
                        sLog.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (hibSession != null && hibSession.isOpen()) {
                    hibSession.close();
                }
                try {
                    this.iClient.stop();
                }
                catch (Exception e2) {
                    sLog.error((Object)e2.getMessage(), (Throwable)e2);
                }
                throw throwable;
            }
        }
    }

    public void save(Session session, org.hibernate.Session hibSession) {
        this.setPhase("Loading classes...", 1L);
        this.iClasses = new Hashtable();
        for (Class_ clazz : hibSession.createQuery("select distinct c from Class_ c where c.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
            this.iClasses.put(clazz.getUniqueId(), clazz);
        }
        this.incProgress();
        this.iCourses = new Hashtable();
        this.setPhase("Loading courses...", 1L);
        for (CourseOffering course : hibSession.createQuery("select distinct c from CourseOffering c where c.subjectArea.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
            this.iCourses.put(course.getUniqueId(), course);
        }
        this.incProgress();
        this.setPhase("Enrolling students...", ((StudentSectioningModel)this.getModel()).getStudents().size());
        if (this.iNrThreads <= 1) {
            for (Student student : ((StudentSectioningModel)this.getModel()).getStudents()) {
                this.incProgress();
                if (student.isDummy()) continue;
                this.saveStudent(student);
            }
        } else {
            ArrayList<Worker> workers = new ArrayList<Worker>();
            Iterator<Student> students = ((StudentSectioningModel)this.getModel()).getStudents().iterator();
            for (int i = 0; i < this.iNrThreads; ++i) {
                workers.add(new Worker(i, students));
            }
            for (Worker worker : workers) {
                worker.start();
            }
            for (Worker worker : workers) {
                try {
                    worker.join();
                }
                catch (InterruptedException e) {
                    this.iCanContinue = false;
                    try {
                        worker.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (!this.iCanContinue) {
                throw new RuntimeException("The save was interrupted.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void saveStudent(Student student) {
        ArrayList<CSVFile.CSVField[]> csv;
        OnlineSectioningLog.Action.Builder action;
        block20: {
            long c0 = OnlineSectioningHelper.getCpuTime();
            action = OnlineSectioningLog.Action.newBuilder();
            action.setOperation("batch-enroll");
            action.setSession(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.iSession.getUniqueId()).setName(this.iSession.toCompactString()));
            action.setStartTime(System.currentTimeMillis());
            action.setUser(this.getUser());
            action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(student.getId()).setExternalId(student.getExternalId()).setName(student.getName()).setType(OnlineSectioningLog.Entity.EntityType.STUDENT));
            OnlineSectioningLog.Enrollment.Builder requested = OnlineSectioningLog.Enrollment.newBuilder();
            requested.setType(OnlineSectioningLog.Enrollment.EnrollmentType.REQUESTED);
            for (Request request : student.getRequests()) {
                Enrollment e;
                action.addRequest(OnlineSectioningHelper.toProto(request));
                if (!(request instanceof CourseRequest) || (e = (Enrollment)this.getAssignment().getValue((Variable)request)) == null) continue;
                for (Section section : e.getSections()) {
                    requested.addSection(OnlineSectioningHelper.toProto((SctAssignment)section, e));
                }
            }
            action.addEnrollment(requested);
            csv = new ArrayList<CSVFile.CSVField[]>();
            try {
                Object var12_11;
                try {
                    this.enroll(student, this.getCrns(student), action, csv);
                }
                catch (Exception e) {
                    if (e instanceof SectioningException) {
                        if (e.getCause() == null) {
                            this.iProgress.info("Enrollment failed: " + e.getMessage());
                        } else {
                            this.iProgress.warn("Enrollment failed: " + e.getMessage(), e.getCause());
                        }
                    } else {
                        this.iProgress.error("Enrollment failed: " + e.getMessage(), (Throwable)e);
                    }
                    String puid = this.getBannerId(student);
                    for (String id : this.getCrns(student)) {
                        if (id == null) continue;
                        csv.add(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)puid), new CSVFile.CSVField((Object)student.getName()), new CSVFile.CSVField((Object)this.getCourseNameForCrn(student, id)), new CSVFile.CSVField((Object)id), new CSVFile.CSVField((Object)"Add"), new CSVFile.CSVField((Object)"Failed"), new CSVFile.CSVField((Object)e.getMessage())});
                    }
                    action.setResult(OnlineSectioningLog.Action.ResultType.FAILURE);
                    if (e.getMessage() != null) {
                        action.setApiException(e.getMessage());
                    }
                    if (e.getCause() != null && e instanceof SectioningException) {
                        action.addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.FATAL).setText(e.getCause().getClass().getName() + ": " + e.getCause().getMessage()));
                    } else {
                        action.addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.FATAL).setText(e.getMessage() == null ? "null" : e.getMessage()));
                    }
                    var12_11 = null;
                    action.setEndTime(System.currentTimeMillis()).setCpuTime(OnlineSectioningHelper.getCpuTime() - c0);
                    break block20;
                }
                var12_11 = null;
                action.setEndTime(System.currentTimeMillis()).setCpuTime(OnlineSectioningHelper.getCpuTime() - c0);
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                action.setEndTime(System.currentTimeMillis()).setCpuTime(OnlineSectioningHelper.getCpuTime() - c0);
                throw throwable;
            }
        }
        StringBuffer table = new StringBuffer();
        InMemoryReport inMemoryReport = this.iCSV;
        synchronized (inMemoryReport) {
            Iterator<Object> iterator = csv.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    action.addOptionBuilder().setKey("table").setValue(table.toString());
                    this.iUpdatedStudents.add(new XStudent(student, (Assignment<Request, Enrollment>)this.getAssignment()));
                    // MONITOREXIT @DISABLED, blocks:[3, 9, 11] lbl87 : MonitorExitStatement: MONITOREXIT : inMemoryReport
                    OnlineSectioningLogger.getInstance().record(OnlineSectioningLog.Log.newBuilder().addAction(action).build());
                    return;
                }
                CSVFile.CSVField[] line = (CSVFile.CSVField[])iterator.next();
                if (table.length() > 0) {
                    table.append("\n");
                }
                table.append(this.iCSV.addLine(line));
            }
        }
    }

    protected Set<String> getCrns(Student student) {
        TreeSet<String> crns = new TreeSet<String>();
        for (Request request : student.getRequests()) {
            Enrollment enrollment = (Enrollment)this.getAssignment().getValue((Variable)request);
            if (enrollment == null || !enrollment.isCourseRequest()) continue;
            CourseOffering course = this.iCourses.get(enrollment.getCourse().getId());
            for (Section section : enrollment.getSections()) {
                Class_ clazz = this.iClasses.get(section.getId());
                if (clazz == null || course == null) continue;
                crns.add(clazz.getExternalId(course));
            }
        }
        return crns;
    }

    protected Gson getGson() {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new JsonSerializer<DateTime>(){

            public JsonElement serialize(DateTime src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.toString("yyyy-MM-dd'T'HH:mm:ss'Z'"));
            }
        }).registerTypeAdapter(DateTime.class, (Object)new JsonDeserializer<DateTime>(){

            public DateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return new DateTime((Object)json.getAsJsonPrimitive().getAsString(), DateTimeZone.UTC);
            }
        });
        return builder.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void enroll(Student student, Set<String> crns, OnlineSectioningLog.Action.Builder action, List<CSVFile.CSVField[]> csv) throws IOException {
        this.iProgress.info("[" + student.getExternalId() + "] " + student.getName() + " " + crns);
        ClientResource resource = null;
        try {
            String op;
            String id4;
            resource = new ClientResource(ApplicationProperties.getProperty("banner.xe.site"));
            resource.setNext((Uniform)this.iClient);
            resource.setChallengeResponse(ChallengeScheme.HTTP_BASIC, ApplicationProperties.getProperty("banner.xe.admin.user"), ApplicationProperties.getProperty("banner.xe.admin.password"));
            String term = this.iExternalTermProvider.getExternalTerm(this.iSession);
            String campus = this.iExternalTermProvider.getExternalCampus(this.iSession);
            String puid = this.getBannerId(student);
            resource.addQueryParameter("term", term);
            resource.addQueryParameter("bannerId", puid);
            resource.addQueryParameter("systemIn", "SB");
            resource.addQueryParameter("persona", "SB");
            if (this.iHoldPassword != null && !this.iHoldPassword.isEmpty()) {
                resource.addQueryParameter("holdPassword", this.iHoldPassword);
            }
            action.addOptionBuilder().setKey("term").setValue(term);
            action.addOptionBuilder().setKey("bannerId").setValue(this.getBannerId(student));
            Gson gson = this.getGson();
            long t0 = System.currentTimeMillis();
            XEInterface.RegisterResponse original = null;
            try {
                original = this.getSchedule(student, resource);
                Object var14_12 = null;
                action.setApiGetTime(System.currentTimeMillis() - t0);
            }
            catch (Throwable throwable) {
                Object var14_13 = null;
                action.setApiGetTime(System.currentTimeMillis() - t0);
                throw throwable;
            }
            action.addOptionBuilder().setKey("original").setValue(gson.toJson((Object)original));
            HashSet<String> noadd = new HashSet<String>();
            HashSet<String> nodrop = new HashSet<String>();
            HashSet<String> notregistered = new HashSet<String>();
            HashMap<String, XEInterface.Registration> registered = new HashMap<String, XEInterface.Registration>();
            if (original.registrations != null) {
                OnlineSectioningLog.Enrollment.Builder previous = OnlineSectioningLog.Enrollment.newBuilder();
                previous.setType(OnlineSectioningLog.Enrollment.EnrollmentType.PREVIOUS);
                for (XEInterface.Registration registration : original.registrations) {
                    if (registration.isRegistered()) {
                        registered.put(registration.courseReferenceNumber, registration);
                        if (!registration.can(this.iActionDrop)) {
                            nodrop.add(registration.courseReferenceNumber);
                        }
                        previous.addSectionBuilder().setClazz(OnlineSectioningLog.Entity.newBuilder().setName(registration.courseReferenceNumber)).setCourse(OnlineSectioningLog.Entity.newBuilder().setName(registration.subject + " " + registration.courseNumber)).setSubpart(OnlineSectioningLog.Entity.newBuilder().setName(registration.scheduleType));
                        continue;
                    }
                    notregistered.add(registration.courseReferenceNumber);
                    if (registration.can(this.iActionAdd)) continue;
                    noadd.add(registration.courseReferenceNumber);
                }
                action.addEnrollment(previous);
            }
            action.setResult(OnlineSectioningLog.Action.ResultType.TRUE);
            HashSet<String> added = new HashSet<String>();
            XEInterface.RegisterRequest req = new XEInterface.RegisterRequest(term, puid, null, true);
            if (this.iHoldPassword != null && !this.iHoldPassword.isEmpty()) {
                req.holdPassword = this.iHoldPassword;
            }
            if (this.iRegistrationDate != null && !this.iRegistrationDate.isEmpty()) {
                req.registrationDate = this.iRegistrationDate;
            }
            if (this.iConditionalAddDrop) {
                req.conditionalAddDrop = "Y";
            }
            for (String string : crns) {
                if (string == null) continue;
                if (!registered.containsKey(string) && noadd.contains(string)) {
                    csv.add(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)puid), new CSVFile.CSVField((Object)student.getName()), new CSVFile.CSVField((Object)this.getCourseNameForCrn(student, string)), new CSVFile.CSVField((Object)string), new CSVFile.CSVField((Object)"Add"), new CSVFile.CSVField((Object)"Failed"), new CSVFile.CSVField((Object)("Action " + this.iActionAdd + " is not allowed."))});
                    this.iProgress.warn("[" + student.getExternalId() + "] " + string + ": Action " + this.iActionAdd + " is not allowed.");
                    action.setResult(OnlineSectioningLog.Action.ResultType.FALSE);
                    action.addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.WARN).setText(string + ": Action " + this.iActionAdd + " is not allowed."));
                    continue;
                }
                if (registered.containsKey(string)) {
                    if (!added.add(string)) continue;
                    this.keep(req, string);
                    continue;
                }
                if (!added.add(string)) continue;
                this.add(req, string, notregistered.contains(string));
            }
            HashSet<String> hashSet = new HashSet<String>();
            for (String id2 : registered.keySet()) {
                if (added.contains(id2)) continue;
                XEInterface.Registration reg = (XEInterface.Registration)registered.get(id2);
                if (!campus.equals(reg.campus)) {
                    if (!added.add(id2)) continue;
                    this.keep(req, id2);
                    continue;
                }
                if (nodrop.contains(id2)) {
                    csv.add(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)puid), new CSVFile.CSVField((Object)student.getName()), new CSVFile.CSVField((Object)(reg.subject + " " + reg.courseNumber)), new CSVFile.CSVField((Object)id2), new CSVFile.CSVField((Object)"Drop"), new CSVFile.CSVField((Object)"Failed"), new CSVFile.CSVField((Object)("Action " + this.iActionDrop + " is not allowed."))});
                    this.iProgress.warn("[" + student.getExternalId() + "] " + id2 + ": Action " + this.iActionDrop + " is not allowed.");
                    action.setResult(OnlineSectioningLog.Action.ResultType.FALSE);
                    action.addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.WARN).setText(id2 + ": Action " + this.iActionDrop + " is not allowed."));
                    if (!added.add(id2)) continue;
                    this.keep(req, id2);
                    continue;
                }
                this.drop(req, id2);
                hashSet.add(id2);
            }
            HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
            action.addOptionBuilder().setKey("request").setValue(gson.toJson((Object)req));
            long t1 = System.currentTimeMillis();
            XEInterface.RegisterResponse response = null;
            try {
                response = this.postChanges(resource, req);
                Object var25_30 = null;
                action.setApiPostTime(System.currentTimeMillis() - t1);
            }
            catch (Throwable throwable) {
                Object var25_31 = null;
                action.setApiPostTime(System.currentTimeMillis() - t1);
                throw throwable;
            }
            action.addOptionBuilder().setKey("response").setValue(gson.toJson((Object)response));
            int index = 1;
            while (this.iAutoOverrides && response.registrations != null) {
                Object var33_48;
                boolean changed = false;
                for (XEInterface.Registration registration : response.registrations) {
                    id4 = registration.courseReferenceNumber;
                    if (registration.crnErrors != null && "F".equals(registration.statusIndicator)) {
                        for (XEInterface.CrnError e : registration.crnErrors) {
                            String override = this.getDefaultOverride(student, id4, e.messageType);
                            if (override == null || !this.iAllowedOverrides.contains(override) || !this.addOverride(student, req, id4, override, hashMap)) continue;
                            changed = true;
                            break;
                        }
                    }
                    if (this.iConditionalAddDrop || !hashSet.contains(registration.courseReferenceNumber) || !"Deleted".equals(registration.statusDescription) && !"Dropped".equals(registration.statusDescription)) continue;
                    this.removeAction(req, registration.courseReferenceNumber);
                }
                if (!changed) break;
                action.addOptionBuilder().setKey("request-override-" + index).setValue(gson.toJson((Object)req));
                long t2 = System.currentTimeMillis();
                try {
                    response = this.postChanges(resource, req);
                    var33_48 = null;
                    action.setApiPostTime(System.currentTimeMillis() - t2 + action.getApiPostTime());
                }
                catch (Throwable throwable) {
                    var33_48 = null;
                    action.setApiPostTime(System.currentTimeMillis() - t2 + action.getApiPostTime());
                    throw throwable;
                }
                action.addOptionBuilder().setKey("response-override-" + index).setValue(gson.toJson((Object)response));
                ++index;
            }
            HashSet<String> checked = new HashSet<String>();
            if (response.registrations != null) {
                OnlineSectioningLog.Enrollment.Builder stored = OnlineSectioningLog.Enrollment.newBuilder();
                stored.setType(OnlineSectioningLog.Enrollment.EnrollmentType.STORED);
                for (XEInterface.Registration reg : response.registrations) {
                    String op2;
                    if ("Registered".equals(reg.statusDescription)) {
                        stored.addSectionBuilder().setClazz(OnlineSectioningLog.Entity.newBuilder().setName(reg.courseReferenceNumber)).setCourse(OnlineSectioningLog.Entity.newBuilder().setName(reg.subject + " " + reg.courseNumber)).setSubpart(OnlineSectioningLog.Entity.newBuilder().setName(reg.scheduleType));
                    }
                    String id3 = reg.courseReferenceNumber;
                    checked.add(id3);
                    String string = op2 = added.contains(id3) ? "Add" : "Drop";
                    if (notregistered.contains(id3)) continue;
                    String error = null;
                    if (reg.crnErrors != null && !reg.crnErrors.isEmpty()) {
                        for (XEInterface.CrnError e : reg.crnErrors) {
                            if (error == null) {
                                error = e.messageType + ": " + e.message;
                                continue;
                            }
                            error = error + "\n" + e.messageType + ": " + e.message;
                        }
                    }
                    csv.add(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)puid), new CSVFile.CSVField((Object)student.getName()), new CSVFile.CSVField((Object)(reg.subject + " " + reg.courseNumber)), new CSVFile.CSVField((Object)id3), new CSVFile.CSVField((Object)op2), new CSVFile.CSVField((Object)reg.statusDescription), new CSVFile.CSVField((Object)error), new CSVFile.CSVField((Object)this.getOverride(req, id3, hashMap))});
                    if (error == null) continue;
                    if ("F".equals(reg.statusIndicator)) {
                        this.iProgress.warn("[" + student.getExternalId() + "] " + id3 + ": " + error);
                        action.setResult(OnlineSectioningLog.Action.ResultType.FALSE);
                        action.addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.WARN).setText(id3 + ": " + error));
                        continue;
                    }
                    this.iProgress.info("[" + student.getExternalId() + "] " + id3 + ": " + error);
                    action.addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.INFO).setText(id3 + ": " + error));
                }
                action.addEnrollment(stored);
            }
            if (response.failedRegistrations != null) {
                for (XEInterface.FailedRegistration failedRegistration : response.failedRegistrations) {
                    if (failedRegistration.failedCRN == null || failedRegistration.failure == null) continue;
                    id4 = failedRegistration.failedCRN;
                    checked.add(id4);
                    op = added.contains(id4) ? "Add" : "Drop";
                    String error = failedRegistration.failure;
                    csv.add(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)puid), new CSVFile.CSVField((Object)student.getName()), new CSVFile.CSVField((Object)this.getCourseNameForCrn(student, id4)), new CSVFile.CSVField((Object)id4), new CSVFile.CSVField((Object)op), new CSVFile.CSVField((Object)"Failed"), new CSVFile.CSVField((Object)error), new CSVFile.CSVField((Object)this.getOverride(req, id4, hashMap))});
                    this.iProgress.warn("[" + student.getExternalId() + "] " + id4 + ": " + error);
                    action.setResult(OnlineSectioningLog.Action.ResultType.FALSE);
                    action.addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.WARN).setText(id4 + ": " + error));
                }
            }
            boolean ex = false;
            for (String id4 : crns) {
                if (id4 == null || checked.contains(id4)) continue;
                op = added.contains(id4) ? "Add" : "Drop";
                ex = true;
                csv.add(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)puid), new CSVFile.CSVField((Object)student.getName()), new CSVFile.CSVField((Object)this.getCourseNameForCrn(student, id4)), new CSVFile.CSVField((Object)id4), new CSVFile.CSVField((Object)op), new CSVFile.CSVField((Object)"Exception"), new CSVFile.CSVField((Object)response.registrationException)});
            }
            if (response.registrationException != null && !ex) {
                csv.add(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)puid), new CSVFile.CSVField((Object)student.getName()), new CSVFile.CSVField(null), new CSVFile.CSVField(null), new CSVFile.CSVField(null), new CSVFile.CSVField((Object)"Exception"), new CSVFile.CSVField((Object)response.registrationException)});
            }
            if (response.registrationException != null) {
                action.setResult(OnlineSectioningLog.Action.ResultType.FAILURE);
                action.addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.ERROR).setText(response.registrationException));
            }
            if (response.registrationException != null) {
                this.iProgress.warn("[" + student.getExternalId() + "] " + response.registrationException);
            }
            Object var35_51 = null;
            if (resource == null) return;
        }
        catch (Throwable throwable) {
            Object var35_52 = null;
            if (resource == null) throw throwable;
            if (resource.getResponse() != null) {
                resource.getResponse().release();
            }
            resource.release();
            throw throwable;
        }
        if (resource.getResponse() != null) {
            resource.getResponse().release();
        }
        resource.release();
    }

    protected boolean addOverride(Student student, XEInterface.RegisterRequest req, String id, String override, Map<String, Set<String>> overrides) {
        if (req.courseReferenceNumbers == null) {
            return false;
        }
        for (XEInterface.CourseReferenceNumber crn : req.courseReferenceNumbers) {
            if (!id.equals(crn.courseReferenceNumber)) continue;
            this.iProgress.debug("[" + student.getExternalId() + "] Adding override " + override + " for " + id);
            crn.courseOverride = override;
            Set<String> list = overrides.get(id);
            if (list == null) {
                list = new TreeSet<String>();
                overrides.put(id, list);
            }
            return list.add(override);
        }
        this.iProgress.warn("[" + student.getExternalId() + "] Failed to add override " + override + " for " + id);
        return false;
    }

    protected String getOverride(XEInterface.RegisterRequest req, String id, Map<String, Set<String>> overrides) {
        Set<String> list = overrides.get(id);
        if (list != null) {
            String ret = "";
            for (String override : list) {
                ret = ret + (ret.isEmpty() ? "" : ",") + override;
            }
            return ret;
        }
        if (req.courseReferenceNumbers != null) {
            for (XEInterface.CourseReferenceNumber crn : req.courseReferenceNumbers) {
                if (!id.equals(crn.courseReferenceNumber)) continue;
                return crn.courseOverride;
            }
        }
        return null;
    }

    protected XEInterface.RegisterResponse getSchedule(Student student, ClientResource resource) throws IOException {
        try {
            resource.get(MediaType.APPLICATION_JSON);
        }
        catch (ResourceException e) {
            this.handleError(resource, (Exception)((Object)e));
        }
        List current = (List)new GsonRepresentation(resource.getResponseEntity(), XEInterface.RegisterResponse.TYPE_LIST).getObject();
        XEInterface.RegisterResponse original = null;
        if (current != null && !current.isEmpty()) {
            original = (XEInterface.RegisterResponse)current.get(0);
        }
        if (original == null || !original.validStudent.booleanValue()) {
            String reason = null;
            if (original != null && original.failureReasons != null) {
                for (String m : original.failureReasons) {
                    if ("Holds prevent registration.".equals(m) && this.iHoldPassword != null && !this.iHoldPassword.isEmpty()) {
                        return this.getHoldSchedule(student, resource);
                    }
                    if ("Invalid or undefined Enrollment Status or date range invalid.".equals(m) && this.iRegistrationDate != null && !this.iRegistrationDate.isEmpty()) {
                        return this.getHoldSchedule(student, resource);
                    }
                    if (m == null) continue;
                    reason = m;
                }
            }
            if (reason != null) {
                throw new SectioningException(reason);
            }
            throw new SectioningException("Failed to check student registration status.");
        }
        return original;
    }

    protected XEInterface.RegisterResponse getHoldSchedule(Student student, ClientResource resource) throws IOException {
        if (this.iHoldPassword != null && !this.iHoldPassword.isEmpty()) {
            this.iProgress.debug("[" + student.getExternalId() + "] Using hold password...");
        }
        if (this.iRegistrationDate != null && !this.iRegistrationDate.isEmpty()) {
            this.iProgress.debug("[" + student.getExternalId() + "] Using registration date...");
        }
        XEInterface.RegisterRequest req = new XEInterface.RegisterRequest(resource.getQueryValue("term"), resource.getQueryValue("bannerId"), null, true);
        req.empty();
        if (this.iHoldPassword != null && !this.iHoldPassword.isEmpty()) {
            req.holdPassword = this.iHoldPassword;
        }
        if (this.iRegistrationDate != null && !this.iRegistrationDate.isEmpty()) {
            req.registrationDate = this.iRegistrationDate;
        }
        try {
            resource.post(new GsonRepresentation<XEInterface.RegisterRequest>(req));
        }
        catch (ResourceException e) {
            this.handleError(resource, (Exception)((Object)e));
        }
        XEInterface.RegisterResponse response = new GsonRepresentation<XEInterface.RegisterResponse>(resource.getResponseEntity(), XEInterface.RegisterResponse.class).getObject();
        if (response == null) {
            throw new SectioningException("Failed to check student registration status.");
        }
        if (!response.validStudent.booleanValue()) {
            String reason = null;
            if (response.failureReasons != null) {
                for (String m : response.failureReasons) {
                    if (reason == null) {
                        reason = m;
                        continue;
                    }
                    reason = reason + "\n" + m;
                }
            }
            if (reason != null) {
                throw new SectioningException(reason);
            }
            throw new SectioningException("Failed to check student registration status.");
        }
        return response;
    }

    protected XEInterface.RegisterResponse postChanges(ClientResource resource, XEInterface.RegisterRequest req) throws IOException {
        if (req.isEmpty()) {
            req.empty();
        }
        try {
            resource.post(new GsonRepresentation<XEInterface.RegisterRequest>(req));
        }
        catch (ResourceException e) {
            this.handleError(resource, (Exception)((Object)e));
        }
        XEInterface.RegisterResponse response = new GsonRepresentation<XEInterface.RegisterResponse>(resource.getResponseEntity(), XEInterface.RegisterResponse.class).getObject();
        if (response == null) {
            throw new SectioningException("Failed to enroll student.");
        }
        if (!response.validStudent.booleanValue()) {
            String reason = null;
            if (response.failureReasons != null) {
                for (String m : response.failureReasons) {
                    if (reason == null) {
                        reason = m;
                        continue;
                    }
                    reason = reason + "\n" + m;
                }
            }
            if (reason != null) {
                throw new SectioningException(reason);
            }
            throw new SectioningException("Failed to enroll student.");
        }
        return response;
    }

    protected void handleError(ClientResource resource, Exception exception) {
        try {
            XEInterface.ErrorResponse response = new GsonRepresentation<XEInterface.ErrorResponse>(resource.getResponseEntity(), XEInterface.ErrorResponse.class).getObject();
            XEInterface.Error error = response.getError();
            if (error != null && error.message != null) {
                throw new SectioningException(error.message);
            }
            if (error != null && error.description != null) {
                throw new SectioningException(error.description);
            }
            if (error != null && error.errorMessage != null) {
                throw new SectioningException(error.errorMessage);
            }
            throw exception;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new SectioningException(exception.getMessage(), exception);
        }
    }

    protected String getBannerId(Student student) {
        String id = student.getExternalId();
        while (id.length() < 9) {
            id = "0" + id;
        }
        return id;
    }

    public String getCourseNameForCrn(Student student, String crn) {
        for (Request request : student.getRequests()) {
            Enrollment enrollment = (Enrollment)this.getAssignment().getValue((Variable)request);
            if (enrollment == null || !enrollment.isCourseRequest()) continue;
            CourseOffering course = this.iCourses.get(enrollment.getCourse().getId());
            for (Section section : enrollment.getSections()) {
                Class_ clazz = this.iClasses.get(section.getId());
                if (clazz == null || course == null || !crn.equals(clazz.getExternalId(course))) continue;
                return course.getCourseName();
            }
        }
        return null;
    }

    public OfferingConsentType getConsent(Student student, String crn) {
        for (Request request : student.getRequests()) {
            Enrollment enrollment = (Enrollment)this.getAssignment().getValue((Variable)request);
            if (enrollment == null || !enrollment.isCourseRequest()) continue;
            CourseOffering course = this.iCourses.get(enrollment.getCourse().getId());
            for (Section section : enrollment.getSections()) {
                Class_ clazz = this.iClasses.get(section.getId());
                if (clazz == null || course == null || !crn.equals(clazz.getExternalId(course))) continue;
                return course.getConsentType();
            }
        }
        return null;
    }

    protected OnlineSectioningLog.Entity getUser() {
        return OnlineSectioningLog.Entity.newBuilder().setExternalId(this.iOwnerId).setType(OnlineSectioningLog.Entity.EntityType.MANAGER).build();
    }

    protected void add(XEInterface.RegisterRequest req, String id, boolean changeStatus) {
        if (this.iActionAdd == null) {
            req.add(id, changeStatus);
        } else if (changeStatus) {
            if (req.actionsAndOptions == null) {
                req.actionsAndOptions = new ArrayList<XEInterface.RegisterAction>();
            }
            req.actionsAndOptions.add(new XEInterface.RegisterAction(this.iActionAdd, id));
        } else {
            if (req.courseReferenceNumbers == null) {
                req.courseReferenceNumbers = new ArrayList<XEInterface.CourseReferenceNumber>();
            }
            req.courseReferenceNumbers.add(new XEInterface.CourseReferenceNumber(id, this.iActionAdd));
        }
    }

    protected void keep(XEInterface.RegisterRequest req, String id) {
        req.keep(id);
    }

    protected void drop(XEInterface.RegisterRequest req, String id) {
        if (this.iActionDrop == null) {
            req.drop(id, null);
        } else {
            if (req.actionsAndOptions == null) {
                req.actionsAndOptions = new ArrayList<XEInterface.RegisterAction>();
            }
            req.actionsAndOptions.add(new XEInterface.RegisterAction(this.iActionDrop, id));
        }
    }

    protected boolean removeAction(XEInterface.RegisterRequest req, String id) {
        if (req.actionsAndOptions == null) {
            return false;
        }
        Iterator<XEInterface.RegisterAction> i = req.actionsAndOptions.iterator();
        while (i.hasNext()) {
            XEInterface.RegisterAction action = i.next();
            if (!id.equals(action.courseReferenceNumber)) continue;
            i.remove();
            return true;
        }
        return false;
    }

    protected String getDefaultOverride(Student student, String crn, String messageType) {
        String override = null;
        if ("DEPT".equals(messageType) || "SAPR".equals(messageType)) {
            OfferingConsentType consent = this.getConsent(student, crn);
            override = consent != null && "IN".equals(consent.getReference()) ? "INST-PERMT" : (consent != null && "DP".equals(consent.getReference()) ? "DPT-PERMIT" : "HONORS");
        } else {
            for (int i = 0; i < defaultOverrides.length; i += 2) {
                if (!messageType.equals(defaultOverrides[i])) continue;
                override = defaultOverrides[i + 1];
            }
        }
        return this.getSolver().getProperties().getProperty("Save.XE.Override." + messageType, override);
    }

    protected void checkTermination() {
        if (this.getTerminationCondition() != null && !this.getTerminationCondition().canContinue(this.getSolution())) {
            throw new RuntimeException("The save was interrupted.");
        }
    }

    protected void setPhase(String phase, long progressMax) {
        this.checkTermination();
        this.iProgress.setPhase(phase, progressMax);
    }

    protected void incProgress() {
        this.checkTermination();
        this.iProgress.incProgress();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Worker
    extends Thread {
        private Iterator<Student> iStudents;

        public Worker(int index, Iterator<Student> students) {
            this.setName("XESaver-" + (1 + index));
            this.iStudents = students;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            XEBatchSolverSaver.this.iProgress.debug(this.getName() + " has started.");
            while (true) {
                Student student = null;
                Iterator<Student> iterator = this.iStudents;
                synchronized (iterator) {
                    if (!XEBatchSolverSaver.this.iCanContinue) {
                        XEBatchSolverSaver.this.iProgress.debug(this.getName() + " has stopped.");
                        return;
                    }
                    if (!this.iStudents.hasNext()) {
                        break;
                    }
                    student = this.iStudents.next();
                    XEBatchSolverSaver.this.iProgress.incProgress();
                }
                if (student.isDummy()) continue;
                XEBatchSolverSaver.this.saveStudent(student);
            }
            XEBatchSolverSaver.this.iProgress.debug(this.getName() + " has finished.");
        }
    }
}

