/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.basic;

import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CustomCourseRequestsValidationHolder;
import org.unitime.timetable.onlinesectioning.match.CourseMatcher;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XStudent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckCourses
implements OnlineSectioningAction<CourseRequestInterface.CheckCoursesResponse> {
    private static final long serialVersionUID = 1L;
    protected static final StudentSectioningMessages MESSAGES = Localization.create(StudentSectioningMessages.class);
    private CourseRequestInterface iRequest;
    private CourseMatcher iMatcher;
    private boolean iCustomValidation = false;

    public CheckCourses forRequest(CourseRequestInterface request) {
        this.iRequest = request;
        return this;
    }

    public CheckCourses withMatcher(CourseMatcher matcher) {
        this.iMatcher = matcher;
        return this;
    }

    public CheckCourses withCustomValidation(boolean validation) {
        this.iCustomValidation = validation;
        return this;
    }

    @Override
    public CourseRequestInterface.CheckCoursesResponse execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        XStudent student;
        OnlineSectioningLog.Action.Builder action = helper.getAction();
        if (this.iMatcher != null) {
            this.iMatcher.setServer(server);
        }
        CourseRequestInterface.CheckCoursesResponse response = new CourseRequestInterface.CheckCoursesResponse();
        if (this.iRequest.getStudentId() != null) {
            action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.iRequest.getStudentId()));
        }
        XStudent xStudent = student = this.iRequest.getStudentId() == null ? null : server.getStudent(this.iRequest.getStudentId());
        if (student != null) {
            action.getStudentBuilder().setExternalId(student.getExternalId());
            action.getStudentBuilder().setName(student.getName());
        }
        for (OnlineSectioningLog.Request r : OnlineSectioningHelper.toProto(this.iRequest)) {
            action.addRequest(r);
        }
        for (CourseRequestInterface.Request cr : this.iRequest.getCourses()) {
            if (!cr.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse rc : cr.getRequestedCourse()) {
                if (!rc.isCourse() || this.lookup(server, student, rc) != null) continue;
                response.addError(rc.getCourseId(), rc.getCourseName(), "NOT_FOUND", MESSAGES.validationCourseNotExists(rc.getCourseName()));
                response.setErrorMessage(MESSAGES.validationCourseNotExists(rc.getCourseName()));
            }
        }
        for (CourseRequestInterface.Request cr : this.iRequest.getAlternatives()) {
            if (!cr.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse rc : cr.getRequestedCourse()) {
                if (!rc.isCourse() || this.lookup(server, student, rc) != null) continue;
                response.addError(rc.getCourseId(), rc.getCourseName(), "NOT_FOUND", MESSAGES.validationCourseNotExists(rc.getCourseName()));
                response.setErrorMessage(MESSAGES.validationCourseNotExists(rc.getCourseName()));
            }
        }
        if (this.iCustomValidation && CustomCourseRequestsValidationHolder.hasProvider()) {
            CustomCourseRequestsValidationHolder.getProvider().validate(server, helper, this.iRequest, response);
        }
        if (response.hasMessages()) {
            for (CourseRequestInterface.CourseMessage m : response.getMessages()) {
                if (!m.hasCourse()) continue;
                action.addMessageBuilder().setText(m.toString()).setLevel(m.isError() ? OnlineSectioningLog.Message.Level.ERROR : (m.isConfirm() ? OnlineSectioningLog.Message.Level.WARN : OnlineSectioningLog.Message.Level.INFO));
            }
        }
        if (response.isError()) {
            action.setResult(OnlineSectioningLog.Action.ResultType.FALSE);
        } else {
            action.setResult(OnlineSectioningLog.Action.ResultType.TRUE);
        }
        return response;
    }

    public XCourseId lookup(OnlineSectioningServer server, XStudent student, CourseRequestInterface.RequestedCourse course) {
        XCourseId c = server.getCourse(course.getCourseId(), course.getCourseName());
        if (c != null && this.iMatcher != null && !this.iMatcher.match(c)) {
            if (student != null) {
                for (XRequest r : student.getRequests()) {
                    if (!(r instanceof XCourseRequest) || !((XCourseRequest)r).hasCourse(c.getCourseId())) continue;
                    return c;
                }
            }
            return null;
        }
        return c;
    }

    @Override
    public String name() {
        return "check-courses";
    }
}

