/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseStudentSectioningStatus;
import org.unitime.timetable.model.dao.StudentSectioningStatusDAO;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudentSectioningStatus
extends BaseStudentSectioningStatus {
    private static final long serialVersionUID = -33276457852954947L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);

    public boolean hasOption(Option option) {
        return this.getStatus() != null && (this.getStatus() & option.toggle()) != 0;
    }

    public void addOption(Option option) {
        if (!this.hasOption(option)) {
            this.setStatus((this.getStatus() == null ? 0 : this.getStatus()) + option.toggle());
        }
    }

    public void removeOption(Option option) {
        if (this.hasOption(option)) {
            this.setStatus(this.getStatus() - option.toggle());
        }
    }

    public static StudentSectioningStatus getStatus(String reference, Long sessionId, org.hibernate.Session hibSession) {
        StudentSectioningStatus status;
        if (reference != null && (status = (StudentSectioningStatus)hibSession.createQuery("from StudentSectioningStatus s where s.reference = :reference").setString("reference", reference).setMaxResults(1).setCacheable(true).uniqueResult()) != null) {
            return status;
        }
        if (sessionId != null && (status = (StudentSectioningStatus)hibSession.createQuery("select s.defaultSectioningStatus from Session s where s.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).setMaxResults(1).setCacheable(true).uniqueResult()) != null) {
            return status;
        }
        return null;
    }

    public static boolean hasOption(Option option, String reference, Long sessionId, org.hibernate.Session hibSession) {
        StudentSectioningStatus status = StudentSectioningStatus.getStatus(reference, sessionId, hibSession);
        return status == null || status.hasOption(option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getMatchingStatuses(Option option) {
        org.hibernate.Session hibSession = StudentSectioningStatusDAO.getInstance().createNewSession();
        try {
            HashSet<String> statuses = new HashSet<String>();
            for (StudentSectioningStatus status : StudentSectioningStatusDAO.getInstance().findAll(hibSession)) {
                if (!status.hasOption(option) || !status.isEffectiveNow()) continue;
                statuses.add(status.getReference());
            }
            HashSet<String> hashSet = statuses;
            return hashSet;
        }
        finally {
            hibSession.close();
        }
    }

    public boolean isEffectiveNow() {
        Calendar cal = Calendar.getInstance(Localization.getJavaLocale());
        int slot = 12 * cal.get(11) + cal.get(12) / 5;
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date today = cal.getTime();
        if (this.getEffectiveStartDate() != null && today.before(this.getEffectiveStartDate())) {
            return false;
        }
        if (this.getEffectiveStartPeriod() != null && (this.getEffectiveStartDate() == null || today.equals(this.getEffectiveStartDate())) && slot < this.getEffectiveStartPeriod()) {
            return false;
        }
        if (this.getEffectiveStopDate() != null && today.after(this.getEffectiveStopDate())) {
            return false;
        }
        return this.getEffectiveStopPeriod() == null || this.getEffectiveStopPeriod() != null && !today.equals(this.getEffectiveStopDate()) || slot < this.getEffectiveStopPeriod();
    }

    public boolean isPast() {
        Calendar cal = Calendar.getInstance(Localization.getJavaLocale());
        int slot = 12 * cal.get(11) + cal.get(12) / 5;
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date today = cal.getTime();
        if (this.getEffectiveStopDate() != null && today.after(this.getEffectiveStopDate())) {
            return true;
        }
        return this.getEffectiveStopPeriod() != null && (this.getEffectiveStopPeriod() == null || today.equals(this.getEffectiveStopDate())) && slot >= this.getEffectiveStopPeriod();
    }

    public static boolean hasEffectiveOption(StudentSectioningStatus status, Session session, Option option) {
        if (status != null) {
            if (status.isEffectiveNow()) {
                return status.hasOption(option);
            }
            int depth = 10;
            for (StudentSectioningStatus fallback = status.getFallBackStatus(); fallback != null && depth-- > 0; fallback = fallback.getFallBackStatus()) {
                if (!fallback.isEffectiveNow()) continue;
                return fallback.hasOption(option);
            }
        }
        StudentSectioningStatus defaultStatus = session == null ? null : session.getDefaultSectioningStatus();
        return defaultStatus == null ? true : defaultStatus.hasOption(option);
    }

    public String getEffectivePeriod() {
        String start = null;
        String stop = null;
        if (this.getEffectiveStartDate() != null || this.getEffectiveStartPeriod() != null) {
            start = this.getEffectiveStartDate() == null ? Constants.slot2str(this.getEffectiveStartPeriod()) : (this.getEffectiveStartPeriod() == null ? Formats.getDateFormat(Formats.Pattern.DATE_EVENT).format(this.getEffectiveStartDate()) : Formats.getDateFormat(Formats.Pattern.DATE_EVENT).format(this.getEffectiveStartDate()) + " " + Constants.slot2str(this.getEffectiveStartPeriod()));
        }
        if (this.getEffectiveStopDate() != null || this.getEffectiveStopPeriod() != null) {
            stop = this.getEffectiveStopDate() == null ? Constants.slot2str(this.getEffectiveStopPeriod()) : (this.getEffectiveStopPeriod() == null ? Formats.getDateFormat(Formats.Pattern.DATE_EVENT).format(this.getEffectiveStopDate()) : Formats.getDateFormat(Formats.Pattern.DATE_EVENT).format(this.getEffectiveStopDate()) + " " + Constants.slot2str(this.getEffectiveStopPeriod()));
        }
        if (start != null) {
            if (stop != null) {
                return MSG.messageEffectivePeriodBetween(start, stop);
            }
            return MSG.messageEffectivePeriodAfter(start);
        }
        if (stop != null) {
            return MSG.messageEffectivePeriodBefore(stop);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Option {
        enabled("Scheduling Assistant Access Enabled"),
        advisor("Advisor Can Enroll"),
        email("Email Notifications"),
        notype("Must Have Course Type"),
        waitlist("Wait-Listing Enabled"),
        nobatch("Do Not Schedule in Batch Solver"),
        enrollment("Student Can Enrol"),
        admin("Admin Can Enroll"),
        registration("Student Can Register"),
        regenabled("Course Requests Access Enabled"),
        regadvisor("Advisor Can Register"),
        regadmin("Admin Can Register"),
        advcanset("Advisor Can Set Status"),
        reqval("Course Request Validation"),
        specreg("Special Registration");

        private String iName;

        private Option(String name) {
            this.iName = name;
        }

        public String getName() {
            return this.iName;
        }

        public int toggle() {
            return 1 << this.ordinal();
        }
    }
}

