/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.base.BaseStudentAccomodation;
import org.unitime.timetable.model.dao.StudentAccomodationDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudentAccomodation
extends BaseStudentAccomodation {
    private static final long serialVersionUID = 1L;

    public StudentAccomodation() {
    }

    public StudentAccomodation(Long uniqueId) {
        super(uniqueId);
    }

    public static StudentAccomodation findByAbbv(Long sessionId, String abbv) {
        return (StudentAccomodation)new StudentAccomodationDAO().getSession().createQuery("select a from StudentAccomodation a where a.session.uniqueId=:sessionId and a.abbreviation=:abbv").setLong("sessionId", sessionId.longValue()).setString("abbv", abbv).setCacheable(true).uniqueResult();
    }

    public static List<AccommodationCounter> getAccommodations(InstructionalOffering offering) {
        ArrayList<AccommodationCounter> ret = new ArrayList<AccommodationCounter>();
        for (Object[] line : StudentAccomodationDAO.getInstance().getSession().createQuery("select a, count(distinct e.student) from StudentClassEnrollment e inner join e.student.accomodations a where e.courseOffering.instructionalOffering.uniqueId = :offeringId group by a.uniqueId, a.session.uniqueId, a.abbreviation, a.name, a.externalUniqueId order by count(a) desc, a.name").setLong("offeringId", offering.getUniqueId().longValue()).setCacheable(true).list()) {
            ret.add(new AccommodationCounter((StudentAccomodation)line[0], ((Number)line[1]).intValue()));
        }
        return ret;
    }

    public static List<AccommodationCounter> getAccommodations(Class_ clazz) {
        ArrayList<AccommodationCounter> ret = new ArrayList<AccommodationCounter>();
        for (Object[] line : StudentAccomodationDAO.getInstance().getSession().createQuery("select a, count(distinct e.student) from StudentClassEnrollment e inner join e.student.accomodations a where e.clazz.uniqueId = :classId group by a.uniqueId, a.session.uniqueId, a.abbreviation, a.name, a.externalUniqueId order by count(a) desc, a.name").setLong("classId", clazz.getUniqueId().longValue()).setCacheable(true).list()) {
            ret.add(new AccommodationCounter((StudentAccomodation)line[0], ((Number)line[1]).intValue()));
        }
        return ret;
    }

    public static List<AccommodationCounter> getAccommodations(Exam exam) {
        Hashtable<StudentAccomodation, Integer> counter = new Hashtable<StudentAccomodation, Integer>();
        for (ExamOwner owner : exam.getOwners()) {
            String query = null;
            switch (owner.getOwnerType()) {
                case 3: {
                    query = "e.clazz.uniqueId = :examOwnerId";
                    break;
                }
                case 2: {
                    query = "e.clazz.schedulingSubpart.instrOfferingConfig.uniqueId = :examOwnerId";
                    break;
                }
                case 1: {
                    query = "e.courseOffering.uniqueId = :examOwnerId";
                    break;
                }
                case 0: {
                    query = "e.courseOffering.instructionalOffering.uniqueId = :examOwnerId";
                }
            }
            if (query == null) continue;
            for (Object[] line : StudentAccomodationDAO.getInstance().getSession().createQuery("select a, count(distinct e.student) from StudentClassEnrollment e inner join e.student.accomodations a where " + query + " group by a.uniqueId, a.session.uniqueId, a.abbreviation, a.name, a.externalUniqueId order by count(a) desc, a.name").setLong("examOwnerId", owner.getOwnerId().longValue()).setCacheable(true).list()) {
                StudentAccomodation a = (StudentAccomodation)line[0];
                int count = ((Number)line[1]).intValue();
                Integer prev = (Integer)counter.get(a);
                counter.put(a, count + (prev == null ? 0 : prev));
            }
        }
        ArrayList<AccommodationCounter> ret = new ArrayList<AccommodationCounter>();
        for (Map.Entry entry : counter.entrySet()) {
            ret.add(new AccommodationCounter((StudentAccomodation)entry.getKey(), (Integer)entry.getValue()));
        }
        Collections.sort(ret);
        return ret;
    }

    public static String toHtml(List<AccommodationCounter> table) {
        if (table == null || table.isEmpty()) {
            return null;
        }
        StringBuffer ret = new StringBuffer("<table>");
        for (AccommodationCounter ac : table) {
            ret.append(ac.toHtmlRow());
        }
        ret.append("</table>");
        return ret.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AccommodationCounter
    implements Comparable<AccommodationCounter> {
        StudentAccomodation iAccommodation;
        private int iCount;

        public AccommodationCounter(StudentAccomodation accommodation, int count) {
            this.iAccommodation = accommodation;
            this.iCount = count;
        }

        public int getCount() {
            return this.iCount;
        }

        public StudentAccomodation getAccommodation() {
            return this.iAccommodation;
        }

        public void increment(int count) {
            this.iCount += count;
        }

        public String toHtmlRow() {
            return "<tr><td>" + this.getAccommodation().getName() + ":</td><td>" + this.getCount() + "</td></tr>";
        }

        @Override
        public int compareTo(AccommodationCounter ac) {
            if (this.getCount() > ac.getCount()) {
                return -1;
            }
            if (this.getCount() < ac.getCount()) {
                return 1;
            }
            int cmp = this.getAccommodation().getName().compareTo(ac.getAccommodation().getName());
            if (cmp != 0) {
                return cmp;
            }
            return this.getAccommodation().getUniqueId().compareTo(ac.getAccommodation().getUniqueId());
        }
    }
}

