/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TimePatternModel;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.base.BaseDatePattern;
import org.unitime.timetable.model.dao.DatePatternDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DateUtils;
import org.unitime.timetable.util.Formats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatePattern
extends BaseDatePattern
implements Comparable {
    private static final long serialVersionUID = 1L;
    public static final int sTypeStandard = 0;
    public static final int sTypeAlternate = 1;
    public static final int sTypeNonStandard = 2;
    public static final int sTypeExtended = 3;
    public static final int sTypePatternSet = 4;
    public static final String[] sTypes = new String[]{"Standard", "Alternate Weeks", "Non-standard", "Extended", "Alternative Pattern Set"};
    public static String DATE_PATTERN_LIST_ATTR = "datePatternList";
    public static String DATE_PATTERN_PARENT_LIST_ATTR = "datePatternParentsList";
    public static String DATE_PATTERN_CHILDREN_LIST_ATTR = "datePatternChildrenList";
    private transient BitSet iCachedPatternBitSet = null;

    public DatePattern() {
    }

    public DatePattern(Long uniqueId) {
        super(uniqueId);
    }

    public int getPatternOffset() {
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setTime(this.getSession().getSessionBeginDateTime());
        int beginDate = cal.get(6);
        return beginDate - (this.getOffset() == null ? 0 : this.getOffset()) - 1;
    }

    @Override
    public void setPattern(String pattern) {
        super.setPattern(pattern);
        this.iCachedPatternBitSet = null;
    }

    @Override
    public void setOffset(Integer offset) {
        super.setOffset(offset);
        this.iCachedPatternBitSet = null;
    }

    public void setPatternOffset(Date firstDate) {
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setTime(this.getSession().getSessionBeginDateTime());
        int offset = 0;
        while (cal.getTime().compareTo(firstDate) < 0) {
            --offset;
            cal.add(6, 1);
        }
        while (cal.getTime().compareTo(firstDate) > 0) {
            ++offset;
            cal.add(6, -1);
        }
        this.setOffset(offset);
    }

    public BitSet getPatternBitSet() {
        if (this.iCachedPatternBitSet != null) {
            return this.iCachedPatternBitSet;
        }
        if (this.getPattern() == null || this.getOffset() == null) {
            return null;
        }
        int startMonth = this.getSession().getPatternStartMonth();
        int endMonth = this.getSession().getPatternEndMonth();
        int size = this.getSession().getDayOfYear(0, endMonth + 1) - this.getSession().getDayOfYear(1, startMonth);
        this.iCachedPatternBitSet = new BitSet(size);
        int offset = this.getPatternOffset() - this.getSession().getDayOfYear(1, startMonth);
        for (int i = 0; i < this.getPattern().length(); ++i) {
            if (this.getPattern().charAt(i) != '1') continue;
            this.iCachedPatternBitSet.set(i + offset);
        }
        return this.iCachedPatternBitSet;
    }

    public void setPatternBitSet(BitSet pattern) {
        String p = null;
        int offset = 0;
        for (int i = 0; i < pattern.length(); ++i) {
            if (pattern.get(i)) {
                if (p == null) {
                    p = "";
                }
                p = p + "1";
                continue;
            }
            if (p == null) {
                ++offset;
                continue;
            }
            p = p + "0";
        }
        this.setOffset(DateUtils.getDayOfYear(this.getSession().getSessionBeginDateTime()) - this.getSession().getDayOfYear(1, this.getSession().getPatternStartMonth()) - offset - 1);
        this.setPattern(p);
    }

    public boolean isOffered(int day, int month) {
        if (this.getPattern() == null || this.getOffset() == null) {
            return false;
        }
        int idx = this.getSession().getDayOfYear(day, month) - this.getPatternOffset();
        if (idx < 0 || idx >= this.getPattern().length()) {
            return false;
        }
        return this.getPattern().charAt(idx) == '1';
    }

    public boolean isUsed(int day, int month, Set usage) {
        if (usage == null || this.getPattern() == null || this.getOffset() == null) {
            return false;
        }
        return usage.contains(new Integer(this.getSession().getDayOfYear(day, month)));
    }

    public String getPatternArray() {
        StringBuffer sb = new StringBuffer("[");
        int startMonth = this.getSession().getPatternStartMonth();
        int endMonth = this.getSession().getPatternEndMonth();
        int year = this.getSession().getSessionStartYear();
        for (int m = startMonth; m <= endMonth; ++m) {
            if (m != startMonth) {
                sb.append(",");
            }
            sb.append("[");
            int daysOfMonth = DateUtils.getNrDaysOfMonth(m, year);
            for (int d = 1; d <= daysOfMonth; ++d) {
                if (d > 1) {
                    sb.append(",");
                }
                sb.append(this.isOffered(d, m) ? "'1'" : "'0'");
            }
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }

    public String getPatternString() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        HashMap dates = this.getPatternDateStringHashMaps();
        TreeSet ts = new TreeSet();
        ts.addAll(dates.keySet());
        for (Date startDate : ts) {
            Date endDate = (Date)dates.get(startDate);
            Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_SHORT);
            String startDateStr = df.format(startDate);
            String endDateStr = df.format(endDate);
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(startDateStr);
            if (startDateStr.equals(endDateStr)) continue;
            sb.append("-" + endDateStr);
        }
        return sb.toString();
    }

    public HashMap getPatternDateStringHashMaps() {
        Calendar startDate = Calendar.getInstance(Locale.US);
        startDate.setTime(this.getStartDate());
        Calendar endDate = Calendar.getInstance(Locale.US);
        endDate.setTime(this.getEndDate());
        int startMonth = startDate.get(2);
        int endMonth = endDate.get(2);
        int startYear = startDate.get(1);
        int endYear = endDate.get(1);
        if (endYear > startYear) {
            endMonth += 12 * (endYear - startYear);
        }
        HashMap<Date, Date> mapStartToEndDate = new HashMap<Date, Date>();
        Date first = null;
        Date previous = null;
        char[] ptrn = this.getPattern().toCharArray();
        int charPosition = 0;
        int dayOfWeek = startDate.get(7);
        Calendar cal = Calendar.getInstance(Locale.US);
        for (int m = startMonth; m <= endMonth; ++m) {
            int daysOfMonth = DateUtils.getNrDaysOfMonth(m, startYear);
            for (int d = m == startMonth ? startDate.get(5) : 1; d <= daysOfMonth && charPosition < ptrn.length; ++d) {
                if (ptrn[charPosition] == '1' || first != null && dayOfWeek == 1 && charPosition + 1 < ptrn.length && ptrn[1 + charPosition] == '1') {
                    if (first == null) {
                        cal.setTime(this.getStartDate());
                        cal.add(6, charPosition);
                        first = cal.getTime();
                    }
                } else if (first != null) {
                    mapStartToEndDate.put(first, previous);
                    first = null;
                }
                cal.setTime(this.getStartDate());
                cal.add(6, charPosition);
                previous = cal.getTime();
                ++charPosition;
                if (++dayOfWeek <= 7) continue;
                dayOfWeek = 1;
            }
        }
        if (first != null) {
            mapStartToEndDate.put(first, previous);
            first = null;
        }
        return mapStartToEndDate;
    }

    public TreeSet getUsage(Collection classes) {
        TreeSet<Integer> days = new TreeSet<Integer>();
        int dowOffset = Constants.getDayOfWeek(DateUtils.getDate(1, 0, this.getSession().getSessionStartYear()));
        int offset = this.getPatternOffset();
        for (Class_ clazz : classes) {
            for (TimePref tp : clazz.effectivePreferences(TimePref.class)) {
                int dayOfWeek;
                int x;
                int dayCode;
                int t;
                boolean used;
                int d;
                if (tp.getTimePattern().getType() == 5) {
                    int dayCode2 = tp.getTimePatternModel().getExactDays();
                    for (int x2 = 0; x2 < this.getPattern().length(); ++x2) {
                        int dayOfWeek2;
                        if (this.getPattern().charAt(x2) != '1' || (dayCode2 & Constants.DAY_CODES[(dayOfWeek2 = (x2 + offset + dowOffset) % 7) < 0 ? dayOfWeek2 + 7 : dayOfWeek2]) == 0) continue;
                        days.add(new Integer(x2 + offset));
                    }
                    continue;
                }
                TimePatternModel m = tp.getTimePatternModel();
                boolean req = false;
                for (d = 0; d < m.getNrDays(); ++d) {
                    used = false;
                    for (t = 0; t < m.getNrTimes(); ++t) {
                        if (!PreferenceLevel.sRequired.equals(m.getPreference(d, t))) continue;
                        used = true;
                        break;
                    }
                    if (!used) continue;
                    req = true;
                    dayCode = m.getDayCode(d);
                    for (x = 0; x < this.getPattern().length(); ++x) {
                        if (this.getPattern().charAt(x) != '1' || (dayCode & Constants.DAY_CODES[(dayOfWeek = (x + offset + dowOffset) % 7) < 0 ? dayOfWeek + 7 : dayOfWeek]) == 0) continue;
                        days.add(new Integer(x + offset));
                    }
                }
                if (req) continue;
                for (d = 0; d < m.getNrDays(); ++d) {
                    used = false;
                    for (t = 0; t < m.getNrTimes(); ++t) {
                        if (PreferenceLevel.sProhibited.equals(m.getPreference(d, t))) continue;
                        used = true;
                        break;
                    }
                    if (!used) continue;
                    req = true;
                    dayCode = m.getDayCode(d);
                    for (x = 0; x < this.getPattern().length(); ++x) {
                        if (this.getPattern().charAt(x) != '1' || (dayCode & Constants.DAY_CODES[(dayOfWeek = (x + offset + dowOffset) % 7) < 0 ? dayOfWeek + 7 : dayOfWeek]) == 0) continue;
                        days.add(new Integer(x + offset));
                    }
                }
            }
        }
        return days;
    }

    public TreeSet getUsage(Long uniqueId) {
        if (uniqueId == null) {
            return null;
        }
        HashSet<Class_> classes = new HashSet<Class_>(new DatePatternDAO().getSession().createQuery("select distinct c from Class_ as c inner join c.datePattern as dp where dp.uniqueId=:uniqueId").setInteger("uniqueId", uniqueId.intValue()).setCacheable(true).list());
        for (SchedulingSubpart s : new DatePatternDAO().getSession().createQuery("select distinct s from SchedulingSubpart as s inner join s.datePattern as dp where dp.uniqueId=:uniqueId").setInteger("uniqueId", uniqueId.intValue()).setCacheable(true).list()) {
            for (Class_ c : s.getClasses()) {
                if (c.getDatePattern() != null) continue;
                classes.add(c);
            }
        }
        return this.getUsage(classes);
    }

    public String getBorderArray(Long uniqueId) {
        int startMonth = this.getSession().getPatternStartMonth();
        int endMonth = this.getSession().getPatternEndMonth();
        int year = this.getSession().getSessionStartYear();
        TreeSet usage = uniqueId != null ? this.getUsage(uniqueId) : null;
        StringBuffer sb = new StringBuffer("[");
        for (int m = startMonth; m <= endMonth; ++m) {
            if (m != startMonth) {
                sb.append(",");
            }
            sb.append("[");
            int daysOfMonth = DateUtils.getNrDaysOfMonth(m, year);
            for (int d = 1; d <= daysOfMonth; ++d) {
                if (d > 1) {
                    sb.append(",");
                }
                String border = this.getSession().getBorder(d, m);
                if (this.isUsed(d, m, usage)) {
                    border = "'green 2px solid'";
                }
                sb.append(border);
            }
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }

    public String getPatternHtml() {
        return this.getPatternHtml(true, null);
    }

    public String getPatternHtml(boolean editable) {
        return this.getPatternHtml(editable, null);
    }

    public String getPatternHtml(boolean editable, Long uniqueId) {
        return this.getPatternHtml(editable, uniqueId, true);
    }

    public String getPatternHtml(boolean editable, Long uniqueId, boolean includeScript) {
        StringBuffer sb = new StringBuffer();
        if (includeScript) {
            sb.append("<script language='JavaScript' type='text/javascript' src='scripts/datepatt.js'></script>");
        }
        sb.append("<script language='JavaScript'>");
        sb.append("calGenerate2(" + this.getSession().getSessionStartYear() + "," + this.getSession().getPatternStartMonth() + "," + this.getSession().getPatternEndMonth() + "," + this.getPatternArray() + ",['1','0'],['Classes offered','Classes not offered'],['rgb(240,240,50)','rgb(240,240,240)'],'1'," + this.getBorderArray(uniqueId) + "," + this.getSession().getColorArray() + "," + editable + "," + editable + ");");
        sb.append("</script>");
        return sb.toString();
    }

    public void setPatternAndOffset(HttpServletRequest request) {
        int startMonth = this.getSession().getPatternStartMonth();
        int endMonth = this.getSession().getPatternEndMonth();
        int firstOne = 0;
        int lastOne = 0;
        int year = this.getSession().getSessionStartYear();
        StringBuffer sb = null;
        int idx = this.getSession().getDayOfYear(1, startMonth);
        for (int m = startMonth; m <= endMonth; ++m) {
            int daysOfMonth = DateUtils.getNrDaysOfMonth(m, year);
            int yr = DateUtils.calculateActualYear(m, year);
            for (int d = 1; d <= daysOfMonth; ++d) {
                String offered = request.getParameter("cal_val_" + yr + "_" + (12 + m) % 12 + "_" + d);
                if (offered != null) {
                    if (sb != null || !offered.equals("0")) {
                        if (sb == null) {
                            firstOne = idx;
                            sb = new StringBuffer();
                        }
                        sb.append(offered);
                    }
                    if (!offered.equals("0")) {
                        lastOne = idx;
                    }
                }
                ++idx;
            }
        }
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setTime(this.getSession().getSessionBeginDateTime());
        if (sb != null) {
            this.setPattern(sb.substring(0, lastOne - firstOne + 1));
            this.setOffset(new Integer(cal.get(6) - firstOne - 1));
        } else {
            this.setPattern("0");
            this.setOffset(new Integer(0));
        }
    }

    public static DatePattern findByName(Session session, String name) {
        return DatePattern.findByName(session.getUniqueId(), name);
    }

    public static DatePattern findByName(Long sessionId, String name) {
        List list = new DatePatternDAO().getSession().createQuery("select distinct p from DatePattern as p where p.session.uniqueId=:sessionId and p.name=:name").setLong("sessionId", sessionId.longValue()).setText("name", name).setCacheable(true).list();
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (DatePattern)list.get(0);
    }

    public static List<DatePattern> findAll(UserContext user, Department department, DatePattern includeGiven) throws Exception {
        boolean includeExtended = user.getCurrentAuthority().hasRight(Right.ExtendedDatePatterns);
        return DatePattern.findAll(user.getCurrentAcademicSessionId(), includeExtended, department, includeGiven);
    }

    public static List<DatePattern> findAll(Session session, boolean includeExtended, Department department, DatePattern includeGiven) {
        return DatePattern.findAll(session.getUniqueId(), includeExtended, department, includeGiven);
    }

    public static List<DatePattern> findAll(Long sessionId, boolean includeExtended, Department department, DatePattern includeGiven) {
        List list = DatePatternDAO.getInstance().getSession().createQuery("select distinct p from DatePattern as p where p.session.uniqueId=:sessionId" + (!includeExtended ? " and p.type!=3" : "")).setLong("sessionId", sessionId.longValue()).setCacheable(true).list();
        if (!includeExtended) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                DatePattern p = (DatePattern)i.next();
                if (p.getType() != 4 || p.getDepartments().isEmpty() || department != null && p.getDepartments().contains(department)) continue;
                i.remove();
            }
        }
        if (!includeExtended && department != null) {
            for (DatePattern dp : department.getDatePatterns()) {
                if (dp.getType() != 3) continue;
                list.add(dp);
            }
        }
        if (includeGiven != null && !list.contains(includeGiven)) {
            list.add(includeGiven);
        }
        Collections.sort(list);
        return list;
    }

    public static Set findAllUsed(Long sessionId) {
        TreeSet<DatePattern> ret = new TreeSet<DatePattern>(new DatePatternDAO().getSession().createQuery("select distinct dp from Class_ as c inner join c.datePattern as dp where dp.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list());
        ret.addAll(new DatePatternDAO().getSession().createQuery("select distinct dp from SchedulingSubpart as s inner join s.datePattern as dp where dp.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list());
        ret.addAll(new DatePatternDAO().getSession().createQuery("select distinct dp from Assignment a inner join a.datePattern dp where dp.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list());
        Session session = (Session)new SessionDAO().get(sessionId);
        if (session.getDefaultDatePattern() != null) {
            ret.add(session.getDefaultDatePattern());
        }
        return ret;
    }

    public List<DatePattern> findChildren() {
        return this.findChildren(null);
    }

    public List<DatePattern> findChildren(org.hibernate.Session hibSession) {
        if (this.getType() != null && this.getType() != 4) {
            return new ArrayList<DatePattern>();
        }
        return (hibSession != null ? hibSession : DatePatternDAO.getInstance().getSession()).createQuery("select dp from DatePattern dp, IN (dp.parents) parent where parent.uniqueId = :parentId").setLong("parentId", this.getUniqueId().longValue()).setCacheable(true).list();
    }

    public static List<DatePattern> findAllParents(Long sessionId) {
        return DatePatternDAO.getInstance().getSession().createQuery("from DatePattern where type = :parentType and session.uniqueId=:sessionId order by name").setInteger("parentType", 4).setLong("sessionId", sessionId.longValue()).setCacheable(true).list();
    }

    public boolean isUsed() {
        return DatePattern.findAllUsed(this.getSession().getUniqueId()).contains(this);
    }

    public boolean isDefault() {
        return this.equals(this.getSession().getDefaultDatePattern());
    }

    public int size() {
        if (this.getPattern() == null) {
            return 0;
        }
        int size = 0;
        for (int i = 0; i < this.getPattern().length(); ++i) {
            if ('1' != this.getPattern().charAt(i)) continue;
            ++size;
        }
        return size;
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof DatePattern)) {
            return -1;
        }
        DatePattern dp = (DatePattern)o;
        int cmp = this.getType().compareTo(dp.getType());
        if (cmp != 0) {
            return cmp;
        }
        if (dp.getType() != 4) {
            if (dp.getType() == 0) {
                cmp = Float.compare(dp.getEffectiveNumberOfWeeks(), this.getEffectiveNumberOfWeeks());
                if (cmp != 0) {
                    return cmp;
                }
                cmp = dp.getOffset().compareTo(this.getOffset());
                if (cmp != 0) {
                    return cmp;
                }
            } else {
                cmp = dp.getOffset().compareTo(this.getOffset());
                if (cmp != 0) {
                    return cmp;
                }
                cmp = Float.compare(this.getEffectiveNumberOfWeeks(), dp.getEffectiveNumberOfWeeks());
                if (cmp != 0) {
                    return cmp;
                }
            }
        }
        if ((cmp = this.getName().compareTo(dp.getName())) != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? new Long(-1L) : this.getUniqueId()).compareTo(dp.getUniqueId() == null ? -1L : dp.getUniqueId());
    }

    public Object clone() {
        DatePattern dp = new DatePattern();
        dp.setSession(this.getSession());
        dp.setOffset(this.getOffset());
        dp.setPattern(this.getPattern());
        dp.setName(this.getName());
        dp.setType(this.getType());
        dp.setVisible(this.isVisible());
        return dp;
    }

    public Date getStartDate() {
        if (this.getPattern() == null || this.getOffset() == null) {
            return null;
        }
        int idx = this.getPattern().indexOf(49);
        if (idx < 0) {
            return this.getSession().getSessionBeginDateTime();
        }
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setTime(this.getSession().getSessionBeginDateTime());
        cal.add(6, idx - this.getOffset());
        return cal.getTime();
    }

    public Date getEndDate() {
        if (this.getPattern() == null || this.getOffset() == null) {
            return null;
        }
        int idx = this.getPattern().lastIndexOf(49);
        if (idx < 0) {
            return this.getSession().getSessionEndDateTime();
        }
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setTime(this.getSession().getSessionBeginDateTime());
        cal.add(6, idx - this.getOffset());
        return cal.getTime();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public DatePattern findCloseMatchDatePatternInSession(Session session) {
        List<DatePattern> allDatePatterns = DatePattern.findAll(session, true, null, null);
        TreeSet<Integer> days = new TreeSet<Integer>();
        if (days.isEmpty()) {
            int offset = this.getPatternOffset();
            for (int x = 0; x < this.getPattern().length(); ++x) {
                if (this.getPattern().charAt(x) != '1') continue;
                days.add(new Integer(x + offset));
            }
        }
        DatePattern likeDp = null;
        int likeDiff = 0;
        for (DatePattern xdp : allDatePatterns) {
            if (xdp.getName().startsWith("generated")) continue;
            if (this.getOffset().equals(xdp.getOffset()) && this.getPattern().equals(xdp.getPattern())) {
                likeDp = xdp;
                likeDiff = 0;
                break;
            }
            TreeSet<Integer> xdays = new TreeSet<Integer>();
            if (xdays.isEmpty()) {
                int offset = xdp.getPatternOffset();
                for (int x = 0; x < xdp.getPattern().length(); ++x) {
                    if (xdp.getPattern().charAt(x) != '1') continue;
                    xdays.add(new Integer(x + offset));
                }
            }
            int diff = this.diff(days, xdays);
            if (likeDp != null && likeDiff <= diff && (likeDiff != diff || !xdp.isDefault())) continue;
            likeDp = xdp;
            likeDiff = diff;
        }
        if (likeDp != null && likeDiff <= 5) {
            return likeDp;
        }
        return null;
    }

    private int diff(Set x, Set y) {
        int diff = 0;
        for (Object o : x) {
            if (y.contains(o)) continue;
            ++diff;
        }
        for (Object o : y) {
            if (x.contains(o)) continue;
            ++diff;
        }
        return diff;
    }

    public static Date[] getBounds(Long sessionId) {
        Date startDate = null;
        Date endDate = null;
        for (DatePattern dp : DatePattern.findAllUsed(sessionId)) {
            if (startDate == null || startDate.compareTo(dp.getStartDate()) > 0) {
                startDate = dp.getStartDate();
            }
            if (endDate != null && endDate.compareTo(dp.getEndDate()) >= 0) continue;
            endDate = dp.getEndDate();
        }
        if (startDate == null) {
            Session session = (Session)SessionDAO.getInstance().get(sessionId);
            startDate = DateUtils.getDate(1, session.getStartMonth(), session.getSessionStartYear());
            endDate = DateUtils.getDate(0, session.getEndMonth() + 1, session.getSessionStartYear());
        }
        Calendar startDateCal = Calendar.getInstance(Locale.US);
        startDateCal.setTime(startDate);
        startDateCal.set(11, 0);
        startDateCal.set(12, 0);
        startDateCal.set(13, 0);
        Calendar endDateCal = Calendar.getInstance(Locale.US);
        endDateCal.setTime(endDate);
        endDateCal.set(11, 23);
        endDateCal.set(12, 59);
        endDateCal.set(13, 59);
        return new Date[]{startDateCal.getTime(), endDateCal.getTime()};
    }

    public float getComputedNumberOfWeeks() {
        int i;
        Iterator<DatePattern> iterator;
        if (this.getType() != null && this.getType() == 4 && (iterator = this.findChildren().iterator()).hasNext()) {
            DatePattern dp = iterator.next();
            return dp.getEffectiveNumberOfWeeks();
        }
        int[] daysInWeek = new int[7];
        for (i = 0; i < 7; ++i) {
            daysInWeek[i] = 0;
        }
        for (i = 0; i < this.getPattern().length(); ++i) {
            if (this.getPattern().charAt(i) != '1') continue;
            int n = i % 7;
            daysInWeek[n] = daysInWeek[n] + 1;
        }
        Arrays.sort(daysInWeek);
        return daysInWeek[2];
    }

    public float getEffectiveNumberOfWeeks() {
        return this.getNumberOfWeeks() == null ? this.getComputedNumberOfWeeks() : this.getNumberOfWeeks().floatValue();
    }
}

