/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseBoolean;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseLong;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseNull;

public class SavedHQLInterface
implements IsSerializable {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HQLSetBackRpcRequest
    implements GwtRpcRequest<GwtRpcResponseNull> {
        private String iAppearance;
        private String iHistory;
        private List<Long> iIds = new ArrayList<Long>();
        private String iType;

        public String getAppearance() {
            return this.iAppearance;
        }

        public void setAppearance(String appearance) {
            this.iAppearance = appearance;
        }

        public String getHistory() {
            return this.iHistory;
        }

        public void setHistory(String history) {
            this.iHistory = history;
        }

        public void addId(Long id) {
            if (!this.iIds.contains(id)) {
                this.iIds.add(id);
            }
        }

        public List<Long> getIds() {
            return this.iIds;
        }

        public void setType(String type) {
            this.iType = type;
        }

        public String getType() {
            return this.iType;
        }

        @Override
        public String toString() {
            return this.getAppearance() + "#" + this.getHistory();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HQLDeleteRpcRequest
    implements GwtRpcRequest<GwtRpcResponseBoolean> {
        private Long iId = null;

        public HQLDeleteRpcRequest() {
        }

        public HQLDeleteRpcRequest(Long id) {
            this.iId = id;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        @Override
        public String toString() {
            return this.iId == null ? "null" : this.iId.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HQLStoreRpcRequest
    extends Query
    implements GwtRpcRequest<GwtRpcResponseLong> {
        public HQLStoreRpcRequest() {
        }

        public HQLStoreRpcRequest(Query query) {
            this.setId(query.getId());
            this.setName(query.getName());
            this.setDescription(query.getDescription());
            this.setQuery(query.getQuery());
            this.setFlags(query.getFlags());
            if (query.hasParameters()) {
                for (Parameter p : query.getParameters()) {
                    this.addParameter(new Parameter(p));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HQLExecuteRpcRequest
    implements GwtRpcRequest<Table> {
        private Query iQuery;
        private List<IdValue> iOptions = new ArrayList<IdValue>();
        private int iFromRow;
        private int iMaxRows;

        public void setQuery(Query query) {
            this.iQuery = query;
        }

        public Query getQuery() {
            return this.iQuery;
        }

        public void addOption(String value, String text) {
            this.iOptions.add(new IdValue(value, text));
        }

        public List<IdValue> getOptions() {
            return this.iOptions;
        }

        public void setFromRow(int fromRow) {
            this.iFromRow = fromRow;
        }

        public int getFromRow() {
            return this.iFromRow;
        }

        public void setMaxRows(int maxRows) {
            this.iMaxRows = maxRows;
        }

        public int getMaxRows() {
            return this.iMaxRows;
        }

        @Override
        public String toString() {
            return this.iQuery.getName() + " {options: " + this.getOptions() + ", from:" + this.getFromRow() + ", max:" + this.getMaxRows() + "}";
        }
    }

    public static class Table
    implements GwtRpcResponse {
        private List<String[]> iData = new ArrayList<String[]>();

        public void add(String ... line) {
            this.iData.add(line);
        }

        public int size() {
            return this.iData.size();
        }

        public String[] get(int row) {
            return this.iData.get(row);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HQLQueriesRpcRequest
    implements GwtRpcRequest<GwtRpcResponseList<Query>> {
        private String iAppearance;

        public HQLQueriesRpcRequest() {
        }

        public HQLQueriesRpcRequest(String appearance) {
            this.iAppearance = appearance;
        }

        public void setAppearance(String appearance) {
            this.iAppearance = appearance;
        }

        public String getAppearance() {
            return this.iAppearance;
        }

        @Override
        public String toString() {
            return this.iAppearance;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HQLOptionsRpcRequest
    implements GwtRpcRequest<HQLOptionsInterface> {
        @Override
        public String toString() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HQLOptionsInterface
    implements GwtRpcResponse {
        private List<Flag> iFlags = new ArrayList<Flag>();
        private List<Option> iOptions = new ArrayList<Option>();
        private boolean iEditable = false;

        public void addFlag(Flag flag) {
            this.iFlags.add(flag);
        }

        public List<Flag> getFlags() {
            return this.iFlags;
        }

        public void addOption(Option option) {
            this.iOptions.add(option);
        }

        public List<Option> getOptions() {
            return this.iOptions;
        }

        public void setEditable(boolean editable) {
            this.iEditable = editable;
        }

        public boolean isEditable() {
            return this.iEditable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListItem
    implements IsSerializable,
    Comparable<ListItem> {
        private String iValue;
        private String iText;

        public ListItem() {
        }

        public ListItem(String value, String text) {
            this.iValue = value;
            this.iText = text;
        }

        public String getValue() {
            return this.iValue;
        }

        public String getText() {
            return this.iText;
        }

        @Override
        public int compareTo(ListItem item) {
            int cmp = this.getText().compareTo(item.getText());
            if (cmp != 0) {
                return cmp;
            }
            return this.getValue().compareTo(item.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Parameter
    implements IsSerializable,
    Comparable<Parameter> {
        private String iName;
        private String iLabel;
        private String iType;
        private String iValue;
        private String iDefault;
        private Set<ListItem> iOptions = null;
        private boolean iMultiSelect = false;

        public Parameter() {
        }

        public Parameter(Parameter p) {
            this.iName = p.iName;
            this.iLabel = p.iLabel;
            this.iType = p.iType;
            this.iValue = p.iValue;
            this.iDefault = p.iDefault;
            this.iOptions = p.iOptions;
            this.iMultiSelect = p.iMultiSelect;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }

        public String getType() {
            return this.iType;
        }

        public void setType(String type) {
            this.iType = type;
        }

        public String getValue() {
            return this.iValue;
        }

        public void setValue(String value) {
            this.iValue = value;
        }

        public String getDefaultValue() {
            return this.iDefault;
        }

        public void setDefaultValue(String defaultValue) {
            this.iDefault = defaultValue;
        }

        public boolean hasOptions() {
            return this.iOptions != null && !this.iOptions.isEmpty();
        }

        public void addOption(String value, String text) {
            if (this.iOptions == null) {
                this.iOptions = new TreeSet<ListItem>();
            }
            this.iOptions.add(new ListItem(value, text));
        }

        public Set<ListItem> getOptions() {
            return this.iOptions;
        }

        public boolean isMultiSelect() {
            return this.iMultiSelect;
        }

        public void setMultiSelect(boolean multiSelect) {
            this.iMultiSelect = multiSelect;
        }

        public String toString() {
            return this.getName() + "=" + (this.getValue() == null ? this.getDefaultValue() : this.getValue());
        }

        @Override
        public int compareTo(Parameter o) {
            int cmp = this.getLabel().compareTo(o.getLabel());
            if (cmp != 0) {
                return cmp;
            }
            return this.getName().compareTo(o.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Query
    implements GwtRpcResponse {
        private Long iId = null;
        private String iName;
        private String iDescription;
        private String iQuery;
        private int iFlags = 0;
        private Set<Parameter> iParameters;

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getDescription() {
            return this.iDescription == null ? "" : this.iDescription;
        }

        public void setDescription(String description) {
            this.iDescription = description;
        }

        public String getQuery() {
            return this.iQuery;
        }

        public void setQuery(String query) {
            this.iQuery = query;
        }

        public int getFlags() {
            return this.iFlags;
        }

        public void setFlags(int flags) {
            this.iFlags = flags;
        }

        public boolean hasParameters() {
            return this.iParameters != null && !this.iParameters.isEmpty();
        }

        public Set<Parameter> getParameters() {
            return this.iParameters;
        }

        public void addParameter(Parameter parameter) {
            if (this.iParameters == null) {
                this.iParameters = new TreeSet<Parameter>();
            }
            this.iParameters.add(parameter);
        }

        public void clearParameters() {
            if (this.iParameters != null) {
                this.iParameters.clear();
            }
        }

        public String toString() {
            return this.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Option
    implements IsSerializable {
        private String iType;
        private String iName;
        private List<IdValue> iValues = new ArrayList<IdValue>();
        private boolean iMultiSelect;

        public String getType() {
            return this.iType;
        }

        public void setType(String type) {
            this.iType = type;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public List<IdValue> values() {
            return this.iValues;
        }

        public boolean isMultiSelect() {
            return this.iMultiSelect;
        }

        public void setMultiSelect(boolean multiSelect) {
            this.iMultiSelect = multiSelect;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IdValue
    implements IsSerializable,
    Comparable<IdValue> {
        private String iValue;
        private String iText;

        public IdValue() {
        }

        public IdValue(String value, String text) {
            this.iValue = value;
            this.iText = text;
        }

        public String getValue() {
            return this.iValue;
        }

        public void setValue(String value) {
            this.iValue = value;
        }

        public String getText() {
            return this.iText;
        }

        public void setText(String text) {
            this.iText = text;
        }

        @Override
        public int compareTo(IdValue o) {
            return this.getText().compareTo(o.getText());
        }

        public String toString() {
            return this.getValue() + ": " + this.getText();
        }
    }

    public static class Flag
    implements IsSerializable {
        private int iValue;
        private String iText;
        private String iAppearance;

        public int getValue() {
            return this.iValue;
        }

        public void setValue(int value) {
            this.iValue = value;
        }

        public String getText() {
            return this.iText;
        }

        public void setText(String text) {
            this.iText = text;
        }

        public boolean isAppearance() {
            return this.iAppearance != null;
        }

        public String getAppearance() {
            return this.iAppearance;
        }

        public void setAppearance(String appearance) {
            this.iAppearance = appearance;
        }
    }
}

