/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class OnlineSectioningInterface
implements IsSerializable,
Serializable {
    private static final long serialVersionUID = 1L;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StudentStatusInfo
    implements IsSerializable,
    Serializable,
    Comparable<StudentStatusInfo> {
        private static final long serialVersionUID = 1L;
        private Long iUniqueId;
        private String iReference;
        private String iLabel;
        private boolean iAssistantPage = false;
        private boolean iRequestsPage = false;
        private boolean iRegStudent = false;
        private boolean iRegAdvisor = false;
        private boolean iRegAdmin = false;
        private boolean iEnrlStudent = false;
        private boolean iEnrlAdvisor = false;
        private boolean iEnrlAdmin = false;
        private boolean iWaitList = false;
        private boolean iEmail = false;
        private boolean iSpecReg = false;
        private boolean iReqValidation = false;
        private String iCourseTypes;
        private String iEffectiveStart;
        private String iEffectiveStop;
        private String iMessage;

        public void setUniqueId(Long id) {
            this.iUniqueId = id;
        }

        public Long getUniqueId() {
            return this.iUniqueId;
        }

        public void setReference(String reference) {
            this.iReference = reference;
        }

        public String getReference() {
            return this.iReference;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setCanAccessAssistantPage(boolean assistantPage) {
            this.iAssistantPage = assistantPage;
        }

        public boolean isCanAccessAssistantPage() {
            return this.iAssistantPage;
        }

        public void setCanAccessRequestsPage(boolean requestPage) {
            this.iRequestsPage = requestPage;
        }

        public boolean isCanAccessRequestsPage() {
            return this.iRequestsPage;
        }

        public void setCanStudentRegister(boolean regStudent) {
            this.iRegStudent = regStudent;
        }

        public boolean isCanStudentRegister() {
            return this.iRegStudent;
        }

        public void setCanAdvisorRegister(boolean regAdvisor) {
            this.iRegAdvisor = regAdvisor;
        }

        public boolean isCanAdvisorRegister() {
            return this.iRegAdvisor;
        }

        public void setCanAdminRegister(boolean regAdmin) {
            this.iRegAdmin = regAdmin;
        }

        public boolean isCanAdminRegister() {
            return this.iRegAdmin;
        }

        public void setCanStudentEnroll(boolean enrlStudent) {
            this.iEnrlStudent = enrlStudent;
        }

        public boolean isCanStudentEnroll() {
            return this.iEnrlStudent;
        }

        public void setCanAdvisorEnroll(boolean enrlAdvisor) {
            this.iEnrlAdvisor = enrlAdvisor;
        }

        public boolean isCanAdvisorEnroll() {
            return this.iEnrlAdvisor;
        }

        public void setCanAdminEnroll(boolean enrlAdmin) {
            this.iEnrlAdmin = enrlAdmin;
        }

        public boolean isCanAdminEnroll() {
            return this.iEnrlAdmin;
        }

        public void setWaitList(boolean waitlist) {
            this.iWaitList = waitlist;
        }

        public boolean isWaitList() {
            return this.iWaitList;
        }

        public void setEmail(boolean email) {
            this.iEmail = email;
        }

        public boolean isEmail() {
            return this.iEmail;
        }

        public void setSpecialRegistration(boolean specReg) {
            this.iSpecReg = specReg;
        }

        public boolean isSpecialRegistration() {
            return this.iSpecReg;
        }

        public void setRequestValiadtion(boolean reqVal) {
            this.iReqValidation = reqVal;
        }

        public boolean isRequestValiadtion() {
            return this.iReqValidation;
        }

        public void setAllEnabled() {
            this.iAssistantPage = true;
            this.iRequestsPage = true;
            this.iRegStudent = true;
            this.iRegAdvisor = true;
            this.iRegAdmin = true;
            this.iEnrlStudent = true;
            this.iEnrlAdvisor = true;
            this.iEnrlAdmin = true;
            this.iWaitList = true;
            this.iEmail = true;
        }

        public void setCourseTypes(String courseTypes) {
            this.iCourseTypes = courseTypes;
        }

        public boolean hasCourseTypes() {
            return this.iCourseTypes != null && !this.iCourseTypes.isEmpty();
        }

        public String getCourseTypes() {
            return this.iCourseTypes;
        }

        public void setEffectiveStart(String start) {
            this.iEffectiveStart = start;
        }

        public boolean hasEffectiveStart() {
            return this.iEffectiveStart != null && !this.iEffectiveStart.isEmpty();
        }

        public String getEffectiveStart() {
            return this.iEffectiveStart;
        }

        public void setEffectiveStop(String stop) {
            this.iEffectiveStop = stop;
        }

        public boolean hasEffectiveStop() {
            return this.iEffectiveStop != null && !this.iEffectiveStop.isEmpty();
        }

        public String getEffectiveStop() {
            return this.iEffectiveStop;
        }

        public void setMessage(String message) {
            this.iMessage = message;
        }

        public boolean hasMessage() {
            return this.iMessage != null && !this.iMessage.isEmpty();
        }

        public String getMessage() {
            return this.iMessage;
        }

        public String toString() {
            return this.getReference();
        }

        public int hashCode() {
            return this.getReference().hashCode();
        }

        @Override
        public int compareTo(StudentStatusInfo status) {
            return this.getReference().compareTo(status.getReference());
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof StudentStatusInfo)) {
                return false;
            }
            return this.getUniqueId().equals(((StudentStatusInfo)o).getUniqueId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StudentGroupInfo
    implements IsSerializable,
    Serializable,
    Comparable<StudentGroupInfo> {
        private static final long serialVersionUID = 1L;
        private Long iUniqueId;
        private String iReference;
        private String iLabel;

        public StudentGroupInfo() {
        }

        public StudentGroupInfo(Long id, String reference, String label) {
            this.iUniqueId = id;
            this.iReference = reference;
            this.iLabel = label;
        }

        public void setUniqueId(Long id) {
            this.iUniqueId = id;
        }

        public Long getUniqueId() {
            return this.iUniqueId;
        }

        public void setReference(String reference) {
            this.iReference = reference;
        }

        public String getReference() {
            return this.iReference;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public String toString() {
            return this.getReference();
        }

        public int hashCode() {
            return this.getReference().hashCode();
        }

        @Override
        public int compareTo(StudentGroupInfo status) {
            return this.getReference().compareTo(status.getReference());
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof StudentGroupInfo)) {
                return false;
            }
            return this.getUniqueId().equals(((StudentGroupInfo)o).getUniqueId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SectioningProperties
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iSessionId = null;
        private boolean iAdmin = false;
        private boolean iAdvisor = false;
        private boolean iEmail = false;
        private boolean iMassCancel = false;
        private boolean iChangeStatus = false;
        private boolean iRequestUpdate = false;
        private boolean iChangeLog = false;
        private boolean iCheckStudentOverrides = false;
        private boolean iValidateStudentOverrides = false;
        private Set<StudentGroupInfo> iEditableGroups = null;

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public boolean isAdmin() {
            return this.iAdmin;
        }

        public boolean isAdvisor() {
            return this.iAdvisor;
        }

        public boolean isAdminOrAdvisor() {
            return this.iAdmin || this.iAdvisor;
        }

        public void setAdmin(boolean admin) {
            this.iAdmin = admin;
        }

        public void setAdvisor(boolean advisor) {
            this.iAdvisor = advisor;
        }

        public void setEmail(boolean email) {
            this.iEmail = email;
        }

        public boolean isEmail() {
            return this.iEmail;
        }

        public void setMassCancel(boolean massCancel) {
            this.iMassCancel = massCancel;
        }

        public boolean isMassCancel() {
            return this.iMassCancel;
        }

        public void setChangeStatus(boolean changeStatus) {
            this.iChangeStatus = changeStatus;
        }

        public boolean isChangeStatus() {
            return this.iChangeStatus;
        }

        public void setRequestUpdate(boolean requestUpdate) {
            this.iRequestUpdate = requestUpdate;
        }

        public boolean isRequestUpdate() {
            return this.iRequestUpdate;
        }

        public void setCheckStudentOverrides(boolean checkOverrides) {
            this.iCheckStudentOverrides = checkOverrides;
        }

        public boolean isCheckStudentOverrides() {
            return this.iCheckStudentOverrides;
        }

        public void setValidateStudentOverrides(boolean ValidateOverrides) {
            this.iValidateStudentOverrides = ValidateOverrides;
        }

        public boolean isValidateStudentOverrides() {
            return this.iValidateStudentOverrides;
        }

        public void setChangeLog(boolean changeLog) {
            this.iChangeLog = changeLog;
        }

        public boolean isChangeLog() {
            return this.iChangeLog;
        }

        public boolean isCanSelectStudent() {
            return this.iEmail || this.iMassCancel || this.iChangeStatus || this.iRequestUpdate || this.iCheckStudentOverrides || this.iValidateStudentOverrides;
        }

        public boolean hasEditableGroups() {
            return this.iEditableGroups != null && !this.iEditableGroups.isEmpty();
        }

        public Set<StudentGroupInfo> getEditableGroups() {
            return this.iEditableGroups;
        }

        public void setEditableGroups(Set<StudentGroupInfo> groups) {
            this.iEditableGroups = groups;
        }

        public void addEditableGroup(StudentGroupInfo group) {
            if (this.iEditableGroups == null) {
                this.iEditableGroups = new TreeSet<StudentGroupInfo>();
            }
            this.iEditableGroups.add(group);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EligibilityCheck
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private int iFlags = 0;
        private String iMessage = null;
        private String iCheckboxMessage = null;
        private Long iSessionId = null;
        private Long iStudentId = null;
        private Set<String> iOverrides = null;

        public EligibilityCheck() {
        }

        public EligibilityCheck(String message, EligibilityFlag ... flags) {
            this.iMessage = message;
            for (EligibilityFlag flag : flags) {
                this.setFlag(flag, true);
            }
        }

        public EligibilityCheck(EligibilityFlag ... flags) {
            for (EligibilityFlag flag : flags) {
                this.setFlag(flag, true);
            }
        }

        public void setFlag(EligibilityFlag flag, boolean set) {
            if (set && !this.hasFlag(flag)) {
                this.iFlags += flag.flag();
            }
            if (!set && this.hasFlag(flag)) {
                this.iFlags -= flag.flag();
            }
        }

        public boolean hasFlag(EligibilityFlag flag) {
            return (this.iFlags & flag.flag()) != 0;
        }

        public boolean hasFlag(EligibilityFlag ... flags) {
            for (EligibilityFlag flag : flags) {
                if ((this.iFlags & flag.flag()) == 0) continue;
                return true;
            }
            return false;
        }

        public void setMessage(String message) {
            this.iMessage = message;
        }

        public boolean hasMessage() {
            return this.iMessage != null && !this.iMessage.isEmpty();
        }

        public String getMessage() {
            return this.iMessage;
        }

        public void setCheckboxMessage(String message) {
            this.iCheckboxMessage = message;
        }

        public boolean hasCheckboxMessage() {
            return this.iCheckboxMessage != null && !this.iCheckboxMessage.isEmpty();
        }

        public String getCheckboxMessage() {
            return this.iCheckboxMessage;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setStudentId(Long studentId) {
            this.iStudentId = studentId;
        }

        public Long getStudentId() {
            return this.iStudentId;
        }

        public boolean hasOverride(String errorCode) {
            if (errorCode == null || errorCode.isEmpty()) {
                return true;
            }
            return this.iOverrides != null && this.iOverrides.contains(errorCode);
        }

        public void setOverrides(Collection<String> overrides) {
            this.iOverrides = overrides == null ? null : new HashSet<String>(overrides);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum EligibilityFlag implements IsSerializable
        {
            IS_ADMIN,
            IS_ADVISOR,
            IS_GUEST,
            CAN_USE_ASSISTANT,
            CAN_ENROLL,
            PIN_REQUIRED,
            CAN_WAITLIST,
            RECHECK_AFTER_ENROLLMENT,
            RECHECK_BEFORE_ENROLLMENT,
            CAN_RESET,
            CONFIRM_DROP,
            QUICK_ADD_DROP,
            ALTERNATIVES_DROP,
            GWT_CONFIRMATIONS,
            DEGREE_PLANS,
            CAN_REGISTER,
            NO_REQUEST_ARROWS,
            CAN_SPECREG,
            HAS_SPECREG,
            SR_ENABLED,
            SR_TIME_CONF,
            SR_LIMIT_CONF;


            public int flag() {
                return 1 << this.ordinal();
            }
        }
    }
}

