/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DegreePlanInterface
implements IsSerializable,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long iStudentId;
    private Long iSessionId;
    private String iId;
    private String iName;
    private String iDegree;
    private String iSchool;
    private String iTrack;
    private String iModifiedWho;
    private Date iModified;
    private DegreeGroupInterface iGroup;
    private boolean iLocked = false;
    private boolean iActive = false;

    public Long getStudentId() {
        return this.iStudentId;
    }

    public void setStudentId(Long studentId) {
        this.iStudentId = studentId;
    }

    public Long getSessionId() {
        return this.iSessionId;
    }

    public void setSessionId(Long sessionId) {
        this.iSessionId = sessionId;
    }

    public String getId() {
        return this.iId;
    }

    public void setId(String id) {
        this.iId = id;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String getDegree() {
        return this.iDegree;
    }

    public void setDegree(String degree) {
        this.iDegree = degree;
    }

    public String getSchool() {
        return this.iSchool;
    }

    public void setSchool(String school) {
        this.iSchool = school;
    }

    public String getTrackingStatus() {
        return this.iTrack;
    }

    public void setTrackingStatus(String track) {
        this.iTrack = track;
    }

    public Date getLastModified() {
        return this.iModified;
    }

    public void setLastModified(Date modified) {
        this.iModified = modified;
    }

    public String getModifiedWho() {
        return this.iModifiedWho;
    }

    public void setModifiedWho(String name) {
        this.iModifiedWho = name;
    }

    public DegreeGroupInterface getGroup() {
        return this.iGroup;
    }

    public void setGroup(DegreeGroupInterface group) {
        this.iGroup = group;
    }

    public boolean isActive() {
        return this.iActive;
    }

    public void setActive(boolean active) {
        this.iActive = active;
    }

    public boolean isLocked() {
        return this.iLocked;
    }

    public void setLocked(boolean locked) {
        this.iLocked = locked;
    }

    public List<DegreeCourseInterface> listSelected(boolean pickFirstWhenNoneSelected) {
        ArrayList<DegreeCourseInterface> ret = new ArrayList<DegreeCourseInterface>();
        if (this.iGroup != null) {
            this.iGroup.listSelected(ret, pickFirstWhenNoneSelected);
        }
        return ret;
    }

    public List<DegreeCourseInterface> listAlternatives(DegreeCourseInterface course) {
        ArrayList<DegreeCourseInterface> ret = new ArrayList<DegreeCourseInterface>();
        if (this.iGroup != null) {
            this.iGroup.listAlternatives(ret, course);
        }
        return ret;
    }

    public boolean hasCourse(String course) {
        if (this.iGroup != null) {
            return this.iGroup.hasCourse(course);
        }
        return false;
    }

    public boolean isCourseSelected(String course) {
        if (this.iGroup != null) {
            return this.iGroup.isCourseSelected(course);
        }
        return false;
    }

    public boolean hasCourse(CourseRequestInterface.RequestedCourse course) {
        if (this.iGroup != null) {
            return this.iGroup.hasCourse(course);
        }
        return false;
    }

    public boolean isCourseSelected(CourseRequestInterface.RequestedCourse course) {
        if (this.iGroup != null) {
            return this.iGroup.isCourseSelected(course);
        }
        return false;
    }

    public String toString() {
        return this.iName + ": " + this.iGroup;
    }

    public static class DegreePlaceHolderInterface
    extends DegreeItemInterface {
        private static final long serialVersionUID = 1L;
        private String iType;
        private String iName;

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getType() {
            return this.iType;
        }

        public void setType(String type) {
            this.iType = type;
        }

        public String toString() {
            return this.iType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DegreeCourseInterface
    extends DegreeItemInterface {
        private static final long serialVersionUID = 1L;
        private Long iCourseId = null;
        private String iSubject;
        private String iCourse;
        private String iTitle;
        private Boolean iSelected = null;
        private List<ClassAssignmentInterface.CourseAssignment> iCourses;

        public String getSubject() {
            return this.iSubject;
        }

        public void setSubject(String subject) {
            this.iSubject = subject;
        }

        public String getCourse() {
            return this.iCourse;
        }

        public void setCourse(String course) {
            this.iCourse = course;
        }

        public boolean hasTitle() {
            return this.iTitle != null && !this.iTitle.isEmpty();
        }

        public String getTitle() {
            return this.iTitle;
        }

        public void setTitle(String title) {
            this.iTitle = title;
        }

        public boolean hasSelected() {
            return this.iSelected != null;
        }

        public boolean isSelected() {
            return this.iSelected == null || this.iSelected != false;
        }

        public void setSelected(boolean selected) {
            this.iSelected = selected;
        }

        public Long getCourseId() {
            return this.iCourseId;
        }

        public void setCourseId(Long courseId) {
            this.iCourseId = courseId;
        }

        public String getCourseName() {
            return this.getSubject() + " " + this.getCourse();
        }

        public String getCourseNameWithTitle() {
            return this.hasTitle() ? this.getSubject() + " " + this.getCourse() + " - " + this.getTitle() : this.getSubject() + " " + this.getCourse();
        }

        public boolean hasCourses() {
            return this.iCourses != null && !this.iCourses.isEmpty();
        }

        public boolean hasMultipleCourses() {
            return this.iCourses != null && this.iCourses.size() > 1;
        }

        public List<ClassAssignmentInterface.CourseAssignment> getCourses() {
            return this.iCourses;
        }

        public void addCourse(ClassAssignmentInterface.CourseAssignment course) {
            if (this.iCourses == null) {
                this.iCourses = new ArrayList<ClassAssignmentInterface.CourseAssignment>();
            }
            this.iCourses.add(course);
        }

        public ClassAssignmentInterface.CourseAssignment getSelectedCourse(boolean pickOneWhenNoneSelected) {
            if (this.iCourses != null && this.iCourseId != null) {
                for (ClassAssignmentInterface.CourseAssignment course : this.iCourses) {
                    if (!this.iCourseId.equals(course.getCourseId())) continue;
                    return course;
                }
            }
            if (pickOneWhenNoneSelected && this.iCourses != null && !this.iCourses.isEmpty()) {
                for (ClassAssignmentInterface.CourseAssignment course : this.iCourses) {
                    if (!this.getCourseName().equals(course.getCourseName())) continue;
                    return course;
                }
                return this.iCourses.get(0);
            }
            return null;
        }

        public String toString() {
            ClassAssignmentInterface.CourseAssignment ca = this.getSelectedCourse(false);
            if (ca != null) {
                return ca.getCourseName();
            }
            return this.getCourseName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DegreeGroupInterface
    extends DegreeItemInterface {
        private static final long serialVersionUID = 1L;
        private boolean iChoice = false;
        List<DegreeCourseInterface> iCourses = null;
        List<DegreeGroupInterface> iGroups = null;
        List<DegreePlaceHolderInterface> iPlaceHolders = null;
        private Boolean iSelected = null;
        private String iDescription = null;

        public boolean isChoice() {
            return this.iChoice;
        }

        public void setChoice(boolean choice) {
            this.iChoice = choice;
        }

        public boolean hasCourses() {
            return this.iCourses != null && !this.iCourses.isEmpty();
        }

        public boolean hasMultipleCourses() {
            if (this.iCourses == null) {
                return false;
            }
            for (DegreeCourseInterface course : this.iCourses) {
                if (!course.hasMultipleCourses()) continue;
                return true;
            }
            return false;
        }

        public List<DegreeCourseInterface> getCourses() {
            return this.iCourses;
        }

        public void addCourse(DegreeCourseInterface course) {
            if (this.iCourses == null) {
                this.iCourses = new ArrayList<DegreeCourseInterface>();
            }
            this.iCourses.add(course);
        }

        public boolean hasGroups() {
            return this.iGroups != null && !this.iGroups.isEmpty();
        }

        public List<DegreeGroupInterface> getGroups() {
            return this.iGroups;
        }

        public void addGroup(DegreeGroupInterface group) {
            if (this.iGroups == null) {
                this.iGroups = new ArrayList<DegreeGroupInterface>();
            }
            this.iGroups.add(group);
        }

        public void merge(DegreeGroupInterface group) {
            if (group.hasCourses()) {
                for (DegreeCourseInterface course : group.getCourses()) {
                    this.addCourse(course);
                }
            }
            if (group.hasPlaceHolders()) {
                for (DegreePlaceHolderInterface ph : group.getPlaceHolders()) {
                    this.addPlaceHolder(ph);
                }
            }
            if (group.hasGroups()) {
                for (DegreeGroupInterface g : group.getGroups()) {
                    if (this.isChoice() == g.isChoice()) {
                        this.merge(g);
                        continue;
                    }
                    this.addGroup(g);
                }
            }
        }

        public boolean hasPlaceHolders() {
            return this.iPlaceHolders != null && !this.iPlaceHolders.isEmpty();
        }

        public List<DegreePlaceHolderInterface> getPlaceHolders() {
            return this.iPlaceHolders;
        }

        public void addPlaceHolder(DegreePlaceHolderInterface placeHolder) {
            if (this.iPlaceHolders == null) {
                this.iPlaceHolders = new ArrayList<DegreePlaceHolderInterface>();
            }
            this.iPlaceHolders.add(placeHolder);
        }

        public boolean hasSelected() {
            return this.iSelected != null;
        }

        public boolean isSelected() {
            return this.iSelected == null || this.iSelected != false;
        }

        public void setSelected(boolean selected) {
            this.iSelected = selected;
        }

        public boolean hasDescription() {
            return this.iDescription != null && !this.iDescription.isEmpty();
        }

        public String getDescription() {
            return this.hasDescription() ? this.iDescription : this.toString();
        }

        public void setDescription(String description) {
            this.iDescription = description;
        }

        public int countItems() {
            return (this.hasPlaceHolders() ? this.getPlaceHolders().size() : 0) + (this.hasGroups() ? this.getGroups().size() : 0) + (this.hasCourses() ? this.getCourses().size() : 0);
        }

        public boolean isUnionGroupWithOneChoice() {
            if (this.isChoice()) {
                return false;
            }
            int nrChoices = (this.hasPlaceHolders() ? this.getPlaceHolders().size() : 0) + (this.hasGroups() ? this.getGroups().size() : 0) + (this.hasCourses() ? this.getCourses().size() : 0);
            return nrChoices == 1;
        }

        public int getMaxDepth() {
            if (this.iGroups == null || this.iGroups.isEmpty()) {
                return !this.isChoice() && this.hasMultipleCourses() ? 2 : 1;
            }
            int ret = 0;
            for (DegreeGroupInterface g : this.iGroups) {
                if (ret >= g.getMaxDepth()) continue;
                ret = g.getMaxDepth();
            }
            return 1 + ret;
        }

        public String toString() {
            String ret = "";
            if (this.iCourses != null) {
                for (DegreeCourseInterface course : this.iCourses) {
                    ret = ret + (ret.isEmpty() ? "" : (this.iChoice ? " or " : " and ")) + course;
                }
            }
            if (this.iGroups != null) {
                for (DegreeGroupInterface group : this.iGroups) {
                    ret = ret + (ret.isEmpty() ? "" : (this.iChoice ? " or " : " and ")) + "(" + group + ")";
                }
            }
            if (this.iPlaceHolders != null) {
                for (DegreePlaceHolderInterface ph : this.iPlaceHolders) {
                    ret = ret + (ret.isEmpty() ? "" : (this.iChoice ? " or " : " and ")) + ph;
                }
            }
            return ret;
        }

        public String toString(StudentSectioningMessages MESSAGES) {
            ArrayList<String> items = new ArrayList<String>();
            if (this.iCourses != null) {
                for (DegreeCourseInterface course : this.iCourses) {
                    items.add(MESSAGES.course(course.getSubject(), course.getCourse()));
                }
            }
            if (this.iGroups != null) {
                for (DegreeGroupInterface group : this.iGroups) {
                    items.add(MESSAGES.surroundWithBrackets(group.toString(MESSAGES)));
                }
            }
            if (this.iPlaceHolders != null) {
                for (DegreePlaceHolderInterface ph : this.iPlaceHolders) {
                    items.add(ph.getType());
                }
            }
            switch (items.size()) {
                case 0: {
                    return "";
                }
                case 1: {
                    return (String)items.get(0);
                }
                case 2: {
                    return this.isChoice() ? MESSAGES.choiceSeparatorPair((String)items.get(0), (String)items.get(1)) : MESSAGES.courseSeparatorPair((String)items.get(0), (String)items.get(1));
                }
            }
            String ret = null;
            Iterator i = items.iterator();
            while (i.hasNext()) {
                String item = (String)i.next();
                if (ret == null) {
                    ret = item;
                    continue;
                }
                if (i.hasNext()) {
                    ret = this.isChoice() ? MESSAGES.choiceSeparatorMiddle(ret, item) : MESSAGES.courseSeparatorMiddle(ret, item);
                    continue;
                }
                ret = this.isChoice() ? MESSAGES.choiceSeparatorLast(ret, item) : MESSAGES.courseSeparatorLast(ret, item);
            }
            return ret;
        }

        protected void listSelected(List<DegreeCourseInterface> requested, boolean pickFirstWhenNoneSelected) {
            boolean hasSelection = false;
            if (this.hasCourses()) {
                for (DegreeCourseInterface course : this.getCourses()) {
                    if (this.isChoice() && !course.isSelected()) continue;
                    requested.add(course);
                    hasSelection = true;
                }
            }
            if (this.hasGroups()) {
                for (DegreeGroupInterface g : this.getGroups()) {
                    if (this.isChoice() && !g.isSelected()) continue;
                    g.listSelected(requested, pickFirstWhenNoneSelected);
                    hasSelection = true;
                }
            }
            if (this.isChoice() && !hasSelection && pickFirstWhenNoneSelected) {
                if (this.hasCourses()) {
                    requested.add(this.getCourses().get(0));
                } else if (this.hasGroups()) {
                    this.getGroups().get(0).listSelected(requested, pickFirstWhenNoneSelected);
                }
            }
        }

        public boolean hasCourse(DegreeCourseInterface course) {
            if (this.hasCourses()) {
                for (DegreeCourseInterface c : this.getCourses()) {
                    if (!c.getId().equals(course.getId())) continue;
                    return true;
                }
            }
            if (this.hasGroups()) {
                for (DegreeGroupInterface g : this.getGroups()) {
                    if (!g.hasCourse(course)) continue;
                    return true;
                }
            }
            return false;
        }

        protected void listAlternatives(List<DegreeCourseInterface> alternatives, DegreeCourseInterface course) {
            block7: {
                block6: {
                    if (!this.isChoice() || !this.hasCourse(course)) break block6;
                    if (this.hasCourses()) {
                        for (DegreeCourseInterface c : this.getCourses()) {
                            if (c.getId().equals(course.getId())) continue;
                            alternatives.add(c);
                        }
                    }
                    if (!this.hasGroups()) break block7;
                    for (DegreeGroupInterface g : this.getGroups()) {
                        if (!g.hasCourses()) continue;
                        for (DegreeCourseInterface c : g.getCourses()) {
                            if (c.getId().equals(course.getId())) continue;
                            alternatives.add(c);
                        }
                    }
                    break block7;
                }
                if (this.hasGroups()) {
                    for (DegreeGroupInterface g : this.getGroups()) {
                        g.listAlternatives(alternatives, course);
                    }
                }
            }
        }

        public boolean hasSelection() {
            if (this.hasCourses()) {
                for (DegreeCourseInterface course : this.getCourses()) {
                    if (this.isChoice() && !course.isSelected()) continue;
                    return true;
                }
            }
            if (this.hasGroups()) {
                for (DegreeGroupInterface g : this.getGroups()) {
                    if (this.isChoice() && !g.isSelected()) continue;
                    return true;
                }
            }
            return false;
        }

        protected boolean hasCourse(String name) {
            if (this.iCourses != null) {
                for (DegreeCourseInterface course : this.iCourses) {
                    if (course.hasCourses()) {
                        for (ClassAssignmentInterface.CourseAssignment ca : course.getCourses()) {
                            if (!name.equalsIgnoreCase(ca.getCourseName()) && !name.equalsIgnoreCase(ca.getCourseNameWithTitle())) continue;
                            return true;
                        }
                    }
                    if (!name.equals(course.getCourseName()) && !name.equalsIgnoreCase(course.getCourseNameWithTitle())) continue;
                    return true;
                }
            }
            if (this.iGroups != null) {
                for (DegreeGroupInterface g : this.iGroups) {
                    if (!g.hasCourse(name)) continue;
                    return true;
                }
            }
            return false;
        }

        protected boolean isCourseSelected(String name) {
            if (this.iCourses != null) {
                for (DegreeCourseInterface course : this.iCourses) {
                    if (this.isChoice() && !course.isSelected()) continue;
                    if (course.hasCourses() && course.getCourseId() != null) {
                        for (ClassAssignmentInterface.CourseAssignment ca : course.getCourses()) {
                            if (!course.getCourseId().equals(ca.getCourseId()) || !name.equalsIgnoreCase(ca.getCourseName()) && !name.equalsIgnoreCase(ca.getCourseNameWithTitle())) continue;
                            return true;
                        }
                        continue;
                    }
                    if (!name.equals(course.getCourseName()) && !name.equalsIgnoreCase(course.getCourseNameWithTitle())) continue;
                    return true;
                }
            }
            if (this.iGroups != null) {
                for (DegreeGroupInterface g : this.iGroups) {
                    if (this.isChoice() && !g.isSelected() || !g.hasCourse(name)) continue;
                    return true;
                }
            }
            return false;
        }

        protected boolean hasCourse(CourseRequestInterface.RequestedCourse rc) {
            if (this.iCourses != null) {
                for (DegreeCourseInterface course : this.iCourses) {
                    if (course.hasCourses()) {
                        for (ClassAssignmentInterface.CourseAssignment ca : course.getCourses()) {
                            if (!rc.equals(ca)) continue;
                            return true;
                        }
                    }
                    if (!rc.equals(course)) continue;
                    return true;
                }
            }
            if (this.iGroups != null) {
                for (DegreeGroupInterface g : this.iGroups) {
                    if (!g.hasCourse(rc)) continue;
                    return true;
                }
            }
            return false;
        }

        protected boolean isCourseSelected(CourseRequestInterface.RequestedCourse rc) {
            if (this.iCourses != null) {
                for (DegreeCourseInterface course : this.iCourses) {
                    if (this.isChoice() && !course.isSelected()) continue;
                    if (course.hasCourses() && course.getCourseId() != null) {
                        for (ClassAssignmentInterface.CourseAssignment ca : course.getCourses()) {
                            if (!course.getCourseId().equals(ca.getCourseId()) || !rc.equals(ca)) continue;
                            return true;
                        }
                        continue;
                    }
                    if (!rc.equals(course)) continue;
                    return true;
                }
            }
            if (this.iGroups != null) {
                for (DegreeGroupInterface g : this.iGroups) {
                    if (this.isChoice() && !g.isSelected() || !g.hasCourse(rc)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static abstract class DegreeItemInterface
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String iId = null;

        public String getId() {
            return this.iId;
        }

        public void setId(String id) {
            this.iId = id;
        }
    }
}

