/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.solver.suggestions;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.unitime.timetable.gwt.client.aria.AriaButton;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.solver.SolverCookie;
import org.unitime.timetable.gwt.client.solver.suggestions.SuggestionsFilter;
import org.unitime.timetable.gwt.client.solver.suggestions.SuggestionsPageContext;
import org.unitime.timetable.gwt.client.solver.suggestions.SuggestionsTable;
import org.unitime.timetable.gwt.client.widgets.FilterBox;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SuggestionsInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuggestionsWidget
extends SimpleForm {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private SuggestionsPageContext iContext;
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private SuggestionsInterface.ComputeSuggestionsRequest iRequest;
    private SuggestionsTable iTable;
    private int iHeaderRow = 0;
    private int iFooterRow = 0;
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private boolean iSuggestionsComputed = false;
    private SuggestionsFilter iFilter = null;
    private AriaButton iApply = null;

    public SuggestionsWidget(SuggestionsPageContext context) {
        super(3);
        this.iContext = context;
        this.iHeader = new UniTimeHeaderPanel(MESSAGES.headerSuggestions());
        this.iHeader.setCollapsible(SolverCookie.getInstance().isShowSuggestions());
        this.iHeader.addCollapsibleHandler(new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                SolverCookie.getInstance().setShowSuggestions((Boolean)event.getValue());
                if (((Boolean)event.getValue()).booleanValue()) {
                    SuggestionsWidget.this.showSuggestions();
                } else {
                    SuggestionsWidget.this.hideSuggestions();
                }
            }
        });
        this.iFooter = new UniTimeHeaderPanel();
        this.iFooter.addButton("deeper", MESSAGES.buttonSearchDeeper(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                SuggestionsWidget.this.iFilter.removeChip(new FilterBox.Chip("depth", null), false);
                SuggestionsWidget.this.iFilter.addChip(new FilterBox.Chip("depth", "D" + (SuggestionsWidget.this.iRequest.getDepth() + 1)), false);
                SuggestionsWidget.this.iRequest.setDepth(SuggestionsWidget.this.iRequest.getDepth() + 1);
                SuggestionsWidget.this.computeSuggestions();
            }
        });
        this.iFooter.addButton("longer", MESSAGES.buttonSearchLonger(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                SuggestionsWidget.this.iFilter.removeChip(new FilterBox.Chip("timeout", null), false);
                SuggestionsWidget.this.iFilter.addChip(new FilterBox.Chip("timeout", "T" + 2 * SuggestionsWidget.this.iRequest.getTimeLimit() / 1000), false);
                SuggestionsWidget.this.iRequest.setTimeLimit(2 * SuggestionsWidget.this.iRequest.getTimeLimit());
                SuggestionsWidget.this.computeSuggestions();
            }
        });
        this.removeStyleName("unitime-NotPrintableBottomLine");
        this.iApply = new AriaButton(MESSAGES.buttonSearch());
        this.iApply.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SuggestionsWidget.this.computeSuggestions();
            }
        });
    }

    public void onSelection(SuggestionsInterface.Suggestion suggestion) {
    }

    public void clearMessage() {
        this.iHeader.clearMessage();
        this.iFooter.clearMessage();
    }

    public void setInfoMessage(String message) {
        this.iHeader.clearMessage();
        this.iFooter.setMessage(message);
    }

    public void showLoading() {
        this.iHeader.showLoading();
        this.iFooter.clearMessage();
    }

    public void setRequest(SuggestionsInterface.SelectedAssignmentsRequest request) {
        this.setSelection(request.getAssignments(), request.getClassId());
    }

    public void setSelection(List<SuggestionsInterface.SelectedAssignment> assignments, Long classId) {
        this.clearMessage();
        if (this.iFilter == null) {
            this.iFilter = new SuggestionsFilter();
            this.iFilter.setValue(SolverCookie.getInstance().getSuggestionsFilter());
        }
        this.iFilter.setClassId(classId);
        this.clear();
        this.iSuggestionsComputed = false;
        if (this.iTable == null) {
            this.iTable = new SuggestionsTable(this.iContext.getProperties(), true);
            this.iTable.setVisible(false);
            this.iTable.addMouseClickListener(new UniTimeTable.MouseClickListener<SuggestionsInterface.Suggestion>(){

                @Override
                public void onMouseClick(UniTimeTable.TableEvent<SuggestionsInterface.Suggestion> event) {
                    if (event.getData() != null) {
                        SuggestionsWidget.this.onSelection(event.getData());
                    }
                }
            });
        } else {
            this.iTable.setVisible(false);
        }
        this.iHeaderRow = this.addHeaderRow((Widget)this.iHeader);
        int filterRow = this.addRow(MESSAGES.propFilter(), (Widget)this.iFilter, 1);
        this.setWidget(filterRow, 2, (Widget)this.iApply);
        this.addRow((Widget)this.iTable);
        this.iFooter.setEnabled("longer", false);
        this.iFooter.setEnabled("deeper", false);
        this.iFooterRow = this.addBottomRow((Widget)this.iFooter);
        this.getFlexCellFormatter().removeStyleName(this.iFooterRow, 0, "unitime-TopLine");
        this.iRequest = new SuggestionsInterface.ComputeSuggestionsRequest(classId, assignments);
        if (SolverCookie.getInstance().isShowSuggestions()) {
            this.showSuggestions();
        } else {
            this.hideSuggestions();
        }
    }

    protected void hideSuggestions() {
        for (int i = this.iHeaderRow + 1; i <= this.iFooterRow; ++i) {
            this.getRowFormatter().setVisible(i, false);
        }
    }

    protected void showSuggestions() {
        for (int i = this.iHeaderRow + 1; i <= this.iFooterRow; ++i) {
            this.getRowFormatter().setVisible(i, true);
        }
        if (!this.iSuggestionsComputed) {
            this.computeSuggestions();
        }
    }

    protected void computeSuggestions() {
        FilterBox.Chip timeout;
        FilterBox.Chip results;
        this.iSuggestionsComputed = true;
        this.iTable.setVisible(false);
        this.iApply.setEnabled(false);
        this.showLoading();
        FilterBox.Chip depth = this.iFilter.getChip("depth");
        if (depth != null) {
            this.iRequest.setDepth(Integer.parseInt(depth.getValue().startsWith("D") || depth.getValue().startsWith("d") ? depth.getValue().substring(1) : depth.getValue()));
        }
        if ((results = this.iFilter.getChip("results")) != null) {
            this.iRequest.setLimit(Integer.parseInt(results.getValue().startsWith("R") || results.getValue().startsWith("r") ? results.getValue().substring(1) : results.getValue()));
        }
        if ((timeout = this.iFilter.getChip("timeout")) != null) {
            this.iRequest.setTimeLimit(1000 * Integer.parseInt(timeout.getValue().startsWith("T") || timeout.getValue().startsWith("t") ? timeout.getValue().substring(1) : timeout.getValue()));
        }
        this.iRequest.setSameRoom(this.iFilter.hasChip(new FilterBox.Chip("flag", "Same Room")));
        this.iRequest.setSameTime(this.iFilter.hasChip(new FilterBox.Chip("flag", "Same Time")));
        this.iRequest.setAllowBreakHard(this.iFilter.hasChip(new FilterBox.Chip("flag", "Allow Break Hard")));
        this.iRequest.setPlacements(this.iFilter.hasChip(new FilterBox.Chip("mode", "Placements")));
        this.iRequest.setFilter(this.iFilter.getValue());
        this.iFooter.setEnabled("longer", false);
        this.iFooter.setEnabled("deeper", false);
        RPC.execute(this.iRequest, new AsyncCallback<SuggestionsInterface.Suggestions>(){

            public void onFailure(Throwable caught) {
                SuggestionsWidget.this.iHeader.setErrorMessage(MESSAGES.failedToComputeSuggestions(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToComputeSuggestions(caught.getMessage()), caught);
                SuggestionsWidget.this.iApply.setEnabled(true);
            }

            public void onSuccess(SuggestionsInterface.Suggestions result) {
                SuggestionsWidget.this.iTable.setValue(result.getSuggestions());
                SuggestionsWidget.this.iTable.setVisible(true);
                SuggestionsWidget.this.iApply.setEnabled(true);
                SuggestionsWidget.this.iFooter.setEnabled("longer", result.isTimeoutReached());
                SuggestionsWidget.this.iFooter.setEnabled("deeper", true);
                if (result.size() == 0) {
                    if (result.isTimeoutReached()) {
                        SuggestionsWidget.this.setInfoMessage(MESSAGES.suggestionsNoteTimeoutNoResults(result.getTimeLimit() / 1000, result.getNrCombinationsConsidered(), result.getDepth()));
                    } else {
                        SuggestionsWidget.this.setInfoMessage(MESSAGES.suggestionsNoteNoTimeoutNoResults(result.getNrCombinationsConsidered(), result.getDepth()));
                    }
                } else if (result.size() < result.getNrSolutions()) {
                    if (result.isTimeoutReached()) {
                        SuggestionsWidget.this.setInfoMessage(MESSAGES.suggestionsNoteTimeoutNResults(result.getTimeLimit() / 1000, result.getNrCombinationsConsidered(), result.getDepth(), result.getSuggestions().size(), result.getNrSolutions()));
                    } else {
                        SuggestionsWidget.this.setInfoMessage(MESSAGES.suggestionsNoteNoTimeoutNResults(result.getNrCombinationsConsidered(), result.getDepth(), result.getSuggestions().size(), result.getNrSolutions()));
                    }
                } else if (result.isTimeoutReached()) {
                    SuggestionsWidget.this.setInfoMessage(MESSAGES.suggestionsNoteTimeoutAllResults(result.getTimeLimit() / 1000, result.getNrCombinationsConsidered(), result.getDepth(), result.getSuggestions().size()));
                } else {
                    SuggestionsWidget.this.setInfoMessage(MESSAGES.suggestionsNoteNoTimeoutAllResults(result.getNrCombinationsConsidered(), result.getDepth(), result.getSuggestions().size()));
                }
            }
        });
    }
}

