/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.solver.suggestions;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.TimeHint;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.rooms.RoomHint;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SuggestionsInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SuggestionsPageContext {
    protected static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static NumberFormat sDF = NumberFormat.getFormat((String)"0.###");
    private SuggestionsInterface.SuggestionProperties iProperties;

    public SuggestionsInterface.SuggestionProperties getProperties() {
        return this.iProperties;
    }

    public void setSuggestionProperties(SuggestionsInterface.SuggestionProperties properties) {
        this.iProperties = properties;
    }

    public abstract void select(SuggestionsInterface.ClassInfo var1);

    public abstract void remove(SuggestionsInterface.ClassInfo var1);

    public abstract void onSelection(Command var1);

    public abstract void assign(List<SuggestionsInterface.SelectedAssignment> var1, UniTimeHeaderPanel var2);

    public DateLabel createDateLabel(SuggestionsInterface.DateInfo date) {
        return new DateLabel(date);
    }

    public TimeLabel createTimeLabel(SuggestionsInterface.TimeInfo time, Long classId, boolean endTime) {
        return new TimeLabel(time, classId, endTime);
    }

    public RoomsLabel createRoomsLabel(List<SuggestionsInterface.RoomInfo> rooms) {
        return new RoomsLabel(rooms);
    }

    public AssignmentLabel createAssignmentLabel(SuggestionsInterface.TimeInfo time, List<SuggestionsInterface.RoomInfo> rooms, Long classId, boolean showDate) {
        return new AssignmentLabel(time, rooms, classId, showDate);
    }

    public InstructorsLabel createInstructorsLabel(List<SuggestionsInterface.InstructorInfo> instructors) {
        return new InstructorsLabel(instructors);
    }

    public StudentConflicts createStudentConflicts(List<SuggestionsInterface.StudentConflictInfo> conflicts) {
        return new StudentConflicts(conflicts);
    }

    protected static String getCurriculumText(Set<SuggestionsInterface.CurriculumInfo> curricula) {
        int top = 0;
        double total = 0.0;
        for (SuggestionsInterface.CurriculumInfo i : curricula) {
            total += (double)i.getNrStudents();
        }
        String ret = "";
        for (SuggestionsInterface.CurriculumInfo i : curricula) {
            double fraction = (double)i.getNrStudents() / total;
            if (top < 3) {
                ++top;
                if (!ret.isEmpty()) {
                    ret = ret + CONSTANTS.itemSeparator();
                }
                ret = ret + (int)Math.round(100.0 * fraction) + "% " + i.getName();
                if (fraction != 1.0) continue;
                return i.getName();
            }
            ret = ret + CONSTANTS.itemMore();
            break;
        }
        return ret;
    }

    public ViolatedConstraints createViolatedConstraints(List<SuggestionsInterface.DistributionInfo> conflicts, List<SuggestionsInterface.BtbInstructorInfo> btbConflicts) {
        return new ViolatedConstraints(conflicts, btbConflicts);
    }

    public DateLocations createDateLocations(List<SuggestionsInterface.TimeInfo> times) {
        return new DateLocations(times);
    }

    protected TimeLocations createTimeLocations(Long classId, List<SuggestionsInterface.TimeInfo> times) {
        return new TimeLocations(classId, times);
    }

    public RoomLocations createRoomLocations(int nrRooms, List<SuggestionsInterface.RoomInfo> rooms) {
        return new RoomLocations(nrRooms, rooms);
    }

    protected P withSeparator(P item, boolean hasNext) {
        if (hasNext) {
            return new Composite(item, new Separator());
        }
        return new Composite(item);
    }

    public static String dispNumber(int number) {
        return SuggestionsPageContext.dispNumber("", number);
    }

    public static String dispNumber(String prefix, int number) {
        if (number > 0) {
            return "<font color='red'>" + prefix + "+" + number + "</font>";
        }
        if (number < 0) {
            return "<font color='green'>" + prefix + number + "</font>";
        }
        return prefix + "0";
    }

    public static String dispNumber(int n1, int n2) {
        return SuggestionsPageContext.dispNumber(n1 - n2) + " (" + n2 + (n1 == n2 ? "" : " &rarr; " + n1) + ")";
    }

    public static String dispNumber(double n1, double n2) {
        return SuggestionsPageContext.dispNumber(n1 - n2) + " (" + sDF.format(n2) + (n1 == n2 ? "" : " &rarr; " + sDF.format(n1)) + ")";
    }

    public static String dispNumber(double number) {
        return SuggestionsPageContext.dispNumber("", number);
    }

    public static String dispNumber(String prefix, double number) {
        if (number > 0.0) {
            return "<font color='red'>" + prefix + "+" + sDF.format(number) + "</font>";
        }
        if (number < 0.0) {
            return "<font color='green'>" + prefix + sDF.format(number) + "</font>";
        }
        return prefix + "0";
    }

    protected class Composite
    extends P {
        public Composite(P ... items) {
            super("composite");
            for (P item : items) {
                this.add((Widget)item);
            }
        }
    }

    protected class Separator
    extends P {
        public Separator() {
            super("separator");
            this.setText(CONSTANTS.itemSeparator());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RoomLocations
    extends P {
        Map<Long, RoomLocation> iRooms;
        int iNrRooms;
        List<RoomLocation> iSelectedRooms;
        P iMore;

        public RoomLocations(int nrRooms, List<SuggestionsInterface.RoomInfo> rooms) {
            super("rooms", "selection");
            this.iRooms = new HashMap<Long, RoomLocation>();
            this.iNrRooms = 0;
            this.iSelectedRooms = new ArrayList<RoomLocation>();
            this.iMore = null;
            this.iNrRooms = nrRooms;
            Collections.sort(rooms);
            Iterator<SuggestionsInterface.RoomInfo> i = rooms.iterator();
            while (i.hasNext()) {
                SuggestionsInterface.RoomInfo room = i.next();
                if (room.isStriked() && this.iMore == null) {
                    this.iMore = new P("more");
                    this.iMore.setText(CONSTANTS.selectionMore());
                    this.iMore.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent e) {
                            RoomLocations panel = RoomLocations.this;
                            for (int i = panel.getWidgetIndex((Widget)RoomLocations.this.iMore) + 1; i < panel.getWidgetCount(); ++i) {
                                panel.getWidget(i).setVisible(true);
                            }
                            RoomLocations.this.iMore.setVisible(false);
                        }
                    });
                    this.add((Widget)this.iMore);
                }
                RoomLocation location = new RoomLocation(room);
                this.iRooms.put(room.getId(), location);
                P p = SuggestionsPageContext.this.withSeparator(location, i.hasNext());
                if (room.isStriked()) {
                    p.setVisible(false);
                }
                this.add((Widget)p);
            }
        }

        protected void invert(final RoomLocation room, boolean fireUpdate) {
            for (int i = 0; i < this.iSelectedRooms.size(); ++i) {
                if (!((Object)((Object)this.iSelectedRooms.get(i))).equals((Object)room)) continue;
                this.iSelectedRooms.get(i).removeStyleName("selected");
                this.iSelectedRooms.remove(i);
                return;
            }
            if (this.iSelectedRooms.size() >= this.iNrRooms) {
                this.iSelectedRooms.get(this.iNrRooms - 1).removeStyleName("selected");
                this.iSelectedRooms.remove(this.iNrRooms - 1);
            }
            if (room != null) {
                this.iSelectedRooms.add(0, room);
                room.addStyleName("selected");
            }
            if (fireUpdate) {
                SuggestionsPageContext.this.onSelection(new Command(){

                    public void execute() {
                        RoomLocations.this.invert(room, false);
                    }
                });
            }
        }

        protected void select(final RoomLocation room, boolean fireUpdate) {
            for (int i = 0; i < this.iSelectedRooms.size(); ++i) {
                if (!((Object)((Object)this.iSelectedRooms.get(i))).equals((Object)room)) continue;
                this.iSelectedRooms.get(i).removeStyleName("selected");
                this.iSelectedRooms.remove(i);
            }
            if (this.iSelectedRooms.size() >= this.iNrRooms) {
                this.iSelectedRooms.get(this.iNrRooms - 1).removeStyleName("selected");
                this.iSelectedRooms.remove(this.iNrRooms - 1);
            }
            if (room != null) {
                this.iSelectedRooms.add(0, room);
                room.addStyleName("selected");
            }
            if (fireUpdate) {
                SuggestionsPageContext.this.onSelection(new Command(){

                    public void execute() {
                        RoomLocations.this.invert(room, false);
                    }
                });
            }
        }

        protected void select(SuggestionsInterface.RoomInfo room, boolean fireUpdate) {
            this.select(room == null ? null : this.iRooms.get(room.getId()), fireUpdate);
        }

        public int getNrSelectedRooms() {
            return this.iSelectedRooms.size();
        }

        public List<SuggestionsInterface.RoomInfo> getSelectedRooms() {
            ArrayList<SuggestionsInterface.RoomInfo> rooms = new ArrayList<SuggestionsInterface.RoomInfo>();
            for (RoomLocation loc : this.iSelectedRooms) {
                rooms.add(loc.iRoom);
            }
            return rooms;
        }

        protected class RoomLocation
        extends P {
            private SuggestionsInterface.RoomInfo iRoom;

            public RoomLocation(final SuggestionsInterface.RoomInfo room) {
                super("room", "item");
                this.iRoom = room;
                this.setText(room.getName());
                if (room.getPref() != 0) {
                    this.getElement().getStyle().setColor(SuggestionsPageContext.this.iProperties.getPreference(room.getPref()).getColor());
                }
                if (room.isStriked()) {
                    this.getElement().getStyle().setTextDecoration(Style.TextDecoration.LINE_THROUGH);
                }
                this.addMouseOverHandler(new MouseOverHandler(){

                    public void onMouseOver(MouseOverEvent e) {
                        RoomHint.showHint((Element)RoomLocation.this.getElement(), room.getId(), null, null, true);
                    }
                });
                this.addMouseOutHandler(new MouseOutHandler(){

                    public void onMouseOut(MouseOutEvent e) {
                        RoomHint.hideHint();
                    }
                });
                this.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent e) {
                        RoomLocations.this.invert(RoomLocation.this, true);
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TimeLocations
    extends P {
        Map<String, TimeLocation> iTimes;
        TimeLocation iSelectedTime;
        P iMore;

        public TimeLocations(Long classId, List<SuggestionsInterface.TimeInfo> times) {
            super("times", "selection");
            this.iTimes = new HashMap<String, TimeLocation>();
            this.iSelectedTime = null;
            this.iMore = null;
            TreeSet<SuggestionsInterface.TimeInfo> t = new TreeSet<SuggestionsInterface.TimeInfo>(new Comparator<SuggestionsInterface.TimeInfo>(){

                @Override
                public int compare(SuggestionsInterface.TimeInfo t1, SuggestionsInterface.TimeInfo t2) {
                    if (t1.isStriked() && !t2.isStriked()) {
                        return 1;
                    }
                    if (!t1.isStriked() && t2.isStriked()) {
                        return -1;
                    }
                    int cmp = Double.compare(t1.getDaysOrder(SuggestionsPageContext.this.iProperties.getFirstDay()), t2.getDaysOrder(SuggestionsPageContext.this.iProperties.getFirstDay()));
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = Double.compare(t1.getStartSlot(), t2.getStartSlot());
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = Double.compare(t1.getMin(), t2.getMin());
                    return cmp;
                }
            });
            t.addAll(times);
            Iterator i = t.iterator();
            while (i.hasNext()) {
                SuggestionsInterface.TimeInfo time = (SuggestionsInterface.TimeInfo)i.next();
                if (time.isStriked() && this.iMore == null) {
                    this.iMore = new P("more");
                    this.iMore.setText(CONSTANTS.selectionMore());
                    this.iMore.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent e) {
                            TimeLocations panel = TimeLocations.this;
                            for (int i = panel.getWidgetIndex((Widget)TimeLocations.this.iMore) + 1; i < panel.getWidgetCount(); ++i) {
                                panel.getWidget(i).setVisible(true);
                            }
                            TimeLocations.this.iMore.setVisible(false);
                        }
                    });
                    this.add((Widget)this.iMore);
                }
                TimeLocation location = new TimeLocation(classId, time);
                this.iTimes.put(this.code(time), location);
                P p = SuggestionsPageContext.this.withSeparator(location, i.hasNext());
                if (time.isStriked()) {
                    p.setVisible(false);
                }
                this.add((Widget)p);
            }
        }

        protected String code(SuggestionsInterface.TimeInfo time) {
            return time.getPatternId() + "," + time.getDays() + "," + time.getStartSlot();
        }

        protected void invert(final TimeLocation time, boolean fireUpdate) {
            if (this.iSelectedTime != null) {
                this.iSelectedTime.removeStyleName("selected");
                if (((Object)((Object)this.iSelectedTime)).equals((Object)time)) {
                    this.iSelectedTime = null;
                    return;
                }
            }
            this.iSelectedTime = time;
            if (this.iSelectedTime != null) {
                this.iSelectedTime.addStyleName("selected");
            }
            if (fireUpdate) {
                SuggestionsPageContext.this.onSelection(new Command(){

                    public void execute() {
                        TimeLocations.this.invert(time, false);
                    }
                });
            }
        }

        protected void select(final TimeLocation time, boolean fireUpdate) {
            if (this.iSelectedTime != null) {
                this.iSelectedTime.removeStyleName("selected");
            }
            this.iSelectedTime = time;
            if (this.iSelectedTime != null) {
                this.iSelectedTime.addStyleName("selected");
            }
            if (fireUpdate) {
                SuggestionsPageContext.this.onSelection(new Command(){

                    public void execute() {
                        TimeLocations.this.invert(time, false);
                    }
                });
            }
        }

        protected void select(SuggestionsInterface.TimeInfo time, boolean fireUpdate) {
            this.select(time == null ? (TimeLocation)null : this.iTimes.get(this.code(time)), fireUpdate);
        }

        public SuggestionsInterface.TimeInfo getSelectedTime() {
            return this.iSelectedTime == null ? null : this.iSelectedTime.iTime;
        }

        protected class TimeLocation
        extends P {
            private SuggestionsInterface.TimeInfo iTime;

            public TimeLocation(Long classId, SuggestionsInterface.TimeInfo time) {
                super("time", "item");
                this.iTime = time;
                this.setText(time.getName(SuggestionsPageContext.this.iProperties.getFirstDay(), false, CONSTANTS));
                if (time.getPref() != 0) {
                    this.getElement().getStyle().setColor(SuggestionsPageContext.this.iProperties.getPreference(time.getPref()).getColor());
                }
                if (time.isStriked()) {
                    this.getElement().getStyle().setTextDecoration(Style.TextDecoration.LINE_THROUGH);
                }
                final String timeHint = classId + "," + time.getDays() + "," + time.getStartSlot();
                if (!time.isStriked()) {
                    this.addMouseOverHandler(new MouseOverHandler(){

                        public void onMouseOver(MouseOverEvent e) {
                            TimeHint.showHint((Element)TimeLocation.this.getElement(), timeHint);
                        }
                    });
                    this.addMouseOutHandler(new MouseOutHandler(){

                        public void onMouseOut(MouseOutEvent e) {
                            TimeHint.hideHint();
                        }
                    });
                }
                this.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent e) {
                        TimeLocations.this.invert(TimeLocation.this, true);
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DateLocations
    extends P {
        Map<Long, DateLocation> iDates;
        DateLocation iSelectedDate;

        public DateLocations(List<SuggestionsInterface.TimeInfo> times) {
            super("dates", "selection");
            this.iDates = new HashMap<Long, DateLocation>();
            this.iSelectedDate = null;
            TreeSet<SuggestionsInterface.DateInfo> dates = new TreeSet<SuggestionsInterface.DateInfo>();
            for (SuggestionsInterface.TimeInfo time : times) {
                if (!time.hasDatePattern()) continue;
                dates.add(time.getDatePattern());
            }
            Iterator i = dates.iterator();
            while (i.hasNext()) {
                SuggestionsInterface.DateInfo date = (SuggestionsInterface.DateInfo)i.next();
                DateLocation location = new DateLocation(date);
                this.iDates.put(date.getDatePatternId(), location);
                this.add((Widget)SuggestionsPageContext.this.withSeparator(location, i.hasNext()));
            }
        }

        protected void invert(final DateLocation date, boolean fireUpdate) {
            if (this.iSelectedDate != null) {
                this.iSelectedDate.removeStyleName("selected");
                if (((Object)((Object)this.iSelectedDate)).equals((Object)date)) {
                    this.iSelectedDate = null;
                    return;
                }
            }
            this.iSelectedDate = date;
            if (this.iSelectedDate != null) {
                this.iSelectedDate.addStyleName("selected");
            }
            if (fireUpdate) {
                SuggestionsPageContext.this.onSelection(new Command(){

                    public void execute() {
                        DateLocations.this.invert(date, false);
                    }
                });
            }
        }

        protected void select(final DateLocation date, boolean fireUpdate) {
            if (this.iSelectedDate != null) {
                this.iSelectedDate.removeStyleName("selected");
            }
            this.iSelectedDate = date;
            if (this.iSelectedDate != null) {
                this.iSelectedDate.addStyleName("selected");
            }
            if (fireUpdate) {
                SuggestionsPageContext.this.onSelection(new Command(){

                    public void execute() {
                        DateLocations.this.invert(date, false);
                    }
                });
            }
        }

        protected void select(SuggestionsInterface.DateInfo date, boolean fireUpdate) {
            this.select(date == null ? (DateLocation)null : this.iDates.get(date.getDatePatternId()), fireUpdate);
        }

        protected SuggestionsInterface.DateInfo getSelectedDate() {
            return this.iSelectedDate == null ? null : this.iSelectedDate.iDate;
        }

        protected class DateLocation
        extends P {
            private SuggestionsInterface.DateInfo iDate;

            public DateLocation(SuggestionsInterface.DateInfo date) {
                super("date", "item");
                this.iDate = date;
                this.setText(date.getDatePatternName());
                if (date.getDatePatternPreference() != 0) {
                    this.getElement().getStyle().setColor(SuggestionsPageContext.this.iProperties.getPreference(date.getDatePatternPreference()).getColor());
                }
                this.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent e) {
                        DateLocations.this.invert(DateLocation.this, true);
                    }
                });
            }
        }
    }

    protected class ViolatedConstraint
    extends P {
        public ViolatedConstraint(SuggestionsInterface.DistributionInfo conflict) {
            super("constraint");
            P h = new P("header");
            P pref = new P("preference");
            SuggestionsInterface.PreferenceInterface preference = SuggestionsPageContext.this.iProperties.getPreference(conflict.getInfo().getPreference());
            pref.setText(preference.getName());
            pref.getElement().getStyle().setColor(preference.getColor());
            h.add((Widget)pref);
            P name = new P("name");
            name.setText(conflict.getInfo().getName());
            h.add((Widget)name);
            this.add((Widget)h);
            for (SuggestionsInterface.ClassAssignmentDetails other : conflict.getOtherClasses()) {
                P p = new P("other");
                p.add((Widget)new ClassLabel(other.getClazz()));
                if (other.getTime() != null) {
                    p.add((Widget)new TimeLabel(other.getTime(), other.getClazz().getClassId(), true));
                }
                if (other.getRoom() != null) {
                    Iterator<SuggestionsInterface.RoomInfo> i = other.getRoom().iterator();
                    while (i.hasNext()) {
                        p.add((Widget)SuggestionsPageContext.this.withSeparator(new RoomLabel(i.next()), i.hasNext()));
                    }
                }
                this.add((Widget)p);
            }
        }

        public ViolatedConstraint(SuggestionsInterface.BtbInstructorInfo conflict) {
            super("constraint");
            P h = new P("header");
            P pref = new P("preference");
            SuggestionsInterface.PreferenceInterface preference = SuggestionsPageContext.this.iProperties.getPreference(conflict.getPreference());
            pref.setText(preference.getName());
            pref.getElement().getStyle().setColor(preference.getColor());
            h.add((Widget)pref);
            P name = new P("name");
            name.setText(MESSAGES.btbInstructorConflictConstraint());
            h.add((Widget)name);
            this.add((Widget)h);
            SuggestionsInterface.ClassAssignmentDetails other = conflict.getOther();
            P p = new P("other");
            p.add((Widget)new ClassLabel(other.getClazz()));
            if (other.getTime() != null) {
                p.add((Widget)new TimeLabel(other.getTime(), other.getClazz().getClassId(), true));
            }
            if (other.getRoom() != null) {
                Iterator<SuggestionsInterface.RoomInfo> i = other.getRoom().iterator();
                while (i.hasNext()) {
                    p.add((Widget)SuggestionsPageContext.this.withSeparator(new RoomLabel(i.next()), i.hasNext()));
                }
            }
            this.add((Widget)p);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ViolatedConstraints
    extends P {
        public ViolatedConstraints(List<SuggestionsInterface.DistributionInfo> conflicts, List<SuggestionsInterface.BtbInstructorInfo> btbConflicts) {
            super("constraints");
            if (conflicts != null) {
                for (SuggestionsInterface.DistributionInfo distributionInfo : conflicts) {
                    if (distributionInfo.getInfo().isSatisfied()) continue;
                    this.add((Widget)new ViolatedConstraint(distributionInfo));
                }
            }
            if (btbConflicts != null) {
                for (SuggestionsInterface.BtbInstructorInfo btbInstructorInfo : btbConflicts) {
                    this.add((Widget)new ViolatedConstraint(btbInstructorInfo));
                }
            }
        }
    }

    protected class ClassLabel
    extends P {
        public ClassLabel(final SuggestionsInterface.ClassInfo clazz) {
            super("class");
            this.setText(clazz.getName());
            if (clazz.getPref() != null) {
                this.getElement().getStyle().setColor(SuggestionsPageContext.this.iProperties.getPreference(clazz.getPref()).getColor());
            }
            this.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent e) {
                    SuggestionsPageContext.this.select(clazz);
                }
            });
        }
    }

    protected class StudentConflict
    extends FlexTable {
        public StudentConflict(SuggestionsInterface.StudentConflictInfo conflict) {
            this.addStyleName("conflict");
            int col = 0;
            this.setHTML(0, col++, conflict.getInfo().getJenrl() + "&times;");
            this.getFlexCellFormatter().setStyleName(0, col - 1, "counter");
            P clazz = new P(new String[0]);
            if (conflict.getInfo().isCommited()) {
                conflict.getOther().getClazz().setPref("R");
            }
            clazz.add((Widget)new ClassLabel(conflict.getOther().getClazz()));
            if (conflict.getOther().getTime() != null) {
                clazz.add((Widget)new TimeLabel(conflict.getOther().getTime(), conflict.getOther().getClazz().getClassId(), true));
            }
            if (conflict.getOther().getRoom() != null) {
                Iterator<SuggestionsInterface.RoomInfo> i = conflict.getOther().getRoom().iterator();
                while (i.hasNext()) {
                    clazz.add((Widget)SuggestionsPageContext.this.withSeparator(new RoomLabel(i.next()), i.hasNext()));
                }
            }
            this.setWidget(0, col++, (Widget)clazz);
            this.getFlexCellFormatter().setStyleName(0, col - 1, "class-assignment");
            if (conflict.getAnother() != null) {
                P another = new P(new String[0]);
                another.add((Widget)new ClassLabel(conflict.getAnother().getClazz()));
                if (conflict.getAnother().getTime() != null) {
                    another.add((Widget)new TimeLabel(conflict.getAnother().getTime(), conflict.getAnother().getClazz().getClassId(), true));
                }
                if (conflict.getAnother().getRoom() != null) {
                    Iterator<SuggestionsInterface.RoomInfo> i = conflict.getAnother().getRoom().iterator();
                    while (i.hasNext()) {
                        another.add((Widget)SuggestionsPageContext.this.withSeparator(new RoomLabel(i.next()), i.hasNext()));
                    }
                }
                this.setWidget(1, 0, (Widget)another);
                this.getFlexCellFormatter().setStyleName(1, 0, "class-assignment");
            }
            ArrayList<String> props = new ArrayList<String>();
            if (conflict.getInfo().isCommited()) {
                props.add(MESSAGES.studentConflictCommitted());
            }
            if (conflict.getInfo().isFixed()) {
                props.add(MESSAGES.studentConflictFixed());
            } else if (conflict.getInfo().isHard()) {
                props.add(MESSAGES.studentConflictHard());
            }
            if (conflict.getInfo().isDistance()) {
                props.add(MESSAGES.studentConflictDistance());
            }
            if (conflict.getInfo().isImportant()) {
                props.add(MESSAGES.studentConflictImportant());
            }
            if (conflict.getInfo().isWorkDay()) {
                props.add(MESSAGES.studentConflictWorkday());
            }
            if (conflict.getInfo().isInstructor()) {
                props.add(MESSAGES.studentConflictInstructor());
            }
            if (!props.isEmpty()) {
                String text = "";
                Iterator i = props.iterator();
                while (i.hasNext()) {
                    text = text + (String)i.next() + (i.hasNext() ? CONSTANTS.itemSeparator() : "");
                }
                this.setText(0, col++, "[" + text + "]");
                this.getFlexCellFormatter().setStyleName(0, col - 1, "properties");
            }
            if (conflict.getInfo().hasCurricula()) {
                this.setText(0, col++, SuggestionsPageContext.getCurriculumText(conflict.getInfo().getCurricula()));
                this.getFlexCellFormatter().setStyleName(0, col - 1, "curricula");
            }
            if (conflict.getAnother() != null) {
                for (int i = 0; i < col; ++i) {
                    if (i == 1) continue;
                    this.getFlexCellFormatter().setRowSpan(0, i, 2);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class StudentConflicts
    extends P {
        public StudentConflicts(List<SuggestionsInterface.StudentConflictInfo> conflicts) {
            super("conflicts");
            Collections.sort(conflicts);
            for (SuggestionsInterface.StudentConflictInfo conflict : conflicts) {
                this.add((Widget)new StudentConflict(conflict));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class InstructorsLabel
    extends P {
        public InstructorsLabel(List<SuggestionsInterface.InstructorInfo> instructors) {
            super("instructors");
            Iterator<SuggestionsInterface.InstructorInfo> i = instructors.iterator();
            while (i.hasNext()) {
                final SuggestionsInterface.InstructorInfo instructor = i.next();
                P r = new P("instructor");
                r.setText(instructor.getName() + (i.hasNext() ? CONSTANTS.itemSeparator() : ""));
                if (instructor.getId() != null) {
                    r.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent e) {
                            ToolBox.open("instructorDetail.do?instructorId=" + instructor.getId());
                        }
                    });
                }
                this.add((Widget)r);
            }
        }
    }

    protected class RoomLabel
    extends P {
        public RoomLabel(final SuggestionsInterface.RoomInfo room) {
            super("room");
            this.setText(room.getName());
            if (room.getPref() != 0) {
                this.getElement().getStyle().setColor(SuggestionsPageContext.this.iProperties.getPreference(room.getPref()).getColor());
            }
            if (room.isStriked()) {
                this.getElement().getStyle().setTextDecoration(Style.TextDecoration.LINE_THROUGH);
            }
            if (room.getId() != null) {
                this.addMouseOverHandler(new MouseOverHandler(){

                    public void onMouseOver(MouseOverEvent e) {
                        RoomHint.showHint((Element)RoomLabel.this.getElement(), room.getId(), null, null, true);
                    }
                });
                this.addMouseOutHandler(new MouseOutHandler(){

                    public void onMouseOut(MouseOutEvent e) {
                        RoomHint.hideHint();
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AssignmentLabel
    extends P {
        public AssignmentLabel(SuggestionsInterface.TimeInfo time, List<SuggestionsInterface.RoomInfo> rooms, Long classId, boolean showDate) {
            super("assignment");
            if (showDate && time.hasDatePattern()) {
                this.add((Widget)new DateLabel(time.getDatePattern()));
            }
            this.add((Widget)new TimeLabel(time, classId, true));
            if (rooms != null) {
                Iterator<SuggestionsInterface.RoomInfo> i = rooms.iterator();
                while (i.hasNext()) {
                    this.add((Widget)SuggestionsPageContext.this.withSeparator(new RoomLabel(i.next()), i.hasNext()));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RoomsLabel
    extends P {
        public RoomsLabel(List<SuggestionsInterface.RoomInfo> rooms) {
            super("rooms");
            Iterator<SuggestionsInterface.RoomInfo> i = rooms.iterator();
            while (i.hasNext()) {
                this.add((Widget)SuggestionsPageContext.this.withSeparator(new RoomLabel(i.next()), i.hasNext()));
            }
        }
    }

    protected class TimeLabel
    extends P {
        public TimeLabel(SuggestionsInterface.TimeInfo time, Long classId, boolean endTime) {
            super("time");
            this.setText(time.getName(SuggestionsPageContext.this.iProperties.getFirstDay(), endTime, CONSTANTS));
            if (time.getPref() != 0) {
                this.getElement().getStyle().setColor(SuggestionsPageContext.this.iProperties.getPreference(time.getPref()).getColor());
            }
            if (time.isStriked()) {
                this.getElement().getStyle().setTextDecoration(Style.TextDecoration.LINE_THROUGH);
            }
            final String timeHint = classId + "," + time.getDays() + "," + time.getStartSlot();
            this.addMouseOverHandler(new MouseOverHandler(){

                public void onMouseOver(MouseOverEvent e) {
                    TimeHint.showHint((Element)TimeLabel.this.getElement(), timeHint);
                }
            });
            this.addMouseOutHandler(new MouseOutHandler(){

                public void onMouseOut(MouseOutEvent e) {
                    TimeHint.hideHint();
                }
            });
        }
    }

    protected class DateLabel
    extends P {
        public DateLabel(SuggestionsInterface.DateInfo date) {
            super("date");
            this.setText(date.getDatePatternName());
            if (date.getDatePatternPreference() != 0) {
                this.getElement().getStyle().setColor(SuggestionsPageContext.this.iProperties.getPreference(date.getDatePatternPreference()).getColor());
            }
        }
    }
}

