/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.solver;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.solver.suggestions.CBSWidget;
import org.unitime.timetable.gwt.client.solver.suggestions.ConflictsWidget;
import org.unitime.timetable.gwt.client.solver.suggestions.CurrentAssignment;
import org.unitime.timetable.gwt.client.solver.suggestions.SelectedSuggestion;
import org.unitime.timetable.gwt.client.solver.suggestions.SuggestionsPageContext;
import org.unitime.timetable.gwt.client.solver.suggestions.SuggestionsWidget;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseNull;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.SuggestionsInterface;

public class SuggestionsPage
extends SimpleForm {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    public static NumberFormat sDF = NumberFormat.getFormat((String)"0.###");
    private SuggestionsPageContext iContext = null;
    private CurrentAssignment iCurrentAssignment = null;
    private SelectedSuggestion iSelectedSuggestion = null;
    private SuggestionsWidget iSuggestions = null;
    private ConflictsWidget iConflicts = null;
    private CBSWidget iCBS = null;
    private List<SuggestionsInterface.SelectedAssignment> iSelectedAssignments = null;

    public SuggestionsPage(final Long classId) {
        this.addStyleName("unitime-SuggestionsPage");
        this.removeStyleName("unitime-NotPrintableBottomLine");
        this.iContext = new SuggestionsPageContext(){

            @Override
            public void select(SuggestionsInterface.ClassInfo clazz) {
                SuggestionsPage.this.setup(clazz.getClassId(), false);
            }

            @Override
            public void onSelection(Command undo) {
                SuggestionsPage.this.selectAssignment(SuggestionsPage.this.iCurrentAssignment.getSelectedAssignment(), undo);
            }

            @Override
            public void remove(SuggestionsInterface.ClassInfo clazz) {
                SuggestionsPage.this.unselectAssignment(clazz);
            }

            @Override
            public void assign(List<SuggestionsInterface.SelectedAssignment> assignment, final UniTimeHeaderPanel panel) {
                SuggestionsInterface.MakeAssignmentRequest request = new SuggestionsInterface.MakeAssignmentRequest(assignment);
                panel.showLoading();
                RPC.execute(request, new AsyncCallback<GwtRpcResponseNull>(){

                    public void onFailure(Throwable t) {
                        panel.setErrorMessage(MESSAGES.failedToAssign(t.getMessage()));
                        UniTimeNotifications.error(MESSAGES.failedToAssign(t.getMessage()), t);
                    }

                    public void onSuccess(GwtRpcResponseNull response) {
                        panel.clearMessage();
                        if (!SuggestionsPage.this.closeSuggestionsDialog()) {
                            if (SuggestionsPage.this.iSelectedAssignments != null) {
                                SuggestionsPage.this.iSelectedAssignments.clear();
                            }
                            SuggestionsPage.this.iSelectedSuggestion.setValue(null);
                            SuggestionsPage.this.setup(SuggestionsPage.this.iCurrentAssignment.getValue().getClazz().getClassId(), true);
                        }
                    }
                });
            }
        };
        SuggestionsInterface.SelectedAssignment assignment = this.getLocationAssignment();
        if (assignment != null) {
            this.iSelectedAssignments = new ArrayList<SuggestionsInterface.SelectedAssignment>();
            this.iSelectedAssignments.add(assignment);
        }
        SuggestionsInterface.SuggestionPropertiesRequest request = new SuggestionsInterface.SuggestionPropertiesRequest();
        if (Window.Location.getParameter((String)"history") != null) {
            request.setHistoryId(Long.valueOf(Window.Location.getParameter((String)"history")));
        }
        RPC.execute(request, new AsyncCallback<SuggestionsInterface.SuggestionProperties>(){

            public void onFailure(Throwable t) {
                UniTimeNotifications.error(MESSAGES.failedToInitialize(t.getMessage()), t);
                ToolBox.checkAccess(t);
            }

            public void onSuccess(SuggestionsInterface.SuggestionProperties properties) {
                SuggestionsPage.this.iContext.setSuggestionProperties(properties);
                if (properties.hasSelectedAssignments()) {
                    SuggestionsPage.this.iSelectedAssignments = properties.getSelectedAssignments();
                }
                if (properties.isSolver()) {
                    SuggestionsPage.this.iSuggestions = new SuggestionsWidget(SuggestionsPage.this.iContext){

                        public void onSelection(SuggestionsInterface.Suggestion suggestion) {
                            SuggestionsPage.this.iCurrentAssignment.clearMessage();
                            SuggestionsPage.this.iCurrentAssignment.setShowUnassign(!suggestion.hasDifferentAssignments());
                            SuggestionsPage.this.iCurrentAssignment.setSelectedAssignment(suggestion.getAssignment(SuggestionsPage.this.iCurrentAssignment.getValue().getClazz().getClassId()));
                            SuggestionsPage.this.iSelectedAssignments = suggestion.getAssignment(false);
                            SuggestionsPage.this.iSelectedSuggestion.setValue(suggestion);
                            SuggestionsPage.this.iSelectedSuggestion.getElement().scrollIntoView();
                        }
                    };
                    SuggestionsPage.this.addRow((Widget)SuggestionsPage.this.iSuggestions);
                    SuggestionsPage.this.iConflicts = new ConflictsWidget(SuggestionsPage.this.iContext){

                        public void onSelection(SuggestionsInterface.ClassAssignmentDetails details) {
                            SuggestionsPage.this.iCurrentAssignment.clearMessage();
                            SuggestionsPage.this.iCurrentAssignment.setSelectedTime(details.getTime(), true);
                            SuggestionsPage.this.iCurrentAssignment.getElement().scrollIntoView();
                        }
                    };
                    SuggestionsPage.this.addRow((Widget)SuggestionsPage.this.iConflicts);
                    SuggestionsPage.this.iCBS = new CBSWidget(SuggestionsPage.this.iContext){

                        public void onSelection(SuggestionsInterface.SelectedAssignment assignment) {
                            if (assignment.getClassId().equals(SuggestionsPage.this.iCurrentAssignment.getValue().getClazz().getClassId())) {
                                SuggestionsPage.this.iCurrentAssignment.clearMessage();
                                final SuggestionsInterface.SelectedAssignment undo = SuggestionsPage.this.iCurrentAssignment.getSelectedAssignment();
                                SuggestionsPage.this.iCurrentAssignment.setSelectedAssignment(assignment);
                                SuggestionsPage.this.iCurrentAssignment.getElement().scrollIntoView();
                                SuggestionsPage.this.iContext.onSelection(new Command(){

                                    public void execute() {
                                        SuggestionsPage.this.iCurrentAssignment.setSelectedAssignment(undo);
                                    }
                                });
                            } else {
                                if (SuggestionsPage.this.iSelectedAssignments == null) {
                                    SuggestionsPage.this.iSelectedAssignments = new ArrayList();
                                } else {
                                    SuggestionsPage.this.iSelectedAssignments.clear();
                                }
                                SuggestionsPage.this.iSelectedAssignments.add(assignment);
                                SuggestionsPage.this.setup(assignment.getClassId(), true);
                            }
                        }
                    };
                    SuggestionsPage.this.addRow((Widget)SuggestionsPage.this.iCBS);
                }
                SuggestionsPage.this.setup(classId, true);
            }
        });
        this.iCurrentAssignment = new CurrentAssignment(this.iContext);
        this.addRow((Widget)this.iCurrentAssignment);
        this.iSelectedSuggestion = new SelectedSuggestion(this.iContext);
        this.addRow((Widget)this.iSelectedSuggestion);
    }

    public SuggestionsInterface.SelectedAssignment getLocationAssignment() {
        SuggestionsInterface.SelectedAssignment ret = new SuggestionsInterface.SelectedAssignment();
        if (Window.Location.getParameter((String)"id") == null) {
            return null;
        }
        ret.setClassId(Long.valueOf(Window.Location.getParameter((String)"id")));
        if (Window.Location.getParameter((String)"days") == null) {
            return null;
        }
        ret.setDays(Integer.valueOf(Window.Location.getParameter((String)"days")));
        if (Window.Location.getParameter((String)"slot") == null) {
            return null;
        }
        ret.setStartSlot(Integer.valueOf(Window.Location.getParameter((String)"slot")));
        if (Window.Location.getParameter((String)"pid") == null) {
            return null;
        }
        ret.setPatternId(Long.valueOf(Window.Location.getParameter((String)"pid")));
        if (Window.Location.getParameter((String)"did") == null) {
            return null;
        }
        ret.setDatePatternId(Long.valueOf(Window.Location.getParameter((String)"did")));
        if (Window.Location.getParameter((String)"room") != null) {
            for (String id : Window.Location.getParameter((String)"room").split(",")) {
                ret.addRoomId(Long.valueOf(id));
            }
        }
        return ret;
    }

    public SuggestionsPage() {
        this(Long.valueOf(Window.Location.getParameter((String)"id")));
    }

    protected void setup(final Long classId, final boolean computeSuggestion) {
        LoadingWidget.showLoading(MESSAGES.waitLoadClassDetails());
        RPC.execute(new SuggestionsInterface.ClassAssignmentDetailsRequest(classId), new AsyncCallback<SuggestionsInterface.ClassAssignmentDetails>(){

            public void onFailure(Throwable t) {
                ToolBox.checkAccess(t);
                LoadingWidget.hideLoading();
                UniTimeNotifications.error(MESSAGES.failedToLoadClassDetails(t.getMessage()), t);
            }

            public void onSuccess(SuggestionsInterface.ClassAssignmentDetails details) {
                LoadingWidget.hideLoading();
                SuggestionsPage.this.iCurrentAssignment.setValue(details);
                if (SuggestionsPage.this.iSelectedAssignments != null && !SuggestionsPage.this.iSelectedAssignments.isEmpty()) {
                    Iterator i = SuggestionsPage.this.iSelectedAssignments.iterator();
                    while (i.hasNext()) {
                        SuggestionsInterface.SelectedAssignment a = (SuggestionsInterface.SelectedAssignment)i.next();
                        if (!a.getClassId().equals(classId)) continue;
                        SuggestionsPage.this.iCurrentAssignment.setSelectedAssignment(a);
                        if (SuggestionsPage.this.iCurrentAssignment.getSelectedAssignment() != null) continue;
                        i.remove();
                    }
                    SuggestionsPage.this.iCurrentAssignment.setShowUnassign(SuggestionsPage.this.iSelectedAssignments.isEmpty());
                } else {
                    SuggestionsPage.this.iCurrentAssignment.setShowUnassign(true);
                }
                if (SuggestionsPage.this.iSuggestions != null) {
                    SuggestionsPage.this.iSuggestions.setVisible(details.isCanUnassign());
                    if (details.isCanUnassign()) {
                        SuggestionsPage.this.iSuggestions.setSelection(SuggestionsPage.this.iSelectedAssignments, classId);
                    }
                }
                if (SuggestionsPage.this.iConflicts != null) {
                    SuggestionsPage.this.iConflicts.setVisible(details.isCanUnassign());
                    if (details.isCanUnassign()) {
                        SuggestionsPage.this.iConflicts.setValue(classId);
                    }
                }
                if (SuggestionsPage.this.iCBS != null) {
                    SuggestionsPage.this.iCBS.setVisible(details.isCanUnassign());
                    if (details.isCanUnassign()) {
                        SuggestionsPage.this.iCBS.setValue(classId);
                    }
                }
                if (computeSuggestion && details.isCanUnassign() && SuggestionsPage.this.iSelectedAssignments != null && !SuggestionsPage.this.iSelectedAssignments.isEmpty()) {
                    SuggestionsInterface.SelectedAssignmentsRequest request = new SuggestionsInterface.SelectedAssignmentsRequest(classId);
                    for (SuggestionsInterface.SelectedAssignment a : SuggestionsPage.this.iSelectedAssignments) {
                        request.addAssignment(a);
                    }
                    SuggestionsPage.this.computeSuggestion(request, null);
                }
            }
        });
    }

    protected void computeSuggestion(final SuggestionsInterface.SelectedAssignmentsRequest request, final Command undo) {
        this.iCurrentAssignment.showLoading();
        RPC.execute(request, new AsyncCallback<SuggestionsInterface.Suggestion>(){

            public void onFailure(Throwable t) {
                if (undo != null) {
                    undo.execute();
                }
                SuggestionsPage.this.iCurrentAssignment.setErrorMessage(MESSAGES.failedToComputeSelectedAssignment(t.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToComputeSelectedAssignment(t.getMessage()), t);
            }

            public void onSuccess(SuggestionsInterface.Suggestion suggestion) {
                SuggestionsPage.this.iCurrentAssignment.clearMessage();
                SuggestionsPage.this.iCurrentAssignment.setShowUnassign(!suggestion.hasDifferentAssignments());
                SuggestionsPage.this.iSelectedSuggestion.setValue(suggestion);
                if (SuggestionsPage.this.iSuggestions != null) {
                    SuggestionsPage.this.iSuggestions.setRequest(request);
                }
            }
        });
    }

    protected void selectAssignment(SuggestionsInterface.SelectedAssignment selection, Command undo) {
        if (selection == null) {
            return;
        }
        SuggestionsInterface.SelectedAssignmentsRequest request = new SuggestionsInterface.SelectedAssignmentsRequest(selection.getClassId());
        if (this.iSelectedAssignments != null) {
            Iterator<SuggestionsInterface.SelectedAssignment> i = this.iSelectedAssignments.iterator();
            while (i.hasNext()) {
                SuggestionsInterface.SelectedAssignment a = i.next();
                if (!a.getClassId().equals(request.getClassId())) {
                    request.addAssignment(a);
                    continue;
                }
                i.remove();
            }
            this.iSelectedAssignments.add(selection);
        } else {
            this.iSelectedAssignments = new ArrayList<SuggestionsInterface.SelectedAssignment>();
            this.iSelectedAssignments.add(selection);
        }
        request.addAssignment(selection);
        this.computeSuggestion(request, undo);
    }

    protected void unselectAssignment(SuggestionsInterface.ClassInfo clazz) {
        if (this.iSelectedAssignments == null || clazz == null) {
            return;
        }
        SuggestionsInterface.SelectedAssignmentsRequest request = new SuggestionsInterface.SelectedAssignmentsRequest(this.iCurrentAssignment.getValue().getClazz().getClassId());
        Iterator<SuggestionsInterface.SelectedAssignment> i = this.iSelectedAssignments.iterator();
        while (i.hasNext()) {
            SuggestionsInterface.SelectedAssignment a = i.next();
            if (!a.getClassId().equals(clazz.getClassId())) {
                request.addAssignment(a);
                continue;
            }
            i.remove();
        }
        if (clazz.equals(this.iCurrentAssignment.getValue().getClazz())) {
            this.iCurrentAssignment.setSelectedAssignment(null);
            SuggestionsInterface.SelectedAssignment selection = this.iCurrentAssignment.getValue().getSelection();
            if (selection != null) {
                this.iCurrentAssignment.setSelectedAssignment(selection);
            }
        }
        this.computeSuggestion(request, null);
    }

    public native boolean closeSuggestionsDialog();
}

