/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.rooms;

import java.util.Comparator;
import org.unitime.timetable.gwt.shared.RoomInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoomsComparator
implements Comparator<RoomInterface.RoomDetailInterface> {
    private RoomInterface.RoomsColumn iColumn;
    private boolean iAsc;

    public int compareById(RoomInterface.RoomDetailInterface r1, RoomInterface.RoomDetailInterface r2) {
        return this.compare(r1.getUniqueId(), r2.getUniqueId());
    }

    public int compareByName(RoomInterface.RoomDetailInterface r1, RoomInterface.RoomDetailInterface r2) {
        return this.compare(r1.getLabel(), r2.getLabel());
    }

    public int compareByExternalId(RoomInterface.RoomDetailInterface r1, RoomInterface.RoomDetailInterface r2) {
        return this.compare(r1.getExternalId(), r2.getExternalId());
    }

    public int compareByType(RoomInterface.RoomDetailInterface r1, RoomInterface.RoomDetailInterface r2) {
        if (r1.getRoomType().hasOrder()) {
            if (r2.getRoomType().hasOrder()) {
                return this.compare(r1.getRoomType().getOrder(), r2.getRoomType().getOrder());
            }
            return -1;
        }
        if (r2.getRoomType().hasOrder()) {
            return 1;
        }
        return this.compare(r1.getRoomType().getLabel(), r2.getRoomType().getLabel());
    }

    public int compareByCapacity(RoomInterface.RoomDetailInterface r1, RoomInterface.RoomDetailInterface r2) {
        return -this.compare(r1.getCapacity(), r2.getCapacity());
    }

    public int compareByExamCapacity(RoomInterface.RoomDetailInterface r1, RoomInterface.RoomDetailInterface r2) {
        return -this.compare(r1.getExamCapacity() == null ? r1.getCapacity() : r1.getExamCapacity(), r2.getExamCapacity() == null ? r2.getCapacity() : r2.getExamCapacity());
    }

    public int compareByDistance(RoomInterface.RoomDetailInterface r1, RoomInterface.RoomDetailInterface r2) {
        return -this.compare(r1.isIgnoreTooFar(), r2.isIgnoreTooFar());
    }

    public int compareByRoomCheck(RoomInterface.RoomDetailInterface r1, RoomInterface.RoomDetailInterface r2) {
        return -this.compare(r1.isIgnoreRoomCheck(), r2.isIgnoreRoomCheck());
    }

    public int compareByControl(RoomInterface.RoomDetailInterface r1, RoomInterface.RoomDetailInterface r2) {
        return this.compare(r1.getControlDepartment() == null ? null : r1.getControlDepartment().getAbbreviationOrCode(), r2.getControlDepartment() == null ? null : r2.getControlDepartment().getAbbreviationOrCode());
    }

    public int compareByEventDepartment(RoomInterface.RoomDetailInterface r1, RoomInterface.RoomDetailInterface r2) {
        return this.compare(r1.getEventDepartment() == null ? null : r1.getEventDepartment().getAbbreviationOrCode(), r2.getEventDepartment() == null ? null : r2.getEventDepartment().getAbbreviationOrCode());
    }

    public int compareByEventStatus(RoomInterface.RoomDetailInterface r1, RoomInterface.RoomDetailInterface r2) {
        return this.compare(r1.getEventStatus(), r2.getEventStatus());
    }

    public int compareByEventMessage(RoomInterface.RoomDetailInterface r1, RoomInterface.RoomDetailInterface r2) {
        return this.compare(r1.getEventNote(), r2.getEventNote());
    }

    public int compareByBreakTime(RoomInterface.RoomDetailInterface r1, RoomInterface.RoomDetailInterface r2) {
        return this.compare(r1.getBreakTime(), r2.getBreakTime());
    }

    public int compareByServices(RoomInterface.RoomDetailInterface r1, RoomInterface.RoomDetailInterface r2) {
        return this.compare(r1.getServices("|"), r2.getServices("|"));
    }

    protected int compareByColumn(RoomInterface.RoomDetailInterface r1, RoomInterface.RoomDetailInterface r2) {
        switch (this.iColumn) {
            case NAME: {
                return this.compareByName(r1, r2);
            }
            case EXTERNAL_ID: {
                return this.compareByExternalId(r1, r2);
            }
            case TYPE: {
                return this.compareByType(r1, r2);
            }
            case CAPACITY: {
                return this.compareByCapacity(r1, r2);
            }
            case EXAM_CAPACITY: {
                return this.compareByExamCapacity(r1, r2);
            }
            case DISTANCE_CHECK: {
                return this.compareByDistance(r1, r2);
            }
            case ROOM_CHECK: {
                return this.compareByRoomCheck(r1, r2);
            }
            case CONTROL_DEPT: {
                return this.compareByControl(r1, r2);
            }
            case EVENT_DEPARTMENT: {
                return this.compareByEventDepartment(r1, r2);
            }
            case EVENT_STATUS: {
                return this.compareByEventStatus(r1, r2);
            }
            case EVENT_MESSAGE: {
                return this.compareByEventMessage(r1, r2);
            }
            case BREAK_TIME: {
                return this.compareByBreakTime(r1, r2);
            }
            case SERVICES: {
                return this.compareByServices(r1, r2);
            }
        }
        return this.compareByName(r1, r2);
    }

    public RoomsComparator(RoomInterface.RoomsColumn column, boolean asc) {
        this.iColumn = column;
        this.iAsc = asc;
    }

    @Override
    public int compare(RoomInterface.RoomDetailInterface r1, RoomInterface.RoomDetailInterface r2) {
        int cmp = this.compareByColumn(r1, r2);
        if (cmp == 0) {
            cmp = this.compareByType(r1, r2);
        }
        if (cmp == 0) {
            cmp = this.compareByName(r1, r2);
        }
        if (cmp == 0) {
            cmp = this.compareById(r1, r2);
        }
        return this.iAsc ? cmp : -cmp;
    }

    @Override
    protected int compare(String s1, String s2) {
        if (s1 == null || s1.isEmpty()) {
            return s2 == null || s2.isEmpty() ? 0 : 1;
        }
        return s2 == null || s2.isEmpty() ? -1 : s1.compareToIgnoreCase(s2);
    }

    @Override
    protected int compare(Number n1, Number n2) {
        return n1 == null ? (n2 == null ? 0 : -1) : (n2 == null ? 1 : Double.compare(n1.doubleValue(), n2.doubleValue()));
    }

    @Override
    protected int compare(Boolean b1, Boolean b2) {
        return b1 == null ? (b2 == null ? 0 : -1) : (b2 == null ? 1 : (b1.booleanValue() == b2.booleanValue() ? 0 : (b1 != false ? 1 : -1)));
    }

    public static boolean isApplicable(RoomInterface.RoomsColumn column) {
        switch (column) {
            case NAME: 
            case EXTERNAL_ID: 
            case TYPE: 
            case CAPACITY: 
            case EXAM_CAPACITY: 
            case DISTANCE_CHECK: 
            case ROOM_CHECK: 
            case CONTROL_DEPT: 
            case EVENT_DEPARTMENT: 
            case EVENT_STATUS: 
            case EVENT_MESSAGE: 
            case BREAK_TIME: 
            case SERVICES: {
                return true;
            }
        }
        return false;
    }
}

