/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.reservations;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.ValueBoxBase;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.unitime.timetable.gwt.client.Lookup;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.events.SingleDateSelector;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.reservations.ReservationCourseSelectionBox;
import org.unitime.timetable.gwt.client.reservations.RestrictionsTable;
import org.unitime.timetable.gwt.client.widgets.CourseSelectionEvent;
import org.unitime.timetable.gwt.client.widgets.CourseSelectionHandler;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTextBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeWidget;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.services.ReservationService;
import org.unitime.timetable.gwt.services.ReservationServiceAsync;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.PersonInterface;
import org.unitime.timetable.gwt.shared.ReservationException;
import org.unitime.timetable.gwt.shared.ReservationInterface;

public class ReservationEdit
extends Composite {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    public static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private List<EditFinishedHandler> iEditFinishedHandlers = new ArrayList<EditFinishedHandler>();
    private SimpleForm iPanel;
    private UniTimeHeaderPanel iTitleAndButtons;
    private UniTimeWidget<UniTimeTextBox> iLimit;
    private UniTimeWidget<SingleDateSelector> iExpirationDate;
    private RestrictionsTable iRestrictions;
    private HashMap<Long, ReservationInterface.Area> iAreas = new HashMap();
    private HashMap<Long, ReservationInterface.Curriculum> iCurricula = new HashMap();
    private ListBox iClassifications;
    private ListBox iMajors;
    private UniTimeWidget<ListBox> iType;
    private UniTimeWidget<ListBox> iArea;
    private UniTimeWidget<ListBox> iCourse;
    private UniTimeWidget<ListBox> iGroup;
    private UniTimeWidget<ListBox> iCurriculum;
    private UniTimeWidget<TextArea> iStudents;
    private ReservationInterface iReservation;
    private ReservationCourseSelectionBox iCourseBox;
    private Lookup iLookup;
    private ReservationInterface.DefaultExpirationDates iExpirations = null;
    private final ReservationServiceAsync iReservationService = (ReservationServiceAsync)GWT.create(ReservationService.class);
    private int iExpirationLine;
    private int iReservedSpaceLine;
    private int iGroupLine;
    private int iCourseLine;
    private int iAreaLine;
    private int iStudentsLine;
    private int iCurriculumLine;
    private ReservationInterface.Offering iOffering = null;

    public ReservationEdit(boolean standAlone) {
        if (standAlone) {
            this.addEditFinishedHandler(new EditFinishedHandler(){

                public void onSave(EditFinishedEvent evt) {
                    ToolBox.open(GWT.getHostPageBaseURL() + "instructionalOfferingDetail.do?io=" + ReservationEdit.this.iOffering.getId() + "#reservations");
                }

                public void onDelete(EditFinishedEvent evt) {
                    ToolBox.open(GWT.getHostPageBaseURL() + "instructionalOfferingDetail.do?io=" + ReservationEdit.this.iOffering.getId() + "#reservations");
                }

                public void onBack(EditFinishedEvent evt) {
                    ToolBox.open(GWT.getHostPageBaseURL() + "instructionalOfferingDetail.do?io=" + ReservationEdit.this.iOffering.getId() + "#reservations");
                }

                public void onFailure(Throwable caught) {
                    new Timer(){

                        public void run() {
                            ToolBox.open(GWT.getHostPageBaseURL() + "instructionalOfferingDetail.do?io=" + ReservationEdit.this.iOffering.getId() + "#reservations");
                        }
                    }.schedule(5000);
                }

                public boolean hasNext(EditFinishedEvent evt) {
                    String ids = Window.Location.getParameter((String)"reservations");
                    if (ids != null) {
                        String[] arr = ids.split(",");
                        for (int i = 0; i < arr.length - 1; ++i) {
                            if (!evt.getReservationId().toString().equals(arr[i])) continue;
                            return true;
                        }
                    }
                    return false;
                }

                public boolean hasPrevious(EditFinishedEvent evt) {
                    String ids = Window.Location.getParameter((String)"reservations");
                    if (ids != null) {
                        String[] arr = ids.split(",");
                        for (int i = 1; i < arr.length; ++i) {
                            if (!evt.getReservationId().toString().equals(arr[i])) continue;
                            return true;
                        }
                    }
                    return false;
                }

                public void onNext(EditFinishedEvent evt) {
                    String ids = Window.Location.getParameter((String)"reservations");
                    if (ids != null) {
                        String[] arr = ids.split(",");
                        for (int i = 0; i < arr.length - 1; ++i) {
                            if (!evt.getReservationId().toString().equals(arr[i])) continue;
                            ReservationEdit.this.load(arr[i + 1]);
                            return;
                        }
                    }
                    this.onSave(evt);
                }

                public void onPrevious(EditFinishedEvent evt) {
                    String ids = Window.Location.getParameter((String)"reservations");
                    if (ids != null) {
                        String[] arr = ids.split(",");
                        for (int i = 1; i < arr.length; ++i) {
                            if (!evt.getReservationId().toString().equals(arr[i])) continue;
                            ReservationEdit.this.load(arr[i - 1]);
                            return;
                        }
                    }
                    this.onSave(evt);
                }
            });
            if (Window.Location.getParameter((String)"id") == null && Window.Location.getParameter((String)"offering") == null) {
                throw new ReservationException(MESSAGES.errorReservationOrOfferingIdNotProvided());
            }
        }
        this.iPanel = new SimpleForm();
        this.initWidget((Widget)this.iPanel);
        this.iTitleAndButtons = new UniTimeHeaderPanel(MESSAGES.sectReservationDetails());
        this.iTitleAndButtons.addButton("save", MESSAGES.buttonSave(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                ReservationEdit.this.iTitleAndButtons.clearMessage();
                ReservationInterface r = ReservationEdit.this.validate();
                if (r == null) {
                    ReservationEdit.this.iTitleAndButtons.setErrorMessage(MESSAGES.failedValidationCheckForm());
                } else {
                    LoadingWidget.getInstance().show(MESSAGES.waitSavingReservation());
                    ReservationEdit.this.iReservationService.save(r, new AsyncCallback<Long>(){

                        public void onFailure(Throwable caught) {
                            LoadingWidget.getInstance().hide();
                            ReservationEdit.this.iTitleAndButtons.setErrorMessage(caught.getMessage());
                        }

                        public void onSuccess(Long result) {
                            LoadingWidget.getInstance().hide();
                            EditFinishedEvent e = new EditFinishedEvent(result);
                            for (EditFinishedHandler h : ReservationEdit.this.iEditFinishedHandlers) {
                                h.onSave(e);
                            }
                        }
                    });
                }
            }
        });
        this.iTitleAndButtons.addButton("previous", MESSAGES.buttonPrevious(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                ReservationEdit.this.iTitleAndButtons.clearMessage();
                ReservationInterface r = ReservationEdit.this.validate();
                if (r == null) {
                    ReservationEdit.this.iTitleAndButtons.setErrorMessage(MESSAGES.failedValidationCheckForm());
                } else {
                    LoadingWidget.getInstance().show(MESSAGES.waitSavingReservation());
                    ReservationEdit.this.iReservationService.save(r, new AsyncCallback<Long>(){

                        public void onFailure(Throwable caught) {
                            LoadingWidget.getInstance().hide();
                            ReservationEdit.this.iTitleAndButtons.setErrorMessage(caught.getMessage());
                        }

                        public void onSuccess(Long result) {
                            LoadingWidget.getInstance().hide();
                            EditFinishedEvent e = new EditFinishedEvent(result);
                            for (EditFinishedHandler h : ReservationEdit.this.iEditFinishedHandlers) {
                                h.onPrevious(e);
                            }
                        }
                    });
                }
            }
        });
        this.iTitleAndButtons.setEnabled("previous", false);
        this.iTitleAndButtons.addButton("next", MESSAGES.buttonNext(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                ReservationEdit.this.iTitleAndButtons.clearMessage();
                ReservationInterface r = ReservationEdit.this.validate();
                if (r == null) {
                    ReservationEdit.this.iTitleAndButtons.setErrorMessage(MESSAGES.failedValidationCheckForm());
                } else {
                    LoadingWidget.getInstance().show(MESSAGES.waitSavingReservation());
                    ReservationEdit.this.iReservationService.save(r, new AsyncCallback<Long>(){

                        public void onFailure(Throwable caught) {
                            LoadingWidget.getInstance().hide();
                            ReservationEdit.this.iTitleAndButtons.setErrorMessage(caught.getMessage());
                        }

                        public void onSuccess(Long result) {
                            LoadingWidget.getInstance().hide();
                            EditFinishedEvent e = new EditFinishedEvent(result);
                            for (EditFinishedHandler h : ReservationEdit.this.iEditFinishedHandlers) {
                                h.onNext(e);
                            }
                        }
                    });
                }
            }
        });
        this.iTitleAndButtons.setEnabled("next", false);
        this.iTitleAndButtons.addButton("delete", MESSAGES.buttonDelete(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (ReservationEdit.this.iReservation == null) {
                    ReservationEdit.this.iTitleAndButtons.setErrorMessage(MESSAGES.errorCannotDeleteUnsavedReservation());
                } else {
                    if (!Window.confirm((String)MESSAGES.confirmDeleteReservation())) {
                        return;
                    }
                    LoadingWidget.getInstance().show(MESSAGES.waitDeletingReservation());
                    ReservationEdit.this.iReservationService.delete(ReservationEdit.this.iReservation.getId(), new AsyncCallback<Boolean>(){

                        public void onFailure(Throwable caught) {
                            LoadingWidget.getInstance().hide();
                            ReservationEdit.this.iTitleAndButtons.setErrorMessage(caught.getMessage());
                        }

                        public void onSuccess(Boolean result) {
                            LoadingWidget.getInstance().hide();
                            EditFinishedEvent e = new EditFinishedEvent(ReservationEdit.this.iReservation == null ? null : ReservationEdit.this.iReservation.getId());
                            for (EditFinishedHandler h : ReservationEdit.this.iEditFinishedHandlers) {
                                h.onDelete(e);
                            }
                        }
                    });
                }
            }
        });
        this.iTitleAndButtons.setEnabled("delete", false);
        this.iTitleAndButtons.addButton("back", MESSAGES.buttonBack(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                EditFinishedEvent e = new EditFinishedEvent(ReservationEdit.this.iReservation == null ? null : ReservationEdit.this.iReservation.getId());
                for (EditFinishedHandler h : ReservationEdit.this.iEditFinishedHandlers) {
                    h.onBack(e);
                }
            }
        });
        this.iPanel.addHeaderRow((Widget)this.iTitleAndButtons);
        this.iCourseBox = new ReservationCourseSelectionBox();
        this.iCourseBox.setWidth("130px");
        this.iPanel.addRow(MESSAGES.propInstructionalOffering(), (Widget)this.iCourseBox);
        this.iPanel.getCellFormatter().getElement(this.iPanel.getRowCount() - 1, 0).getStyle().setWidth(100.0, Style.Unit.PX);
        this.iType = new UniTimeWidget<ListBox>(new ListBox());
        this.iType.getWidget().setStyleName("unitime-TextBox");
        this.iType.getWidget().addItem(MESSAGES.itemSelect(), "");
        this.iType.getWidget().addItem(MESSAGES.reservationIndividual(), "individual");
        this.iType.getWidget().addItem(MESSAGES.reservationStudentGroup(), "group");
        this.iType.getWidget().addItem(MESSAGES.reservationCurriculum(), "curriculum");
        this.iType.getWidget().addItem(MESSAGES.reservationCourse(), "course");
        for (ReservationInterface.OverrideType t : ReservationInterface.OverrideType.values()) {
            this.iType.getWidget().addItem(CONSTANTS.reservationOverrideTypeName()[t.ordinal()], t.getReference());
        }
        this.iType.getWidget().setSelectedIndex(0);
        this.iType.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ReservationEdit.this.iType.clearHint();
            }
        });
        this.iPanel.addRow(MESSAGES.propType(), (Widget)this.iType);
        this.iType.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ReservationEdit.this.typeChanged(true);
            }
        });
        this.iLimit = new UniTimeWidget<UniTimeTextBox>(new UniTimeTextBox(4, ValueBoxBase.TextAlignment.RIGHT));
        this.iReservedSpaceLine = this.iPanel.addRow(MESSAGES.propReservedSpace(), (Widget)this.iLimit);
        this.iExpirationDate = new UniTimeWidget<SingleDateSelector>(new SingleDateSelector());
        this.iExpirationDate.getWidget().addValueChangeHandler(new ValueChangeHandler<Date>(){

            public void onValueChange(ValueChangeEvent<Date> event) {
                ReservationEdit.this.iExpirationDate.clearHint();
            }
        });
        this.iExpirationLine = this.iPanel.addRow(MESSAGES.propExpirationDate(), (Widget)this.iExpirationDate);
        this.iRestrictions = new RestrictionsTable(this.iLimit);
        this.iPanel.addRow(MESSAGES.propRestrictions(), (Widget)this.iRestrictions);
        this.iPanel.getCellFormatter().setVerticalAlignment(this.iPanel.getRowCount() - 1, 0, HasVerticalAlignment.ALIGN_TOP);
        this.iStudents = new UniTimeWidget<TextArea>(new TextArea());
        this.iStudents.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ReservationEdit.this.iStudents.clearHint();
                ((UniTimeTextBox)ReservationEdit.this.iLimit.getWidget()).setValue(String.valueOf(((TextArea)ReservationEdit.this.iStudents.getWidget()).getText().split("\n").length), true);
            }
        });
        this.iStudents.getWidget().setStyleName("unitime-TextArea");
        this.iStudents.getWidget().setVisibleLines(10);
        this.iStudents.getWidget().setCharacterWidth(80);
        VerticalPanel students = new VerticalPanel();
        students.add(this.iStudents);
        Button lookup = new Button(MESSAGES.buttonLookup());
        lookup.setAccessKey('l');
        this.iLookup = new Lookup();
        lookup.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ReservationEdit.this.iLookup.center();
            }
        });
        this.iLookup.setOptions("mustHaveExternalId,source=students");
        this.iLookup.addValueChangeHandler(new ValueChangeHandler<PersonInterface>(){

            public void onValueChange(ValueChangeEvent<PersonInterface> event) {
                PersonInterface student = (PersonInterface)event.getValue();
                if (student != null) {
                    ((TextArea)ReservationEdit.this.iStudents.getWidget()).setValue((Object)(((TextArea)ReservationEdit.this.iStudents.getWidget()).getValue() + (((TextArea)ReservationEdit.this.iStudents.getWidget()).getValue().isEmpty() ? "" : "\n") + student.getId() + " " + student.getLastName() + ", " + student.getFirstName() + (student.getMiddleName() == null ? "" : " " + student.getMiddleName())), true);
                    ((UniTimeTextBox)ReservationEdit.this.iLimit.getWidget()).setValue(String.valueOf(((TextArea)ReservationEdit.this.iStudents.getWidget()).getText().split("\n").length), true);
                }
            }
        });
        students.add((Widget)lookup);
        students.setCellHorizontalAlignment((Widget)lookup, HasHorizontalAlignment.ALIGN_RIGHT);
        this.iPanel.addRow(MESSAGES.propStudents(), (Widget)students);
        this.iPanel.getCellFormatter().setVerticalAlignment(this.iPanel.getRowCount() - 1, 0, HasVerticalAlignment.ALIGN_TOP);
        this.iStudentsLine = this.iPanel.getRowCount() - 1;
        this.iGroup = new UniTimeWidget<ListBox>(new ListBox());
        this.iGroup.getWidget().setStyleName("unitime-TextBox");
        this.iGroup.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ReservationEdit.this.iGroup.clearHint();
            }
        });
        this.iGroup.getWidget().addItem(MESSAGES.itemSelect(), "");
        this.iGroup.getWidget().setSelectedIndex(0);
        this.iPanel.addRow(MESSAGES.propStudentGroup(), (Widget)this.iGroup);
        this.iGroupLine = this.iPanel.getRowCount() - 1;
        this.iCourse = new UniTimeWidget<ListBox>(new ListBox());
        this.iCourse.getWidget().setStyleName("unitime-TextBox");
        this.iCourse.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ReservationEdit.this.iCourse.clearHint();
                String cid = ((ListBox)ReservationEdit.this.iCourse.getWidget()).getValue(((ListBox)ReservationEdit.this.iCourse.getWidget()).getSelectedIndex());
                for (ReservationInterface.Course course : ReservationEdit.this.iOffering.getCourses()) {
                    if (!course.getId().toString().equals(cid)) continue;
                    ((UniTimeTextBox)ReservationEdit.this.iLimit.getWidget()).setValue(course.getLimit() == null ? "" : course.getLimit().toString(), true);
                }
            }
        });
        this.iPanel.addRow(MESSAGES.propCourse(), (Widget)this.iCourse);
        this.iCourseLine = this.iPanel.getRowCount() - 1;
        this.iCurriculum = new UniTimeWidget<ListBox>(new ListBox());
        this.iCurriculum.getWidget().setStyleName("unitime-TextBox");
        this.iCurriculum.getWidget().addItem(MESSAGES.itemNone(), "");
        this.iCurriculum.getWidget().setSelectedIndex(0);
        this.iPanel.addRow("Curriculum:", (Widget)this.iCurriculum);
        this.iCurriculumLine = this.iPanel.getRowCount() - 1;
        this.iArea = new UniTimeWidget<ListBox>(new ListBox());
        this.iArea.getWidget().setStyleName("unitime-TextBox");
        this.iArea.getWidget().addItem(MESSAGES.itemSelect(), "");
        this.iArea.getWidget().setSelectedIndex(0);
        this.iPanel.addRow(MESSAGES.propAcademicArea(), (Widget)this.iArea);
        this.iAreaLine = this.iPanel.getRowCount() - 1;
        this.iClassifications = new ListBox();
        this.iClassifications.setMultipleSelect(true);
        this.iClassifications.setWidth("300px");
        this.iClassifications.setStyleName("unitime-TextBox");
        this.iClassifications.setVisibleItemCount(3);
        this.iClassifications.setHeight("100px");
        this.iPanel.addRow(MESSAGES.propClassifications(), (Widget)this.iClassifications);
        this.iMajors = new ListBox();
        this.iMajors.setMultipleSelect(true);
        this.iMajors.setWidth("300px");
        this.iMajors.setStyleName("unitime-TextBox");
        this.iMajors.setVisibleItemCount(3);
        this.iMajors.setHeight("100px");
        this.iPanel.addRow(MESSAGES.propMajors(), (Widget)this.iMajors);
        this.iCurriculum.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ReservationEdit.this.curriculumChanged();
                ReservationEdit.this.iCurriculum.clearHint();
            }
        });
        this.iArea.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ReservationEdit.this.areaChanged();
                ReservationEdit.this.iArea.clearHint();
            }
        });
        this.iClassifications.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                String curId;
                String string = curId = ((ListBox)ReservationEdit.this.iCurriculum.getWidget()).getSelectedIndex() < 0 ? "" : ((ListBox)ReservationEdit.this.iCurriculum.getWidget()).getValue(((ListBox)ReservationEdit.this.iCurriculum.getWidget()).getSelectedIndex());
                if (!curId.isEmpty()) {
                    ReservationInterface.Curriculum c = (ReservationInterface.Curriculum)ReservationEdit.this.iCurricula.get(Long.valueOf(curId));
                    int limit = 0;
                    boolean noneSelected = true;
                    block0: for (int i = 0; i < ReservationEdit.this.iClassifications.getItemCount(); ++i) {
                        if (!ReservationEdit.this.iClassifications.isItemSelected(i)) continue;
                        for (ReservationInterface.IdName f : c.getClassifications()) {
                            if (!f.getId().toString().equals(ReservationEdit.this.iClassifications.getValue(i))) continue;
                            limit += f.getLimit().intValue();
                            noneSelected = false;
                            continue block0;
                        }
                    }
                    if (noneSelected) {
                        limit = c.getLimit();
                    }
                    ((UniTimeTextBox)ReservationEdit.this.iLimit.getWidget()).setValue(limit == 0 ? "" : String.valueOf(limit), true);
                }
            }
        });
        this.iMajors.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ((ListBox)ReservationEdit.this.iCurriculum.getWidget()).setSelectedIndex(0);
            }
        });
        this.iPanel.addNotPrintableBottomRow((Widget)this.iTitleAndButtons.clonePanel(null));
        if (standAlone) {
            this.load(Window.Location.getParameter((String)"id"));
        } else {
            new InitializationChain(new InitStudentGroups(), new InitCurricula(), new InitExpirationDates()).execute(new AsyncCallback<Boolean>(){

                public void onFailure(Throwable caught) {
                    ReservationEdit.this.iTitleAndButtons.setErrorMessage(MESSAGES.failedLoadData(caught.getMessage()));
                }

                public void onSuccess(Boolean result) {
                }
            });
        }
        this.iCourseBox.addCourseSelectionHandler(new CourseSelectionHandler(){

            public void onCourseSelection(CourseSelectionEvent event) {
                if (event.getValue() != null && event.getValue().isCourse()) {
                    ReservationEdit.this.iReservationService.getOfferingByCourseName(event.getValue().getCourseName(), new AsyncCallback<ReservationInterface.Offering>(){

                        public void onFailure(Throwable caught) {
                            ReservationEdit.this.iCourseBox.setError(caught.getMessage());
                        }

                        public void onSuccess(ReservationInterface.Offering result) {
                            ReservationEdit.this.setOffering(result);
                        }
                    });
                } else {
                    ReservationEdit.this.setOffering(null);
                }
            }
        });
    }

    protected void load(String id) {
        LoadingWidget.getInstance().show(MESSAGES.waitLoadingReservation());
        if (id == null) {
            new InitializationChain(new InitStudentGroups(), new InitCurricula(), new InitExpirationDates()).execute(new AsyncCallback<Boolean>(){

                public void onFailure(Throwable caught) {
                    ReservationEdit.this.loadingFailed(caught);
                }

                public void onSuccess(Boolean result) {
                    ReservationEdit.this.setReservation(null);
                    LoadingWidget.getInstance().hide();
                }
            });
        } else {
            this.iReservationService.getReservation(Long.valueOf(id), new AsyncCallback<ReservationInterface>(){

                public void onFailure(Throwable caught) {
                    ReservationEdit.this.loadingFailed(caught);
                }

                public void onSuccess(final ReservationInterface reservation) {
                    if (reservation instanceof ReservationInterface.CurriculumReservation) {
                        new InitializationChain(new InitCurricula(), new InitExpirationDates()).execute(new AsyncCallback<Boolean>(){

                            public void onFailure(Throwable caught) {
                                ReservationEdit.this.loadingFailed(caught);
                            }

                            public void onSuccess(Boolean result) {
                                ReservationEdit.this.setReservation(reservation);
                                LoadingWidget.getInstance().hide();
                            }
                        });
                    } else if (reservation instanceof ReservationInterface.GroupReservation) {
                        new InitializationChain(new InitStudentGroups(), new InitExpirationDates()).execute(new AsyncCallback<Boolean>(){

                            public void onFailure(Throwable caught) {
                                ReservationEdit.this.loadingFailed(caught);
                            }

                            public void onSuccess(Boolean result) {
                                ReservationEdit.this.setReservation(reservation);
                                LoadingWidget.getInstance().hide();
                            }
                        });
                    } else {
                        ReservationEdit.this.setReservation(reservation);
                        LoadingWidget.getInstance().hide();
                    }
                }
            });
        }
    }

    private void loadingFailed(Throwable caught) {
        LoadingWidget.getInstance().hide();
        UniTimeNotifications.error(MESSAGES.failedLoadData(caught.getMessage()));
        this.iTitleAndButtons.setErrorMessage(MESSAGES.failedLoadData(caught.getMessage()));
        for (EditFinishedHandler h : this.iEditFinishedHandlers) {
            h.onFailure(caught);
        }
    }

    public void setReservation(ReservationInterface r) {
        Long offeringId;
        this.iReservation = r;
        UniTimePageLabel.getInstance().setPageName(this.iReservation == null ? MESSAGES.pageAddReservation() : MESSAGES.pageEditReservation());
        this.iTitleAndButtons.setEnabled("delete", this.iReservation != null);
        this.iTitleAndButtons.clearMessage();
        this.iLimit.clearHint();
        this.iType.clearHint();
        Long l = offeringId = this.iReservation == null ? null : this.iReservation.getOffering().getId();
        if (offeringId == null && Window.Location.getParameter((String)"offering") != null) {
            offeringId = Long.valueOf(Window.Location.getParameter((String)"offering"));
        }
        if (offeringId == null) {
            this.iOffering = null;
            this.iCourseBox.setEnabled(true);
            this.iCourseBox.setValue((CourseRequestInterface.RequestedCourse)null, false);
            this.iCourseBox.setError(null);
            this.iLimit.getWidget().setValue("", true);
            this.iExpirationDate.getWidget().setValue(null);
            this.iRestrictions.clear();
            this.iType.getWidget().setSelectedIndex(0);
            this.iGroup.getWidget().setSelectedIndex(0);
            this.iArea.getWidget().setSelectedIndex(0);
            this.iClassifications.clear();
            this.iStudents.getWidget().setText("");
            this.iCourse.getWidget().clear();
            this.iMajors.clear();
            this.iType.setReadOnly(false);
            this.iCurricula.clear();
            this.iCurriculum.getWidget().clear();
            this.iCurriculum.getWidget().addItem(MESSAGES.itemNone(), "");
            this.iCurriculum.getWidget().setSelectedIndex(0);
            this.areaChanged();
            this.typeChanged(true);
        } else {
            this.iCourseBox.setEnabled(false);
            LoadingWidget.getInstance().show(MESSAGES.waitLoadingReservation());
            this.iReservationService.getOffering(offeringId, new AsyncCallback<ReservationInterface.Offering>(){

                public void onFailure(Throwable caught) {
                    ReservationEdit.this.loadingFailed(caught);
                }

                public void onSuccess(ReservationInterface.Offering result) {
                    ReservationEdit.this.setOffering(result);
                    LoadingWidget.getInstance().hide();
                }
            });
        }
        if (this.iReservation == null) {
            this.iTitleAndButtons.setEnabled("previous", false);
            this.iTitleAndButtons.setEnabled("next", false);
        } else {
            EditFinishedEvent e = new EditFinishedEvent(this.iReservation.getId());
            for (EditFinishedHandler h : this.iEditFinishedHandlers) {
                this.iTitleAndButtons.setEnabled("previous", h.hasPrevious(e));
                this.iTitleAndButtons.setEnabled("next", h.hasNext(e));
            }
        }
    }

    public void setOffering(ReservationInterface.Offering offering) {
        this.iOffering = offering;
        this.iCourseBox.setError(null);
        if (this.iOffering == null) {
            return;
        }
        if (this.iOffering.isUnlockNeeded()) {
            this.iCourseBox.setError(MESSAGES.hintOfferingIsLocked(this.iOffering.getAbbv()));
        }
        if (!this.iCourseBox.isEnabled()) {
            CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
            ReservationInterface.Course course = this.iOffering.getControllingCourse();
            if (course != null) {
                rc.setCourseId(course.getId());
            }
            rc.setCourseName(this.iOffering.getAbbv());
            this.iCourseBox.setValue(rc, false);
        }
        this.iRestrictions.setOffering(this.iOffering);
        this.iCourse.getWidget().clear();
        this.iCourse.getWidget().addItem(MESSAGES.itemSelect(), "");
        for (ReservationInterface.Course course : this.iOffering.getCourses()) {
            this.iCourse.getWidget().addItem(course.getAbbv() + (course.getName() == null || course.getName().isEmpty() ? "" : " - " + course.getName()), course.getId().toString());
        }
        this.typeChanged(true);
        this.populate();
        this.iCurricula.clear();
        this.iCurriculum.getWidget().clear();
        this.iCurriculum.getWidget().addItem(MESSAGES.itemNone(), "");
        this.iCurriculum.getWidget().setSelectedIndex(0);
        this.iReservationService.getCurricula(this.iOffering.getId(), new AsyncCallback<List<ReservationInterface.Curriculum>>(){

            public void onFailure(Throwable caught) {
                ReservationEdit.this.loadingFailed(caught);
            }

            public void onSuccess(List<ReservationInterface.Curriculum> result) {
                block0: for (ReservationInterface.Curriculum curriculum : result) {
                    ReservationEdit.this.iCurricula.put(curriculum.getId(), curriculum);
                    ((ListBox)ReservationEdit.this.iCurriculum.getWidget()).addItem(curriculum.getAbbv() + " - " + curriculum.getName() + " (" + curriculum.getLimit() + ")", curriculum.getId().toString());
                    if (!curriculum.getArea().getId().toString().equals(((ListBox)ReservationEdit.this.iArea.getWidget()).getValue(((ListBox)ReservationEdit.this.iArea.getWidget()).getSelectedIndex()))) continue;
                    block1: for (int i = 0; i < ReservationEdit.this.iMajors.getItemCount(); ++i) {
                        if (ReservationEdit.this.iMajors.isItemSelected(i)) {
                            for (ReservationInterface.IdName m : curriculum.getMajors()) {
                                if (!m.getId().toString().equals(ReservationEdit.this.iMajors.getValue(i))) continue;
                                continue block1;
                            }
                            continue block0;
                        }
                        for (ReservationInterface.IdName m : curriculum.getMajors()) {
                            if (!m.getId().toString().equals(ReservationEdit.this.iMajors.getValue(i))) continue;
                            continue block0;
                        }
                    }
                    ((ListBox)ReservationEdit.this.iCurriculum.getWidget()).setSelectedIndex(((ListBox)ReservationEdit.this.iCurriculum.getWidget()).getItemCount() - 1);
                }
                String val = ((ListBox)ReservationEdit.this.iType.getWidget()).getValue(((ListBox)ReservationEdit.this.iType.getWidget()).getSelectedIndex());
                ReservationEdit.this.iPanel.getRowFormatter().setVisible(ReservationEdit.this.iCurriculumLine, "curriculum".equals(val) && ((ListBox)ReservationEdit.this.iCurriculum.getWidget()).getItemCount() > 1);
            }
        });
    }

    private ReservationInterface.OverrideType getOverrideType(String ref) {
        for (ReservationInterface.OverrideType t : ReservationInterface.OverrideType.values()) {
            if (!t.getReference().equals(ref)) continue;
            return t;
        }
        return null;
    }

    private void typeChanged(boolean setExpiration) {
        String val = this.iType.getWidget().getValue(this.iType.getWidget().getSelectedIndex());
        this.iPanel.getRowFormatter().setVisible(this.iStudentsLine, "individual".equals(val) || this.getOverrideType(val) != null);
        this.iPanel.getRowFormatter().setVisible(this.iCourseLine, "course".equals(val));
        this.iPanel.getRowFormatter().setVisible(this.iGroupLine, "group".equals(val));
        this.iPanel.getRowFormatter().setVisible(this.iCurriculumLine, "curriculum".equals(val) && this.iCurriculum.getWidget().getItemCount() > 1);
        this.iPanel.getRowFormatter().setVisible(this.iAreaLine, "curriculum".equals(val));
        this.iPanel.getRowFormatter().setVisible(1 + this.iAreaLine, "curriculum".equals(val));
        this.iPanel.getRowFormatter().setVisible(2 + this.iAreaLine, "curriculum".equals(val));
        this.iPanel.getRowFormatter().setVisible(this.iExpirationLine, this.getOverrideType(val) == null || this.getOverrideType(val).isCanHaveExpirationDate());
        this.iPanel.getRowFormatter().setVisible(this.iReservedSpaceLine, this.getOverrideType(val) == null || this.getOverrideType(val).isCanHaveExpirationDate() || this.getOverrideType(val).isExpired() == false);
        if ("course".equals(val)) {
            this.iLimit.getWidget().setReadOnly(true);
            this.iLimit.getWidget().setValue("", true);
            if (this.iOffering != null) {
                String cid = this.iCourse.getWidget().getValue(this.iCourse.getWidget().getSelectedIndex());
                for (ReservationInterface.Course course : this.iOffering.getCourses()) {
                    if (!course.getId().toString().equals(cid)) continue;
                    this.iLimit.getWidget().setValue(course.getLimit() == null ? "" : course.getLimit().toString(), true);
                }
            }
        } else if ("individual".equals(val) || this.getOverrideType(val) != null) {
            this.iLimit.getWidget().setReadOnly(true);
            this.iLimit.getWidget().setValue(String.valueOf(this.iStudents.getWidget().getText().split("\n").length), true);
        } else {
            this.iLimit.getWidget().setReadOnly(false);
        }
        if (setExpiration && this.iExpirations != null) {
            this.iExpirationDate.getWidget().setValueInServerTimeZone(this.iExpirations.getExpirationDate(val));
        }
    }

    private void areaChanged() {
        ReservationInterface.Curriculum c;
        String curId;
        this.iMajors.clear();
        this.iClassifications.clear();
        String id = this.iArea.getWidget().getValue(this.iArea.getWidget().getSelectedIndex());
        if (!id.isEmpty()) {
            ReservationInterface.Area c2 = this.iAreas.get(Long.valueOf(id));
            for (ReservationInterface.IdName major : c2.getMajors()) {
                this.iMajors.addItem(major.getAbbv() + " - " + major.getName(), major.getId().toString());
            }
            for (ReservationInterface.IdName clasf : c2.getClassifications()) {
                this.iClassifications.addItem(clasf.getAbbv() + " - " + clasf.getName(), clasf.getId().toString());
            }
        }
        String string = curId = this.iCurriculum.getWidget().getSelectedIndex() < 0 ? "" : this.iCurriculum.getWidget().getValue(this.iCurriculum.getWidget().getSelectedIndex());
        if (!curId.isEmpty() && !(c = this.iCurricula.get(Long.valueOf(curId))).getArea().getId().toString().equals(id)) {
            this.iCurriculum.getWidget().setSelectedIndex(0);
        }
    }

    private void curriculumChanged() {
        String id = this.iCurriculum.getWidget().getValue(this.iCurriculum.getWidget().getSelectedIndex());
        if (!id.isEmpty()) {
            int i;
            this.iMajors.clear();
            this.iClassifications.clear();
            ReservationInterface.Curriculum c = this.iCurricula.get(Long.valueOf(id));
            for (i = 0; i < this.iArea.getWidget().getItemCount(); ++i) {
                if (!c.getArea().getId().toString().equals(this.iArea.getWidget().getValue(i))) continue;
                this.iArea.getWidget().setSelectedIndex(i);
                break;
            }
            this.areaChanged();
            for (i = 0; i < this.iMajors.getItemCount(); ++i) {
                String majorId = this.iMajors.getValue(i);
                boolean hasMajor = false;
                for (ReservationInterface.IdName m : c.getMajors()) {
                    if (!m.getId().toString().equals(majorId)) continue;
                    hasMajor = true;
                    break;
                }
                this.iMajors.setItemSelected(i, hasMajor);
            }
            for (i = 0; i < this.iClassifications.getItemCount(); ++i) {
                String clasfId = this.iClassifications.getValue(i);
                boolean hasClasf = false;
                for (ReservationInterface.IdName m : c.getClassifications()) {
                    if (!m.getId().toString().equals(clasfId)) continue;
                    hasClasf = true;
                    break;
                }
                this.iClassifications.setItemSelected(i, hasClasf);
            }
            this.iLimit.getWidget().setValue(c.getLimit() == null ? "" : c.getLimit().toString(), true);
        }
    }

    public void populate() {
        if (this.iReservation == null) {
            return;
        }
        this.iLimit.getWidget().setValue(this.iReservation.getLimit() == null ? "" : this.iReservation.getLimit().toString());
        this.iExpirationDate.getWidget().setValueInServerTimeZone(this.iReservation.getExpirationDate());
        this.iRestrictions.populate(this.iReservation);
        if (this.iReservation instanceof ReservationInterface.OverrideReservation) {
            this.select(this.iType.getWidget(), ((ReservationInterface.OverrideReservation)this.iReservation).getType().getReference());
            String students = "";
            for (ReservationInterface.IdName student : ((ReservationInterface.OverrideReservation)this.iReservation).getStudents()) {
                students = students + (students.isEmpty() ? "" : "\n") + student.getAbbv() + " " + student.getName();
            }
            this.iStudents.getWidget().setText(students);
        } else if (this.iReservation instanceof ReservationInterface.IndividualReservation) {
            this.select(this.iType.getWidget(), "individual");
            String students = "";
            for (ReservationInterface.IdName student : ((ReservationInterface.IndividualReservation)this.iReservation).getStudents()) {
                students = students + (students.isEmpty() ? "" : "\n") + student.getAbbv() + " " + student.getName();
            }
            this.iStudents.getWidget().setText(students);
        } else if (this.iReservation instanceof ReservationInterface.GroupReservation) {
            this.select(this.iType.getWidget(), "group");
            this.select(this.iGroup.getWidget(), ((ReservationInterface.GroupReservation)this.iReservation).getGroup().getId().toString());
        } else if (this.iReservation instanceof ReservationInterface.CourseReservation) {
            this.select(this.iType.getWidget(), "course");
            this.select(this.iCourse.getWidget(), ((ReservationInterface.CourseReservation)this.iReservation).getCourse().getId().toString());
        } else if (this.iReservation instanceof ReservationInterface.CurriculumReservation) {
            boolean selected;
            Long id;
            int i;
            this.select(this.iType.getWidget(), "curriculum");
            ReservationInterface.Area curriculum = ((ReservationInterface.CurriculumReservation)this.iReservation).getCurriculum();
            this.select(this.iArea.getWidget(), curriculum.getId().toString());
            this.areaChanged();
            for (i = 0; i < this.iMajors.getItemCount(); ++i) {
                id = Long.valueOf(this.iMajors.getValue(i));
                selected = false;
                for (ReservationInterface.IdName mj : curriculum.getMajors()) {
                    if (!mj.getId().equals(id)) continue;
                    selected = true;
                }
                this.iMajors.setItemSelected(i, selected);
            }
            for (i = 0; i < this.iClassifications.getItemCount(); ++i) {
                id = Long.valueOf(this.iClassifications.getValue(i));
                selected = false;
                for (ReservationInterface.IdName clasf : curriculum.getClassifications()) {
                    if (!clasf.getId().equals(id)) continue;
                    selected = true;
                }
                this.iClassifications.setItemSelected(i, selected);
            }
        }
        this.typeChanged(false);
        this.iType.setReadOnly(true);
        this.iType.setText(this.iType.getWidget().getItemText(this.iType.getWidget().getSelectedIndex()));
    }

    private void select(ListBox l, String value) {
        for (int i = 0; i < l.getItemCount(); ++i) {
            if (!l.getValue(i).equals(value)) continue;
            l.setSelectedIndex(i);
            return;
        }
    }

    public ReservationInterface validate() {
        ReservationInterface r;
        boolean ok = true;
        String type = this.iType.getWidget().getValue(this.iType.getWidget().getSelectedIndex());
        if (type.isEmpty()) {
            this.iType.setErrorHint(MESSAGES.hintReservationTypeNotSelected());
            ok = false;
        } else {
            this.iType.clearHint();
        }
        if ("individual".equals(type) || this.getOverrideType(type) != null) {
            r = "individual".equals(type) ? new ReservationInterface.IndividualReservation() : new ReservationInterface.OverrideReservation(this.getOverrideType(type));
            if (this.iStudents.getWidget().getText().isEmpty()) {
                this.iStudents.setErrorHint(MESSAGES.hintNoStudentsProvided());
                ok = false;
            } else {
                RegExp rx = RegExp.compile((String)"^([a-zA-Z0-9]+)[ ,;\\|]?(.*)$");
                for (String student : this.iStudents.getWidget().getText().split("\\n")) {
                    if (student.trim().isEmpty()) continue;
                    try {
                        MatchResult m = rx.exec(student.trim());
                        if (m == null) {
                            this.iStudents.setErrorHint(MESSAGES.hintLineXIsNotValidStudent(student));
                            ok = false;
                            break;
                        }
                        ReservationInterface.IdName s = new ReservationInterface.IdName();
                        s.setAbbv(m.getGroup(1));
                        s.setName(m.getGroupCount() <= 2 ? "" : m.getGroup(2).trim());
                        ((ReservationInterface.IndividualReservation)r).getStudents().add(s);
                        if (!((ReservationInterface.IndividualReservation)r).getStudents().isEmpty()) continue;
                        this.iStudents.setErrorHint(MESSAGES.hintNoStudentsProvided());
                        ok = false;
                    }
                    catch (Exception e) {
                        this.iStudents.setErrorHint(MESSAGES.hintLineXIsNotValidStudentException(student, e.getMessage()));
                        ok = false;
                    }
                }
            }
        } else if ("group".equals(type)) {
            r = new ReservationInterface.GroupReservation();
            String gid = this.iGroup.getWidget().getValue(this.iGroup.getWidget().getSelectedIndex());
            if (gid.isEmpty()) {
                this.iGroup.setErrorHint(MESSAGES.hintStudentGroupNotProvided());
                ok = false;
            } else {
                ReservationInterface.IdName group = new ReservationInterface.IdName();
                group.setId(Long.valueOf(gid));
                group.setName(this.iGroup.getWidget().getItemText(this.iGroup.getWidget().getSelectedIndex()));
                ((ReservationInterface.GroupReservation)r).setGroup(group);
            }
        } else if ("course".equals(type)) {
            r = new ReservationInterface.CourseReservation();
            String cid = this.iCourse.getWidget().getValue(this.iCourse.getWidget().getSelectedIndex());
            if (cid.isEmpty()) {
                this.iCourse.setErrorHint(MESSAGES.hintCourseNotProvided());
                ok = false;
            } else {
                ReservationInterface.Course course = new ReservationInterface.Course();
                course.setId(Long.valueOf(cid));
                course.setName(this.iCourse.getWidget().getItemText(this.iCourse.getWidget().getSelectedIndex()));
                ((ReservationInterface.CourseReservation)r).setCourse(course);
            }
        } else if ("curriculum".equals(type)) {
            r = new ReservationInterface.CurriculumReservation();
            String aid = this.iArea.getWidget().getValue(this.iArea.getWidget().getSelectedIndex());
            if (aid.isEmpty()) {
                this.iArea.setErrorHint(MESSAGES.hintAcademicAreaNotProvided());
                ok = false;
            } else {
                int i;
                ReservationInterface.Area curriculum = new ReservationInterface.Area();
                curriculum.setId(Long.valueOf(aid));
                curriculum.setName(this.iArea.getWidget().getItemText(this.iArea.getWidget().getSelectedIndex()));
                for (i = 0; i < this.iMajors.getItemCount(); ++i) {
                    if (!this.iMajors.isItemSelected(i)) continue;
                    ReservationInterface.IdName mj = new ReservationInterface.IdName();
                    mj.setId(Long.valueOf(this.iMajors.getValue(i)));
                    mj.setName(this.iMajors.getItemText(i));
                    curriculum.getMajors().add(mj);
                }
                for (i = 0; i < this.iClassifications.getItemCount(); ++i) {
                    if (!this.iClassifications.isItemSelected(i)) continue;
                    ReservationInterface.IdName clasf = new ReservationInterface.IdName();
                    clasf.setId(Long.valueOf(this.iClassifications.getValue(i)));
                    clasf.setName(this.iClassifications.getItemText(i));
                    curriculum.getClassifications().add(clasf);
                }
                ((ReservationInterface.CurriculumReservation)r).setCurriculum(curriculum);
            }
        } else {
            if ("".equals(type)) {
                this.iType.setErrorHint(MESSAGES.hintReservationTypeNotSelected());
                return null;
            }
            this.iType.setErrorHint(MESSAGES.hintReservationTypeNotSupported(type));
            return null;
        }
        if (this.iExpirationDate.getWidget().getValue() == null && !this.iExpirationDate.getWidget().getText().isEmpty()) {
            this.iExpirationDate.setErrorHint(MESSAGES.hintExpirationDateNotValid());
            ok = false;
        } else {
            r.setExpirationDate(this.iExpirationDate.getWidget().getValueInServerTimeZone());
            this.iExpirationDate.clearHint();
        }
        if (!"individual".equals(type) && this.getOverrideType(type) == null) {
            if (this.iLimit.getWidget().getText().isEmpty()) {
                r.setLimit(null);
            } else {
                try {
                    r.setLimit(Integer.parseInt(this.iLimit.getWidget().getText()));
                }
                catch (Exception e) {
                    this.iLimit.setErrorHint(MESSAGES.hintReservationLimitNotValid());
                    ok = false;
                }
            }
        }
        if (this.iReservation != null) {
            r.setId(this.iReservation.getId());
        }
        ReservationInterface.Offering o = new ReservationInterface.Offering();
        if (this.iOffering == null) {
            this.iCourseBox.setError(MESSAGES.hintOfferingNotProvided());
            ok = false;
        } else if (this.iOffering.isUnlockNeeded()) {
            this.iCourseBox.setError(MESSAGES.hintOfferingIsLocked(this.iOffering.getAbbv()));
            ok = false;
        } else {
            o.setId(this.iOffering.getId());
            o.setName(this.iOffering.getName());
        }
        r.setOffering(o);
        this.iRestrictions.validate(r);
        return ok ? r : null;
    }

    public void addEditFinishedHandler(EditFinishedHandler h) {
        this.iEditFinishedHandlers.add(h);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InitializationChain
    implements Initialization {
        private Initialization[] iInitializations;

        public InitializationChain(Initialization ... initializations) {
            this.iInitializations = initializations;
        }

        @Override
        public void execute(AsyncCallback<Boolean> callback) {
            this.execute(0, callback);
        }

        private void execute(final int index, final AsyncCallback<Boolean> callback) {
            if (index >= this.iInitializations.length) {
                callback.onSuccess((Object)true);
            } else {
                this.iInitializations[index].execute(new AsyncCallback<Boolean>(){

                    public void onFailure(Throwable caught) {
                        callback.onFailure(caught);
                    }

                    public void onSuccess(Boolean result) {
                        if (result.booleanValue()) {
                            InitializationChain.this.execute(1 + index, (AsyncCallback<Boolean>)callback);
                        } else {
                            callback.onSuccess((Object)false);
                        }
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class InitCurricula
    implements Initialization {
        @Override
        public void execute(final AsyncCallback<Boolean> callback) {
            ReservationEdit.this.iReservationService.getAreas(new AsyncCallback<List<ReservationInterface.Area>>(){

                public void onFailure(Throwable caught) {
                    callback.onFailure(caught);
                }

                public void onSuccess(List<ReservationInterface.Area> result) {
                    for (ReservationInterface.Area c : result) {
                        ((ListBox)ReservationEdit.this.iArea.getWidget()).addItem(c.getAbbv() + " - " + c.getName(), c.getId().toString());
                        ReservationEdit.this.iAreas.put(c.getId(), c);
                    }
                    callback.onSuccess((Object)true);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class InitStudentGroups
    implements Initialization {
        @Override
        public void execute(final AsyncCallback<Boolean> callback) {
            ReservationEdit.this.iReservationService.getStudentGroups(new AsyncCallback<List<ReservationInterface.IdName>>(){

                public void onFailure(Throwable caught) {
                    ((ListBox)ReservationEdit.this.iType.getWidget()).removeItem(2);
                    callback.onFailure(caught);
                }

                public void onSuccess(List<ReservationInterface.IdName> result) {
                    if (result.isEmpty()) {
                        ((ListBox)ReservationEdit.this.iType.getWidget()).removeItem(2);
                    } else {
                        for (ReservationInterface.IdName group : result) {
                            ((ListBox)ReservationEdit.this.iGroup.getWidget()).addItem(group.getAbbv() + " - " + group.getName() + " (" + group.getLimit() + ")", group.getId().toString());
                        }
                    }
                    callback.onSuccess((Object)true);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class InitExpirationDates
    implements Initialization {
        @Override
        public void execute(final AsyncCallback<Boolean> callback) {
            RPC.execute(new ReservationInterface.ReservationDefaultExpirationDatesRpcRequest(), new AsyncCallback<ReservationInterface.DefaultExpirationDates>(){

                public void onFailure(Throwable caught) {
                    callback.onFailure(caught);
                }

                public void onSuccess(ReservationInterface.DefaultExpirationDates result) {
                    ReservationEdit.this.iExpirations = result;
                    callback.onSuccess((Object)true);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Initialization {
        public void execute(AsyncCallback<Boolean> var1);
    }

    public static interface EditFinishedHandler {
        public void onBack(EditFinishedEvent var1);

        public void onDelete(EditFinishedEvent var1);

        public void onSave(EditFinishedEvent var1);

        public void onFailure(Throwable var1);

        public boolean hasNext(EditFinishedEvent var1);

        public boolean hasPrevious(EditFinishedEvent var1);

        public void onNext(EditFinishedEvent var1);

        public void onPrevious(EditFinishedEvent var1);
    }

    public static class EditFinishedEvent {
        private Long iReservationId;

        public EditFinishedEvent(Long reservationId) {
            this.iReservationId = reservationId;
        }

        public Long getReservationId() {
            return this.iReservationId;
        }
    }
}

