/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.curricula;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.ValueBoxBase;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.curricula.CurriculumCookie;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTextBox;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseNull;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.services.CurriculaService;
import org.unitime.timetable.gwt.services.CurriculaServiceAsync;
import org.unitime.timetable.gwt.shared.CurriculaException;
import org.unitime.timetable.gwt.shared.CurriculumInterface;
import org.unitime.timetable.gwt.shared.UserDataInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurriculumProjectionRulesPage
extends Composite {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    public static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private final CurriculaServiceAsync iService = (CurriculaServiceAsync)GWT.create(CurriculaService.class);
    private static NumberFormat NF = NumberFormat.getFormat((String)"##0.0");
    private MyFlexTable iTable;
    private SimpleForm iPanel = null;
    private UniTimeHeaderPanel iHeader = null;
    private UniTimeHeaderPanel iBottom = null;
    private boolean iEditable = false;
    private HashMap<CurriculumInterface.AcademicAreaInterface, HashMap<CurriculumInterface.MajorInterface, HashMap<CurriculumInterface.AcademicClassificationInterface, Number[]>>> iRules = null;
    private HashMap<String, String> iOrder = null;
    private List<ProjectionRulesHandler> iProjectionRulesHandlers = new ArrayList<ProjectionRulesHandler>();

    public CurriculumProjectionRulesPage() {
        this.iPanel = new SimpleForm();
        ClickHandler save = new ClickHandler(){

            public void onClick(ClickEvent event) {
                LoadingWidget.getInstance().show(MESSAGES.waitSavingCurriculumProjectionRules());
                CurriculumProjectionRulesPage.this.iService.saveProjectionRules(CurriculumProjectionRulesPage.this.iRules, new AsyncCallback<Boolean>(){

                    public void onFailure(Throwable caught) {
                        CurriculumProjectionRulesPage.this.iHeader.setErrorMessage(MESSAGES.failedToSaveCurriculumProjectionRules(caught.getMessage()));
                        UniTimeNotifications.error(MESSAGES.failedToSaveCurriculumProjectionRules(caught.getMessage()), caught);
                        LoadingWidget.getInstance().hide();
                        for (ProjectionRulesHandler h : CurriculumProjectionRulesPage.this.iProjectionRulesHandlers) {
                            h.onException(caught);
                        }
                    }

                    public void onSuccess(Boolean result) {
                        CurriculumProjectionRulesPage.this.iHeader.clearMessage();
                        LoadingWidget.getInstance().hide();
                        ProjectionRulesEvent e = new ProjectionRulesEvent();
                        for (ProjectionRulesHandler h : CurriculumProjectionRulesPage.this.iProjectionRulesHandlers) {
                            h.onRulesSaved(e);
                        }
                        if (!CurriculumProjectionRulesPage.this.iHeader.isEnabled("close").booleanValue()) {
                            CurriculumProjectionRulesPage.this.iHeader.setEnabled("back", false);
                            CurriculumProjectionRulesPage.this.iHeader.setEnabled("save", false);
                            CurriculumProjectionRulesPage.this.iHeader.setEnabled("edit", true);
                            CurriculumProjectionRulesPage.this.iHeader.setEnabled("print", true);
                            CurriculumProjectionRulesPage.this.iEditable = false;
                            CurriculumProjectionRulesPage.this.updateAll();
                        }
                    }
                });
            }
        };
        ClickHandler close = new ClickHandler(){

            public void onClick(ClickEvent event) {
                ProjectionRulesEvent e = new ProjectionRulesEvent();
                for (ProjectionRulesHandler h : CurriculumProjectionRulesPage.this.iProjectionRulesHandlers) {
                    h.onRulesClosed(e);
                }
            }
        };
        ClickHandler print = new ClickHandler(){

            public void onClick(ClickEvent event) {
                Window.print();
            }
        };
        ClickHandler edit = new ClickHandler(){

            public void onClick(ClickEvent event) {
                CurriculumProjectionRulesPage.this.iEditable = true;
                CurriculumProjectionRulesPage.this.updateAll();
                CurriculumProjectionRulesPage.this.iHeader.setEnabled("back", true);
                CurriculumProjectionRulesPage.this.iHeader.setEnabled("save", true);
                CurriculumProjectionRulesPage.this.iHeader.setEnabled("edit", false);
                CurriculumProjectionRulesPage.this.iHeader.setEnabled("print", false);
            }
        };
        ClickHandler back = new ClickHandler(){

            public void onClick(ClickEvent event) {
                CurriculumProjectionRulesPage.this.iEditable = false;
                CurriculumProjectionRulesPage.this.reload();
            }
        };
        this.iHeader = new UniTimeHeaderPanel();
        this.iHeader.addButton("edit", MESSAGES.buttonEdit(), 75, edit);
        this.iHeader.addButton("save", MESSAGES.buttonSave(), 75, save);
        this.iHeader.addButton("print", MESSAGES.buttonPrint(), 75, print);
        this.iHeader.addButton("close", MESSAGES.buttonClose(), 75, close);
        this.iHeader.addButton("back", MESSAGES.buttonBack(), 75, back);
        this.iPanel.addHeaderRow((Widget)this.iHeader);
        this.iTable = new MyFlexTable();
        this.iTable.setVisible(false);
        ScrollPanel tableScroll = new ScrollPanel((Widget)this.iTable);
        tableScroll.addStyleName("unitime-ScrollTable");
        this.iPanel.addRow((Widget)tableScroll);
        this.iBottom = this.iHeader.clonePanel();
        this.iPanel.addNotPrintableBottomRow((Widget)this.iBottom);
        this.initWidget((Widget)this.iPanel);
        this.iHeader.setEnabled("close", false);
        this.reload();
    }

    public void reload() {
        this.iHeader.setEnabled("save", false);
        this.iHeader.setEnabled("edit", false);
        this.iHeader.setEnabled("back", false);
        this.iHeader.setEnabled("print", false);
        LoadingWidget.getInstance().show(MESSAGES.waitLoadingCurriculumProjectionRules());
        this.iService.loadProjectionRules(new AsyncCallback<HashMap<CurriculumInterface.AcademicAreaInterface, HashMap<CurriculumInterface.MajorInterface, HashMap<CurriculumInterface.AcademicClassificationInterface, Number[]>>>>(){

            public void onFailure(Throwable caught) {
                CurriculumProjectionRulesPage.this.iHeader.setErrorMessage(MESSAGES.failedToLoadCurriculumProjectionRules(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToLoadCurriculumProjectionRules(caught.getMessage()), caught);
                LoadingWidget.getInstance().hide();
                for (ProjectionRulesHandler h : CurriculumProjectionRulesPage.this.iProjectionRulesHandlers) {
                    h.onException(caught);
                }
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(HashMap<CurriculumInterface.AcademicAreaInterface, HashMap<CurriculumInterface.MajorInterface, HashMap<CurriculumInterface.AcademicClassificationInterface, Number[]>>> result) {
                CurriculumProjectionRulesPage.this.iRules = result;
                UserDataInterface.GetUserDataRpcRequest ordRequest = new UserDataInterface.GetUserDataRpcRequest();
                ordRequest.add("CurProjRules.Order");
                for (CurriculumInterface.AcademicAreaInterface area : CurriculumProjectionRulesPage.this.iRules.keySet()) {
                    ordRequest.add("CurProjRules.Order[" + area.getAbbv() + "]");
                }
                CurriculumProjectionRulesPage.this.iHeader.clearMessage();
                RPC.execute(ordRequest, new AsyncCallback<UserDataInterface>(){

                    public void onSuccess(UserDataInterface result) {
                        CurriculumProjectionRulesPage.this.iOrder = result;
                        CurriculumProjectionRulesPage.this.refreshTableAndAll();
                    }

                    public void onFailure(Throwable caught) {
                        CurriculumProjectionRulesPage.this.refreshTableAndAll();
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshTableAndAll() {
        try {
            try {
                this.refreshTable();
                this.iService.canEditProjectionRules(new AsyncCallback<Boolean>(){

                    public void onFailure(Throwable caught) {
                    }

                    public void onSuccess(Boolean result) {
                        if (result.booleanValue()) {
                            if (CurriculumProjectionRulesPage.this.iHeader.isEnabled("close").booleanValue()) {
                                CurriculumProjectionRulesPage.this.iHeader.setEnabled("save", true);
                                CurriculumProjectionRulesPage.this.iEditable = true;
                                CurriculumProjectionRulesPage.this.updateAll();
                            } else {
                                CurriculumProjectionRulesPage.this.iHeader.setEnabled("edit", true);
                            }
                        }
                    }
                });
                ProjectionRulesEvent e = new ProjectionRulesEvent();
                for (ProjectionRulesHandler h : this.iProjectionRulesHandlers) {
                    h.onRulesLoaded(e);
                }
                Object var5_7 = null;
                LoadingWidget.getInstance().hide();
            }
            catch (Throwable t) {
                this.iHeader.setErrorMessage(MESSAGES.failedToLoadCurriculumProjectionRules(t.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToLoadCurriculumProjectionRules(t.getMessage()), t);
                for (ProjectionRulesHandler h : this.iProjectionRulesHandlers) {
                    h.onException(t);
                }
                Object var5_8 = null;
                LoadingWidget.getInstance().hide();
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            LoadingWidget.getInstance().hide();
            throw throwable;
        }
    }

    public void setAllowClose(boolean allow) {
        this.iHeader.setEnabled("close", allow);
    }

    private boolean isUsed(CurriculumInterface.AcademicClassificationInterface c) {
        CurriculumInterface.MajorInterface defaultMajor = new CurriculumInterface.MajorInterface();
        defaultMajor.setId(-1L);
        for (Map.Entry<CurriculumInterface.AcademicAreaInterface, HashMap<CurriculumInterface.MajorInterface, HashMap<CurriculumInterface.AcademicClassificationInterface, Number[]>>> e : this.iRules.entrySet()) {
            if (e.getValue().get(defaultMajor).get(c)[1].intValue() <= 0) continue;
            return true;
        }
        return true;
    }

    private boolean canCombine(CurriculumInterface.AcademicClassificationInterface c1, Set<CurriculumInterface.AcademicClassificationInterface> s2) {
        CurriculumInterface.MajorInterface defaultMajor = new CurriculumInterface.MajorInterface();
        defaultMajor.setId(-1L);
        for (Map.Entry<CurriculumInterface.AcademicAreaInterface, HashMap<CurriculumInterface.MajorInterface, HashMap<CurriculumInterface.AcademicClassificationInterface, Number[]>>> e : this.iRules.entrySet()) {
            if (e.getValue().get(defaultMajor).get(c1)[1].intValue() <= 0) continue;
            for (CurriculumInterface.AcademicClassificationInterface c2 : s2) {
                if (e.getValue().get(defaultMajor).get(c2)[1].intValue() <= 0) continue;
                return false;
            }
        }
        return true;
    }

    public void updateAll() {
        for (int row = 1; row < this.iTable.getRowCount(); ++row) {
            for (int col = 1; col < this.iTable.getCellCount(row); ++col) {
                Widget w = this.iTable.getWidget(row, col);
                if (w == null) continue;
                ((Updatable)w).update();
            }
        }
    }

    public void refreshTable() throws CurriculaException {
        for (int row = this.iTable.getRowCount() - 1; row >= 0; --row) {
            this.iTable.removeRow(row);
        }
        if (this.iRules == null || this.iRules.isEmpty()) {
            throw new CurriculaException(MESSAGES.errorNoAcademicAreasDefined());
        }
        String areaOrd = this.iOrder == null ? null : this.iOrder.get("CurProjRules.Order");
        TreeSet<CurriculumInterface.AcademicAreaInterface> areas = null;
        if (areaOrd != null && areaOrd.length() > 0) {
            final String ord = "|" + areaOrd + "|";
            areas = new TreeSet<CurriculumInterface.AcademicAreaInterface>(new Comparator<CurriculumInterface.AcademicAreaInterface>(){

                @Override
                public int compare(CurriculumInterface.AcademicAreaInterface a1, CurriculumInterface.AcademicAreaInterface a2) {
                    int i2;
                    int i1 = ord.indexOf("|" + a1.getAbbv() + "|");
                    if (i1 >= 0 && (i2 = ord.indexOf("|" + a2.getAbbv() + "|")) >= 0) {
                        return i1 < i2 ? -1 : (i1 > i2 ? 1 : a1.compareTo(a2));
                    }
                    return a1.compareTo(a2);
                }
            });
            areas.addAll(this.iRules.keySet());
        } else {
            areas = new TreeSet<CurriculumInterface.AcademicAreaInterface>(this.iRules.keySet());
        }
        TreeSet<CurriculumInterface.AcademicClassificationInterface> classifications = null;
        CurriculumInterface.MajorInterface defaultMajor = new CurriculumInterface.MajorInterface();
        defaultMajor.setId(-1L);
        ArrayList col2clasf = new ArrayList();
        HashMap<CurriculumInterface.AcademicClassificationInterface, Integer> clasf2col = new HashMap<CurriculumInterface.AcademicClassificationInterface, Integer>();
        HashMap<Integer, ArrayList<MyCell>> col2cells = new HashMap<Integer, ArrayList<MyCell>>();
        int row = 1;
        for (CurriculumInterface.AcademicAreaInterface area : areas) {
            HashMap<CurriculumInterface.MajorInterface, HashMap<CurriculumInterface.AcademicClassificationInterface, Number[]>> rules = this.iRules.get(area);
            MyRow rr = new MyRow(area, null, rules.get(defaultMajor));
            if (classifications == null) {
                classifications = rr.getClassifications();
                for (CurriculumInterface.AcademicClassificationInterface academicClassificationInterface : classifications) {
                    if (!this.isUsed(academicClassificationInterface)) continue;
                    Integer col = (Integer)clasf2col.get(academicClassificationInterface);
                    if (col == null) {
                        for (int c = 0; c < col2clasf.size(); ++c) {
                            if (!this.canCombine(academicClassificationInterface, (Set)col2clasf.get(c))) continue;
                            ((Set)col2clasf.get(c)).add(academicClassificationInterface);
                            clasf2col.put(academicClassificationInterface, c);
                            col = c;
                            break;
                        }
                    }
                    if (col != null) continue;
                    TreeSet<CurriculumInterface.AcademicClassificationInterface> s = new TreeSet<CurriculumInterface.AcademicClassificationInterface>();
                    s.add(academicClassificationInterface);
                    col = col2clasf.size();
                    col2clasf.add(s);
                    clasf2col.put(academicClassificationInterface, col);
                }
            }
            if (!rr.hasLastLike()) continue;
            this.iTable.setText(row, 0, area.getAbbv());
            ArrayList<MyCell> cells = new ArrayList<MyCell>();
            for (CurriculumInterface.AcademicClassificationInterface clasf3 : classifications) {
                if (rr.getLastLike(clasf3) <= 0) continue;
                Integer col = (Integer)clasf2col.get(clasf3);
                MyCell cell = new MyCell(rr, clasf3);
                this.iTable.setWidget(row, 1 + col, (Widget)cell);
                cells.add(cell);
                ArrayList<MyCell> cellsThisCol = (ArrayList<MyCell>)col2cells.get(col);
                if (cellsThisCol == null) {
                    cellsThisCol = new ArrayList<MyCell>();
                    col2cells.put(col, cellsThisCol);
                }
                cellsThisCol.add(cell);
            }
            this.iTable.setWidget(row, 1 + col2clasf.size(), (Widget)new MySumCell(cells, false));
            this.iTable.getCellFormatter().getElement(row, 1 + col2clasf.size()).getStyle().setBackgroundColor("#EEEEEE");
            ++row;
            String string = this.iOrder == null ? null : this.iOrder.get("CurProjRules.Order[" + area.getAbbv() + "]");
            TreeSet<CurriculumInterface.MajorInterface> majors = null;
            if (string != null && string.length() > 0) {
                final String ord = "|" + string + "|";
                majors = new TreeSet<CurriculumInterface.MajorInterface>(new Comparator<CurriculumInterface.MajorInterface>(){

                    @Override
                    public int compare(CurriculumInterface.MajorInterface m1, CurriculumInterface.MajorInterface m2) {
                        int i2;
                        int i1 = ord.indexOf("|" + m1.getCode() + "|");
                        if (i1 >= 0 && (i2 = ord.indexOf("|" + m2.getCode() + "|")) >= 0) {
                            return i1 < i2 ? -1 : (i1 > i2 ? 1 : m1.compareTo(m2));
                        }
                        return m1.compareTo(m2);
                    }
                });
                majors.addAll(this.iRules.get(area).keySet());
            } else {
                majors = new TreeSet<CurriculumInterface.MajorInterface>(this.iRules.get(area).keySet());
            }
            for (CurriculumInterface.MajorInterface major : majors) {
                MyRow r;
                if (major.getId() < 0L || !(r = new MyRow(area, major, rules.get(major))).hasLastLike()) continue;
                r.setParent(rr);
                rr.addChild(r);
                Label majorLabel = new Label(major.getCode(), false);
                majorLabel.getElement().getStyle().setMarginLeft(10.0, Style.Unit.PX);
                this.iTable.setWidget(row, 0, (Widget)majorLabel);
                ArrayList<MyCell> mcells = new ArrayList<MyCell>();
                for (CurriculumInterface.AcademicClassificationInterface clasf4 : classifications) {
                    if (r.getLastLike(clasf4) <= 0) continue;
                    Integer col = (Integer)clasf2col.get(clasf4);
                    MyCell cell = new MyCell(r, clasf4);
                    mcells.add(cell);
                    this.iTable.setWidget(row, 1 + col, (Widget)cell);
                    ArrayList<MyCell> cellsThisCol = (ArrayList<MyCell>)col2cells.get(col);
                    if (cellsThisCol == null) {
                        cellsThisCol = new ArrayList<MyCell>();
                        col2cells.put(col, cellsThisCol);
                    }
                    cellsThisCol.add(cell);
                }
                this.iTable.setWidget(row, 1 + col2clasf.size(), (Widget)new MySumCell(mcells, false));
                this.iTable.getRowFormatter().setVisible(row, r.hasProjection());
                this.iTable.getCellFormatter().getElement(row, 1 + col2clasf.size()).getStyle().setBackgroundColor("#EEEEEE");
                ++row;
            }
        }
        if (classifications == null || classifications.isEmpty()) {
            throw new CurriculaException(MESSAGES.errorNoAcademicClassificationsDefined());
        }
        ClickHandler menu = new ClickHandler(){

            public void onClick(ClickEvent event) {
                final PopupPanel popup = new PopupPanel(true);
                MenuBar menu = new MenuBar(true);
                if (CurriculumCookie.getInstance().getCurriculumProjectionRulesPercent()) {
                    menu.addItem(new MenuItem(MESSAGES.opShowNumbers(), true, (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            popup.hide();
                            CurriculumCookie.getInstance().setCurriculumProjectionRulesPercent(false);
                            CurriculumProjectionRulesPage.this.updateAll();
                        }
                    }));
                } else {
                    menu.addItem(new MenuItem(MESSAGES.opShowPercentages(), true, (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            popup.hide();
                            CurriculumCookie.getInstance().setCurriculumProjectionRulesPercent(true);
                            CurriculumProjectionRulesPage.this.updateAll();
                        }
                    }));
                }
                if (CurriculumCookie.getInstance().getCurriculumProjectionRulesShowLastLike()) {
                    menu.addItem(new MenuItem(MESSAGES.opHide(MESSAGES.fieldLastLikeEnrollment()), true, (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            popup.hide();
                            CurriculumCookie.getInstance().setCurriculumProjectionRulesShowLastLike(false);
                            CurriculumProjectionRulesPage.this.updateAll();
                        }
                    }));
                } else {
                    menu.addItem(new MenuItem(MESSAGES.opShow(MESSAGES.fieldLastLikeEnrollment()), true, (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            popup.hide();
                            CurriculumCookie.getInstance().setCurriculumProjectionRulesShowLastLike(true);
                            CurriculumProjectionRulesPage.this.updateAll();
                        }
                    }));
                }
                boolean canCollapse = false;
                boolean canExpand = false;
                for (int row = 1; row < CurriculumProjectionRulesPage.this.iTable.getRowCount(); ++row) {
                    MyRow r = CurriculumProjectionRulesPage.this.iTable.getMyRow(row);
                    if (r == null || r.getMajor() == null || r.hasProjection()) continue;
                    if (CurriculumProjectionRulesPage.this.iTable.getRowFormatter().isVisible(row)) {
                        canCollapse = true;
                        continue;
                    }
                    canExpand = true;
                }
                if (canCollapse) {
                    menu.addItem(new MenuItem(MESSAGES.opCollapseAll(), true, (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            popup.hide();
                            for (int row = 1; row < CurriculumProjectionRulesPage.this.iTable.getRowCount(); ++row) {
                                MyRow r = CurriculumProjectionRulesPage.this.iTable.getMyRow(row);
                                if (r == null || r.getMajor() == null || r.hasProjection() || !CurriculumProjectionRulesPage.this.iTable.getRowFormatter().isVisible(row)) continue;
                                CurriculumProjectionRulesPage.this.iTable.getRowFormatter().setVisible(row, false);
                            }
                        }
                    }));
                }
                if (canExpand) {
                    menu.addItem(new MenuItem(MESSAGES.opExpandAll(), true, (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            popup.hide();
                            for (int row = 1; row < CurriculumProjectionRulesPage.this.iTable.getRowCount(); ++row) {
                                MyRow r = CurriculumProjectionRulesPage.this.iTable.getMyRow(row);
                                if (r == null || r.getMajor() == null || r.hasProjection() || CurriculumProjectionRulesPage.this.iTable.getRowFormatter().isVisible(row)) continue;
                                CurriculumProjectionRulesPage.this.iTable.getRowFormatter().setVisible(row, true);
                            }
                        }
                    }));
                }
                menu.setVisible(true);
                popup.add((Widget)menu);
                popup.showRelativeTo((UIObject)((Widget)event.getSource()));
            }
        };
        for (int c = 0; c < col2clasf.size(); ++c) {
            String text = "";
            for (CurriculumInterface.AcademicClassificationInterface clasf : (Set)col2clasf.get(c)) {
                if (!text.isEmpty()) {
                    text = text + " / ";
                }
                text = text + clasf.getCode();
            }
            Label label = new Label(text, true);
            label.addClickHandler(menu);
            this.iTable.getFlexCellFormatter().setStyleName(0, c + 1, "unitime-ClickableTableHeader");
            this.iTable.setWidget(0, c + 1, (Widget)label);
            this.iTable.getCellFormatter().setHorizontalAlignment(0, c + 1, HasHorizontalAlignment.ALIGN_CENTER);
        }
        HTML label = new HTML("&nbsp;", false);
        label.addClickHandler(menu);
        this.iTable.getFlexCellFormatter().setStyleName(0, 0, "unitime-ClickableTableHeader");
        this.iTable.setWidget(0, 0, (Widget)label);
        HTML totals = new HTML(MESSAGES.colTotal(), false);
        totals.addClickHandler(menu);
        this.iTable.getFlexCellFormatter().setStyleName(0, col2clasf.size() + 1, "unitime-ClickableTableHeader");
        this.iTable.setWidget(0, col2clasf.size() + 1, (Widget)totals);
        if (row == 1) {
            throw new CurriculaException(MESSAGES.errorNoLastLikeEnrollemnts());
        }
        this.iTable.setText(row, 0, MESSAGES.colTotal());
        this.iTable.getCellFormatter().getElement(row, 0).getStyle().setBackgroundColor("#EEEEEE");
        ArrayList<MyCell> cells = new ArrayList<MyCell>();
        for (int c = 0; c < col2clasf.size(); ++c) {
            List list = (List)col2cells.get(c);
            if (list == null || list.isEmpty()) continue;
            cells.addAll(list);
            this.iTable.setWidget(row, 1 + c, (Widget)new MySumCell(list, true));
            this.iTable.getCellFormatter().getElement(row, 1 + c).getStyle().setBackgroundColor("#EEEEEE");
        }
        this.iTable.setWidget(row, 1 + col2clasf.size(), (Widget)new MySumCell(cells, true));
        this.iTable.getCellFormatter().getElement(row, 1 + col2clasf.size()).getStyle().setBackgroundColor("#EEEEEE");
        for (int r = 1; r < this.iTable.getRowCount(); ++r) {
            for (int i = this.iTable.getCellCount(r); i < 1 + col2clasf.size(); ++i) {
                this.iTable.setHTML(r, i, "&nbsp;");
            }
        }
        this.iBottom.setVisible(true);
        this.iTable.setVisible(true);
        if (!this.iHeader.isEnabled("close").booleanValue()) {
            this.iHeader.setEnabled("print", true);
        }
    }

    public void addProjectionRulesHandler(ProjectionRulesHandler h) {
        this.iProjectionRulesHandlers.add(h);
    }

    public static interface ProjectionRulesHandler {
        public void onRulesLoaded(ProjectionRulesEvent var1);

        public void onException(Throwable var1);

        public void onRulesSaved(ProjectionRulesEvent var1);

        public void onRulesClosed(ProjectionRulesEvent var1);
    }

    public static class ProjectionRulesEvent {
    }

    private class MyFlexTable
    extends FlexTable {
        private Timer iTimer = null;

        public MyFlexTable() {
            this.setCellPadding(2);
            this.setCellSpacing(0);
            this.sinkEvents(16);
            this.sinkEvents(32);
            this.sinkEvents(1);
            this.sinkEvents(128);
            this.setStylePrimaryName("unitime-MainTable");
            this.iTimer = new Timer(){

                public void run() {
                    MyFlexTable.this.saveOrder();
                }
            };
        }

        private boolean focus(Event event, int oldRow, int oldCol, int row, int col) {
            if (!this.getRowFormatter().isVisible(row) || col >= this.getCellCount(row)) {
                return false;
            }
            Widget w = this.getWidget(row, col);
            if (w == null || !w.isVisible()) {
                return false;
            }
            if (w instanceof Updatable) {
                ((Updatable)w).focus();
                event.stopPropagation();
                return true;
            }
            return false;
        }

        public MyRow getMyRow(int row) {
            if (row == 0 || row + 1 >= CurriculumProjectionRulesPage.this.iTable.getRowCount()) {
                return null;
            }
            for (int c = 1; c < this.getCellCount(row) - 1; ++c) {
                Widget w = this.getWidget(row, c);
                if (w == null) continue;
                return ((MyCell)w).getRow();
            }
            return null;
        }

        private void moveRow(Element tr, Element before) {
            com.google.gwt.user.client.Element body = DOM.getParent((Element)tr);
            body.removeChild((Node)tr);
            DOM.insertBefore((Element)body, (Element)tr, (Element)before);
        }

        public void saveOrder() {
            CurriculumProjectionRulesPage.this.iHeader.setMessage(MESSAGES.waitSavingOrder());
            String areaOrd = "";
            HashMap<String, String> area2majorOrd = new HashMap<String, String>();
            for (int i = 1; i < this.getRowCount() - 1; ++i) {
                MyRow r = this.getMyRow(i);
                if (r == null) continue;
                if (r.getMajor() == null) {
                    if (!areaOrd.isEmpty()) {
                        areaOrd = areaOrd + "|";
                    }
                    areaOrd = areaOrd + r.getArea().getAbbv();
                    continue;
                }
                String majorOrd = (String)area2majorOrd.get(r.getArea().getAbbv());
                area2majorOrd.put(r.getArea().getAbbv(), (majorOrd == null ? "" : majorOrd + "|") + r.getMajor().getCode());
            }
            UserDataInterface.SetUserDataRpcRequest ord = new UserDataInterface.SetUserDataRpcRequest();
            ord.put("CurProjRules.Order", areaOrd);
            for (Map.Entry e : area2majorOrd.entrySet()) {
                ord.put("CurProjRules.Order[" + (String)e.getKey() + "]", e.getValue());
            }
            RPC.execute(ord, new AsyncCallback<GwtRpcResponseNull>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(GwtRpcResponseNull result) {
                    CurriculumProjectionRulesPage.this.iHeader.clearMessage();
                }
            });
        }

        public void onBrowserEvent(Event event) {
            com.google.gwt.user.client.Element td = this.getEventTargetCell(event);
            if (td == null) {
                return;
            }
            com.google.gwt.user.client.Element tr = DOM.getParent((Element)td);
            int col = DOM.getChildIndex((Element)tr, (Element)td);
            com.google.gwt.user.client.Element body = DOM.getParent((Element)tr);
            int row = DOM.getChildIndex((Element)body, (Element)tr);
            if (row == 0) {
                return;
            }
            MyRow r = this.getMyRow(row);
            switch (DOM.eventGetType((Event)event)) {
                case 16: {
                    this.getRowFormatter().setStyleName(row, "unitime-TableRowHover");
                    if (r != null) {
                        this.getCellFormatter().getElement(row, DOM.getChildCount((Element)tr) - 1).getStyle().clearBackgroundColor();
                    }
                    if (r != null && !r.getChildren().isEmpty()) break;
                    this.getRowFormatter().getElement(row).getStyle().setCursor(Style.Cursor.AUTO);
                    break;
                }
                case 32: {
                    this.getRowFormatter().setStyleName(row, null);
                    if (r == null) break;
                    this.getCellFormatter().getElement(row, DOM.getChildCount((Element)tr) - 1).getStyle().setBackgroundColor("#EEEEEE");
                    break;
                }
                case 1: {
                    int rx;
                    if (r == null || r.getMajor() != null) break;
                    com.google.gwt.user.client.Element element = DOM.eventGetTarget((Event)event);
                    while (element.getPropertyString("tagName").equalsIgnoreCase("div")) {
                        element = DOM.getParent((Element)element);
                    }
                    if (!element.getPropertyString("tagName").equalsIgnoreCase("td") || r.getMajor() != null) break;
                    boolean canCollapse = false;
                    for (rx = row + 1; rx < this.getRowCount() - 1 && (r = this.getMyRow(rx)) != null && r.getMajor() != null; ++rx) {
                        if (r.hasProjection() || !this.getRowFormatter().isVisible(rx)) continue;
                        canCollapse = true;
                        break;
                    }
                    for (rx = row + 1; rx < this.getRowCount() - 1 && (r = this.getMyRow(rx)) != null && r.getMajor() != null; ++rx) {
                        if (r.hasProjection()) continue;
                        this.getRowFormatter().setVisible(rx, !canCollapse);
                    }
                    break;
                }
                case 128: {
                    int i;
                    com.google.gwt.user.client.Element x;
                    MyRow p;
                    Updatable u;
                    int oldRow = row;
                    int oldCol = col;
                    if (event.getKeyCode() == 39 && (event.getAltKey() || event.getMetaKey())) {
                        while (++col < this.getCellCount(row) && !this.focus(event, oldRow, oldCol, row, col)) {
                        }
                        event.preventDefault();
                    }
                    if (event.getKeyCode() == 37 && (event.getAltKey() || event.getMetaKey())) {
                        while (--col >= 0 && !this.focus(event, oldRow, oldCol, row, col)) {
                        }
                        event.preventDefault();
                    }
                    if (event.getKeyCode() == 38 && (event.getAltKey() || event.getMetaKey())) {
                        while (--row > 0 && !this.focus(event, oldRow, oldCol, row, col)) {
                        }
                        event.preventDefault();
                    }
                    if (event.getKeyCode() == 40 && (event.getAltKey() || event.getMetaKey())) {
                        while (++row < this.getRowCount() && !this.focus(event, oldRow, oldCol, row, col)) {
                        }
                        event.preventDefault();
                    }
                    if (event.getKeyCode() == 38 && event.getCtrlKey()) {
                        if (r != null) {
                            u = (Updatable)this.getWidget(row, col);
                            if (r.getMajor() != null) {
                                p = this.getMyRow(row - 1);
                                if (p.getMajor() != null) {
                                    this.moveRow((Element)tr, (Element)DOM.getChild((Element)body, (int)(row - 1)));
                                }
                            } else {
                                p = this.getMyRow(row - 1);
                                if (p != null && p.getParent() != null) {
                                    p = p.getParent();
                                }
                                if (p != null && p.getMajor() == null) {
                                    x = DOM.getChild((Element)body, (int)(row - 1 - p.getChildren().size()));
                                    for (i = 0; i <= r.getChildren().size(); ++i) {
                                        this.moveRow((Element)DOM.getChild((Element)body, (int)(row + i)), (Element)x);
                                    }
                                }
                            }
                            this.iTimer.schedule(5000);
                            u.focus();
                        }
                        event.stopPropagation();
                        event.preventDefault();
                    }
                    if (event.getKeyCode() != 40 || !event.getCtrlKey()) break;
                    if (r != null) {
                        u = (Updatable)this.getWidget(row, col);
                        if (r.getMajor() != null) {
                            p = this.getMyRow(row + 1);
                            if (p.getMajor() != null) {
                                this.moveRow((Element)tr, (Element)DOM.getChild((Element)body, (int)(row + 2)));
                            }
                        } else {
                            p = this.getMyRow(1 + row + r.getChildren().size());
                            if (p != null && p.getMajor() == null) {
                                x = DOM.getChild((Element)body, (int)(row + 2 + r.getChildren().size() + p.getChildren().size()));
                                for (i = 0; i <= r.getChildren().size(); ++i) {
                                    this.moveRow((Element)DOM.getChild((Element)body, (int)row), (Element)x);
                                }
                            }
                        }
                        this.iTimer.schedule(5000);
                        u.focus();
                    }
                    event.stopPropagation();
                    event.preventDefault();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyRow {
        private CurriculumInterface.AcademicAreaInterface iArea;
        private CurriculumInterface.MajorInterface iMajor;
        private HashMap<CurriculumInterface.AcademicClassificationInterface, Number[]> iData;
        private MyRow iParent = null;
        private List<MyRow> iChildren = new ArrayList<MyRow>();
        private HashMap<CurriculumInterface.AcademicClassificationInterface, MyCell> iCells = new HashMap();

        public MyRow(CurriculumInterface.AcademicAreaInterface area, CurriculumInterface.MajorInterface major, HashMap<CurriculumInterface.AcademicClassificationInterface, Number[]> data) {
            this.iArea = area;
            this.iMajor = major;
            this.iData = data;
        }

        public CurriculumInterface.AcademicAreaInterface getArea() {
            return this.iArea;
        }

        public CurriculumInterface.MajorInterface getMajor() {
            return this.iMajor;
        }

        public TreeSet<CurriculumInterface.AcademicClassificationInterface> getClassifications() {
            return new TreeSet<CurriculumInterface.AcademicClassificationInterface>(this.iData.keySet());
        }

        public float getProjection(CurriculumInterface.AcademicClassificationInterface clasf) {
            Number proj = this.iData.get(clasf)[0];
            if (proj == null && this.iParent != null) {
                proj = this.iParent.iData.get(clasf)[0];
            }
            return proj == null ? 1.0f : proj.floatValue();
        }

        public boolean isDefaultProjection(CurriculumInterface.AcademicClassificationInterface clasf) {
            return this.iData.get(clasf)[0] == null || this.iMajor == null && this.iData.get(clasf)[0].floatValue() == 1.0f;
        }

        public void setProjection(CurriculumInterface.AcademicClassificationInterface clasf, Float projection) {
            this.iData.get((Object)clasf)[0] = projection;
        }

        public int getLastLike(CurriculumInterface.AcademicClassificationInterface clasf) {
            return this.iData.get(clasf)[1].intValue();
        }

        public boolean hasLastLike() {
            for (Number[] n : this.iData.values()) {
                if (n[1].intValue() <= 0) continue;
                return true;
            }
            return false;
        }

        public boolean hasProjection() {
            for (Number[] n : this.iData.values()) {
                if (n[1].intValue() <= 0 || n[0] == null) continue;
                return true;
            }
            return false;
        }

        public void setParent(MyRow row) {
            this.iParent = row;
        }

        public MyRow getParent() {
            return this.iParent;
        }

        public void addChild(MyRow row) {
            if (this.iChildren == null) {
                this.iChildren = new ArrayList<MyRow>();
            }
            this.iChildren.add(row);
        }

        public List<MyRow> getChildren() {
            return this.iChildren;
        }

        public void setCell(CurriculumInterface.AcademicClassificationInterface clasf, MyCell cell) {
            this.iCells.put(clasf, cell);
        }

        public MyCell getCell(CurriculumInterface.AcademicClassificationInterface clasf) {
            return this.iCells.get(clasf);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MySumCell
    extends Composite
    implements Updatable {
        private List<MyCell> iCells;
        private boolean iVertical;
        private UniTimeTextBox iTextBox;
        private HTML iFrontLabel;
        private HTML iRearLabel;
        private HorizontalPanel iPanel;
        private boolean iCellEditable = true;

        public MySumCell(List<MyCell> cells, boolean vertical) {
            this.iCells = cells;
            for (MyCell cell : this.iCells) {
                cell.addSum(this);
            }
            this.iVertical = vertical;
            this.iPanel = new HorizontalPanel();
            this.iTextBox = new UniTimeTextBox(6, ValueBoxBase.TextAlignment.RIGHT);
            this.iTextBox.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    HashSet<MySumCell> sums = new HashSet<MySumCell>();
                    sums.add(MySumCell.this);
                    Float projection = null;
                    try {
                        if (!MySumCell.this.iTextBox.getText().isEmpty()) {
                            if (MySumCell.this.iTextBox.getText().endsWith("%")) {
                                projection = Float.valueOf((float)NF.parse(MySumCell.this.iTextBox.getText().substring(0, MySumCell.this.iTextBox.getText().length() - 1)) / 100.0f);
                            } else {
                                int lastLike = 0;
                                for (MyCell cell : MySumCell.this.iCells) {
                                    if (MySumCell.this.iVertical && cell.getRow().getParent() == null) continue;
                                    lastLike += cell.getRow().getLastLike(cell.getClassification());
                                }
                                projection = Float.valueOf((float)NF.parse(MySumCell.this.iTextBox.getText()) / (float)lastLike);
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    for (MyCell cell : MySumCell.this.iCells) {
                        if (MySumCell.this.iVertical && cell.getRow().getParent() != null) {
                            cell.getRow().setProjection(cell.getClassification(), null);
                        } else {
                            cell.getRow().setProjection(cell.getClassification(), projection);
                        }
                        cell.update();
                        sums.addAll(cell.getSums());
                    }
                    if (!MySumCell.this.iVertical) {
                        for (MyCell cell : MySumCell.this.iCells) {
                            for (MyRow r : cell.getRow().getChildren()) {
                                MyCell c;
                                if (((Number[])r.iData.get(cell.getClassification()))[0] != null || (c = r.getCell(cell.getClassification())) == null) continue;
                                c.update();
                                sums.addAll(c.getSums());
                            }
                        }
                    }
                    for (MySumCell sum : sums) {
                        sum.update();
                    }
                }
            });
            int lastLike = 0;
            for (MyCell cell : this.iCells) {
                if (this.iVertical && cell.getRow().getParent() == null) continue;
                lastLike += cell.getRow().getLastLike(cell.getClassification());
            }
            this.iFrontLabel = new HTML(MESSAGES.curriculumProjectionRulesOldValue(lastLike), false);
            this.iFrontLabel.setWidth("55px");
            this.iFrontLabel.setStyleName("unitime-Label");
            this.iFrontLabel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
            this.iRearLabel = new HTML(MESSAGES.curriculumProjectionRulesOfTotal(lastLike), false);
            this.iRearLabel.setWidth("55px");
            this.iRearLabel.setStyleName("unitime-Label");
            this.iRearLabel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
            this.iPanel.add((Widget)this.iFrontLabel);
            this.iPanel.setCellVerticalAlignment((Widget)this.iFrontLabel, HasVerticalAlignment.ALIGN_MIDDLE);
            this.iPanel.add((Widget)this.iTextBox);
            this.iPanel.setCellVerticalAlignment((Widget)this.iTextBox, HasVerticalAlignment.ALIGN_MIDDLE);
            this.iPanel.add((Widget)this.iRearLabel);
            this.iPanel.setCellVerticalAlignment((Widget)this.iFrontLabel, HasVerticalAlignment.ALIGN_MIDDLE);
            this.initWidget((Widget)this.iPanel);
            this.update();
        }

        @Override
        public void focus() {
            this.iTextBox.focus();
        }

        @Override
        public void update() {
            int lastLike = 0;
            float projected = 0.0f;
            boolean allDefault = true;
            for (MyCell cell : this.iCells) {
                if (allDefault && !cell.getRow().isDefaultProjection(cell.getClassification())) {
                    allDefault = false;
                }
                if (this.iVertical && cell.getRow().getParent() == null) continue;
                lastLike += cell.getRow().getLastLike(cell.getClassification());
                projected += cell.getRow().getProjection(cell.getClassification()) * (float)cell.getRow().getLastLike(cell.getClassification());
            }
            float projection = projected / (float)lastLike;
            if (CurriculumCookie.getInstance().getCurriculumProjectionRulesPercent()) {
                this.iTextBox.setText(NF.format(100.0 * (double)projection) + "%");
            } else {
                this.iTextBox.setText(String.valueOf(Math.round(projection * (float)lastLike)));
            }
            if (allDefault) {
                this.iTextBox.addStyleName("unitime-GrayText");
            } else {
                this.iTextBox.removeStyleName("unitime-GrayText");
            }
            this.setVisible(lastLike > 0);
            if (this.iCellEditable != CurriculumProjectionRulesPage.this.iEditable) {
                this.iCellEditable = CurriculumProjectionRulesPage.this.iEditable;
                this.iTextBox.setReadOnly(!this.iCellEditable);
                if (this.iCellEditable) {
                    this.iTextBox.getElement().getStyle().clearBorderColor();
                    this.iTextBox.getElement().getStyle().clearBackgroundColor();
                } else {
                    this.iTextBox.getElement().getStyle().setBorderColor("transparent");
                    this.iTextBox.getElement().getStyle().setBackgroundColor("transparent");
                }
            }
            this.iFrontLabel.setVisible(CurriculumCookie.getInstance().getCurriculumProjectionRulesShowLastLike() && !CurriculumCookie.getInstance().getCurriculumProjectionRulesPercent());
            this.iRearLabel.setVisible(CurriculumCookie.getInstance().getCurriculumProjectionRulesShowLastLike() && CurriculumCookie.getInstance().getCurriculumProjectionRulesPercent());
            if (projection == 1.0f) {
                this.iFrontLabel.setHTML("&nbsp;");
            } else {
                this.iFrontLabel.setHTML(MESSAGES.curriculumProjectionRulesOldValue(lastLike));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyCell
    extends Composite
    implements Updatable {
        private MyRow iRow;
        private CurriculumInterface.AcademicClassificationInterface iClasf;
        private UniTimeTextBox iTextBox;
        private HTML iFrontLabel;
        private HTML iRearLabel;
        private HorizontalPanel iPanel;
        private HTML iHint = null;
        private PopupPanel iHintPanel = null;
        private boolean iCellEditable = true;
        private List<MySumCell> iSums = new ArrayList<MySumCell>();

        public MyCell(MyRow row, CurriculumInterface.AcademicClassificationInterface clasf) {
            this.iRow = row;
            this.iClasf = clasf;
            this.iRow.setCell(this.iClasf, this);
            this.iPanel = new HorizontalPanel();
            this.iTextBox = new UniTimeTextBox(6, ValueBoxBase.TextAlignment.RIGHT);
            this.iTextBox.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    try {
                        if (MyCell.this.iTextBox.getText().isEmpty()) {
                            MyCell.this.iRow.setProjection(MyCell.this.iClasf, null);
                        } else if (MyCell.this.iTextBox.getText().endsWith("%")) {
                            MyCell.this.iRow.setProjection(MyCell.this.iClasf, Float.valueOf((float)NF.parse(MyCell.this.iTextBox.getText().substring(0, MyCell.this.iTextBox.getText().length() - 1)) / 100.0f));
                        } else {
                            MyCell.this.iRow.setProjection(MyCell.this.iClasf, Float.valueOf((float)NF.parse(MyCell.this.iTextBox.getText()) / (float)MyCell.this.iRow.getLastLike(MyCell.this.iClasf)));
                        }
                    }
                    catch (Exception e) {
                        MyCell.this.iRow.setProjection(MyCell.this.iClasf, null);
                    }
                    if (MyCell.this.iRow.getParent() != null && MyCell.this.iRow.getProjection(MyCell.this.iClasf) == MyCell.this.iRow.getParent().getProjection(MyCell.this.iClasf)) {
                        MyCell.this.iRow.setProjection(MyCell.this.iClasf, null);
                    }
                    MyCell.this.update();
                    for (MySumCell sum : MyCell.this.iSums) {
                        sum.update();
                    }
                    for (MyRow r : MyCell.this.iRow.getChildren()) {
                        MyCell c;
                        if (((Number[])r.iData.get(MyCell.this.iClasf))[0] != null || (c = r.getCell(MyCell.this.iClasf)) == null) continue;
                        c.update();
                        for (MySumCell sum : c.iSums) {
                            sum.update();
                        }
                    }
                }
            });
            this.iFrontLabel = new HTML(MESSAGES.curriculumProjectionRulesOldValue(this.iRow.getLastLike(this.iClasf)), false);
            this.iFrontLabel.setWidth("55px");
            this.iFrontLabel.setStyleName("unitime-Label");
            this.iFrontLabel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
            this.iRearLabel = new HTML(MESSAGES.curriculumProjectionRulesOfTotal(this.iRow.getLastLike(this.iClasf)), false);
            this.iRearLabel.setWidth("55px");
            this.iRearLabel.setStyleName("unitime-Label");
            this.iRearLabel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
            this.iPanel.add((Widget)this.iFrontLabel);
            this.iPanel.setCellVerticalAlignment((Widget)this.iFrontLabel, HasVerticalAlignment.ALIGN_MIDDLE);
            this.iPanel.add((Widget)this.iTextBox);
            this.iPanel.setCellVerticalAlignment((Widget)this.iTextBox, HasVerticalAlignment.ALIGN_MIDDLE);
            this.iPanel.add((Widget)this.iRearLabel);
            this.iPanel.setCellVerticalAlignment((Widget)this.iRearLabel, HasVerticalAlignment.ALIGN_MIDDLE);
            this.initWidget((Widget)this.iPanel);
            this.update();
            this.iHint = new HTML(MESSAGES.propAcademicArea() + " " + this.iRow.getArea().getAbbv() + " - " + this.iRow.getArea().getName() + "<br>" + (this.iRow.getMajor() == null ? "" : MESSAGES.propMajor() + " " + this.iRow.getMajor().getCode() + " - " + this.iRow.getMajor().getName() + "<br>") + MESSAGES.propAcademicClassification() + " " + this.iClasf.getCode() + " - " + this.iClasf.getName(), false);
            this.iHintPanel = new PopupPanel();
            this.iHintPanel.setWidget((Widget)this.iHint);
            this.iHintPanel.setStyleName("unitime-PopupHint");
            this.sinkEvents(16);
            this.sinkEvents(32);
            this.sinkEvents(64);
        }

        public void addSum(MySumCell sum) {
            this.iSums.add(sum);
        }

        public List<MySumCell> getSums() {
            return this.iSums;
        }

        @Override
        public void focus() {
            this.iTextBox.focus();
        }

        public void onBrowserEvent(Event event) {
            com.google.gwt.user.client.Element tr = this.getElement();
            while (tr != null && !tr.getPropertyString("tagName").equalsIgnoreCase("tr")) {
                tr = DOM.getParent((Element)tr);
            }
            com.google.gwt.user.client.Element e = tr;
            switch (DOM.eventGetType((Event)event)) {
                case 16: {
                    if (this.iHintPanel.isShowing()) break;
                    this.iHintPanel.setPopupPositionAndShow(new PopupPanel.PositionCallback((Element)e, event){
                        final /* synthetic */ Element val$e;
                        final /* synthetic */ Event val$event;
                        {
                            this.val$e = element;
                            this.val$event = event;
                        }

                        public void setPosition(int offsetWidth, int offsetHeight) {
                            boolean top = this.val$e.getAbsoluteBottom() - Window.getScrollTop() + 15 + offsetHeight > Window.getClientHeight();
                            MyCell.this.iHintPanel.setPopupPosition(Math.max(Math.min(this.val$event.getClientX(), this.val$e.getAbsoluteRight() - offsetWidth - 15), this.val$e.getAbsoluteLeft() + 15), top ? this.val$e.getAbsoluteTop() - offsetHeight - 15 : this.val$e.getAbsoluteBottom() + 15);
                        }
                    });
                    break;
                }
                case 32: {
                    if (!this.iHintPanel.isShowing()) break;
                    this.iHintPanel.hide();
                    break;
                }
                case 64: {
                    if (!this.iHintPanel.isShowing()) break;
                    boolean top = e.getAbsoluteBottom() - Window.getScrollTop() + 15 + this.iHintPanel.getOffsetHeight() > Window.getClientHeight();
                    this.iHintPanel.setPopupPosition(Math.max(Math.min(event.getClientX(), e.getAbsoluteRight() - this.iHintPanel.getOffsetWidth() - 15), e.getAbsoluteLeft() + 15), top ? e.getAbsoluteTop() - this.iHintPanel.getOffsetHeight() - 15 : e.getAbsoluteBottom() + 15);
                }
            }
        }

        @Override
        public void update() {
            float projection = this.iRow.getProjection(this.iClasf);
            int lastLike = this.iRow.getLastLike(this.iClasf);
            if (CurriculumCookie.getInstance().getCurriculumProjectionRulesPercent()) {
                this.iTextBox.setText(NF.format(100.0 * (double)projection) + "%");
            } else {
                this.iTextBox.setText(String.valueOf(Math.round(projection * (float)lastLike)));
            }
            if (this.iRow.isDefaultProjection(this.iClasf)) {
                this.iTextBox.addStyleName("unitime-GrayText");
            } else {
                this.iTextBox.removeStyleName("unitime-GrayText");
            }
            this.setVisible(lastLike > 0);
            if (this.iCellEditable != CurriculumProjectionRulesPage.this.iEditable) {
                this.iCellEditable = CurriculumProjectionRulesPage.this.iEditable;
                this.iTextBox.setReadOnly(!this.iCellEditable);
                if (this.iCellEditable) {
                    this.iTextBox.getElement().getStyle().clearBorderColor();
                    this.iTextBox.getElement().getStyle().clearBackgroundColor();
                } else {
                    this.iTextBox.getElement().getStyle().setBorderColor("transparent");
                    this.iTextBox.getElement().getStyle().setBackgroundColor("transparent");
                }
            }
            this.iFrontLabel.setVisible(CurriculumCookie.getInstance().getCurriculumProjectionRulesShowLastLike() && !CurriculumCookie.getInstance().getCurriculumProjectionRulesPercent());
            this.iRearLabel.setVisible(CurriculumCookie.getInstance().getCurriculumProjectionRulesShowLastLike() && CurriculumCookie.getInstance().getCurriculumProjectionRulesPercent());
            if (projection == 1.0f) {
                this.iFrontLabel.setHTML("&nbsp;");
            } else {
                this.iFrontLabel.setHTML(MESSAGES.curriculumProjectionRulesOldValue(this.iRow.getLastLike(this.iClasf)));
            }
        }

        public MyRow getRow() {
            return this.iRow;
        }

        public CurriculumInterface.AcademicClassificationInterface getClassification() {
            return this.iClasf;
        }
    }

    private static interface Updatable {
        public void update();

        public void focus();
    }
}

