/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.curricula;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.curricula.CourseCurriculaTable;
import org.unitime.timetable.gwt.client.curricula.CurriculumCookie;
import org.unitime.timetable.gwt.client.widgets.CourseFinder;
import org.unitime.timetable.gwt.client.widgets.DataProvider;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.CurriculumInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CourseFinderCurricula
extends CourseCurriculaTable
implements CourseFinder.CourseFinderCourseDetails<ClassAssignmentInterface.CourseAssignment, TreeSet<CurriculumInterface>> {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final StudentSectioningMessages SCT_MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    private ClassAssignmentInterface.CourseAssignment iValue = null;
    private DataProvider<ClassAssignmentInterface.CourseAssignment, TreeSet<CurriculumInterface>> iDataProvider;

    public CourseFinderCurricula() {
        super(false, false);
        this.setMessage(SCT_MESSAGES.courseSelectionNoCourseSelected());
    }

    public void setValue(final ClassAssignmentInterface.CourseAssignment value) {
        if (value == null) {
            this.iValue = value;
            this.clear(false);
            this.setMessage(SCT_MESSAGES.courseSelectionNoCourseSelected());
        } else {
            this.iValue = value;
            this.clear(true);
            this.ensureInitialized(new AsyncCallback<Boolean>(){

                public void onSuccess(Boolean result) {
                    CourseFinderCurricula.this.iDataProvider.getData(value, new AsyncCallback<TreeSet<CurriculumInterface>>(){

                        public void onFailure(Throwable caught) {
                            CourseFinderCurricula.this.setMessage(MESSAGES.failedToLoadCurricula(caught.getMessage()));
                            CurriculumCookie.getInstance().setCurriculaCoursesDetails(false);
                        }

                        public void onSuccess(TreeSet<CurriculumInterface> result) {
                            if (result.isEmpty()) {
                                CourseFinderCurricula.this.setMessage(MESSAGES.offeringHasNoCurricula());
                            } else {
                                CourseFinderCurricula.this.populate(result);
                            }
                        }
                    });
                }

                public void onFailure(Throwable caught) {
                }
            });
        }
    }

    public ClassAssignmentInterface.CourseAssignment getValue() {
        return this.iValue;
    }

    @Override
    public void setDataProvider(DataProvider<ClassAssignmentInterface.CourseAssignment, TreeSet<CurriculumInterface>> provider) {
        this.iDataProvider = provider;
    }

    @Override
    public String getName() {
        return MESSAGES.tabCurricula();
    }

    @Override
    public void onSetValue(CourseRequestInterface.RequestedCourse course) {
    }

    @Override
    public void onGetValue(CourseRequestInterface.RequestedCourse course) {
    }

    public boolean isEnabled() {
        return true;
    }

    public void setEnabled(boolean enabled) {
    }
}

