/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.upload.FormFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataImportForm
extends ActionForm {
    private static final long serialVersionUID = 7165669008085313647L;
    private transient FormFile iFile;
    private String iOp;
    private String iExport;
    private boolean iEmail = false;
    private String iAddress = null;

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if ("Import".equals(this.iOp) && (this.iFile == null || this.iFile.getFileSize() <= 0)) {
            errors.add("name", new ActionMessage("errors.required", (Object)"File"));
        }
        if ("Export".equals(this.iOp) && this.getExportType() == null) {
            errors.add("export", new ActionMessage("errors.generic", (Object)"Nothing to export"));
        }
        return errors;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.iFile = null;
        this.iExport = null;
        this.iEmail = false;
        this.iAddress = null;
    }

    public FormFile getFile() {
        return this.iFile;
    }

    public void setFile(FormFile file) {
        this.iFile = file;
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public String getExport() {
        return this.iExport;
    }

    public void setExport(String export) {
        this.iExport = export;
    }

    public boolean getEmail() {
        return this.iEmail;
    }

    public void setEmail(boolean email) {
        this.iEmail = email;
    }

    public String getAddress() {
        return this.iAddress;
    }

    public void setAddress(String address) {
        this.iAddress = address;
    }

    public Object clone() {
        DataImportForm form = new DataImportForm();
        form.iFile = this.iFile;
        form.iOp = this.iOp;
        form.iExport = this.iExport;
        form.iEmail = this.iEmail;
        form.iAddress = this.iAddress;
        return form;
    }

    public List<ListItem> getExportTypes() {
        ArrayList<ListItem> items = new ArrayList<ListItem>();
        for (ExportType t : ExportType.values()) {
            items.add(new ListItem(t.name(), t.getLabel()));
        }
        return items;
    }

    public ExportType getExportType() {
        if (this.getExport() == null || this.getExport().isEmpty()) {
            return null;
        }
        return ExportType.valueOf(this.getExport());
    }

    public static class ListItem {
        String iValue;
        String iText;

        public ListItem(String value, String text) {
            this.iValue = value;
            this.iText = text;
        }

        public String getValue() {
            return this.iValue;
        }

        public String getLabel() {
            return this.iText;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExportType {
        COURSES("offerings", "Course Offerings", "tmtbl.export.timetable", "false", "tmtbl.export.exam.type", "none"),
        COURSES_WITH_TIME("offerings", "Course Offerings (including course timetable)", "tmtbl.export.timetable", "true", "tmtbl.export.exam.type", "none"),
        COURSES_WITH_EXAMS("offerings", "Course Offerings (including exams)", "tmtbl.export.timetable", "false", "tmtbl.export.exam.type", "all"),
        COURSES_ALL("offerings", "Course Offerings (including course timetable and exams)", "tmtbl.export.timetable", "true", "tmtbl.export.exam.type", "all"),
        TIMETABLE("timetable", "Course Timetable", new String[0]),
        EXAMS("exams", "Examinations", "tmtbl.export.exam", "true", "tmtbl.export.exam.type", "all"),
        EXAMS_FINAL("exams", "Examinations (only finals)", "tmtbl.export.exam", "true", "tmtbl.export.exam.type", "final"),
        EXAMS_MIDTERM("exams", "Examinations (only midterm)", "tmtbl.export.exam", "true", "tmtbl.export.exam.type", "midterm"),
        CURRICULA("curricula", "Curricula", new String[0]),
        STUDENTS("students", "Students", new String[0]),
        STUDENT_ENRL("studentEnrollments", "Student class enrollments", new String[0]),
        REQUESTS("request", "Student course requests", new String[0]),
        RESERVATIONS("reservations", "Reservations", new String[0]),
        SESSION("session", "Academic Session", new String[0]),
        PERMISSIONS("permissions", "Permissions", new String[0]),
        TRAVELTIMES("traveltimes", "Travel Times", new String[0]),
        ROOM_SHARING("roomSharing", "Room Sharing", new String[0]),
        POINT_IN_TIME_DATA("pointInTimeData", "Point-In-Time Data", new String[0]),
        PREFERENCES("preferences", "Course Timetabling Preferences", new String[0]),
        SESSION_SETUP("sessionSetup", "Academic Session Setup", new String[0]),
        STUDENT_ADVISORS("studentAdvisors", "Student Advisors", new String[0]),
        STUDENT_STATUSES("studentStatuses", "Student Scheduling Statuses", new String[0]);

        private String iType;
        private String iLabel;
        private String[] iOptions;

        private ExportType(String type, String label, String ... options) {
            this.iType = type;
            this.iLabel = label;
            this.iOptions = options;
        }

        public String getType() {
            return this.iType;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setOptions(Properties config) {
            for (int i = 0; i < this.iOptions.length; i += 2) {
                config.put(this.iOptions[i], this.iOptions[i + 1]);
            }
        }
    }
}

