/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.events;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.events.EventLookupBackend;
import org.unitime.timetable.events.ResourceLookupBackend;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.gwt.client.events.EventComparator;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.rights.Right;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EventsExporter
implements Exporter {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static final GwtConstants CONSTANTS = Localization.create(GwtConstants.class);

    @Override
    public void export(ExportHelper helper) throws IOException {
        int eventCookieFlags;
        EventInterface.ResourceInterface resource;
        String name;
        String type;
        String ext;
        Long sessionId = helper.getAcademicSessionId();
        if (sessionId == null) {
            throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
        }
        Session session = (Session)SessionDAO.getInstance().get(sessionId);
        if (session == null) {
            throw new IllegalArgumentException("Given academic session no longer exists.");
        }
        EventInterface.EventLookupRpcRequest request = new EventInterface.EventLookupRpcRequest();
        request.setSessionId(sessionId);
        String id = helper.getParameter("id");
        if (id != null) {
            request.setResourceId(Long.valueOf(id));
        }
        if ((ext = helper.getParameter("ext")) != null) {
            request.setResourceExternalId(ext);
        }
        if ((type = helper.getParameter("type")) == null) {
            throw new IllegalArgumentException("Resource type not provided, please set the type parameter.");
        }
        request.setResourceType(EventInterface.ResourceType.valueOf(type.toUpperCase()));
        EventInterface.EventFilterRpcRequest eventFilter = new EventInterface.EventFilterRpcRequest();
        eventFilter.setSessionId(sessionId);
        request.setEventFilter(eventFilter);
        EventInterface.RoomFilterRpcRequest roomFilter = new EventInterface.RoomFilterRpcRequest();
        roomFilter.setSessionId(sessionId);
        Enumeration<String> e = helper.getParameterNames();
        while (e.hasMoreElements()) {
            String command = e.nextElement();
            if (command.equals("e:text")) {
                eventFilter.setText(helper.getParameter("e:text"));
                continue;
            }
            if (command.startsWith("e:")) {
                for (String value : helper.getParameterValues(command)) {
                    eventFilter.addOption(command.substring(2), value);
                }
                continue;
            }
            if (command.equals("r:text")) {
                roomFilter.setText(helper.getParameter("r:text"));
                continue;
            }
            if (!command.startsWith("r:")) continue;
            for (String value : helper.getParameterValues(command)) {
                roomFilter.addOption(command.substring(2), value);
            }
        }
        request.setRoomFilter(roomFilter);
        EventAction.EventContext context = new EventAction.EventContext(helper.getSessionContext(), helper.getSessionContext().getUser(), sessionId);
        context.checkPermission(Right.Events);
        if (request.getResourceType() == EventInterface.ResourceType.PERSON && !context.getUser().getExternalUserId().equals(request.getResourceExternalId())) {
            context.checkPermission(Right.EventLookupSchedule);
            Set<String> roles = request.getEventFilter().getOptions("role");
            if (roles == null) {
                roles = new HashSet<String>();
                if (context.hasPermission(Right.CanLookupStudents)) {
                    roles.add("Student");
                }
                if (context.hasPermission(Right.CanLookupInstructors)) {
                    roles.add("Instructor");
                    roles.add("Coordinator");
                }
                if (context.hasPermission(Right.CanLookupEventContacts)) {
                    roles.add("Contact");
                }
                if (roles.size() < 4) {
                    request.getEventFilter().setOptions("role", roles);
                }
            } else {
                if (!context.hasPermission(Right.CanLookupStudents)) {
                    roles.remove("Student");
                    roles.remove("student");
                }
                if (!context.hasPermission(Right.CanLookupInstructors)) {
                    roles.remove("Instructor");
                    roles.remove("instructor");
                    roles.remove("Coordinator");
                    roles.remove("coordinator");
                }
                if (!context.hasPermission(Right.CanLookupStudents)) {
                    roles.remove("Contact");
                    roles.remove("contact");
                }
            }
        }
        if (request.getResourceType() != EventInterface.ResourceType.ROOM && request.getResourceType() != EventInterface.ResourceType.PERSON && request.getResourceId() == null && (name = helper.getParameter("name")) != null && (resource = new ResourceLookupBackend().findResource(request.getSessionId(), request.getResourceType(), name)) != null) {
            request.setResourceId(resource.getId());
        }
        GwtRpcResponseList<EventInterface> events = new EventLookupBackend().findEvents(request, context);
        String sortBy = helper.getParameter("sort");
        EventComparator.EventMeetingSortBy sort = null;
        boolean asc = true;
        if (sortBy == null || sortBy.isEmpty()) {
            sort = null;
            asc = true;
        } else if (sortBy.startsWith("+")) {
            asc = true;
            sort = EventComparator.EventMeetingSortBy.values()[Integer.parseInt(sortBy.substring(1))];
        } else if (sortBy.startsWith("-")) {
            asc = false;
            sort = EventComparator.EventMeetingSortBy.values()[Integer.parseInt(sortBy.substring(1))];
        } else {
            asc = true;
            sort = sortBy == null ? null : EventComparator.EventMeetingSortBy.values()[Integer.parseInt(sortBy)];
        }
        int n = eventCookieFlags = helper.getParameter("flags") == null ? EventInterface.sDefaultEventFlags : Integer.parseInt(helper.getParameter("flags"));
        if (!context.hasPermission(Right.EventLookupContact)) {
            eventCookieFlags = EventInterface.EventFlag.SHOW_MAIN_CONTACT.clear(eventCookieFlags);
            eventCookieFlags = EventInterface.EventFlag.SHOW_LAST_CHANGE.clear(eventCookieFlags);
        }
        if (!context.hasPermission(Right.EventCanViewMeetingContacts)) {
            eventCookieFlags = EventInterface.EventFlag.SHOW_MEETING_CONTACTS.clear(eventCookieFlags);
        }
        eventCookieFlags = EventInterface.EventFlag.SHOW_SECTION.set(eventCookieFlags);
        if (!"1".equals(helper.getParameter("ua"))) {
            Iterator i = events.iterator();
            while (i.hasNext()) {
                EventInterface event = (EventInterface)i.next();
                if (event.getType() != EventInterface.EventType.Unavailabile) continue;
                i.remove();
            }
        }
        this.print(helper, request, events, eventCookieFlags, sort, asc);
    }

    protected abstract void print(ExportHelper var1, EventInterface.EventLookupRpcRequest var2, List<EventInterface> var3, int var4, EventComparator.EventMeetingSortBy var5, boolean var6) throws IOException;

    protected void hideColumns(Exporter.Printer out, List<EventInterface> events, int eventCookieFlags) {
        for (EventInterface.EventFlag flag : EventInterface.EventFlag.values()) {
            if (flag.in(eventCookieFlags)) continue;
            this.hideColumn(out, events, flag);
        }
        boolean hasSection = false;
        for (EventInterface event : events) {
            if (this.getSection(event) == null) continue;
            hasSection = true;
            break;
        }
        if (!hasSection) {
            this.hideColumn(out, events, EventInterface.EventFlag.SHOW_SECTION);
        }
    }

    protected void hideColumn(Exporter.Printer out, List<EventInterface> events, EventInterface.EventFlag flag) {
    }

    protected void sort(List<EventInterface> events, final EventComparator.EventMeetingSortBy sort, boolean asc) {
        if (sort != null) {
            Collections.sort(events, new ReverseComparator<EventInterface>(new Comparator<EventInterface>(){

                @Override
                public int compare(EventInterface e1, EventInterface e2) {
                    int cmp = EventComparator.compareEvents(e1, e2, sort);
                    if (cmp != 0) {
                        return cmp;
                    }
                    Iterator<EventInterface.MeetingInterface> i1 = e1.getMeetings().iterator();
                    Iterator<EventInterface.MeetingInterface> i2 = e2.getMeetings().iterator();
                    while (i1.hasNext() && i2.hasNext()) {
                        cmp = EventComparator.compareMeetings(i1.next(), i2.next(), sort);
                        if (cmp == 0) continue;
                        return cmp;
                    }
                    cmp = EventComparator.compareFallback(e1, e2);
                    if (cmp != 0) {
                        return cmp;
                    }
                    i1 = e1.getMeetings().iterator();
                    i2 = e2.getMeetings().iterator();
                    while (i1.hasNext() && i2.hasNext()) {
                        cmp = EventComparator.compareFallback(i1.next(), i2.next());
                        if (cmp == 0) continue;
                        return cmp;
                    }
                    if (i1.hasNext() && !i2.hasNext()) {
                        return 1;
                    }
                    if (!i1.hasNext() && i2.hasNext()) {
                        return -1;
                    }
                    return e1.compareTo(e2);
                }
            }, !asc));
        } else {
            Collections.sort(events);
        }
    }

    protected Set<EventMeeting> meetings(List<EventInterface> events, final EventComparator.EventMeetingSortBy sort, boolean asc) {
        TreeSet<EventMeeting> meetings = new TreeSet<EventMeeting>(new ReverseComparator<EventMeeting>(new Comparator<EventMeeting>(){

            @Override
            public int compare(EventMeeting m1, EventMeeting m2) {
                if (sort != null) {
                    int cmp = EventComparator.compareEvents(m1.getEvent(), m2.getEvent(), sort);
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = EventComparator.compareMeetings(m1.getMeeting(), m2.getMeeting(), sort);
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = EventComparator.compareFallback(m1.getEvent(), m2.getEvent());
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = EventComparator.compareFallback(m1.getMeeting(), m2.getMeeting());
                    if (cmp != 0) {
                        return cmp;
                    }
                }
                return m1.compareTo(m2);
            }
        }, !asc));
        for (EventInterface event : events) {
            for (EventInterface.MeetingInterface meeting : event.getMeetings()) {
                meetings.add(new EventMeeting(event, meeting));
            }
        }
        return meetings;
    }

    public String getName(EventInterface event) {
        if (event.hasCourseNames()) {
            String name = "";
            if (event.getType() == EventInterface.EventType.Course) {
                name = event.getName();
            }
            for (String cn : event.getCourseNames()) {
                if (name.isEmpty()) {
                    name = name + cn;
                    continue;
                }
                if (event.getInstruction() != null || event.getType() == EventInterface.EventType.Course) {
                    name = name + "\n  " + cn;
                    continue;
                }
                name = name + "\n" + cn;
            }
            return name;
        }
        return event.getName();
    }

    public String getTitle(EventInterface event) {
        if (event.hasCourseTitles()) {
            String title = "";
            String last = null;
            for (String ct : event.getCourseTitles()) {
                if (last != null && !last.isEmpty() && last.equals(ct)) {
                    ct = "";
                } else {
                    last = ct;
                }
                if (title.isEmpty()) {
                    title = title + ct;
                    continue;
                }
                if (event.getInstruction() != null || event.getType() == EventInterface.EventType.Course) {
                    title = title + "\n  " + ct;
                    continue;
                }
                title = title + "\n" + ct;
            }
            return title;
        }
        return "";
    }

    public String getSection(EventInterface event) {
        if (event.hasCourseNames()) {
            String section = "";
            if (event.hasExternalIds()) {
                for (String ex : event.getExternalIds()) {
                    if (section.isEmpty()) {
                        section = section + ex;
                        continue;
                    }
                    if (event.getInstruction() != null || event.getType() == EventInterface.EventType.Course) {
                        section = section + "\n  " + ex;
                        continue;
                    }
                    section = section + "\n" + ex;
                }
            } else if (event.hasSectionNumber()) {
                section = event.getSectionNumber();
            }
            return section;
        }
        return event.getSectionNumber();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReverseComparator<T>
    implements Comparator<T> {
        private Comparator<T> iComparator = null;
        private boolean iReverse;

        public ReverseComparator(Comparator<T> comparator, boolean reverse) {
            this.iComparator = comparator;
            this.iReverse = reverse;
        }

        @Override
        public int compare(T o1, T o2) {
            if (this.iReverse) {
                return this.iComparator.compare(o2, o1);
            }
            return this.iComparator.compare(o1, o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EventMeeting
    implements Comparable<EventMeeting> {
        private EventInterface iEvent;
        private EventInterface.MeetingInterface iMeeting;

        private EventMeeting(EventInterface event, EventInterface.MeetingInterface meeting) {
            this.iEvent = event;
            this.iMeeting = meeting;
        }

        public EventInterface getEvent() {
            return this.iEvent;
        }

        public EventInterface.MeetingInterface getMeeting() {
            return this.iMeeting;
        }

        @Override
        public int compareTo(EventMeeting m) {
            int cmp = this.getEvent().compareTo(m.getEvent());
            return cmp == 0 ? this.getMeeting().compareTo(m.getMeeting()) : cmp;
        }
    }
}

