/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.export.PDFPrinter;

public class XLSPrinter
implements Exporter.Printer {
    private static Pattern sNumber = Pattern.compile("[+-]?[0-9]*\\.?[0-9]*[a-z]?");
    private OutputStream iOutput;
    private Workbook iWorkbook;
    private Object[] iLastLine = null;
    private boolean iCheckLast = false;
    private Set<Integer> iHiddenColumns = new HashSet<Integer>();
    private Sheet iSheet;
    private int iRowNum = 0;
    private Map<String, CellStyle> iStyles;
    private Map<String, Font> iFonts = new HashMap<String, Font>();
    private Map<String, Short> iColors = new HashMap<String, Short>();
    public static final int EXPAND_ROW = 1;
    public static final int EXPAND_COLUMN = 2;
    public static final int EXPAND_ROW_AND_COLUMN = 3;
    public static final int OVERLAY_ROW_AND_COLUMN = 7;

    public XLSPrinter(OutputStream output, boolean checkLast) {
        this.iOutput = output;
        this.iCheckLast = checkLast;
        this.iWorkbook = new HSSFWorkbook();
        this.iSheet = this.iWorkbook.createSheet();
        this.iSheet.setDisplayGridlines(false);
        this.iSheet.setPrintGridlines(false);
        this.iSheet.setFitToPage(true);
        this.iSheet.setHorizontallyCenter(true);
        PrintSetup printSetup = this.iSheet.getPrintSetup();
        printSetup.setLandscape(true);
        this.iSheet.setAutobreaks(true);
        printSetup.setFitHeight((short)1);
        printSetup.setFitWidth((short)1);
        this.iStyles = new HashMap<String, CellStyle>();
        CellStyle style = this.iWorkbook.createCellStyle();
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        style.setAlignment(HorizontalAlignment.LEFT);
        style.setVerticalAlignment(VerticalAlignment.TOP);
        style.setFont(this.getFont(true, false, false, Color.BLACK));
        style.setFillForegroundColor(IndexedColors.LIGHT_CORNFLOWER_BLUE.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setWrapText(true);
        this.iStyles.put("header", style);
        style = this.iWorkbook.createCellStyle();
        style.setAlignment(HorizontalAlignment.LEFT);
        style.setVerticalAlignment(VerticalAlignment.TOP);
        style.setFont(this.getFont(false, false, false, Color.BLACK));
        style.setWrapText(true);
        this.iStyles.put("plain", style);
        style = this.iWorkbook.createCellStyle();
        style.setAlignment(HorizontalAlignment.RIGHT);
        style.setVerticalAlignment(VerticalAlignment.TOP);
        style.setFont(this.getFont(false, false, false, Color.BLACK));
        this.iStyles.put("number", style);
    }

    public String getContentType() {
        return "application/vnd.ms-excel";
    }

    public void hideColumn(int col) {
        this.iHiddenColumns.add(col);
    }

    public void printHeader(String ... fields) {
        Row headerRow = this.iSheet.createRow(this.iRowNum++);
        int cellIdx = 0;
        int nrLines = 1;
        for (int idx = 0; idx < fields.length; ++idx) {
            if (this.iHiddenColumns.contains(idx)) continue;
            Cell cell = headerRow.createCell(cellIdx++);
            cell.setCellStyle(this.iStyles.get("header"));
            cell.setCellValue(fields[idx]);
            if (fields[idx] == null) continue;
            nrLines = Math.max(nrLines, fields[idx].split("\n").length);
        }
        if (nrLines > 1) {
            headerRow.setHeightInPoints((float)nrLines * this.iSheet.getDefaultRowHeightInPoints() + 1.0f);
        }
    }

    public void printLine(String ... fields) {
        int cellIdx = 0;
        Row row = this.iSheet.createRow(this.iRowNum++);
        int nrLines = 1;
        for (int idx = 0; idx < fields.length; ++idx) {
            boolean number;
            if (this.iHiddenColumns.contains(idx) || this.iHiddenColumns.contains(idx)) continue;
            Cell cell = row.createCell(cellIdx++);
            String f = fields[idx];
            if (f == null || f.isEmpty() || this.iCheckLast && f.equals(this.iLastLine == null || idx >= this.iLastLine.length ? null : this.iLastLine[idx])) {
                f = "";
            }
            cell.setCellStyle(this.iStyles.get((number = sNumber.matcher(f).matches()) ? "number" : "plain"));
            if (f == null || f.isEmpty()) continue;
            if (number) {
                try {
                    cell.setCellValue(Double.valueOf(f).doubleValue());
                }
                catch (NumberFormatException e) {
                    cell.setCellValue(f);
                }
                continue;
            }
            nrLines = Math.max(nrLines, f.split("\n").length);
            cell.setCellValue(f);
        }
        if (nrLines > 1) {
            row.setHeightInPoints((float)nrLines * this.iSheet.getDefaultRowHeightInPoints() + 1.0f);
        }
        this.iLastLine = fields;
    }

    public void printLine(PDFPrinter.A ... fields) {
        int cellIdx = 0;
        Row row = this.iSheet.createRow(this.iRowNum++);
        int nrLines = 1;
        for (int idx = 0; idx < fields.length; ++idx) {
            if (this.iHiddenColumns.contains(idx)) continue;
            Cell cell = row.createCell(cellIdx++);
            PDFPrinter.A f = fields[idx];
            if (f == null || f.isEmpty() || this.iCheckLast && f.equals(this.iLastLine == null || idx >= this.iLastLine.length ? null : this.iLastLine[idx])) {
                f = new PDFPrinter.A();
                if (fields[idx] != null && fields[idx].has(PDFPrinter.F.NOSEPARATOR)) {
                    f.set(PDFPrinter.F.NOSEPARATOR);
                }
            }
            cell.setCellStyle(this.getStyle(f, this.iLastLine == null && !f.has(PDFPrinter.F.NOSEPARATOR), f.getPattern()));
            if (f.hasBufferedImage()) {
                try {
                    this.addImageToSheet(cellIdx - 1, this.iRowNum - 1, (HSSFSheet)this.iSheet, f.getBufferedImage(), 3);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (f.isNumber()) {
                cell.setCellValue(f.getNumber().doubleValue());
                continue;
            }
            if (f.isDate()) {
                cell.setCellValue(f.getDate());
                continue;
            }
            if (f.hasText()) {
                boolean number = sNumber.matcher(f.getText()).matches();
                if (number && f.has(PDFPrinter.F.RIGHT)) {
                    try {
                        cell.setCellValue(Double.valueOf(f.getText()).doubleValue());
                    }
                    catch (NumberFormatException e) {
                        cell.setCellValue(f.getText());
                    }
                    continue;
                }
                cell.setCellValue(f.getText());
                nrLines = Math.max(nrLines, f.getText().split("\n").length);
                continue;
            }
            if (!f.hasChunks()) continue;
            StringBuffer text = new StringBuffer();
            ArrayList<Object[]> font = new ArrayList<Object[]>();
            for (PDFPrinter.A g : f.getChunks()) {
                if (g.hasText()) {
                    if (text.length() > 0) {
                        text.append(f.has(PDFPrinter.F.INLINE) ? " " : "\n");
                    }
                    font.add(new Object[]{text.length(), this.getFont(g.has(PDFPrinter.F.BOLD), g.has(PDFPrinter.F.ITALIC), g.has(PDFPrinter.F.UNDERLINE), g.getColor()).getIndex()});
                    text.append(g.getText());
                }
                if (!g.hasChunks()) continue;
                for (PDFPrinter.A h : g.getChunks()) {
                    if (!h.hasText()) continue;
                    if (text.length() > 0) {
                        text.append(" ");
                    }
                    font.add(new Object[]{text.length(), this.getFont(h.has(PDFPrinter.F.BOLD), h.has(PDFPrinter.F.ITALIC), h.has(PDFPrinter.F.UNDERLINE), h.getColor()).getIndex()});
                    text.append(h.getText());
                }
            }
            nrLines = Math.max(nrLines, text.toString().split("\n").length);
            font.add(new Object[]{text.length(), (short)0});
            HSSFRichTextString value = new HSSFRichTextString(text.toString());
            for (int i = 0; i < font.size() - 1; ++i) {
                value.applyFont(((Integer)((Object[])font.get(i))[0]).intValue(), ((Integer)((Object[])font.get(1 + i))[0]).intValue(), ((Short)((Object[])font.get(i))[1]).shortValue());
            }
            cell.setCellValue((RichTextString)value);
        }
        if (nrLines > 1) {
            row.setHeightInPoints(Math.max((float)nrLines * this.iSheet.getDefaultRowHeightInPoints() + 1.0f, row.getHeightInPoints()));
        }
        this.iLastLine = fields;
    }

    protected Font getFont(boolean bold, boolean italic, boolean underline, Color c) {
        String fontId;
        Font font;
        String colorId;
        Short color = null;
        if (c == null) {
            c = Color.BLACK;
        }
        if (c != null && (color = this.iColors.get(colorId = Integer.toHexString(c.getRGB()))) == null) {
            HSSFPalette palette = ((HSSFWorkbook)this.iWorkbook).getCustomPalette();
            HSSFColor clr = palette.findSimilarColor(c.getRed(), c.getGreen(), c.getBlue());
            color = clr == null ? IndexedColors.BLACK.getIndex() : clr.getIndex();
            this.iColors.put(colorId, color);
        }
        if ((font = this.iFonts.get(fontId = (bold ? "b" : "") + (italic ? "i" : "") + (underline ? "u" : "") + (color == null ? "" : color))) == null) {
            font = this.iWorkbook.createFont();
            font.setBold(bold);
            font.setItalic(italic);
            font.setUnderline(underline ? (byte)1 : 0);
            font.setColor(color.shortValue());
            font.setFontHeightInPoints((short)10);
            font.setFontName("Arial");
            this.iFonts.put(fontId, font);
        }
        return font;
    }

    protected CellStyle getStyle(PDFPrinter.A f, boolean dashed, String format) {
        String styleId = (dashed ? "D" : "") + (f.has(PDFPrinter.F.BOLD) ? "b" : "") + (f.has(PDFPrinter.F.ITALIC) ? "i" : "") + (f.has(PDFPrinter.F.UNDERLINE) ? "u" : "") + (f.has(PDFPrinter.F.RIGHT) ? "R" : (f.has(PDFPrinter.F.CENTER) ? "C" : "L")) + (f.hasColor() ? "#" + Integer.toHexString(f.getColor().getRGB()) : "") + (format == null ? "" : "|" + format);
        CellStyle style = this.iStyles.get(styleId);
        if (style == null) {
            style = this.iWorkbook.createCellStyle();
            if (dashed) {
                style.setBorderTop(BorderStyle.DASHED);
                style.setTopBorderColor(IndexedColors.BLACK.getIndex());
            }
            style.setAlignment(f.has(PDFPrinter.F.RIGHT) ? HorizontalAlignment.RIGHT : (f.has(PDFPrinter.F.CENTER) ? HorizontalAlignment.CENTER : HorizontalAlignment.LEFT));
            style.setVerticalAlignment(VerticalAlignment.TOP);
            style.setFont(this.getFont(f.has(PDFPrinter.F.BOLD), f.has(PDFPrinter.F.ITALIC), f.has(PDFPrinter.F.UNDERLINE), f.getColor()));
            style.setWrapText(true);
            if (format != null) {
                style.setDataFormat(this.iWorkbook.createDataFormat().getFormat(format));
            }
            this.iStyles.put(styleId, style);
        }
        return style;
    }

    protected void addImageToSheet(int colNumber, int rowNumber, HSSFSheet sheet, BufferedImage image, int resizeBehaviour) throws IOException {
        double reqImageWidthMM = (double)image.getWidth() / 3.78;
        double reqImageHeightMM = (double)image.getHeight() / 3.78;
        this.addImageToSheet(colNumber, rowNumber, sheet, image, reqImageWidthMM, reqImageHeightMM, resizeBehaviour);
    }

    protected void addImageToSheet(int colNumber, int rowNumber, HSSFSheet sheet, BufferedImage image, double reqImageWidthMM, double reqImageHeightMM, int resizeBehaviour) throws IOException {
        ClientAnchorDetail colClientAnchorDetail = this.fitImageToColumns(sheet, colNumber, reqImageWidthMM, resizeBehaviour);
        ClientAnchorDetail rowClientAnchorDetail = this.fitImageToRows(sheet, rowNumber, reqImageHeightMM, resizeBehaviour);
        HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, colClientAnchorDetail.getInset(), rowClientAnchorDetail.getInset(), (short)colClientAnchorDetail.getFromIndex(), rowClientAnchorDetail.getFromIndex(), (short)colClientAnchorDetail.getToIndex(), rowClientAnchorDetail.getToIndex());
        anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "PNG", bytes);
        int index = sheet.getWorkbook().addPicture(bytes.toByteArray(), 6);
        HSSFPatriarch patriarch = sheet.createDrawingPatriarch();
        patriarch.createPicture(anchor, index);
    }

    private ClientAnchorDetail fitImageToColumns(HSSFSheet sheet, int colNumber, double reqImageWidthMM, int resizeBehaviour) {
        ClientAnchorDetail colClientAnchorDetail = null;
        double colWidthMM = ConvertImageUnits.widthUnits2Millimetres((short)sheet.getColumnWidth(colNumber));
        if (colWidthMM < reqImageWidthMM) {
            if (resizeBehaviour == 2 || resizeBehaviour == 3) {
                sheet.setColumnWidth(colNumber, ConvertImageUnits.millimetres2WidthUnits(reqImageWidthMM));
                colWidthMM = reqImageWidthMM;
                double colCoordinatesPerMM = 1023.0 / colWidthMM;
                int pictureWidthCoordinates = (int)(reqImageWidthMM * colCoordinatesPerMM);
                colClientAnchorDetail = new ClientAnchorDetail(colNumber, colNumber, pictureWidthCoordinates);
            } else if (resizeBehaviour == 7 || resizeBehaviour == 1) {
                colClientAnchorDetail = this.calculateColumnLocation(sheet, colNumber, reqImageWidthMM);
            }
        } else {
            double colCoordinatesPerMM = 1023.0 / colWidthMM;
            int pictureWidthCoordinates = (int)(reqImageWidthMM * colCoordinatesPerMM);
            colClientAnchorDetail = new ClientAnchorDetail(colNumber, colNumber, pictureWidthCoordinates);
        }
        return colClientAnchorDetail;
    }

    private ClientAnchorDetail calculateColumnLocation(HSSFSheet sheet, int startingColumn, double reqImageWidthMM) {
        ClientAnchorDetail anchorDetail;
        double totalWidthMM = 0.0;
        double colWidthMM = 0.0;
        int toColumn = startingColumn;
        while (totalWidthMM < reqImageWidthMM) {
            colWidthMM = ConvertImageUnits.widthUnits2Millimetres((short)sheet.getColumnWidth(toColumn));
            totalWidthMM += colWidthMM + 2.0;
            ++toColumn;
        }
        --toColumn;
        if ((int)totalWidthMM == (int)reqImageWidthMM) {
            anchorDetail = new ClientAnchorDetail(startingColumn, toColumn, 1023);
        } else {
            double overlapMM = reqImageWidthMM - (totalWidthMM - colWidthMM);
            if (overlapMM < 0.0) {
                overlapMM = 0.0;
            }
            double coordinatePositionsPerMM = 1023.0 / colWidthMM;
            int inset = (int)(coordinatePositionsPerMM * overlapMM);
            anchorDetail = new ClientAnchorDetail(startingColumn, toColumn, inset);
        }
        return anchorDetail;
    }

    private ClientAnchorDetail fitImageToRows(HSSFSheet sheet, int rowNumber, double reqImageHeightMM, int resizeBehaviour) {
        double rowHeightMM;
        ClientAnchorDetail rowClientAnchorDetail = null;
        HSSFRow row = sheet.getRow(rowNumber);
        if (row == null) {
            row = sheet.createRow(rowNumber);
        }
        if ((rowHeightMM = (double)row.getHeightInPoints() / 2.83) < reqImageHeightMM) {
            if (resizeBehaviour == 1 || resizeBehaviour == 3) {
                row.setHeightInPoints((float)(reqImageHeightMM * 2.83));
                rowHeightMM = reqImageHeightMM;
                double rowCoordinatesPerMM = 255.0 / rowHeightMM;
                int pictureHeightCoordinates = (int)(reqImageHeightMM * rowCoordinatesPerMM);
                rowClientAnchorDetail = new ClientAnchorDetail(rowNumber, rowNumber, pictureHeightCoordinates);
            } else if (resizeBehaviour == 7 || resizeBehaviour == 2) {
                rowClientAnchorDetail = this.calculateRowLocation(sheet, rowNumber, reqImageHeightMM);
            }
        } else {
            double rowCoordinatesPerMM = 255.0 / rowHeightMM;
            int pictureHeightCoordinates = (int)(reqImageHeightMM * rowCoordinatesPerMM);
            rowClientAnchorDetail = new ClientAnchorDetail(rowNumber, rowNumber, pictureHeightCoordinates);
        }
        return rowClientAnchorDetail;
    }

    private ClientAnchorDetail calculateRowLocation(HSSFSheet sheet, int startingRow, double reqImageHeightMM) {
        ClientAnchorDetail clientAnchorDetail;
        double rowHeightMM = 0.0;
        double totalRowHeightMM = 0.0;
        int toRow = startingRow;
        while (totalRowHeightMM < reqImageHeightMM) {
            HSSFRow row = sheet.getRow(toRow);
            if (row == null) {
                row = sheet.createRow(toRow);
            }
            rowHeightMM = (double)row.getHeightInPoints() / 2.83;
            totalRowHeightMM += rowHeightMM;
            ++toRow;
        }
        --toRow;
        if ((int)totalRowHeightMM == (int)reqImageHeightMM) {
            clientAnchorDetail = new ClientAnchorDetail(startingRow, toRow, 255);
        } else {
            double overlapMM = reqImageHeightMM - (totalRowHeightMM - rowHeightMM);
            if (overlapMM < 0.0) {
                overlapMM = 0.0;
            }
            double rowCoordinatesPerMM = 255.0 / rowHeightMM;
            int inset = (int)(overlapMM * rowCoordinatesPerMM);
            clientAnchorDetail = new ClientAnchorDetail(startingRow, toRow, inset);
        }
        return clientAnchorDetail;
    }

    public void flush() {
        this.iLastLine = null;
    }

    public void close() throws IOException {
        for (short col = 0; col <= this.iSheet.getRow(0).getLastCellNum(); col = (short)(col + 1)) {
            if (this.iSheet.getColumnWidth((int)col) != 256 * this.iSheet.getDefaultColumnWidth()) continue;
            this.iSheet.autoSizeColumn((int)col);
        }
        this.iWorkbook.write(this.iOutput);
        this.iWorkbook.close();
    }

    public static class ConvertImageUnits {
        public static final int TOTAL_COLUMN_COORDINATE_POSITIONS = 1023;
        public static final int TOTAL_ROW_COORDINATE_POSITIONS = 255;
        public static final int PIXELS_PER_INCH = 96;
        public static final double PIXELS_PER_MILLIMETRES = 3.78;
        public static final double POINTS_PER_MILLIMETRE = 2.83;
        public static final double CELL_BORDER_WIDTH_MILLIMETRES = 2.0;
        public static final short EXCEL_COLUMN_WIDTH_FACTOR = 256;
        public static final int UNIT_OFFSET_LENGTH = 7;
        public static final int[] UNIT_OFFSET_MAP = new int[]{0, 36, 73, 109, 146, 182, 219};

        public static short pixel2WidthUnits(int pxs) {
            short widthUnits = (short)(256 * (pxs / 7));
            widthUnits = (short)(widthUnits + UNIT_OFFSET_MAP[pxs % 7]);
            return widthUnits;
        }

        public static int widthUnits2Pixel(short widthUnits) {
            int pixels = widthUnits / 256 * 7;
            int offsetWidthUnits = widthUnits % 256;
            return pixels += Math.round((float)offsetWidthUnits / 36.57143f);
        }

        public static double widthUnits2Millimetres(short widthUnits) {
            return (double)ConvertImageUnits.widthUnits2Pixel(widthUnits) / 3.78;
        }

        public static int millimetres2WidthUnits(double millimetres) {
            return ConvertImageUnits.pixel2WidthUnits((int)(millimetres * 3.78));
        }
    }

    public static class ClientAnchorDetail {
        public int iFromIndex;
        public int iToIndex;
        public int iInset;

        public ClientAnchorDetail(int fromIndex, int toIndex, int inset) {
            this.iFromIndex = fromIndex;
            this.iToIndex = toIndex;
            this.iInset = inset;
        }

        public int getFromIndex() {
            return this.iFromIndex;
        }

        public int getToIndex() {
            return this.iToIndex;
        }

        public int getInset() {
            return this.iInset;
        }
    }
}

