/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.coursett.model.TimeLocation;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.dataexchange.StudentEnrollmentImport;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.CourseRequestOption;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.FreeTime;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.PosMinor;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentAreaClassificationMajor;
import org.unitime.timetable.model.StudentAreaClassificationMinor;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentEnrollmentMessage;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.base.BaseAcademicArea;
import org.unitime.timetable.model.base.BaseAcademicClassification;
import org.unitime.timetable.model.base.BaseCourseDemand;
import org.unitime.timetable.model.base.BasePosMajor;
import org.unitime.timetable.model.base.BasePosMinor;
import org.unitime.timetable.model.base.BaseStudent;
import org.unitime.timetable.model.base.BaseStudentAccomodation;
import org.unitime.timetable.model.base.BaseStudentAreaClassificationMajor;
import org.unitime.timetable.model.base.BaseStudentAreaClassificationMinor;
import org.unitime.timetable.model.base.BaseStudentGroup;
import org.unitime.timetable.model.dao.InstructionalMethodDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.util.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudentSectioningImport
extends BaseImport {
    @Override
    public void loadXml(Element rootElement) {
        try {
            this.beginTransaction();
            boolean trimLeadingZerosFromExternalId = ApplicationProperty.DataExchangeTrimLeadingZerosFromExternalIds.isTrue();
            String campus = rootElement.attributeValue("campus");
            String year = rootElement.attributeValue("year");
            String term = rootElement.attributeValue("term");
            EnrollmentMode mode = null;
            if (rootElement.attributeValue("enrollments") != null) {
                mode = EnrollmentMode.valueOf(rootElement.attributeValue("enrollments").toUpperCase());
            } else {
                mode = EnrollmentMode.UPDATE;
                if ("true".equals(rootElement.attributeValue("keepEnrollments", "false"))) {
                    mode = EnrollmentMode.NOCHANGE;
                }
                Iterator i = rootElement.elementIterator("student");
                block2: while (i.hasNext()) {
                    Element addCoursesElement;
                    Element studentElement = (Element)i.next();
                    Element reqCoursesElement = studentElement.element("updateCourseRequests");
                    if (reqCoursesElement != null && "true".equals(reqCoursesElement.attributeValue("commit", "true"))) {
                        Iterator j = reqCoursesElement.elementIterator("courseOffering");
                        while (j.hasNext()) {
                            Element requestElement = (Element)j.next();
                            if (requestElement.element("class") != null) {
                                mode = EnrollmentMode.IMPORT;
                                break block2;
                            }
                            Iterator k = requestElement.elementIterator("alternative");
                            while (k.hasNext()) {
                                Element altElement = (Element)k.next();
                                if (altElement.element("class") == null) continue;
                                mode = EnrollmentMode.IMPORT;
                                break block2;
                            }
                        }
                    }
                    if ((addCoursesElement = studentElement.element("addCourseRequests")) == null || !"true".equals(addCoursesElement.attributeValue("commit", "true"))) continue;
                    Iterator j = addCoursesElement.elementIterator("courseOffering");
                    while (j.hasNext()) {
                        Element requestElement = (Element)j.next();
                        if (requestElement.element("class") != null) {
                            mode = EnrollmentMode.IMPORT;
                            break block2;
                        }
                        Iterator k = requestElement.elementIterator("alternative");
                        while (k.hasNext()) {
                            Element altElement = (Element)k.next();
                            if (altElement.element("class") == null) continue;
                            mode = EnrollmentMode.IMPORT;
                            break block2;
                        }
                    }
                }
            }
            this.info("Enrollment mode set to " + mode.name() + ": " + mode.toString());
            Session session = Session.getSessionUsingInitiativeYearTerm(campus, year, term);
            if (session == null) {
                throw new Exception("No session found for the given campus, year, and term.");
            }
            Hashtable<String, Student> students = new Hashtable<String, Student>();
            for (Object student : this.getHibSession().createQuery("from Student s where s.session.uniqueId=:sessionId and s.externalUniqueId is not null").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                students.put(((BaseStudent)student).getExternalUniqueId(), (Student)student);
            }
            Hashtable<String, AcademicArea> abbv2area = new Hashtable<String, AcademicArea>();
            for (Object area : this.getHibSession().createQuery("from AcademicArea where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                abbv2area.put(((BaseAcademicArea)area).getAcademicAreaAbbreviation(), (AcademicArea)area);
            }
            Hashtable<String, AcademicClassification> code2clasf = new Hashtable<String, AcademicClassification>();
            for (Object clasf : this.getHibSession().createQuery("from AcademicClassification where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                code2clasf.put(((BaseAcademicClassification)clasf).getCode(), (AcademicClassification)clasf);
            }
            Hashtable<String, Object> code2major = new Hashtable<String, Object>();
            for (Object major : this.getHibSession().createQuery("from PosMajor where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                for (AcademicArea academicArea : ((BasePosMajor)major).getAcademicAreas()) {
                    code2major.put(academicArea.getAcademicAreaAbbreviation() + ":" + ((BasePosMajor)major).getCode(), major);
                }
            }
            Hashtable<String, Object> code2minor = new Hashtable<String, Object>();
            for (Object minor : this.getHibSession().createQuery("from PosMinor where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                for (AcademicArea area : ((BasePosMinor)minor).getAcademicAreas()) {
                    code2minor.put(area.getAcademicAreaAbbreviation() + ":" + ((BasePosMinor)minor).getCode(), minor);
                }
            }
            Hashtable<String, StudentGroup> code2group = new Hashtable<String, StudentGroup>();
            for (StudentGroup studentGroup : this.getHibSession().createQuery("from StudentGroup where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                code2group.put(studentGroup.getGroupAbbreviation(), studentGroup);
            }
            Hashtable<String, StudentAccomodation> code2accomodation = new Hashtable<String, StudentAccomodation>();
            for (Object accomodation : this.getHibSession().createQuery("from StudentAccomodation where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                code2accomodation.put(((BaseStudentAccomodation)accomodation).getAbbreviation(), (StudentAccomodation)accomodation);
            }
            Hashtable<String, CourseOffering> hashtable = new Hashtable<String, CourseOffering>();
            for (CourseOffering course : this.getHibSession().createQuery("from CourseOffering where subjectArea.session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                hashtable.put(course.getCourseName(), course);
            }
            HashMap course2extId2class = new HashMap();
            HashMap course2name2class = new HashMap();
            this.info("Loading classes...");
            for (Object[] o : this.getHibSession().createQuery("select c, co from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where c.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                String name;
                HashSet<Object> sameNameClasses;
                String extId;
                HashMap<String, HashSet<Object>> name2class;
                Class_ clazz = (Class_)o[0];
                CourseOffering course = (CourseOffering)o[1];
                HashMap<String, HashSet<Object>> extId2class = (HashMap<String, HashSet<Object>>)course2extId2class.get(course.getUniqueId());
                if (extId2class == null) {
                    extId2class = new HashMap<String, HashSet<Object>>();
                    course2extId2class.put(course.getUniqueId(), extId2class);
                }
                if ((name2class = (HashMap<String, HashSet<Object>>)course2name2class.get(course.getUniqueId())) == null) {
                    name2class = new HashMap<String, HashSet<Object>>();
                    course2name2class.put(course.getUniqueId(), name2class);
                }
                if ((extId = clazz.getExternalId(course)) != null && !extId.isEmpty()) {
                    HashSet<Object> sameExtIdClasses = (HashSet<Object>)extId2class.get(extId);
                    if (sameExtIdClasses == null) {
                        sameExtIdClasses = new HashSet<Object>();
                        extId2class.put(extId, sameExtIdClasses);
                    }
                    sameExtIdClasses.add(clazz);
                }
                if ((sameNameClasses = (HashSet<Object>)name2class.get(name = clazz.getSchedulingSubpart().getItypeDesc().trim() + " " + this.getClassSuffix(clazz))) == null) {
                    sameNameClasses = new HashSet<Object>();
                    name2class.put(name, sameNameClasses);
                }
                sameNameClasses.add(clazz);
            }
            HashMap<String, InstructionalMethod> ref2im = new HashMap<String, InstructionalMethod>();
            HashMap<String, InstructionalMethod> name2im = new HashMap<String, InstructionalMethod>();
            for (InstructionalMethod meth : InstructionalMethodDAO.getInstance().findAll(this.getHibSession())) {
                ref2im.put(meth.getReference(), meth);
                name2im.put(meth.getLabel(), meth);
            }
            HashSet<Long> updatedStudents = new HashSet<Long>();
            Iterator i1 = rootElement.elementIterator("student");
            while (i1.hasNext()) {
                boolean bl;
                String status;
                Object email;
                Element name;
                Element studentElement = (Element)i1.next();
                String externalId = studentElement.attributeValue("key");
                if (externalId == null) continue;
                while (trimLeadingZerosFromExternalId && externalId.startsWith("0")) {
                    externalId = externalId.substring(1);
                }
                Element cancelElement = studentElement.element("cancelStudent");
                if (cancelElement != null) {
                    Student student = (Student)students.remove(externalId);
                    if (student == null) continue;
                    Iterator<Serializable> i = student.getCourseDemands().iterator();
                    while (i.hasNext()) {
                        CourseDemand cd = i.next();
                        if (cd.getFreeTime() != null) {
                            this.getHibSession().delete((Object)cd.getFreeTime());
                        }
                        for (CourseRequest cr : cd.getCourseRequests()) {
                            this.getHibSession().delete((Object)cr);
                        }
                        i.remove();
                        this.getHibSession().delete((Object)cd);
                        updatedStudents.add(student.getUniqueId());
                    }
                    i = student.getClassEnrollments().iterator();
                    while (i.hasNext()) {
                        StudentClassEnrollment enrollment = (StudentClassEnrollment)i.next();
                        this.getHibSession().delete((Object)enrollment);
                        i.remove();
                        updatedStudents.add(student.getUniqueId());
                    }
                    boolean delete = "true".equals(cancelElement.attributeValue("delete", "false"));
                    if (delete) {
                        updatedStudents.add(student.getUniqueId());
                        this.getHibSession().delete((Object)student);
                        continue;
                    }
                }
                Element demographicsElement = studentElement.element("updateDemographics");
                Student student = (Student)students.remove(externalId);
                if (student == null) {
                    if (demographicsElement == null) {
                        this.error("Student " + externalId + " not found, but no demographics information provided.");
                        continue;
                    }
                    student = new Student();
                    student.setSession(session);
                    student.setExternalUniqueId(externalId);
                    student.setFreeTimeCategory(0);
                    student.setSchedulePreference(0);
                    student.setClassEnrollments(new HashSet<StudentClassEnrollment>());
                    student.setCourseDemands(new HashSet<CourseDemand>());
                    name = demographicsElement.element("name");
                    if (name != null) {
                        student.setFirstName(name.attributeValue("first"));
                        student.setMiddleName(name.attributeValue("middle"));
                        student.setLastName(name.attributeValue("last"));
                    } else {
                        student.setFirstName("Name");
                        student.setLastName("Unknown");
                    }
                    email = demographicsElement.element("email");
                    if (email != null) {
                        student.setEmail(email.attributeValue("value"));
                    }
                    student.setAreaClasfMajors(new HashSet<StudentAreaClassificationMajor>());
                    student.setAreaClasfMinors(new HashSet<StudentAreaClassificationMinor>());
                    student.setGroups(new HashSet<StudentGroup>());
                    student.setAccomodations(new HashSet<StudentAccomodation>());
                } else if (demographicsElement != null) {
                    name = demographicsElement.element("name");
                    if (name != null) {
                        String fName = name.attributeValue("first");
                        String mName = name.attributeValue("middle");
                        String string = name.attributeValue("last");
                        if (!this.eq(fName, student.getFirstName())) {
                            student.setFirstName(name.attributeValue("first"));
                            updatedStudents.add(student.getUniqueId());
                        }
                        if (!this.eq(mName, student.getMiddleName())) {
                            student.setMiddleName(mName);
                            updatedStudents.add(student.getUniqueId());
                        }
                        if (!this.eq(string, student.getLastName())) {
                            student.setLastName(string);
                            updatedStudents.add(student.getUniqueId());
                        }
                    }
                    if ((email = demographicsElement.element("email")) != null && !this.eq(email.attributeValue("value"), student.getEmail())) {
                        student.setEmail(email.attributeValue("value"));
                        updatedStudents.add(student.getUniqueId());
                    }
                }
                if (demographicsElement != null) {
                    Object group2;
                    String clasf;
                    AcademicClassification f;
                    AcademicArea a;
                    Serializable m;
                    String area;
                    Element g;
                    Iterator i3;
                    String code;
                    Comparable<StudentAreaClassificationMajor> acm;
                    Hashtable<String, Object> sMajors = new Hashtable<String, Object>();
                    email = student.getAreaClasfMajors().iterator();
                    while (email.hasNext()) {
                        StudentAreaClassificationMajor major = (StudentAreaClassificationMajor)email.next();
                        sMajors.put(major.getAcademicArea().getAcademicAreaAbbreviation() + ":" + major.getAcademicClassification().getCode() + ":" + major.getMajor().getCode(), major);
                    }
                    Hashtable<String, StudentAreaClassificationMinor> sMinors = new Hashtable<String, StudentAreaClassificationMinor>();
                    for (StudentAreaClassificationMinor studentAreaClassificationMinor : student.getAreaClasfMinors()) {
                        sMinors.put(studentAreaClassificationMinor.getAcademicArea().getAcademicAreaAbbreviation() + ":" + studentAreaClassificationMinor.getAcademicClassification().getCode() + ":" + studentAreaClassificationMinor.getMinor().getCode(), studentAreaClassificationMinor);
                    }
                    Iterator i2 = demographicsElement.elementIterator("acadArea");
                    while (i2.hasNext()) {
                        String code2;
                        Element element = (Element)i2.next();
                        String area2 = element.attributeValue("abbv");
                        AcademicArea a2 = (AcademicArea)abbv2area.get(area2);
                        if (a2 == null) {
                            this.warn("Academic area " + area2 + " not known.");
                            continue;
                        }
                        String clasf2 = element.attributeValue("classification");
                        AcademicClassification f2 = (AcademicClassification)code2clasf.get(clasf2);
                        if (f2 == null) {
                            this.warn("Academic classification " + clasf2 + " not known.");
                            continue;
                        }
                        Iterator i32 = element.elementIterator("major");
                        while (i32.hasNext()) {
                            Element g2 = (Element)i32.next();
                            String code22 = g2.attributeValue("code");
                            if (sMajors.remove(area2 + ":" + clasf2 + ":" + code22) != null) continue;
                            PosMajor m2 = (PosMajor)code2major.get(area2 + ":" + code22);
                            if (m2 == null) {
                                this.warn("Major " + area2 + " " + code22 + " not known.");
                                continue;
                            }
                            acm = new StudentAreaClassificationMajor();
                            ((BaseStudentAreaClassificationMajor)((Object)acm)).setAcademicArea(a2);
                            ((BaseStudentAreaClassificationMajor)((Object)acm)).setAcademicClassification(f2);
                            ((BaseStudentAreaClassificationMajor)((Object)acm)).setMajor(m2);
                            ((BaseStudentAreaClassificationMajor)((Object)acm)).setStudent(student);
                            student.getAreaClasfMajors().add((StudentAreaClassificationMajor)acm);
                            if (student.getUniqueId() == null) continue;
                            updatedStudents.add(student.getUniqueId());
                        }
                        if (element.element("major") == null && element.element("minor") == null) {
                            boolean noMajor = true;
                            Iterator i33 = demographicsElement.elementIterator("major");
                            while (i33.hasNext()) {
                                code2 = ((Element)i33.next()).attributeValue("code");
                                if (code2major.get(area2 + ":" + code2) == null) continue;
                                noMajor = false;
                                break;
                            }
                            if (noMajor) {
                                String code3 = "-";
                                if (sMajors.remove(area2 + ":" + clasf2 + ":" + code3) == null) {
                                    PosMajor m3 = (PosMajor)code2major.get(area2 + ":" + code3);
                                    if (m3 == null) {
                                        m3 = new PosMajor();
                                        m3.addToacademicAreas(a2);
                                        m3.setExternalUniqueId("-");
                                        m3.setCode("-");
                                        m3.setName("No Major");
                                        m3.setSession(a2.getSession());
                                        a2.addToposMajors(m3);
                                        this.getHibSession().saveOrUpdate((Object)m3);
                                        code2major.put(area2 + ":" + code3, m3);
                                    }
                                    StudentAreaClassificationMajor acm2 = new StudentAreaClassificationMajor();
                                    acm2.setAcademicArea(a2);
                                    acm2.setAcademicClassification(f2);
                                    acm2.setMajor(m3);
                                    acm2.setStudent(student);
                                    student.getAreaClasfMajors().add(acm2);
                                    if (student.getUniqueId() != null) {
                                        updatedStudents.add(student.getUniqueId());
                                    }
                                }
                            }
                        }
                        Iterator i33 = element.elementIterator("minor");
                        while (i33.hasNext()) {
                            Element g2 = (Element)i33.next();
                            code2 = g2.attributeValue("code");
                            if (sMinors.remove(area2 + ":" + clasf2 + ":" + code2) != null) continue;
                            PosMinor m2 = (PosMinor)code2minor.get(area2 + ":" + code2);
                            if (m2 == null) {
                                this.warn("Minor " + area2 + " " + code2 + " not known.");
                                continue;
                            }
                            acm = new StudentAreaClassificationMinor();
                            ((BaseStudentAreaClassificationMinor)((Object)acm)).setAcademicArea(a2);
                            ((BaseStudentAreaClassificationMinor)((Object)acm)).setAcademicClassification(f2);
                            ((BaseStudentAreaClassificationMinor)((Object)acm)).setMinor(m2);
                            ((BaseStudentAreaClassificationMinor)((Object)acm)).setStudent(student);
                            student.getAreaClasfMinors().add((StudentAreaClassificationMinor)acm);
                            if (student.getUniqueId() == null) continue;
                            updatedStudents.add(student.getUniqueId());
                        }
                    }
                    i2 = demographicsElement.elementIterator("major");
                    while (i2.hasNext()) {
                        Element element = (Element)i2.next();
                        code = element.attributeValue("code");
                        i3 = demographicsElement.elementIterator("acadArea");
                        while (i3.hasNext()) {
                            g = (Element)i3.next();
                            area = g.attributeValue("abbv");
                            m = (PosMajor)code2major.get(area + ":" + code);
                            if (m == null || (a = (AcademicArea)abbv2area.get(area)) == null || (f = (AcademicClassification)code2clasf.get(clasf = g.attributeValue("classification"))) == null || sMajors.remove(area + ":" + clasf + ":" + code) != null) continue;
                            acm = new StudentAreaClassificationMajor();
                            ((BaseStudentAreaClassificationMajor)((Object)acm)).setAcademicArea(a);
                            ((BaseStudentAreaClassificationMajor)((Object)acm)).setAcademicClassification(f);
                            ((BaseStudentAreaClassificationMajor)((Object)acm)).setMajor((PosMajor)m);
                            ((BaseStudentAreaClassificationMajor)((Object)acm)).setStudent(student);
                            student.getAreaClasfMajors().add((StudentAreaClassificationMajor)acm);
                            if (student.getUniqueId() == null) continue;
                            updatedStudents.add(student.getUniqueId());
                        }
                    }
                    i2 = demographicsElement.elementIterator("minor");
                    while (i2.hasNext()) {
                        Element element = (Element)i2.next();
                        code = element.attributeValue("code");
                        i3 = demographicsElement.elementIterator("acadArea");
                        while (i3.hasNext()) {
                            g = (Element)i3.next();
                            area = g.attributeValue("abbv");
                            m = (PosMinor)code2minor.get(area + ":" + code);
                            if (m == null || (a = (AcademicArea)abbv2area.get(area)) == null || (f = (AcademicClassification)code2clasf.get(clasf = g.attributeValue("classification"))) == null || sMinors.remove(area + ":" + clasf + ":" + code) != null) continue;
                            acm = new StudentAreaClassificationMinor();
                            ((BaseStudentAreaClassificationMinor)((Object)acm)).setAcademicArea(a);
                            ((BaseStudentAreaClassificationMinor)((Object)acm)).setAcademicClassification(f);
                            ((BaseStudentAreaClassificationMinor)((Object)acm)).setMinor((PosMinor)m);
                            ((BaseStudentAreaClassificationMinor)((Object)acm)).setStudent(student);
                            student.getAreaClasfMinors().add((StudentAreaClassificationMinor)acm);
                            if (student.getUniqueId() == null) continue;
                            updatedStudents.add(student.getUniqueId());
                        }
                    }
                    for (StudentAreaClassificationMajor studentAreaClassificationMajor : sMajors.values()) {
                        student.getAreaClasfMajors().remove(studentAreaClassificationMajor);
                        this.getHibSession().delete((Object)studentAreaClassificationMajor);
                        if (student.getUniqueId() == null) continue;
                        updatedStudents.add(student.getUniqueId());
                    }
                    for (StudentAreaClassificationMinor studentAreaClassificationMinor : sMinors.values()) {
                        student.getAreaClasfMinors().remove(studentAreaClassificationMinor);
                        this.getHibSession().delete((Object)studentAreaClassificationMinor);
                        if (student.getUniqueId() == null) continue;
                        updatedStudents.add(student.getUniqueId());
                    }
                    Hashtable<String, StudentGroup> sGroups = new Hashtable<String, StudentGroup>();
                    for (StudentGroup group3 : student.getGroups()) {
                        sGroups.put(group3.getGroupAbbreviation(), group3);
                    }
                    Iterator iterator = demographicsElement.elementIterator("groupAffiliation");
                    while (iterator.hasNext()) {
                        Element e2 = (Element)iterator.next();
                        String code4 = e2.attributeValue("code");
                        if (sGroups.remove(code4) != null) continue;
                        StudentGroup group2 = (StudentGroup)code2group.get(code4);
                        if (group2 == null) {
                            this.warn("Student group " + code4 + " not known.");
                            continue;
                        }
                        student.getGroups().add(group2);
                        group2.getStudents().add(student);
                        this.getHibSession().saveOrUpdate((Object)group2);
                        if (student.getUniqueId() == null) continue;
                        updatedStudents.add(student.getUniqueId());
                    }
                    for (Object group2 : sGroups.values()) {
                        if (((BaseStudentGroup)group2).getExternalUniqueId() == null) continue;
                        student.getGroups().remove(group2);
                        ((BaseStudentGroup)group2).getStudents().remove(student);
                        this.getHibSession().saveOrUpdate(group2);
                        if (student.getUniqueId() == null) continue;
                        updatedStudents.add(student.getUniqueId());
                    }
                    Hashtable<String, StudentAccomodation> hashtable2 = new Hashtable<String, StudentAccomodation>();
                    group2 = student.getAccomodations().iterator();
                    while (group2.hasNext()) {
                        StudentAccomodation accomodation = (StudentAccomodation)group2.next();
                        hashtable2.put(accomodation.getAbbreviation(), accomodation);
                    }
                    Iterator i23 = demographicsElement.elementIterator("disability");
                    while (i23.hasNext()) {
                        Element e3 = (Element)i23.next();
                        String code5 = e3.attributeValue("code");
                        if (hashtable2.remove(code5) != null) continue;
                        StudentAccomodation accomodation2 = (StudentAccomodation)code2accomodation.get(code5);
                        if (accomodation2 == null) {
                            this.warn("Student accomodation " + code5 + " not known.");
                            continue;
                        }
                        student.getAccomodations().add(accomodation2);
                        accomodation2.getStudents().add(student);
                        if (student.getUniqueId() == null) continue;
                        updatedStudents.add(student.getUniqueId());
                    }
                    for (Object accomodation3 : hashtable2.values()) {
                        student.getAccomodations().remove(accomodation3);
                        ((BaseStudentAccomodation)accomodation3).getStudents().remove(student);
                        if (student.getUniqueId() == null) continue;
                        updatedStudents.add(student.getUniqueId());
                    }
                }
                if ((status = studentElement.attributeValue("status")) != null) {
                    if (status.isEmpty()) {
                        student.setSectioningStatus(null);
                    } else {
                        StudentSectioningStatus s = StudentSectioningStatus.getStatus(status, null, this.getHibSession());
                        if (s != null) {
                            student.setSectioningStatus(s);
                        } else {
                            this.warn("Student sectioning status " + status + " not found.");
                        }
                    }
                }
                if (student.getUniqueId() == null) {
                    updatedStudents.add((Long)this.getHibSession().save((Object)student));
                } else {
                    this.getHibSession().update((Object)student);
                }
                Element reqCoursesElement = studentElement.element("updateCourseRequests");
                Element delCoursesElement = null;
                boolean bl2 = bl = reqCoursesElement != null;
                if (!bl) {
                    reqCoursesElement = studentElement.element("addCourseRequests");
                    delCoursesElement = studentElement.element("dropCourseRequests");
                }
                if (reqCoursesElement != null && "true".equals(reqCoursesElement.attributeValue("commit", "true")) || delCoursesElement != null) {
                    FreeTime free;
                    Element requestElement;
                    Iterator<Object> i;
                    Object accomodation3;
                    Hashtable<StudentEnrollmentImport.Pair, StudentClassEnrollment> enrollments = new Hashtable<StudentEnrollmentImport.Pair, StudentClassEnrollment>();
                    accomodation3 = student.getClassEnrollments().iterator();
                    while (accomodation3.hasNext()) {
                        StudentClassEnrollment enrollment = accomodation3.next();
                        enrollments.put(new StudentEnrollmentImport.Pair(enrollment.getCourseOffering().getUniqueId(), enrollment.getClazz().getUniqueId()), enrollment);
                    }
                    TreeSet<CourseDemand> remaining = new TreeSet<CourseDemand>(student.getCourseDemands());
                    int priority = bl ? 0 : remaining.size();
                    Date ts = new Date();
                    HashMap<Long, CourseRequest> course2request = new HashMap<Long, CourseRequest>();
                    ArrayList<CourseRequest> unusedRequests = new ArrayList<CourseRequest>();
                    if (reqCoursesElement != null) {
                        i = reqCoursesElement.elementIterator();
                        while (i.hasNext()) {
                            Iterator j;
                            requestElement = (Element)i.next();
                            String waitList = requestElement.attributeValue("waitlist");
                            String alternative = requestElement.attributeValue("alternative");
                            if (requestElement.getName().equals("courseOffering")) {
                                ArrayList<CourseOffering> courses = new ArrayList<CourseOffering>();
                                ArrayList<Integer> credits = new ArrayList<Integer>();
                                ArrayList<Element> elements = new ArrayList<Element>();
                                CourseOffering course = (CourseOffering)hashtable.get(requestElement.attributeValue("subjectArea") + " " + requestElement.attributeValue("courseNumber"));
                                if (course == null) {
                                    this.warn("Course " + requestElement.attributeValue("subjectArea") + " " + requestElement.attributeValue("courseNumber") + " not found.");
                                } else {
                                    courses.add(course);
                                    credits.add(Integer.valueOf(requestElement.attributeValue("credit", "0")));
                                    elements.add(requestElement);
                                }
                                LinkedList<Element> queue = new LinkedList<Element>();
                                queue.add(requestElement);
                                Element requestOrAlternativeElement = null;
                                while ((requestOrAlternativeElement = (Element)queue.poll()) != null) {
                                    j = requestOrAlternativeElement.elementIterator("alternative");
                                    while (j.hasNext()) {
                                        Element altElement = (Element)j.next();
                                        CourseOffering altCourse = (CourseOffering)hashtable.get(altElement.attributeValue("subjectArea") + " " + altElement.attributeValue("courseNumber"));
                                        if (altCourse == null) {
                                            this.warn("Course " + altElement.attributeValue("subjectArea") + " " + altElement.attributeValue("courseNumber") + " not found.");
                                        } else {
                                            courses.add(altCourse);
                                            credits.add(Integer.valueOf(altElement.attributeValue("credit", "0")));
                                            elements.add(altElement);
                                        }
                                        queue.add(altElement);
                                    }
                                }
                                if (!courses.isEmpty()) {
                                    CourseDemand cd = null;
                                    Iterator j2 = remaining.iterator();
                                    block46: while (j2.hasNext()) {
                                        CourseDemand adept = (CourseDemand)j2.next();
                                        if (adept.getFreeTime() != null) continue;
                                        for (CourseRequest cr : adept.getCourseRequests()) {
                                            if (!cr.getCourseOffering().getUniqueId().equals(((CourseOffering)courses.get(0)).getUniqueId())) continue;
                                            cd = adept;
                                            j2.remove();
                                            break block46;
                                        }
                                    }
                                    if (cd == null) {
                                        cd = new CourseDemand();
                                        cd.setTimestamp(ts);
                                        cd.setCourseRequests(new HashSet<CourseRequest>());
                                        cd.setEnrollmentMessages(new HashSet<StudentEnrollmentMessage>());
                                        cd.setStudent(student);
                                        student.getCourseDemands().add(cd);
                                    }
                                    cd.setAlternative("true".equals(alternative));
                                    cd.setPriority(priority);
                                    cd.setWaitlist("true".equals(waitList));
                                    Iterator<CourseRequest> requests = new TreeSet<CourseRequest>(cd.getCourseRequests()).iterator();
                                    int order = 0;
                                    for (CourseOffering co : courses) {
                                        CourseRequest cr = null;
                                        if (requests.hasNext()) {
                                            cr = requests.next();
                                            if (cr.getCourseRequestOptions() != null) {
                                                Iterator<CourseRequestOption> j3 = cr.getCourseRequestOptions().iterator();
                                                while (j3.hasNext()) {
                                                    this.getHibSession().delete((Object)j3.next());
                                                }
                                                cr.getCourseRequestOptions().clear();
                                            }
                                        } else {
                                            cr = new CourseRequest();
                                            cd.getCourseRequests().add(cr);
                                            cr.setCourseDemand(cd);
                                            cr.setCourseRequestOptions(new HashSet<CourseRequestOption>());
                                        }
                                        cr.setAllowOverlap(false);
                                        cr.setCredit((Integer)credits.get(order));
                                        OnlineSectioningLog.CourseRequestOption prefs = this.getPreferences((Element)elements.get(order), co, (Map)course2extId2class.get(co.getUniqueId()), (Map)course2name2class.get(co.getUniqueId()), ref2im, name2im);
                                        if (prefs != null) {
                                            CourseRequestOption o = new CourseRequestOption();
                                            o.setCourseRequest(cr);
                                            o.setOption(prefs);
                                            cr.getCourseRequestOptions().add(o);
                                        }
                                        cr.setOrder(order++);
                                        cr.setCourseOffering(co);
                                        course2request.put(co.getUniqueId(), cr);
                                    }
                                    while (requests.hasNext()) {
                                        unusedRequests.add(requests.next());
                                        requests.remove();
                                    }
                                    this.getHibSession().saveOrUpdate((Object)cd);
                                    if (mode == EnrollmentMode.IMPORT) {
                                        for (int j4 = 0; j4 < courses.size(); ++j4) {
                                            CourseOffering co;
                                            co = (CourseOffering)courses.get(j4);
                                            Element reqEl = (Element)elements.get(j4);
                                            Map extId2class = (Map)course2extId2class.get(co.getUniqueId());
                                            Map name2class = (Map)course2name2class.get(co.getUniqueId());
                                            HashSet<Long> imported = new HashSet<Long>();
                                            Iterator k = reqEl.elementIterator("class");
                                            while (k.hasNext()) {
                                                Element classElement = (Element)k.next();
                                                Set classes = null;
                                                String classExternalId = classElement.attributeValue("externalId");
                                                if (classExternalId != null && (classes = (Set)extId2class.get(classExternalId)) == null) {
                                                    classes = (Set)name2class.get(classExternalId);
                                                }
                                                if (classes == null) {
                                                    String type = classElement.attributeValue("type");
                                                    String suffix = classElement.attributeValue("suffix");
                                                    if (type != null && suffix != null) {
                                                        classes = (Set)name2class.get(type.trim() + " " + suffix);
                                                    }
                                                }
                                                if (classes == null) {
                                                    this.warn(co.getCourseName() + ": Class " + (classExternalId != null ? classExternalId : classElement.attributeValue("type") + " " + classElement.attributeValue("suffix")) + " not found.");
                                                    continue;
                                                }
                                                CourseRequest request = (CourseRequest)course2request.get(co.getUniqueId());
                                                if (request != null) {
                                                    Iterator<StudentEnrollmentMessage> l = request.getCourseDemand().getEnrollmentMessages().iterator();
                                                    while (l.hasNext()) {
                                                        StudentEnrollmentMessage message = l.next();
                                                        this.getHibSession().delete((Object)message);
                                                        l.remove();
                                                    }
                                                }
                                                for (Class_ clazz : classes) {
                                                    StudentClassEnrollment enrollment;
                                                    if (!imported.add(clazz.getUniqueId()) || (enrollment = (StudentClassEnrollment)enrollments.remove(new StudentEnrollmentImport.Pair(co.getUniqueId(), clazz.getUniqueId()))) != null) continue;
                                                    enrollment = new StudentClassEnrollment();
                                                    enrollment.setStudent(student);
                                                    enrollment.setClazz(clazz);
                                                    enrollment.setCourseOffering(co);
                                                    enrollment.setTimestamp(ts);
                                                    enrollment.setChangedBy(StudentClassEnrollment.SystemChange.IMPORT.toString());
                                                    enrollment.setCourseRequest(request);
                                                    student.getClassEnrollments().add(enrollment);
                                                }
                                            }
                                        }
                                    }
                                }
                            } else if (requestElement.getName().equals("freeTime")) {
                                String days = requestElement.attributeValue("days");
                                String startTime = requestElement.attributeValue("startTime");
                                String length = requestElement.attributeValue("length");
                                String endTime = requestElement.attributeValue("endTime");
                                TimeLocation time = this.makeTime(student.getSession().getDefaultDatePattern(), days, startTime, endTime, length);
                                CourseDemand cd = null;
                                j = remaining.iterator();
                                while (j.hasNext()) {
                                    TimeLocation free2;
                                    CourseDemand adept = (CourseDemand)j.next();
                                    if (adept.getFreeTime() == null || !bl && !(free2 = new TimeLocation(adept.getFreeTime().getDayCode().intValue(), adept.getFreeTime().getStartSlot().intValue(), adept.getFreeTime().getLength().intValue(), 0, 0.0, 0, null, null, student.getSession().getDefaultDatePattern().getPatternBitSet(), 0)).hasIntersection(time)) continue;
                                    cd = adept;
                                    j.remove();
                                    break;
                                }
                                if (cd == null) {
                                    cd = new CourseDemand();
                                    cd.setTimestamp(ts);
                                    student.getCourseDemands().add(cd);
                                    cd.setStudent(student);
                                }
                                cd.setAlternative("true".equals(alternative));
                                cd.setPriority(priority);
                                cd.setWaitlist("true".equals(waitList));
                                free = cd.getFreeTime();
                                if (free == null) {
                                    free = new FreeTime();
                                    cd.setFreeTime(free);
                                }
                                free.setCategory(time.getBreakTime());
                                free.setDayCode(time.getDayCode());
                                free.setStartSlot(time.getStartSlot());
                                free.setLength(time.getLength());
                                free.setSession(student.getSession());
                                free.setName(time.getLongName(true));
                                this.getHibSession().saveOrUpdate((Object)free);
                                this.getHibSession().saveOrUpdate((Object)cd);
                            } else {
                                this.warn("Request element " + requestElement.getName() + " not recognized.");
                            }
                            ++priority;
                        }
                    }
                    if (delCoursesElement != null) {
                        i = delCoursesElement.elementIterator();
                        while (i.hasNext()) {
                            requestElement = (Element)i.next();
                            if (requestElement.getName().equals("courseOffering")) {
                                CourseOffering course = (CourseOffering)hashtable.get(requestElement.attributeValue("subjectArea") + " " + requestElement.attributeValue("courseNumber"));
                                if (course == null) {
                                    this.warn("Course " + requestElement.attributeValue("subjectArea") + " " + requestElement.attributeValue("courseNumber") + " not found.");
                                } else {
                                    BaseCourseDemand cd = null;
                                    Iterator<Object> j = remaining.iterator();
                                    block57: while (j.hasNext()) {
                                        CourseDemand adept = (CourseDemand)j.next();
                                        if (adept.getFreeTime() != null) continue;
                                        for (CourseRequest cr : adept.getCourseRequests()) {
                                            if (!cr.getCourseOffering().getUniqueId().equals(course.getUniqueId())) continue;
                                            cd = adept;
                                            j.remove();
                                            break block57;
                                        }
                                    }
                                    if (cd != null) {
                                        for (CourseRequest cr : cd.getCourseRequests()) {
                                            unusedRequests.add(cr);
                                        }
                                    }
                                }
                            } else if (requestElement.getName().equals("freeTime")) {
                                String days = requestElement.attributeValue("days");
                                String startTime = requestElement.attributeValue("startTime");
                                String length = requestElement.attributeValue("length");
                                String endTime = requestElement.attributeValue("endTime");
                                TimeLocation time = this.makeTime(student.getSession().getDefaultDatePattern(), days, startTime, endTime, length);
                                BaseCourseDemand cd = null;
                                Iterator j = remaining.iterator();
                                while (j.hasNext()) {
                                    CourseDemand adept = (CourseDemand)j.next();
                                    if (adept.getFreeTime() == null || !bl && !(free = new TimeLocation(adept.getFreeTime().getDayCode().intValue(), adept.getFreeTime().getStartSlot().intValue(), adept.getFreeTime().getLength().intValue(), 0, 0.0, 0, null, null, student.getSession().getDefaultDatePattern().getPatternBitSet(), 0)).hasIntersection(time)) continue;
                                    cd = adept;
                                    j.remove();
                                    break;
                                }
                                if (cd != null) {
                                    this.getHibSession().delete((Object)cd.getFreeTime());
                                    student.getCourseDemands().remove(cd);
                                    this.getHibSession().delete((Object)cd);
                                }
                            } else {
                                this.warn("Request element " + requestElement.getName() + " not recognized.");
                            }
                            ++priority;
                        }
                    }
                    if (!bl) {
                        for (CourseDemand cd : remaining) {
                            for (CourseRequest cr : cd.getCourseRequests()) {
                                if (course2request.containsKey(cr.getCourseOffering().getUniqueId())) {
                                    unusedRequests.add(cr);
                                    continue;
                                }
                                course2request.put(cr.getCourseOffering().getUniqueId(), cr);
                                if (mode != EnrollmentMode.IMPORT) continue;
                                for (StudentClassEnrollment e : student.getClassEnrollments()) {
                                    if (!e.getCourseOffering().equals(cr.getCourseOffering())) continue;
                                    enrollments.remove(new StudentEnrollmentImport.Pair(e.getCourseOffering().getUniqueId(), e.getClazz().getUniqueId()));
                                }
                            }
                        }
                        remaining.clear();
                    }
                    if (mode == EnrollmentMode.DELETE || mode == EnrollmentMode.IMPORT) {
                        for (StudentClassEnrollment enrl : enrollments.values()) {
                            student.getClassEnrollments().remove(enrl);
                            enrl.getClazz().getStudentEnrollments().remove(enrl);
                            this.getHibSession().delete((Object)enrl);
                        }
                    } else {
                        i = student.getClassEnrollments().iterator();
                        while (i.hasNext()) {
                            StudentClassEnrollment enrl;
                            enrl = (StudentClassEnrollment)i.next();
                            CourseRequest cr = (CourseRequest)course2request.get(enrl.getCourseOffering().getUniqueId());
                            if (cr == null) {
                                if (mode == EnrollmentMode.NOCHANGE) {
                                    enrl.setCourseRequest(null);
                                    this.getHibSession().saveOrUpdate((Object)enrl);
                                    continue;
                                }
                                enrl.getClazz().getStudentEnrollments().remove(enrl);
                                this.getHibSession().delete((Object)enrl);
                                i.remove();
                                continue;
                            }
                            enrl.setCourseRequest(cr);
                            this.getHibSession().saveOrUpdate((Object)enrl);
                        }
                    }
                    for (CourseRequest cr : unusedRequests) {
                        CourseDemand cd = cr.getCourseDemand();
                        cd.getCourseRequests().remove(cr);
                        this.getHibSession().delete((Object)cr);
                        if (!cd.getCourseRequests().isEmpty()) continue;
                        student.getCourseDemands().remove(cd);
                        this.getHibSession().delete((Object)cd);
                    }
                    for (CourseDemand cd : remaining) {
                        if (cd.getFreeTime() != null) {
                            this.getHibSession().delete((Object)cd.getFreeTime());
                        }
                        for (CourseRequest cr : cd.getCourseRequests()) {
                            this.getHibSession().delete((Object)cr);
                        }
                        student.getCourseDemands().remove(cd);
                        this.getHibSession().delete((Object)cd);
                    }
                    if (!bl) {
                        priority = 0;
                        for (CourseDemand cd : new TreeSet<CourseDemand>(student.getCourseDemands())) {
                            cd.setPriority(priority++);
                            this.getHibSession().saveOrUpdate((Object)cd);
                        }
                    }
                    updatedStudents.add(student.getUniqueId());
                }
                this.getHibSession().update((Object)student);
            }
            this.info(updatedStudents.size() + " students changed");
            if (!updatedStudents.isEmpty()) {
                StudentSectioningQueue.studentChanged(this.getHibSession(), null, session.getUniqueId(), updatedStudents);
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
        }
    }

    private TimeLocation makeTime(DatePattern dp, String days, String startTime, String endTime, String length) {
        int dayCode = 0;
        if (days.contains("Th")) {
            dayCode += Constants.DAY_CODES[3];
            days = days.replace("Th", "..");
        }
        if (days.contains("R")) {
            dayCode += Constants.DAY_CODES[3];
            days = days.replace("R", ".");
        }
        if (days.contains("Su")) {
            dayCode += Constants.DAY_CODES[6];
            days = days.replace("Su", "..");
        }
        if (days.contains("U")) {
            dayCode += Constants.DAY_CODES[6];
            days = days.replace("U", ".");
        }
        if (days.contains("M")) {
            dayCode += Constants.DAY_CODES[0];
            days = days.replace("M", ".");
        }
        if (days.contains("T")) {
            dayCode += Constants.DAY_CODES[1];
            days = days.replace("T", ".");
        }
        if (days.contains("W")) {
            dayCode += Constants.DAY_CODES[2];
            days = days.replace("W", ".");
        }
        if (days.contains("F")) {
            dayCode += Constants.DAY_CODES[4];
            days = days.replace("F", ".");
        }
        if (days.contains("S")) {
            dayCode += Constants.DAY_CODES[5];
            days = days.replace("S", ".");
        }
        int startSlot = (Integer.parseInt(startTime) / 100 * 60 + Integer.parseInt(startTime) % 100 - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
        int nrSlots = 0;
        nrSlots = length != null ? Integer.parseInt(length) / Constants.SLOT_LENGTH_MIN : (Integer.parseInt(endTime) / 100 * 60 + Integer.parseInt(endTime) % 100 - (Integer.parseInt(startTime) / 100 * 60 + Integer.parseInt(startTime) % 100)) / Constants.SLOT_LENGTH_MIN;
        return new TimeLocation(dayCode, startSlot, nrSlots, 0, 0.0, dp.getUniqueId(), dp.getName(), dp.getPatternBitSet(), 0);
    }

    private boolean eq(String a, String b) {
        return a == null ? b == null : a.equals(b);
    }

    protected OnlineSectioningLog.CourseRequestOption getPreferences(Element requestEl, CourseOffering course, Map<String, Set<Class_>> extId2class, Map<String, Set<Class_>> name2class, Map<String, InstructionalMethod> ref2im, Map<String, InstructionalMethod> name2im) {
        Element prefEl = requestEl.element("preferences");
        if (prefEl == null) {
            return null;
        }
        OnlineSectioningLog.CourseRequestOption.Builder preferences = OnlineSectioningLog.CourseRequestOption.newBuilder();
        preferences.setType(OnlineSectioningLog.CourseRequestOption.OptionType.REQUEST_PREFERENCE);
        HashSet<Class_> preferredClasses = new HashSet<Class_>();
        Iterator i = prefEl.elementIterator("class");
        while (i.hasNext()) {
            Element classElement = (Element)i.next();
            Set<Class_> classes = null;
            String classExternalId = classElement.attributeValue("externalId");
            if (classExternalId != null && (classes = extId2class.get(classExternalId)) == null) {
                classes = name2class.get(classExternalId);
            }
            if (classes == null) {
                String type = classElement.attributeValue("type");
                String suffix = classElement.attributeValue("suffix");
                if (type != null && suffix != null) {
                    classes = name2class.get(type.trim() + " " + suffix);
                }
            }
            if (classes == null) {
                this.warn(course.getCourseName() + ": Class " + (classExternalId != null ? classExternalId : classElement.attributeValue("type") + " " + classElement.attributeValue("suffix")) + " not found.");
                continue;
            }
            preferredClasses.addAll(classes);
        }
        for (Class_ clazz : preferredClasses) {
            preferences.addSection(OnlineSectioningHelper.toProto(clazz, course));
        }
        HashSet<InstructionalMethod> preferredIMs = new HashSet<InstructionalMethod>();
        Iterator i2 = prefEl.elementIterator("instructional-method");
        while (i2.hasNext()) {
            String imName;
            Element imElement = (Element)i2.next();
            InstructionalMethod meth = null;
            String imExternalId = imElement.attributeValue("externalId", imElement.attributeValue("id"));
            if (imExternalId != null) {
                meth = ref2im.get(imExternalId);
            }
            if (meth == null && (imName = imElement.attributeValue("name")) != null) {
                meth = name2im.get(imName);
            }
            if (meth == null) {
                this.warn(course.getCourseName() + ": Instructional Method " + (imExternalId != null ? imExternalId : imElement.attributeValue("name")) + " not found.");
                continue;
            }
            preferredIMs.add(meth);
        }
        for (InstructionalMethod meth : preferredIMs) {
            preferences.addInstructionalMethod(OnlineSectioningLog.Entity.newBuilder().setUniqueId(meth.getUniqueId()).setExternalId(meth.getReference()).setName(meth.getLabel()));
        }
        return preferences.build();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnrollmentMode {
        DELETE("Student enrollments will be deleted."),
        IMPORT("Student enrollments will be imported."),
        NOCHANGE("Student enrollments will be left unchanged"),
        UPDATE("Student enrollments will be updated (only enrollments that are no longer requested will be deleted)");

        private String iText;

        private EnrollmentMode(String text) {
            this.iText = text;
        }

        public String toString() {
            return this.iText;
        }
    }
}

