/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.Date;
import java.util.Properties;
import org.cpsolver.ifs.util.ToolBox;
import org.dom4j.Document;
import org.dom4j.Element;
import org.hibernate.criterion.Order;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.dataexchange.BaseExport;
import org.unitime.timetable.model.Roles;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.RolesDAO;
import org.unitime.timetable.security.rights.Right;

public class PermissionsExport
extends BaseExport {
    public void saveXml(Document document, Session session, Properties parameters) throws Exception {
        try {
            this.beginTransaction();
            Element root = document.addElement("permissions");
            root.addAttribute("created", new Date().toString());
            document.addDocType("permissions", "-//UniTime//DTD University Course Timetabling/EN", "http://www.unitime.org/interface/Permissions.dtd");
            for (Roles role : RolesDAO.getInstance().findAll(this.getHibSession(), Order.asc((String)"abbv"))) {
                Element r = root.addElement("role");
                r.addAttribute("reference", role.getReference());
                r.addAttribute("name", role.getAbbv());
                r.addAttribute("manager", role.isManager() != false ? "true" : "false");
                r.addAttribute("enabled", role.isEnabled() != false ? "true" : "false");
                r.addAttribute("instructor", role.isInstructor() != false ? "true" : "false");
                for (Right right : Right.values()) {
                    if (!role.hasRight(right)) continue;
                    r.addElement("right").setText(right.name());
                }
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                args = new String[]{"/Users/muller/permissions.xml"};
            }
            ToolBox.configureLogging();
            HibernateUtil.configureHibernate(ApplicationProperties.getProperties());
            new PermissionsExport().saveXml(args[0], null, ApplicationProperties.getProperties());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

