/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseExport;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.LastLikeCourseDemand;
import org.unitime.timetable.model.Session;

public class LastLikeCourseDemandExport
extends BaseExport {
    public void saveXml(Document document, Session session, Properties parameters) throws Exception {
        try {
            this.beginTransaction();
            Element root = document.addElement("lastLikeCourseDemand");
            root.addAttribute("campus", session.getAcademicInitiative());
            root.addAttribute("year", session.getAcademicYear());
            root.addAttribute("term", session.getAcademicTerm());
            root.addAttribute("created", new Date().toString());
            document.addDocType("lastLikeCourseDemand", "-//UniTime//DTD University Course Timetabling/EN", "http://www.unitime.org/interface/StudentCourse.dtd");
            String lastExternalId = null;
            Element studentEl = null;
            Hashtable<String, CourseOffering> permId2course = new Hashtable<String, CourseOffering>();
            for (CourseOffering course : this.getHibSession().createQuery("from CourseOffering co where co.subjectArea.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                if (course.getPermId() == null) continue;
                permId2course.put(course.getPermId(), course);
            }
            for (LastLikeCourseDemand demand : this.getHibSession().createQuery("from LastLikeCourseDemand d where d.subjectArea.session.uniqueId = :sessionId order by d.student.externalUniqueId, d.priority, d.subjectArea.subjectAreaAbbreviation, d.courseNbr").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                CourseOffering course;
                if (!demand.getStudent().getExternalUniqueId().equals(lastExternalId)) {
                    lastExternalId = demand.getStudent().getExternalUniqueId();
                    studentEl = root.addElement("student");
                    studentEl.addAttribute("externalId", lastExternalId);
                }
                Element demandEl = studentEl.addElement("studentCourse");
                CourseOffering courseOffering = course = demand.getCoursePermId() == null ? null : (CourseOffering)permId2course.get(demand.getCoursePermId());
                if (course == null) {
                    demandEl.addAttribute("subject", demand.getSubjectArea().getSubjectAreaAbbreviation());
                    demandEl.addAttribute("courseNumber", demand.getCourseNbr());
                    continue;
                }
                demandEl.addAttribute("subject", course.getSubjectAreaAbbv());
                demandEl.addAttribute("courseNumber", course.getCourseNbr());
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
        }
    }
}

