/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.authenticate.jaas;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.authenticate.jaas.AuthenticateModule;
import org.unitime.timetable.authenticate.jaas.AuthenticatedUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class LdapAuthenticateModule
extends AuthenticateModule {
    private static Logger sLog = Logger.getLogger(LdapAuthenticateModule.class);
    private String iExternalUid;

    @Override
    public boolean abort() throws LoginException {
        if (!this.isAuthSucceeded()) {
            return false;
        }
        if (this.isAuthSucceeded() && !this.isCommitSucceeded()) {
            this.reset();
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.isAuthSucceeded()) {
            if (this.iExternalUid == null || this.iExternalUid.trim().length() == 0) {
                throw new LoginException("External UID not found");
            }
            this.getSubject().getPrincipals().add(new AuthenticatedUser(this.getUser(), this.iExternalUid));
            this.setCommitSucceeded(true);
            return true;
        }
        this.reset();
        return false;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.iExternalUid = null;
    }

    @Override
    public boolean login() throws LoginException {
        if (ApplicationProperties.getProperty("tmtbl.authenticate.ldap.provider") == null) {
            return false;
        }
        sLog.debug((Object)"Performing ldap authentication ... ");
        if (this.getCallbackHandler() == null) {
            throw new LoginException("Error: no CallbackHandler available ");
        }
        Callback[] callbacks = new Callback[]{new NameCallback("User Name: "), new PasswordCallback("Password: ", true)};
        try {
            this.getCallbackHandler().handle(callbacks);
            String n = ((NameCallback)callbacks[0]).getName();
            String p = String.valueOf(((PasswordCallback)callbacks[1]).getPassword());
            HashMap<String, String> userProps = new HashMap<String, String>();
            userProps.put("username", n);
            userProps.put("password", p);
            if (this.doAuthenticate(userProps)) {
                return true;
            }
            sLog.debug((Object)"Ldap authentication failed ... ");
            this.setAuthSucceeded(false);
            return false;
        }
        catch (Exception ex) {
            sLog.debug((Object)("Ldap authentication failed ... " + ex.getMessage()), (Throwable)ex);
            this.setAuthSucceeded(false);
            return false;
        }
    }

    @Override
    public boolean logout() throws LoginException {
        this.reset();
        return true;
    }

    @Override
    public void reset() {
        this.iExternalUid = null;
        super.reset();
    }

    private static Hashtable<String, String> getEnv() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", ApplicationProperties.getProperty("tmtbl.authenticate.ldap.ctxFactory", "com.sun.jndi.ldap.LdapCtxFactory"));
        env.put("java.naming.provider.url", ApplicationProperties.getProperty("tmtbl.authenticate.ldap.provider"));
        env.put("java.naming.referral", ApplicationProperties.getProperty("tmtbl.authenticate.ldap.referral", "ignore"));
        if (ApplicationProperties.getProperty("tmtbl.authenticate.ldap.version") != null) {
            env.put("java.naming.ldap.version", ApplicationProperties.getProperty("tmtbl.authenticate.ldap.version"));
        }
        env.put("java.naming.security.authentication", ApplicationProperties.getProperty("tmtbl.authenticate.ldap.security", "simple"));
        if (ApplicationProperties.getProperty("tmtbl.authenticate.ldap.socketFactory") != null) {
            env.put("java.naming.ldap.factory.socket", ApplicationProperties.getProperty("tmtbl.authenticate.ldap.socketFactory"));
        }
        if (ApplicationProperties.getProperty("tmtbl.authenticate.ldap.ssl.keyStore") != null) {
            System.setProperty("javax.net.ssl.keyStore", ApplicationProperties.getProperty("tmtbl.authenticate.ldap.ssl.keyStore").replaceAll("%WEB-INF%", ApplicationProperties.getBasePath()));
        }
        if (ApplicationProperties.getProperty("tmtbl.authenticate.ldap.ssl.trustStore") != null) {
            System.setProperty("javax.net.ssl.trustStore", ApplicationProperties.getProperty("tmtbl.authenticate.ldap.ssl.trustStore").replaceAll("%WEB-INF%", ApplicationProperties.getBasePath()));
        }
        if (ApplicationProperties.getProperty("tmtbl.authenticate.ldap.ssl.trustStorePassword") != null) {
            System.setProperty("javax.net.ssl.keyStorePassword", ApplicationProperties.getProperty("tmtbl.authenticate.ldap.ssl.keyStorePassword"));
        }
        if (ApplicationProperties.getProperty("tmtbl.authenticate.ldap.ssl.trustStorePassword") != null) {
            System.setProperty("javax.net.ssl.trustStorePassword", ApplicationProperties.getProperty("tmtbl.authenticate.ldap.ssl.trustStorePassword"));
        }
        if (ApplicationProperties.getProperty("tmtbl.authenticate.ldap.ssl.trustStoreType") != null) {
            System.setProperty("javax.net.ssl.trustStoreType", ApplicationProperties.getProperty("tmtbl.authenticate.ldap.ssl.trustStoreType"));
        }
        return env;
    }

    public static DirContext getDirContext() throws NamingException {
        return new InitialDirContext(LdapAuthenticateModule.getEnv());
    }

    @Override
    public boolean doAuthenticate(HashMap userProps) throws Exception {
        if (ApplicationProperties.getProperty("tmtbl.authenticate.ldap.provider") == null) {
            throw new Exception("Ldap provider is not set.");
        }
        String principal = ApplicationProperties.getProperty("tmtbl.authenticate.ldap.principal");
        if (principal == null) {
            throw new Exception("Ldap principal is not set.");
        }
        String query = ApplicationProperties.getProperty("tmtbl.authenticate.ldap.query");
        if (query == null) {
            throw new Exception("Ldap query is not set.");
        }
        String n = (String)userProps.get("username");
        String p = (String)userProps.get("password");
        Hashtable<String, String> env = LdapAuthenticateModule.getEnv();
        env.put("java.naming.security.principal", principal.replaceAll("%", n));
        env.put("java.naming.security.credentials", p);
        InitialDirContext cx = new InitialDirContext(env);
        String idAttributeName = ApplicationProperties.getProperty("tmtbl.authenticate.ldap.externalId", "uid");
        Attributes attributes = cx.getAttributes(query.replaceAll("%", n), new String[]{idAttributeName});
        Attribute idAttribute = attributes.get(idAttributeName);
        if (idAttribute != null) {
            sLog.debug((Object)"Ldap authentication passed ... ");
            this.setAuthSucceeded(true);
            this.iExternalUid = (String)idAttribute.get();
            try {
                if (this.iExternalUid != null && ApplicationProperties.getProperty("tmtbl.authenticate.ldap.externalId.format") != null) {
                    this.iExternalUid = new DecimalFormat(ApplicationProperties.getProperty("tmtbl.authenticate.ldap.externalId.format")).format(Long.parseLong(this.iExternalUid));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.setUser(n);
            return true;
        }
        return false;
    }
}

