/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.util.MessageResources;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.timetable.action.PreferencesAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.ExamEditForm;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamEvent;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SolverParameterDef;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.InstrOfferingConfigDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.Navigation;

@Service(value="/examEdit")
public class ExamEditAction
extends PreferencesAction {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExamEditForm frm = (ExamEditForm)form;
        try {
            int i;
            ExamType type;
            Exam exam;
            super.execute(mapping, form, request, response);
            MessageResources rsc = this.getResources(request);
            ActionMessages errors = new ActionMessages();
            String examId = request.getParameter("examId");
            String op = frm.getOp();
            String reloadCause = request.getParameter("reloadCause");
            String deleteType = request.getParameter("deleteType");
            if (op.equals(rsc.getMessage("button.reload")) || op.equals(rsc.getMessage("button.addObject")) || op.equals(rsc.getMessage("button.addPeriod")) || op.equals(rsc.getMessage("button.addRoomPref")) || op.equals(rsc.getMessage("button.addBldgPref")) || op.equals(rsc.getMessage("button.addRoomFeaturePref")) || op.equals(rsc.getMessage("button.addDistPref")) || op.equals(rsc.getMessage("button.addRoomGroupPref")) || op.equals(rsc.getMessage("button.addInstructor")) || op.equals(rsc.getMessage("button.updateExam")) || op.equals(rsc.getMessage("button.cancel")) || op.equals(rsc.getMessage("button.clearExamPrefs")) || op.equals(rsc.getMessage("button.delete")) || op.equals(rsc.getMessage("button.saveExam")) || op.equals(rsc.getMessage("button.addExam")) || op.equals(rsc.getMessage("button.returnToDetail")) || op.equals(rsc.getMessage("button.nextExam")) || op.equals(rsc.getMessage("button.previousExam"))) {
                examId = frm.getExamId();
            }
            if (op == null || op.trim().length() == 0 || op.equals(rsc.getMessage("button.reload")) && (reloadCause == null || reloadCause.trim().length() == 0)) {
                op = deleteType != null && deleteType.length() > 0 ? "delete" : "init";
            }
            if (op == null || op.trim() == "") {
                throw new Exception("Null Operation not supported.");
            }
            Exam exam2 = exam = examId == null || examId.trim().length() == 0 ? null : (Exam)new ExamDAO().get(Long.valueOf(examId));
            if (exam != null) {
                this.sessionContext.checkPermission((Serializable)((Object)examId), "Exam", Right.ExaminationEdit);
            }
            if (exam == null) {
                this.sessionContext.checkPermission(Right.ExaminationAdd);
            }
            boolean timeVertical = CommonValues.VerticalGrid.eq(this.sessionContext.getUser().getProperty(UserProperty.GridOrientation));
            if (op.equals(rsc.getMessage("button.returnToDetail"))) {
                if (BackTracker.hasBack(request, 1)) {
                    BackTracker.doBack(request, response);
                    return null;
                }
                if (examId != null && examId.trim() != "") {
                    ActionRedirect redirect = new ActionRedirect((ForwardConfig)mapping.findForward("showDetail"));
                    redirect.addParameter("examId", (Object)examId);
                    return redirect;
                }
                return mapping.findForward("showList");
            }
            if (exam != null && op.equals(rsc.getMessage("button.clearExamPrefs"))) {
                this.sessionContext.checkPermission(exam, Right.ExaminationEditClearPreferences);
                Set<Preference> s = exam.getPreferences();
                s.clear();
                exam.setPreferences(s);
                new ExamDAO().update(exam);
                op = "init";
                ChangeLog.addChange(null, this.sessionContext, exam, ChangeLog.Source.EXAM_EDIT, ChangeLog.Operation.CLEAR_PREF, exam.firstSubjectArea(), exam.firstDepartment());
                ActionRedirect redirect = new ActionRedirect((ForwardConfig)mapping.findForward("showDetail"));
                redirect.addParameter("examId", (Object)examId);
                return redirect;
            }
            if (op.equals("init")) {
                frm.reset(mapping, request);
                this.doLoad(request, frm, exam);
                if ("true".equals(request.getParameter("clone"))) {
                    frm.setExamId(null);
                    frm.setClone(true);
                }
            }
            if (ApplicationProperty.ExaminationSizeUseLimitInsteadOfEnrollment.isTrue((type = (ExamType)ExamTypeDAO.getInstance().get(frm.getExamType())).getReference(), type.getType() != 0)) {
                frm.setSizeNote("A number of enrolled students or a total limit of selected classes/courses (whichever is bigger) is used when blank");
            } else {
                frm.setSizeNote("A number of enrolled students is used when blank");
            }
            frm.setLabel(frm.getClone() || exam == null ? "New Examination" : exam.getLabel());
            if (op.equals(rsc.getMessage("button.addInstructor"))) {
                for (i = 0; i < 2; ++i) {
                    frm.getInstructors().add("-");
                }
            }
            if (op.equals(rsc.getMessage("button.addObject"))) {
                for (i = 0; i < 2; ++i) {
                    frm.addExamOwner(null);
                }
                request.setAttribute("hash", (Object)"objects");
            }
            long deleteId = -1L;
            try {
                deleteId = Long.parseLong(request.getParameter("deleteId"));
            }
            catch (Exception e) {
                deleteId = -1L;
            }
            if ("instructor".equals(deleteType) && deleteId >= 0L) {
                frm.getInstructors().remove((int)deleteId);
            } else if ("examType".equals(deleteType) && deleteId >= 0L) {
                frm.setExamType(deleteId);
            } else if ("objects".equals(deleteType) && deleteId >= 0L) {
                frm.deleteExamOwner((int)deleteId);
            }
            if (op.equals(rsc.getMessage("button.updateExam")) || op.equals(rsc.getMessage("button.saveExam")) || op.equals(rsc.getMessage("button.nextExam")) || op.equals(rsc.getMessage("button.previousExam"))) {
                errors = frm.validate(mapping, request);
                if (errors.size() == 0) {
                    this.doUpdate(request, frm, exam);
                    if (op.equals(rsc.getMessage("button.nextExam"))) {
                        response.sendRedirect(response.encodeURL("examEdit.do?examId=" + frm.getNextId()));
                        return null;
                    }
                    if (op.equals(rsc.getMessage("button.previousExam"))) {
                        response.sendRedirect(response.encodeURL("examEdit.do?examId=" + frm.getPreviousId()));
                        return null;
                    }
                    if (op.equals(rsc.getMessage("button.saveExam")) && BackTracker.hasBack(request, 2) && !frm.getClone()) {
                        request.setAttribute("backType", (Object)"PreferenceGroup");
                        request.setAttribute("backId", (Object)frm.getExamId());
                        BackTracker.doBack(request, response);
                        return null;
                    }
                    ActionRedirect redirect = new ActionRedirect((ForwardConfig)mapping.findForward("showDetail"));
                    redirect.addParameter("examId", (Object)frm.getExamId());
                    return redirect;
                }
                this.saveErrors(request, errors);
            }
            frm.setAvailableTimePatterns(null);
            if (op.equals("init")) {
                this.initPrefs(frm, exam, null, true);
            }
            this.generateExamPeriodGrid(request, frm, frm.getClone() ? null : exam, op, timeVertical, true);
            this.processPrefAction(request, frm, errors);
            this.setupInstructors(request, frm, exam);
            LookupTables.setupExamTypes(request, this.sessionContext.getUser(), DepartmentStatusType.Status.ExamTimetable, DepartmentStatusType.Status.ExamEdit);
            if (exam != null) {
                LookupTables.setupRooms(request, exam);
                LookupTables.setupBldgs(request, exam);
                LookupTables.setupRoomFeatures(request, exam);
                LookupTables.setupRoomGroups(request, exam);
            } else {
                Exam dummy = new Exam();
                dummy.setSession((Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId()));
                dummy.setExamType((ExamType)ExamTypeDAO.getInstance().get(frm.getExamType()));
                LookupTables.setupRooms(request, dummy);
                LookupTables.setupBldgs(request, dummy);
                LookupTables.setupRoomFeatures(request, dummy);
                LookupTables.setupRoomGroups(request, dummy);
            }
            frm.setAllowHardPrefs(this.sessionContext.hasPermission(exam, Right.CanUseHardPeriodPrefs));
            frm.setSubjectAreas(SubjectArea.getUserSubjectAreas(this.sessionContext.getUser(), false));
            if (!frm.getClone() && exam != null) {
                BackTracker.markForBack(request, "examDetail.do?examId=" + frm.getExamId(), "Exam (" + (frm.getName() == null || frm.getName().length() == 0 ? frm.getLabel().trim() : frm.getName().trim()) + ")", true, false);
            }
            return frm.getClone() || exam == null ? mapping.findForward("showAdd") : mapping.findForward("showEdit");
        }
        catch (Exception e) {
            Debug.error(e);
            throw e;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void doLoad(HttpServletRequest request, ExamEditForm frm, Exam exam) {
        if (exam != null) {
            frm.setExamId(exam.getUniqueId().toString());
            frm.setExamType(exam.getExamType().getUniqueId());
            frm.setName(exam.generateName().equals(exam.getName()) != false ? null : exam.getName());
            frm.setNote(exam.getNote());
            frm.setLength(exam.getLength());
            frm.setSize(exam.getExamSize() == null ? null : exam.getExamSize().toString());
            frm.setPrintOffset(exam.getPrintOffset() == null || exam.getPrintOffset() == 0 ? null : exam.getPrintOffset().toString());
            frm.setSeatingType(Exam.sSeatingTypes[exam.getSeatingType()]);
            frm.setMaxNbrRooms(exam.getMaxNbrRooms());
            frm.setAccommodation(StudentAccomodation.toHtml(StudentAccomodation.getAccommodations(exam)));
            instructors = new TreeSet<DepartmentalInstructor>(exam.getInstructors());
            for (DepartmentalInstructor instr : instructors) {
                frm.getInstructors().add(instr.getUniqueId().toString());
            }
            nextId = Navigation.getNext(this.sessionContext, Navigation.sInstructionalOfferingLevel, exam.getUniqueId());
            prevId = Navigation.getPrevious(this.sessionContext, Navigation.sInstructionalOfferingLevel, exam.getUniqueId());
            frm.setPreviousId(prevId == null ? null : prevId.toString());
            frm.setNextId(nextId == null ? null : nextId.toString());
            i = new TreeSet<ExamOwner>(exam.getOwners()).iterator();
            while (i.hasNext()) {
                frm.addExamOwner(i.next());
            }
        } else {
            try {
                periods = ExamPeriod.findAll(this.sessionContext.getUser().getCurrentAcademicSessionId(), frm.getExamType());
                if (!periods.isEmpty()) {
                    frm.setLength(Constants.SLOT_LENGTH_MIN * periods.first().getLength());
                }
                if ((maxRoomsParam = SolverParameterDef.findByNameType("Exams.MaxRooms", SolverParameterGroup.SolverType.EXAM)) == null || maxRoomsParam.getDefault() == null) ** GOTO lbl35
                frm.setMaxNbrRooms(Integer.valueOf(maxRoomsParam.getDefault()));
            }
            catch (Exception periods) {
                // empty catch block
            }
        }
lbl35:
        // 4 sources

        if (request.getParameter("firstType") != null && request.getParameter("firstId") != null) {
            firstType = request.getParameter("firstType");
            firstId = Long.valueOf(request.getParameter("firstId"));
            if ("Class_".equals(firstType)) {
                clazz = (Class_)new Class_DAO().get(firstId);
                frm.getSubjectArea().add(clazz.getSchedulingSubpart().getControllingCourseOffering().getSubjectArea().getUniqueId());
                frm.getCourseNbr().add(clazz.getSchedulingSubpart().getControllingCourseOffering().getUniqueId());
                frm.getItype().add(clazz.getSchedulingSubpart().getUniqueId());
                frm.getClassNumber().add(clazz.getUniqueId());
            } else if ("SchedulingSubpart".equals(firstType)) {
                subpart = (SchedulingSubpart)new SchedulingSubpartDAO().get(firstId);
                config = subpart.getInstrOfferingConfig();
                frm.getSubjectArea().add(config.getControllingCourseOffering().getSubjectArea().getUniqueId());
                frm.getCourseNbr().add(config.getControllingCourseOffering().getUniqueId());
                frm.getItype().add(-config.getUniqueId().longValue());
                frm.getClassNumber().add(new Long(-1L));
            } else if ("InstrOfferingConfig".equals(firstType)) {
                config = (InstrOfferingConfig)new InstrOfferingConfigDAO().get(firstId);
                frm.getSubjectArea().add(config.getControllingCourseOffering().getSubjectArea().getUniqueId());
                frm.getCourseNbr().add(config.getControllingCourseOffering().getUniqueId());
                frm.getItype().add(-config.getUniqueId().longValue());
                frm.getClassNumber().add(new Long(-1L));
            } else if ("InstructionalOffering".equals(firstType)) {
                offering = (InstructionalOffering)new InstructionalOfferingDAO().get(firstId);
                frm.getSubjectArea().add(offering.getControllingCourseOffering().getSubjectArea().getUniqueId());
                frm.getCourseNbr().add(offering.getControllingCourseOffering().getUniqueId());
                frm.getItype().add(-9223372036854775807L);
                frm.getClassNumber().add(new Long(-1L));
            } else if ("CourseOffering".equals(firstType)) {
                course = (CourseOffering)new CourseOfferingDAO().get(firstId);
                frm.getSubjectArea().add(course.getSubjectArea().getUniqueId());
                frm.getCourseNbr().add(course.getUniqueId());
                frm.getItype().add(-9223372036854775808L);
                frm.getClassNumber().add(new Long(-1L));
            }
        }
        for (i = 0; i < 2; ++i) {
            frm.addExamOwner(null);
            frm.getInstructors().add(Constants.BLANK_OPTION_VALUE);
        }
    }

    protected void setupInstructors(HttpServletRequest request, ExamEditForm frm, Exam exam) throws Exception {
        List instructors = frm.getInstructors();
        if (instructors.size() == 0) {
            return;
        }
        HashSet<Long> deptIds = new HashSet<Long>();
        if (exam != null) {
            for (DepartmentalInstructor instr : exam.getInstructors()) {
                deptIds.add(instr.getDepartment().getUniqueId());
            }
            for (ExamOwner own : exam.getOwners()) {
                deptIds.add(own.getCourse().getDepartment().getUniqueId());
            }
        } else {
            for (int i = 0; i < frm.getSubjectAreaList().size(); ++i) {
                ExamOwner own;
                own = frm.getExamOwner(i);
                if (own == null) continue;
                deptIds.add(own.getCourse().getDepartment().getUniqueId());
            }
            if (deptIds.isEmpty()) {
                for (Department dept : Department.getUserDepartments(this.sessionContext.getUser())) {
                    deptIds.add(dept.getUniqueId());
                }
            }
        }
        Long[] deptsIdsArray = new Long[deptIds.size()];
        int idx = 0;
        Iterator i = deptIds.iterator();
        while (i.hasNext()) {
            deptsIdsArray[idx++] = (Long)i.next();
        }
        LookupTables.setupInstructors(request, this.sessionContext, deptsIdsArray);
        Vector deptInstrList = (Vector)request.getAttribute(DepartmentalInstructor.INSTR_LIST_ATTR_NAME);
        for (int i2 = 0; i2 < instructors.size(); ++i2) {
            request.setAttribute(DepartmentalInstructor.INSTR_LIST_ATTR_NAME + i2, (Object)deptInstrList);
        }
    }

    protected void doUpdate(HttpServletRequest request, ExamEditForm frm, Exam exam) throws Exception {
        int oldPrintOffset;
        Set<Preference> s;
        boolean add = false;
        if (exam == null) {
            add = true;
            exam = new Exam();
            exam.setSession((Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId()));
            exam.setExamType((ExamType)ExamTypeDAO.getInstance().get(frm.getExamType()));
        }
        if ((s = exam.getPreferences()) == null) {
            s = new HashSet<Preference>();
        }
        Iterator<Preference> i = s.iterator();
        while (i.hasNext()) {
            Preference p = i.next();
            if (p instanceof DistributionPref) continue;
            i.remove();
        }
        super.doUpdate(request, frm, exam, s, false, Preference.Type.PERIOD, Preference.Type.ROOM, Preference.Type.ROOM_FEATURE, Preference.Type.ROOM_GROUP, Preference.Type.BUILDING);
        exam.setNote(frm.getNote());
        exam.setSeatingType(frm.getSeatingTypeIdx());
        Integer oldLength = exam.getLength();
        exam.setLength((int)frm.getLength());
        if (frm.getSize() == null || frm.getSize().length() == 0) {
            exam.setExamSize(null);
        } else {
            exam.setExamSize(Integer.valueOf(frm.getSize()));
        }
        int n = oldPrintOffset = exam.getPrintOffset() == null ? 0 : exam.getPrintOffset();
        if (frm.getPrintOffset() == null || frm.getPrintOffset().length() == 0) {
            exam.setPrintOffset(null);
        } else {
            exam.setPrintOffset(Integer.valueOf(frm.getPrintOffset()));
        }
        exam.setMaxNbrRooms((int)frm.getMaxNbrRooms());
        if (exam.getInstructors() == null) {
            exam.setInstructors(new HashSet<DepartmentalInstructor>());
        }
        Iterator<DepartmentalInstructor> i2 = exam.getInstructors().iterator();
        while (i2.hasNext()) {
            DepartmentalInstructor instructor = i2.next();
            instructor.getExams().remove(exam);
            i2.remove();
        }
        for (String instructorId : frm.getInstructors()) {
            DepartmentalInstructor instructor;
            if (Constants.BLANK_OPTION_VALUE.equals(instructorId) || "-".equals(instructorId) || (instructor = (DepartmentalInstructor)new DepartmentalInstructorDAO().get(Long.valueOf(instructorId))) == null) continue;
            exam.getInstructors().add(instructor);
            instructor.getExams().add(exam);
        }
        frm.setExamOwners(exam);
        if (frm.getName() == null || frm.getName().trim().length() == 0) {
            exam.setName(exam.generateName());
        } else {
            exam.setName(frm.getName());
        }
        ExamEvent event = exam.getEvent();
        if (event != null) {
            event.setEventName(exam.getName());
            if (!(exam.getAssignedPeriod() == null || exam.getLength().equals(oldLength) && oldPrintOffset == (exam.getPrintOffset() == null ? 0 : exam.getPrintOffset()))) {
                for (Meeting m : event.getMeetings()) {
                    m.setStartOffset(new Integer(exam.getAssignedPeriod().getExamEventStartOffsetForExam(exam)));
                    m.setStopOffset(new Integer(exam.getAssignedPeriod().getExamEventStopOffsetForExam(exam)));
                }
            }
        }
        exam.generateDefaultPreferences(false);
        new ExamDAO().saveOrUpdate(exam);
        ChangeLog.addChange(null, this.sessionContext, exam, ChangeLog.Source.EXAM_EDIT, add ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, exam.firstSubjectArea(), exam.firstDepartment());
        if (add) {
            frm.setExamId(exam.getUniqueId().toString());
        }
    }
}

