/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.localization.impl;

import com.google.gwt.i18n.client.Constants;
import com.google.gwt.i18n.client.Messages;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.unitime.localization.impl.LocalizedLookupDispatchAction;
import org.unitime.localization.messages.Messages;
import org.unitime.timetable.defaults.ApplicationProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Localization {
    private static Log sLog = LogFactory.getLog(Localization.class);
    public static final String ROOT = "org.unitime.localization.messages.";
    public static final String GWTROOT = "org.unitime.timetable.gwt.resources.";
    private static Map<Class, Object> sBundles = new Hashtable<Class, Object>();
    private static final ThreadLocal<String> sLocale = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return ApplicationProperty.Locale.value();
        }
    };
    private static final ThreadLocal<Locale> sJavaLocale = new ThreadLocal<Locale>(){

        @Override
        protected Locale initialValue() {
            return Localization.guessJavaLocale(ApplicationProperty.Locale.value());
        }
    };

    public static void setLocale(String locale) {
        sLocale.set(locale);
        sJavaLocale.set(Localization.guessJavaLocale(locale));
    }

    public static void removeLocale() {
        sLocale.remove();
        sJavaLocale.remove();
    }

    public static String getLocale() {
        return sLocale.get();
    }

    public static Locale getJavaLocale() {
        return sJavaLocale.get();
    }

    public static DateFormat getDateFormat(String pattern) {
        return new SimpleDateFormat(pattern, Localization.getJavaLocale());
    }

    public static NumberFormat getNumberFormat(String pattern) {
        return new DecimalFormat(pattern, new DecimalFormatSymbols(Localization.getJavaLocale()));
    }

    public static String getFirstLocale() {
        String locale = Localization.getLocale();
        if (locale.indexOf(44) >= 0) {
            locale = locale.substring(0, locale.indexOf(44));
        }
        if (locale.indexOf(59) >= 0) {
            locale = locale.substring(0, locale.indexOf(59));
        }
        return locale.trim();
    }

    private static Locale guessJavaLocale(String locale) {
        StringTokenizer s = new StringTokenizer(locale, ",;");
        while (s.hasMoreTokens()) {
            String lang = s.nextToken();
            String cc = null;
            if (lang.indexOf(95) >= 0) {
                cc = lang.substring(lang.indexOf(95) + 1);
                lang = lang.substring(0, lang.indexOf(95));
            }
            for (Locale loc : Locale.getAvailableLocales()) {
                if (lang != null && !lang.isEmpty() && !lang.equals(loc.getLanguage()) || cc != null && !cc.isEmpty() && !cc.equals(loc.getCountry())) continue;
                return loc;
            }
        }
        return Locale.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T create(Class<T> bundle) {
        Map<Class, Object> map = sBundles;
        synchronized (map) {
            Object ret = sBundles.get(bundle);
            if (ret == null) {
                ret = Proxy.newProxyInstance(Localization.class.getClassLoader(), new Class[]{bundle, StrutsActionsRetriever.class}, (InvocationHandler)new Bundle(bundle));
                sBundles.put(bundle, ret);
            }
            return (T)ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface StrutsActionsRetriever {
        public Map<String, String> getStrutsActions(Class<? extends LocalizedLookupDispatchAction> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Bundle
    implements InvocationHandler {
        private Map<String, Properties> iProperties = new Hashtable<String, Properties>();
        private Class<?> iMessages = null;

        public Bundle(Class<?> messages) {
            this.iMessages = messages;
        }

        private synchronized String getProperty(String locale, String name) {
            Properties properties = this.iProperties.get(locale);
            if (properties == null) {
                properties = new Properties();
                String resource = this.iMessages.getName().replace('.', '/') + (locale.isEmpty() ? "" : "_" + locale) + ".properties";
                try {
                    InputStream is = Localization.class.getClassLoader().getResourceAsStream(resource);
                    if (is != null) {
                        properties.load(is);
                    }
                }
                catch (Exception e) {
                    sLog.warn((Object)("Failed to load message bundle " + this.iMessages.getName().substring(this.iMessages.getName().lastIndexOf(46) + 1) + " for " + locale + ": " + e.getMessage()), (Throwable)e);
                }
                this.iProperties.put(locale, properties);
            }
            return properties.getProperty(name);
        }

        private String getProperty(String name) {
            for (String locale : Localization.getLocale().split(",")) {
                String value;
                if (locale.indexOf(59) >= 0) {
                    locale = locale.substring(0, locale.indexOf(59));
                }
                if ((value = this.getProperty(locale.trim(), name)) != null) {
                    return value;
                }
                if (locale.indexOf(95) < 0 || (value = this.getProperty((locale = locale.substring(0, locale.indexOf(95))).trim(), name)) == null) continue;
                return value;
            }
            return this.getProperty("", name);
        }

        private String fillArgumentsIn(String value, Object[] args, int firstIndex) {
            if (value == null || args == null) {
                return value;
            }
            int i = 0;
            while (i + firstIndex < args.length) {
                value = value.replace("{" + i + "}", args[i + firstIndex] == null ? "" : args[i + firstIndex].toString());
                ++i;
            }
            return value;
        }

        private String[] string2array(String value) {
            return value.split("(?<=^.*[^\\\\]),(?=.*$)");
        }

        private Map<String, String> array2map(String[] value) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < value.length - 1; i += 2) {
                map.put(value[i], value[i + 1]);
            }
            return map;
        }

        private Object type(String value, Class returnType) {
            if (value == null) {
                return value;
            }
            if (String.class.equals((Object)returnType)) {
                return value;
            }
            if (Boolean.class.equals((Object)returnType) || Boolean.TYPE.equals(returnType)) {
                return "true".equalsIgnoreCase(value);
            }
            if (Double.class.equals((Object)returnType) || Double.TYPE.equals(returnType)) {
                return Double.valueOf(value);
            }
            if (Float.class.equals((Object)returnType) || Float.TYPE.equals(returnType)) {
                return Float.valueOf(value);
            }
            if (Integer.class.equals((Object)returnType) || Integer.TYPE.equals(returnType)) {
                return Integer.valueOf(value);
            }
            if (String[].class.equals((Object)returnType)) {
                return this.string2array(value);
            }
            if (Map.class.equals((Object)returnType)) {
                HashMap<String, String> map = new HashMap<String, String>();
                for (String key : this.string2array(value)) {
                    String val = this.getProperty(key.trim());
                    if (val == null) continue;
                    map.put(key.trim(), val);
                }
                if (map.isEmpty()) {
                    return this.array2map(this.string2array(value));
                }
                return map;
            }
            return value;
        }

        private String[] fixStringArray(String[] value, String[] defaults) {
            if (value != null && value.length < defaults.length) {
                String[] fixed = Arrays.copyOf(value, defaults.length);
                for (int i = value.length; i < defaults.length; ++i) {
                    fixed[i] = defaults[i];
                }
                return fixed;
            }
            return value;
        }

        private Map<String, String> fixStringMap(Map<String, String> value, Map<String, String> defaults) {
            if (value != null && !value.keySet().equals(defaults.keySet())) {
                HashMap<String, String> fixed = new HashMap<String, String>(value);
                for (Map.Entry<String, String> e : defaults.entrySet()) {
                    if (value.containsKey(e.getKey())) continue;
                    fixed.put(e.getKey(), e.getValue());
                }
                return fixed;
            }
            return value;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("getStrutsActions".equals(method.getName()) && method.getParameterTypes().length == 1) {
                return this.getStrutsActions(proxy, (Class)args[0]);
            }
            if ("translateMessage".equals(method.getName()) && method.getParameterTypes().length >= 2) {
                String value = args[0] == null ? null : this.getProperty((String)args[0]);
                return value == null ? (String)args[1] : this.fillArgumentsIn(value, args, 2);
            }
            String value = this.getProperty(method.getName());
            if (value != null) {
                Constants.DefaultStringMapValue dsm;
                Constants.DefaultStringArrayValue dsa;
                Object ret = this.type(this.fillArgumentsIn(value, args, 0), method.getReturnType());
                if (String[].class.equals(method.getReturnType()) && (dsa = method.getAnnotation(Constants.DefaultStringArrayValue.class)) != null) {
                    return this.fixStringArray((String[])ret, dsa.value());
                }
                if (Map.class.equals(method.getReturnType()) && (dsm = method.getAnnotation(Constants.DefaultStringMapValue.class)) != null) {
                    return this.fixStringMap((Map)ret, this.array2map(dsm.value()));
                }
                return ret;
            }
            Messages.DefaultMessage dm = method.getAnnotation(Messages.DefaultMessage.class);
            if (dm != null) {
                return this.fillArgumentsIn(dm.value(), args, 0);
            }
            Constants.DefaultBooleanValue db = method.getAnnotation(Constants.DefaultBooleanValue.class);
            if (db != null) {
                return db.value();
            }
            Constants.DefaultDoubleValue dd = method.getAnnotation(Constants.DefaultDoubleValue.class);
            if (dd != null) {
                return dd.value();
            }
            Constants.DefaultFloatValue df = method.getAnnotation(Constants.DefaultFloatValue.class);
            if (df != null) {
                return Float.valueOf(df.value());
            }
            Constants.DefaultIntValue di = method.getAnnotation(Constants.DefaultIntValue.class);
            if (di != null) {
                return di.value();
            }
            Constants.DefaultStringValue ds = method.getAnnotation(Constants.DefaultStringValue.class);
            if (ds != null) {
                return ds.value();
            }
            Constants.DefaultStringArrayValue dsa = method.getAnnotation(Constants.DefaultStringArrayValue.class);
            if (dsa != null) {
                return dsa.value();
            }
            Constants.DefaultStringMapValue dsm = method.getAnnotation(Constants.DefaultStringMapValue.class);
            if (dsm != null) {
                return this.array2map(dsm.value());
            }
            return method.getName();
        }

        private Map<String, String> getStrutsActions(Object proxy, Class<? extends LocalizedLookupDispatchAction> apply) throws Throwable {
            HashMap<String, String> ret = new HashMap<String, String>();
            for (Method m : this.iMessages.getDeclaredMethods()) {
                Messages.StrutsAction action;
                if (m.getParameterTypes().length > 0 || (action = m.getAnnotation(Messages.StrutsAction.class)) == null) continue;
                Messages.DefaultMessage dm = m.getAnnotation(Messages.DefaultMessage.class);
                if (action.apply() == null || action.apply().length == 0) {
                    try {
                        if (apply.getMethod(action.value(), ActionMapping.class, ActionForm.class, HttpServletRequest.class, HttpServletResponse.class) == null) continue;
                        ret.put((String)this.invoke(proxy, m, new Object[0]), action.value());
                        if (dm == null) continue;
                        ret.put(dm.value(), action.value());
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                    continue;
                }
                for (Class<? extends LocalizedLookupDispatchAction> a : action.apply()) {
                    if (!a.equals(apply)) continue;
                    ret.put((String)this.invoke(proxy, m, new Object[0]), action.value());
                    if (dm == null) continue;
                    ret.put(dm.value(), action.value());
                }
            }
            return ret;
        }
    }
}

