/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io;

import biweekly.component.DaylightSavingsTime;
import biweekly.component.Observance;
import biweekly.component.StandardTime;
import biweekly.component.VTimezone;
import biweekly.property.DateStart;
import biweekly.property.ExceptionDates;
import biweekly.property.ExceptionRule;
import biweekly.property.RecurrenceDates;
import biweekly.property.RecurrenceRule;
import biweekly.property.TimezoneId;
import biweekly.property.TimezoneName;
import biweekly.property.TimezoneOffsetFrom;
import biweekly.property.TimezoneOffsetTo;
import biweekly.property.UtcOffsetProperty;
import biweekly.property.ValuedProperty;
import biweekly.util.Google2445Utils;
import biweekly.util.ICalDate;
import biweekly.util.Recurrence;
import biweekly.util.UtcOffset;
import com.google.ical.iter.RecurrenceIterator;
import com.google.ical.iter.RecurrenceIteratorFactory;
import com.google.ical.values.DateTimeValue;
import com.google.ical.values.DateTimeValueImpl;
import com.google.ical.values.DateValue;
import com.google.ical.values.RRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICalTimeZone
extends TimeZone {
    private final VTimezone component;

    public ICalTimeZone(VTimezone component) {
        this.component = component;
        TimezoneId id = component.getTimezoneId();
        if (id != null) {
            this.setID((String)id.getValue());
        }
    }

    @Override
    public String getDisplayName(boolean daylight, int style, Locale locale) {
        List<Observance> observances = this.getSortedObservances();
        ListIterator<Observance> it = observances.listIterator(observances.size());
        while (it.hasPrevious()) {
            List<TimezoneName> names;
            Observance observance = it.previous();
            if (daylight && observance instanceof DaylightSavingsTime && !(names = observance.getTimezoneNames()).isEmpty()) {
                TimezoneName name = names.get(0);
                return (String)name.getValue();
            }
            if (daylight || !(observance instanceof StandardTime) || (names = observance.getTimezoneNames()).isEmpty()) continue;
            TimezoneName name = names.get(0);
            return (String)name.getValue();
        }
        return super.getDisplayName(daylight, style, locale);
    }

    @Override
    public int getOffset(int era, int year, int month, int day, int dayOfWeek, int millis) {
        int hour = millis / 1000 / 60 / 60;
        millis -= hour * 1000 * 60 * 60;
        int minute = millis / 1000 / 60;
        int second = (millis -= minute * 1000 * 60) / 1000;
        Observance observance = this.getObservance(year, month + 1, day, hour, minute, second);
        if (observance == null) {
            for (Observance o : this.getSortedObservances()) {
                if (!this.hasDateStart(o) || !this.hasTimezoneOffsetFrom(o)) continue;
                return (int)((UtcOffset)o.getTimezoneOffsetFrom().getValue()).getMillis();
            }
            return 0;
        }
        return this.hasTimezoneOffsetTo(observance) ? (int)((UtcOffset)observance.getTimezoneOffsetTo().getValue()).getMillis() : 0;
    }

    @Override
    public int getRawOffset() {
        Observance observance = this.getObservance(new Date());
        if (observance == null) {
            for (Observance o : this.getSortedObservances()) {
                if (!(o instanceof StandardTime) || !this.hasTimezoneOffsetTo(o)) continue;
                return (int)((UtcOffset)o.getTimezoneOffsetTo().getValue()).getMillis();
            }
            return 0;
        }
        UtcOffsetProperty offset = observance instanceof StandardTime ? observance.getTimezoneOffsetTo() : observance.getTimezoneOffsetFrom();
        return (int)((UtcOffset)offset.getValue()).getMillis();
    }

    @Override
    public boolean inDaylightTime(Date date) {
        if (!this.useDaylightTime()) {
            return false;
        }
        Observance observance = this.getObservance(date);
        return observance == null ? false : observance instanceof DaylightSavingsTime;
    }

    @Override
    public void setRawOffset(int offset) {
        throw new UnsupportedOperationException("Unable to set the raw offset.  Modify the VTIMEZONE component instead.");
    }

    @Override
    public boolean useDaylightTime() {
        return !this.component.getDaylightSavingsTime().isEmpty();
    }

    public Boundary getObservanceBoundary(Date date) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTime(date);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(10);
        int minute = cal.get(12);
        int second = cal.get(13);
        return this.getObservanceBoundary(year, month, day, hour, minute, second);
    }

    public Observance getObservance(Date date) {
        Boundary boundary = this.getObservanceBoundary(date);
        return boundary == null ? null : boundary.getObservanceIn();
    }

    public VTimezone getComponent() {
        return this.component;
    }

    private Observance getObservance(int year, int month, int day, int hour, int minute, int second) {
        Boundary boundary = this.getObservanceBoundary(year, month, day, hour, minute, second);
        return boundary == null ? null : boundary.getObservanceIn();
    }

    private Boundary getObservanceBoundary(int year, int month, int day, int hour, int minute, int second) {
        DateTimeValue cur;
        List<Observance> observances = this.getSortedObservances();
        if (observances.isEmpty()) {
            return null;
        }
        DateTimeValueImpl givenTime = new DateTimeValueImpl(year, month, day, hour, minute, second);
        int closestIndex = -1;
        Observance closest = null;
        Comparable closestValue = null;
        for (int i = 0; i < observances.size(); ++i) {
            DateTimeValue dtstartValue;
            Observance observance = observances.get(i);
            DateStart dtstart = observance.getDateStart();
            if (dtstart != null && (dtstartValue = Google2445Utils.convert(dtstart)) != null && dtstartValue.compareTo(givenTime) > 0) continue;
            RecurrenceIterator it = this.createIterator(observance);
            Comparable prev = null;
            while (it.hasNext() && givenTime.compareTo(cur = (DateTimeValue)it.next()) >= 0) {
                prev = cur;
            }
            if (prev == null || closestValue != null && closestValue.compareTo(prev) >= 0) continue;
            closestValue = prev;
            closest = observance;
            closestIndex = i;
        }
        Observance observanceIn = closest;
        Comparable observanceInStart = closestValue;
        Observance observanceAfter = null;
        DateTimeValue observanceAfterStart = null;
        if (closestIndex < observances.size() - 1) {
            observanceAfter = observances.get(closestIndex + 1);
            RecurrenceIterator it = this.createIterator(observanceAfter);
            while (it.hasNext()) {
                cur = (DateTimeValue)it.next();
                if (givenTime.compareTo(cur) >= 0) continue;
                observanceAfterStart = cur;
                break;
            }
        }
        return new Boundary((DateTimeValue)observanceInStart, observanceIn, observanceAfterStart, observanceAfter);
    }

    private boolean hasDateStart(Observance observance) {
        DateStart dtstart = observance.getDateStart();
        return dtstart != null && dtstart.getValue() != null;
    }

    private boolean hasTimezoneOffsetFrom(Observance observance) {
        TimezoneOffsetFrom offset = observance.getTimezoneOffsetFrom();
        return offset != null && offset.getValue() != null;
    }

    private boolean hasTimezoneOffsetTo(Observance observance) {
        TimezoneOffsetTo offset = observance.getTimezoneOffsetTo();
        return offset != null && offset.getValue() != null;
    }

    List<Observance> getSortedObservances() {
        ArrayList<Observance> observances = new ArrayList<Observance>();
        observances.addAll(this.component.getStandardTimes());
        observances.addAll(this.component.getDaylightSavingsTime());
        Collections.sort(observances, new Comparator<Observance>(){

            @Override
            public int compare(Observance left, Observance right) {
                ICalDate startLeft = ValuedProperty.getValue(left.getDateStart());
                ICalDate startRight = ValuedProperty.getValue(right.getDateStart());
                if (startLeft == null && startRight == null) {
                    return 0;
                }
                if (startLeft == null) {
                    return -1;
                }
                if (startRight == null) {
                    return 1;
                }
                return startLeft.getRawComponents().compareTo(startRight.getRawComponents());
            }
        });
        return observances;
    }

    RecurrenceIterator createIterator(Observance observance) {
        DateTimeValue dtstartValue;
        ArrayList<RecurrenceIterator> inclusions = new ArrayList<RecurrenceIterator>();
        ArrayList<RecurrenceIterator> exclusions = new ArrayList<RecurrenceIterator>();
        DateStart dtstart = observance.getDateStart();
        if (dtstart != null && (dtstartValue = Google2445Utils.convert(dtstart)) != null) {
            Recurrence recur;
            inclusions.add(new DateValueRecurrenceIterator(Arrays.asList(dtstartValue)));
            TimeZone utc = TimeZone.getTimeZone("UTC");
            for (RecurrenceRule rrule : observance.getProperties(RecurrenceRule.class)) {
                recur = (Recurrence)rrule.getValue();
                if (recur == null) continue;
                RRule rruleValue = Google2445Utils.convert(recur);
                inclusions.add(RecurrenceIteratorFactory.createRecurrenceIterator(rruleValue, (DateValue)dtstartValue, utc));
            }
            for (ExceptionRule exrule : observance.getProperties(ExceptionRule.class)) {
                recur = (Recurrence)exrule.getValue();
                if (recur == null) continue;
                RRule exruleValue = Google2445Utils.convert(recur);
                exclusions.add(RecurrenceIteratorFactory.createRecurrenceIterator(exruleValue, (DateValue)dtstartValue, utc));
            }
        }
        ArrayList<ICalDate> rdates = new ArrayList<ICalDate>();
        for (RecurrenceDates rdate : observance.getRecurrenceDates()) {
            rdates.addAll(rdate.getDates());
        }
        Collections.sort(rdates);
        inclusions.add(new DateRecurrenceIterator(rdates));
        ArrayList<ICalDate> exdates = new ArrayList<ICalDate>();
        for (ExceptionDates exdate : observance.getProperties(ExceptionDates.class)) {
            exdates.addAll(exdate.getValues());
        }
        Collections.sort(exdates);
        exclusions.add(new DateRecurrenceIterator(exdates));
        RecurrenceIterator included = this.join(inclusions);
        if (exclusions.isEmpty()) {
            return included;
        }
        RecurrenceIterator excluded = this.join(exclusions);
        return RecurrenceIteratorFactory.except(included, excluded);
    }

    private RecurrenceIterator join(List<RecurrenceIterator> iterators) {
        if (iterators.isEmpty()) {
            return new EmptyRecurrenceIterator();
        }
        RecurrenceIterator first = iterators.get(0);
        if (iterators.size() == 1) {
            return first;
        }
        List<RecurrenceIterator> theRest = iterators.subList(1, iterators.size());
        return RecurrenceIteratorFactory.join(first, theRest.toArray(new RecurrenceIterator[0]));
    }

    public static class Boundary {
        private final DateTimeValue observanceInStart;
        private final DateTimeValue observanceAfterStart;
        private final Observance observanceIn;
        private final Observance observanceAfter;

        public Boundary(DateTimeValue observanceInStart, Observance observanceIn, DateTimeValue observanceAfterStart, Observance observanceAfter) {
            this.observanceInStart = observanceInStart;
            this.observanceAfterStart = observanceAfterStart;
            this.observanceIn = observanceIn;
            this.observanceAfter = observanceAfter;
        }

        public DateTimeValue getObservanceInStart() {
            return this.observanceInStart;
        }

        public DateTimeValue getObservanceAfterStart() {
            return this.observanceAfterStart;
        }

        public Observance getObservanceIn() {
            return this.observanceIn;
        }

        public Observance getObservanceAfter() {
            return this.observanceAfter;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class IteratorWrapper<T>
    implements RecurrenceIterator {
        protected final Iterator<T> it;

        public IteratorWrapper(Iterator<T> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public void advanceTo(DateValue newStartUtc) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateRecurrenceIterator
    extends IteratorWrapper<ICalDate> {
        public DateRecurrenceIterator(Collection<ICalDate> dates) {
            super(dates.iterator());
        }

        @Override
        public DateValue next() {
            ICalDate value = (ICalDate)this.it.next();
            return Google2445Utils.convert(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateValueRecurrenceIterator
    extends IteratorWrapper<DateValue> {
        public DateValueRecurrenceIterator(Collection<DateValue> dates) {
            super(dates.iterator());
        }

        @Override
        public DateValue next() {
            return (DateValue)this.it.next();
        }
    }

    private static class EmptyRecurrenceIterator
    implements RecurrenceIterator {
        private EmptyRecurrenceIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public DateValue next() {
            throw new NoSuchElementException();
        }

        public void advanceTo(DateValue newStartUtc) {
        }

        public void remove() {
        }
    }
}

