/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.model;

import java.util.List;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentContext;
import org.cpsolver.ifs.assignment.context.VariableWithContext;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.reservation.Reservation;

public abstract class Request
extends VariableWithContext<Request, Enrollment, RequestContext> {
    private long iId = -1L;
    private int iPriority = 0;
    private boolean iAlternative = false;
    private Student iStudent = null;
    private double iWeight = 1.0;
    public static boolean sCacheValues = false;

    public Request(long id, int priority, boolean alternative, Student student) {
        this.iId = id;
        this.iPriority = priority;
        this.iAlternative = alternative;
        this.iStudent = student;
        this.iStudent.getRequests().add(this);
    }

    @Override
    public long getId() {
        return this.iId;
    }

    public int getPriority() {
        return this.iPriority;
    }

    public void setPriority(int priority) {
        this.iPriority = priority;
    }

    public boolean isAlternative() {
        return this.iAlternative;
    }

    public Student getStudent() {
        return this.iStudent;
    }

    @Override
    public int compareTo(Request r) {
        if (this.getStudent().getId() == r.getStudent().getId()) {
            return this.isAlternative() != r.isAlternative() ? (this.isAlternative() ? 1 : -1) : (this.getPriority() < r.getPriority() ? -1 : 1);
        }
        return this.getStudent().compareTo(r.getStudent());
    }

    public abstract List<Enrollment> computeEnrollments(Assignment<Request, Enrollment> var1);

    @Override
    public List<Enrollment> values(Assignment<Request, Enrollment> assignment) {
        List<Enrollment> values = super.values(assignment);
        if (values != null) {
            return values;
        }
        values = this.computeEnrollments(assignment);
        if (sCacheValues) {
            this.setValues(values);
        }
        return values;
    }

    @Override
    public void variableAssigned(Assignment<Request, Enrollment> assignment, long iteration, Enrollment enrollment) {
        super.variableAssigned(assignment, iteration, enrollment);
        for (SctAssignment a : enrollment.getAssignments()) {
            a.assigned(assignment, enrollment);
        }
        if (enrollment.getConfig() != null) {
            ((Config.ConfigContext)enrollment.getConfig().getContext(assignment)).assigned(assignment, enrollment);
        }
        if (enrollment.getCourse() != null) {
            enrollment.getCourse().assigned(assignment, enrollment);
        }
        if (enrollment.getReservation() != null) {
            ((Reservation.ReservationContext)enrollment.getReservation().getContext(assignment)).assigned(assignment, enrollment);
        }
    }

    @Override
    public void variableUnassigned(Assignment<Request, Enrollment> assignment, long iteration, Enrollment enrollment) {
        super.variableUnassigned(assignment, iteration, enrollment);
        for (SctAssignment a : enrollment.getAssignments()) {
            a.unassigned(assignment, enrollment);
        }
        if (enrollment.getConfig() != null) {
            ((Config.ConfigContext)enrollment.getConfig().getContext(assignment)).unassigned(assignment, enrollment);
        }
        if (enrollment.getCourse() != null) {
            enrollment.getCourse().unassigned(assignment, enrollment);
        }
        if (enrollment.getReservation() != null) {
            ((Reservation.ReservationContext)enrollment.getReservation().getContext(assignment)).unassigned(assignment, enrollment);
        }
    }

    public abstract double getBound();

    public double getWeight() {
        return this.iWeight;
    }

    public void setWeight(double weight) {
        this.iWeight = weight;
    }

    public boolean isAssigned(Assignment<Request, Enrollment> assignment) {
        return assignment.getValue(this) != null;
    }

    @Override
    public int hashCode() {
        return (int)(this.iId ^ this.iId >>> 32 ^ this.getStudent().getId() ^ this.getStudent().getId() >>> 32);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof Request)) {
            return false;
        }
        return this.getId() == ((Request)o).getId() && this.getStudent().getId() == ((Request)o).getStudent().getId();
    }

    @Override
    public RequestContext createAssignmentContext(Assignment<Request, Enrollment> assignment) {
        return new RequestContext(assignment);
    }

    public boolean isMPP() {
        return false;
    }

    public boolean hasSelection() {
        return false;
    }

    public class RequestContext
    implements AssignmentContext {
        private Double iWeight = null;

        public RequestContext(Assignment<Request, Enrollment> assignment) {
            Enrollment enrollment = assignment.getValue(Request.this);
            if (enrollment != null) {
                this.setLastWeight(enrollment.getRequest().getWeight() * ((StudentSectioningModel)Request.this.getModel()).getStudentWeights().getWeight(assignment, enrollment));
            }
        }

        public Double getLastWeight() {
            return this.iWeight;
        }

        public void setLastWeight(Double weight) {
            this.iWeight = weight;
        }
    }
}

